# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ScheduleArgs', 'Schedule']

@pulumi.input_type
class ScheduleArgs:
    def __init__(__self__, *,
                 load_test_id: pulumi.Input[_builtins.str],
                 starts: pulumi.Input[_builtins.str],
                 recurrence_rule: Optional[pulumi.Input['ScheduleRecurrenceRuleArgs']] = None):
        """
        The set of arguments for constructing a Schedule resource.
        :param pulumi.Input[_builtins.str] load_test_id: The identifier of the load test to schedule.
        :param pulumi.Input[_builtins.str] starts: The start time for the schedule (RFC3339 format).
        :param pulumi.Input['ScheduleRecurrenceRuleArgs'] recurrence_rule: The schedule recurrence settings. If not specified, the test will run only once on the 'starts' date.
        """
        pulumi.set(__self__, "load_test_id", load_test_id)
        pulumi.set(__self__, "starts", starts)
        if recurrence_rule is not None:
            pulumi.set(__self__, "recurrence_rule", recurrence_rule)

    @_builtins.property
    @pulumi.getter(name="loadTestId")
    def load_test_id(self) -> pulumi.Input[_builtins.str]:
        """
        The identifier of the load test to schedule.
        """
        return pulumi.get(self, "load_test_id")

    @load_test_id.setter
    def load_test_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "load_test_id", value)

    @_builtins.property
    @pulumi.getter
    def starts(self) -> pulumi.Input[_builtins.str]:
        """
        The start time for the schedule (RFC3339 format).
        """
        return pulumi.get(self, "starts")

    @starts.setter
    def starts(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "starts", value)

    @_builtins.property
    @pulumi.getter(name="recurrenceRule")
    def recurrence_rule(self) -> Optional[pulumi.Input['ScheduleRecurrenceRuleArgs']]:
        """
        The schedule recurrence settings. If not specified, the test will run only once on the 'starts' date.
        """
        return pulumi.get(self, "recurrence_rule")

    @recurrence_rule.setter
    def recurrence_rule(self, value: Optional[pulumi.Input['ScheduleRecurrenceRuleArgs']]):
        pulumi.set(self, "recurrence_rule", value)


@pulumi.input_type
class _ScheduleState:
    def __init__(__self__, *,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 deactivated: Optional[pulumi.Input[_builtins.bool]] = None,
                 load_test_id: Optional[pulumi.Input[_builtins.str]] = None,
                 next_run: Optional[pulumi.Input[_builtins.str]] = None,
                 recurrence_rule: Optional[pulumi.Input['ScheduleRecurrenceRuleArgs']] = None,
                 starts: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Schedule resources.
        :param pulumi.Input[_builtins.str] created_by: The email of the user who created the schedule.
        :param pulumi.Input[_builtins.bool] deactivated: Whether the schedule is deactivated.
        :param pulumi.Input[_builtins.str] load_test_id: The identifier of the load test to schedule.
        :param pulumi.Input[_builtins.str] next_run: The next scheduled execution time.
        :param pulumi.Input['ScheduleRecurrenceRuleArgs'] recurrence_rule: The schedule recurrence settings. If not specified, the test will run only once on the 'starts' date.
        :param pulumi.Input[_builtins.str] starts: The start time for the schedule (RFC3339 format).
        """
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if deactivated is not None:
            pulumi.set(__self__, "deactivated", deactivated)
        if load_test_id is not None:
            pulumi.set(__self__, "load_test_id", load_test_id)
        if next_run is not None:
            pulumi.set(__self__, "next_run", next_run)
        if recurrence_rule is not None:
            pulumi.set(__self__, "recurrence_rule", recurrence_rule)
        if starts is not None:
            pulumi.set(__self__, "starts", starts)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email of the user who created the schedule.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter
    def deactivated(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the schedule is deactivated.
        """
        return pulumi.get(self, "deactivated")

    @deactivated.setter
    def deactivated(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deactivated", value)

    @_builtins.property
    @pulumi.getter(name="loadTestId")
    def load_test_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The identifier of the load test to schedule.
        """
        return pulumi.get(self, "load_test_id")

    @load_test_id.setter
    def load_test_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_test_id", value)

    @_builtins.property
    @pulumi.getter(name="nextRun")
    def next_run(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The next scheduled execution time.
        """
        return pulumi.get(self, "next_run")

    @next_run.setter
    def next_run(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "next_run", value)

    @_builtins.property
    @pulumi.getter(name="recurrenceRule")
    def recurrence_rule(self) -> Optional[pulumi.Input['ScheduleRecurrenceRuleArgs']]:
        """
        The schedule recurrence settings. If not specified, the test will run only once on the 'starts' date.
        """
        return pulumi.get(self, "recurrence_rule")

    @recurrence_rule.setter
    def recurrence_rule(self, value: Optional[pulumi.Input['ScheduleRecurrenceRuleArgs']]):
        pulumi.set(self, "recurrence_rule", value)

    @_builtins.property
    @pulumi.getter
    def starts(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The start time for the schedule (RFC3339 format).
        """
        return pulumi.get(self, "starts")

    @starts.setter
    def starts(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "starts", value)


@pulumi.type_token("grafana:k6/schedule:Schedule")
class Schedule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 load_test_id: Optional[pulumi.Input[_builtins.str]] = None,
                 recurrence_rule: Optional[pulumi.Input[Union['ScheduleRecurrenceRuleArgs', 'ScheduleRecurrenceRuleArgsDict']]] = None,
                 starts: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a k6 schedule for automated test execution.

        ## Import

        ```sh
        $ pulumi import grafana:k6/schedule:Schedule name "{{ load_test_id }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] load_test_id: The identifier of the load test to schedule.
        :param pulumi.Input[Union['ScheduleRecurrenceRuleArgs', 'ScheduleRecurrenceRuleArgsDict']] recurrence_rule: The schedule recurrence settings. If not specified, the test will run only once on the 'starts' date.
        :param pulumi.Input[_builtins.str] starts: The start time for the schedule (RFC3339 format).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScheduleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a k6 schedule for automated test execution.

        ## Import

        ```sh
        $ pulumi import grafana:k6/schedule:Schedule name "{{ load_test_id }}"
        ```

        :param str resource_name: The name of the resource.
        :param ScheduleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScheduleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 load_test_id: Optional[pulumi.Input[_builtins.str]] = None,
                 recurrence_rule: Optional[pulumi.Input[Union['ScheduleRecurrenceRuleArgs', 'ScheduleRecurrenceRuleArgsDict']]] = None,
                 starts: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScheduleArgs.__new__(ScheduleArgs)

            if load_test_id is None and not opts.urn:
                raise TypeError("Missing required property 'load_test_id'")
            __props__.__dict__["load_test_id"] = load_test_id
            __props__.__dict__["recurrence_rule"] = recurrence_rule
            if starts is None and not opts.urn:
                raise TypeError("Missing required property 'starts'")
            __props__.__dict__["starts"] = starts
            __props__.__dict__["created_by"] = None
            __props__.__dict__["deactivated"] = None
            __props__.__dict__["next_run"] = None
        super(Schedule, __self__).__init__(
            'grafana:k6/schedule:Schedule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            deactivated: Optional[pulumi.Input[_builtins.bool]] = None,
            load_test_id: Optional[pulumi.Input[_builtins.str]] = None,
            next_run: Optional[pulumi.Input[_builtins.str]] = None,
            recurrence_rule: Optional[pulumi.Input[Union['ScheduleRecurrenceRuleArgs', 'ScheduleRecurrenceRuleArgsDict']]] = None,
            starts: Optional[pulumi.Input[_builtins.str]] = None) -> 'Schedule':
        """
        Get an existing Schedule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_by: The email of the user who created the schedule.
        :param pulumi.Input[_builtins.bool] deactivated: Whether the schedule is deactivated.
        :param pulumi.Input[_builtins.str] load_test_id: The identifier of the load test to schedule.
        :param pulumi.Input[_builtins.str] next_run: The next scheduled execution time.
        :param pulumi.Input[Union['ScheduleRecurrenceRuleArgs', 'ScheduleRecurrenceRuleArgsDict']] recurrence_rule: The schedule recurrence settings. If not specified, the test will run only once on the 'starts' date.
        :param pulumi.Input[_builtins.str] starts: The start time for the schedule (RFC3339 format).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScheduleState.__new__(_ScheduleState)

        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["deactivated"] = deactivated
        __props__.__dict__["load_test_id"] = load_test_id
        __props__.__dict__["next_run"] = next_run
        __props__.__dict__["recurrence_rule"] = recurrence_rule
        __props__.__dict__["starts"] = starts
        return Schedule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        The email of the user who created the schedule.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter
    def deactivated(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the schedule is deactivated.
        """
        return pulumi.get(self, "deactivated")

    @_builtins.property
    @pulumi.getter(name="loadTestId")
    def load_test_id(self) -> pulumi.Output[_builtins.str]:
        """
        The identifier of the load test to schedule.
        """
        return pulumi.get(self, "load_test_id")

    @_builtins.property
    @pulumi.getter(name="nextRun")
    def next_run(self) -> pulumi.Output[_builtins.str]:
        """
        The next scheduled execution time.
        """
        return pulumi.get(self, "next_run")

    @_builtins.property
    @pulumi.getter(name="recurrenceRule")
    def recurrence_rule(self) -> pulumi.Output[Optional['outputs.ScheduleRecurrenceRule']]:
        """
        The schedule recurrence settings. If not specified, the test will run only once on the 'starts' date.
        """
        return pulumi.get(self, "recurrence_rule")

    @_builtins.property
    @pulumi.getter
    def starts(self) -> pulumi.Output[_builtins.str]:
        """
        The start time for the schedule (RFC3339 format).
        """
        return pulumi.get(self, "starts")

