# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IntegrationArgs', 'Integration']

@pulumi.input_type
class IntegrationArgs:
    def __init__(__self__, *,
                 default_route: pulumi.Input['IntegrationDefaultRouteArgs'],
                 type: pulumi.Input[_builtins.str],
                 dynamic_labels: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 templates: Optional[pulumi.Input['IntegrationTemplatesArgs']] = None):
        """
        The set of arguments for constructing a Integration resource.
        :param pulumi.Input['IntegrationDefaultRouteArgs'] default_route: The Default route for all alerts from the given integration
        :param pulumi.Input[_builtins.str] type: The type of integration. Can be grafana, grafana*alerting, webhook, alertmanager, kapacitor, fabric, newrelic, datadog, pagerduty, pingdom, elastalert, amazon*sns, curler, sentry, formatted*webhook, heartbeat, demo, manual, stackdriver, uptimerobot, sentry*platform, zabbix, prtg, slack*channel, inbound*email, direct_paging, jira, zendesk.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]] dynamic_labels: A list of string-to-string mappings for dynamic labels. Each map must include one key named "key" and one key named "value" (using the `on_call_get_label` datasource).
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]] labels: A list of string-to-string mappings for static labels. Each map must include one key named "key" and one key named "value" (using the `on_call_get_label` datasource).
        :param pulumi.Input[_builtins.str] name: The name of the service integration.
        :param pulumi.Input[_builtins.str] team_id: The ID of the OnCall team (using the `on_call_get_team` datasource).
        :param pulumi.Input['IntegrationTemplatesArgs'] templates: Jinja2 templates for Alert payload. An empty templates block will be ignored.
        """
        pulumi.set(__self__, "default_route", default_route)
        pulumi.set(__self__, "type", type)
        if dynamic_labels is not None:
            pulumi.set(__self__, "dynamic_labels", dynamic_labels)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if templates is not None:
            pulumi.set(__self__, "templates", templates)

    @_builtins.property
    @pulumi.getter(name="defaultRoute")
    def default_route(self) -> pulumi.Input['IntegrationDefaultRouteArgs']:
        """
        The Default route for all alerts from the given integration
        """
        return pulumi.get(self, "default_route")

    @default_route.setter
    def default_route(self, value: pulumi.Input['IntegrationDefaultRouteArgs']):
        pulumi.set(self, "default_route", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of integration. Can be grafana, grafana*alerting, webhook, alertmanager, kapacitor, fabric, newrelic, datadog, pagerduty, pingdom, elastalert, amazon*sns, curler, sentry, formatted*webhook, heartbeat, demo, manual, stackdriver, uptimerobot, sentry*platform, zabbix, prtg, slack*channel, inbound*email, direct_paging, jira, zendesk.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="dynamicLabels")
    def dynamic_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]]:
        """
        A list of string-to-string mappings for dynamic labels. Each map must include one key named "key" and one key named "value" (using the `on_call_get_label` datasource).
        """
        return pulumi.get(self, "dynamic_labels")

    @dynamic_labels.setter
    def dynamic_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]]):
        pulumi.set(self, "dynamic_labels", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]]:
        """
        A list of string-to-string mappings for static labels. Each map must include one key named "key" and one key named "value" (using the `on_call_get_label` datasource).
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the service integration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the OnCall team (using the `on_call_get_team` datasource).
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "team_id", value)

    @_builtins.property
    @pulumi.getter
    def templates(self) -> Optional[pulumi.Input['IntegrationTemplatesArgs']]:
        """
        Jinja2 templates for Alert payload. An empty templates block will be ignored.
        """
        return pulumi.get(self, "templates")

    @templates.setter
    def templates(self, value: Optional[pulumi.Input['IntegrationTemplatesArgs']]):
        pulumi.set(self, "templates", value)


@pulumi.input_type
class _IntegrationState:
    def __init__(__self__, *,
                 default_route: Optional[pulumi.Input['IntegrationDefaultRouteArgs']] = None,
                 dynamic_labels: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]] = None,
                 link: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 templates: Optional[pulumi.Input['IntegrationTemplatesArgs']] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Integration resources.
        :param pulumi.Input['IntegrationDefaultRouteArgs'] default_route: The Default route for all alerts from the given integration
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]] dynamic_labels: A list of string-to-string mappings for dynamic labels. Each map must include one key named "key" and one key named "value" (using the `on_call_get_label` datasource).
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]] labels: A list of string-to-string mappings for static labels. Each map must include one key named "key" and one key named "value" (using the `on_call_get_label` datasource).
        :param pulumi.Input[_builtins.str] link: The link for using in an integrated tool.
        :param pulumi.Input[_builtins.str] name: The name of the service integration.
        :param pulumi.Input[_builtins.str] team_id: The ID of the OnCall team (using the `on_call_get_team` datasource).
        :param pulumi.Input['IntegrationTemplatesArgs'] templates: Jinja2 templates for Alert payload. An empty templates block will be ignored.
        :param pulumi.Input[_builtins.str] type: The type of integration. Can be grafana, grafana*alerting, webhook, alertmanager, kapacitor, fabric, newrelic, datadog, pagerduty, pingdom, elastalert, amazon*sns, curler, sentry, formatted*webhook, heartbeat, demo, manual, stackdriver, uptimerobot, sentry*platform, zabbix, prtg, slack*channel, inbound*email, direct_paging, jira, zendesk.
        """
        if default_route is not None:
            pulumi.set(__self__, "default_route", default_route)
        if dynamic_labels is not None:
            pulumi.set(__self__, "dynamic_labels", dynamic_labels)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if link is not None:
            pulumi.set(__self__, "link", link)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if templates is not None:
            pulumi.set(__self__, "templates", templates)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="defaultRoute")
    def default_route(self) -> Optional[pulumi.Input['IntegrationDefaultRouteArgs']]:
        """
        The Default route for all alerts from the given integration
        """
        return pulumi.get(self, "default_route")

    @default_route.setter
    def default_route(self, value: Optional[pulumi.Input['IntegrationDefaultRouteArgs']]):
        pulumi.set(self, "default_route", value)

    @_builtins.property
    @pulumi.getter(name="dynamicLabels")
    def dynamic_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]]:
        """
        A list of string-to-string mappings for dynamic labels. Each map must include one key named "key" and one key named "value" (using the `on_call_get_label` datasource).
        """
        return pulumi.get(self, "dynamic_labels")

    @dynamic_labels.setter
    def dynamic_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]]):
        pulumi.set(self, "dynamic_labels", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]]:
        """
        A list of string-to-string mappings for static labels. Each map must include one key named "key" and one key named "value" (using the `on_call_get_label` datasource).
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def link(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The link for using in an integrated tool.
        """
        return pulumi.get(self, "link")

    @link.setter
    def link(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "link", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the service integration.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the OnCall team (using the `on_call_get_team` datasource).
        """
        return pulumi.get(self, "team_id")

    @team_id.setter
    def team_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "team_id", value)

    @_builtins.property
    @pulumi.getter
    def templates(self) -> Optional[pulumi.Input['IntegrationTemplatesArgs']]:
        """
        Jinja2 templates for Alert payload. An empty templates block will be ignored.
        """
        return pulumi.get(self, "templates")

    @templates.setter
    def templates(self, value: Optional[pulumi.Input['IntegrationTemplatesArgs']]):
        pulumi.set(self, "templates", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of integration. Can be grafana, grafana*alerting, webhook, alertmanager, kapacitor, fabric, newrelic, datadog, pagerduty, pingdom, elastalert, amazon*sns, curler, sentry, formatted*webhook, heartbeat, demo, manual, stackdriver, uptimerobot, sentry*platform, zabbix, prtg, slack*channel, inbound*email, direct_paging, jira, zendesk.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("grafana:onCall/integration:Integration")
class Integration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_route: Optional[pulumi.Input[Union['IntegrationDefaultRouteArgs', 'IntegrationDefaultRouteArgsDict']]] = None,
                 dynamic_labels: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 templates: Optional[pulumi.Input[Union['IntegrationTemplatesArgs', 'IntegrationTemplatesArgsDict']]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        * [Official documentation](https://grafana.com/docs/oncall/latest/configure/integrations/)
        * [HTTP API](https://grafana.com/docs/oncall/latest/oncall-api-reference/)

        ## Import

        ```sh
        $ pulumi import grafana:onCall/integration:Integration name "{{ id }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['IntegrationDefaultRouteArgs', 'IntegrationDefaultRouteArgsDict']] default_route: The Default route for all alerts from the given integration
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]] dynamic_labels: A list of string-to-string mappings for dynamic labels. Each map must include one key named "key" and one key named "value" (using the `on_call_get_label` datasource).
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]] labels: A list of string-to-string mappings for static labels. Each map must include one key named "key" and one key named "value" (using the `on_call_get_label` datasource).
        :param pulumi.Input[_builtins.str] name: The name of the service integration.
        :param pulumi.Input[_builtins.str] team_id: The ID of the OnCall team (using the `on_call_get_team` datasource).
        :param pulumi.Input[Union['IntegrationTemplatesArgs', 'IntegrationTemplatesArgsDict']] templates: Jinja2 templates for Alert payload. An empty templates block will be ignored.
        :param pulumi.Input[_builtins.str] type: The type of integration. Can be grafana, grafana*alerting, webhook, alertmanager, kapacitor, fabric, newrelic, datadog, pagerduty, pingdom, elastalert, amazon*sns, curler, sentry, formatted*webhook, heartbeat, demo, manual, stackdriver, uptimerobot, sentry*platform, zabbix, prtg, slack*channel, inbound*email, direct_paging, jira, zendesk.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IntegrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        * [Official documentation](https://grafana.com/docs/oncall/latest/configure/integrations/)
        * [HTTP API](https://grafana.com/docs/oncall/latest/oncall-api-reference/)

        ## Import

        ```sh
        $ pulumi import grafana:onCall/integration:Integration name "{{ id }}"
        ```

        :param str resource_name: The name of the resource.
        :param IntegrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IntegrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_route: Optional[pulumi.Input[Union['IntegrationDefaultRouteArgs', 'IntegrationDefaultRouteArgsDict']]] = None,
                 dynamic_labels: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 team_id: Optional[pulumi.Input[_builtins.str]] = None,
                 templates: Optional[pulumi.Input[Union['IntegrationTemplatesArgs', 'IntegrationTemplatesArgsDict']]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IntegrationArgs.__new__(IntegrationArgs)

            if default_route is None and not opts.urn:
                raise TypeError("Missing required property 'default_route'")
            __props__.__dict__["default_route"] = default_route
            __props__.__dict__["dynamic_labels"] = dynamic_labels
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["team_id"] = team_id
            __props__.__dict__["templates"] = templates
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["link"] = None
        super(Integration, __self__).__init__(
            'grafana:onCall/integration:Integration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_route: Optional[pulumi.Input[Union['IntegrationDefaultRouteArgs', 'IntegrationDefaultRouteArgsDict']]] = None,
            dynamic_labels: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]] = None,
            labels: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]]] = None,
            link: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            team_id: Optional[pulumi.Input[_builtins.str]] = None,
            templates: Optional[pulumi.Input[Union['IntegrationTemplatesArgs', 'IntegrationTemplatesArgsDict']]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Integration':
        """
        Get an existing Integration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['IntegrationDefaultRouteArgs', 'IntegrationDefaultRouteArgsDict']] default_route: The Default route for all alerts from the given integration
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]] dynamic_labels: A list of string-to-string mappings for dynamic labels. Each map must include one key named "key" and one key named "value" (using the `on_call_get_label` datasource).
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]] labels: A list of string-to-string mappings for static labels. Each map must include one key named "key" and one key named "value" (using the `on_call_get_label` datasource).
        :param pulumi.Input[_builtins.str] link: The link for using in an integrated tool.
        :param pulumi.Input[_builtins.str] name: The name of the service integration.
        :param pulumi.Input[_builtins.str] team_id: The ID of the OnCall team (using the `on_call_get_team` datasource).
        :param pulumi.Input[Union['IntegrationTemplatesArgs', 'IntegrationTemplatesArgsDict']] templates: Jinja2 templates for Alert payload. An empty templates block will be ignored.
        :param pulumi.Input[_builtins.str] type: The type of integration. Can be grafana, grafana*alerting, webhook, alertmanager, kapacitor, fabric, newrelic, datadog, pagerduty, pingdom, elastalert, amazon*sns, curler, sentry, formatted*webhook, heartbeat, demo, manual, stackdriver, uptimerobot, sentry*platform, zabbix, prtg, slack*channel, inbound*email, direct_paging, jira, zendesk.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IntegrationState.__new__(_IntegrationState)

        __props__.__dict__["default_route"] = default_route
        __props__.__dict__["dynamic_labels"] = dynamic_labels
        __props__.__dict__["labels"] = labels
        __props__.__dict__["link"] = link
        __props__.__dict__["name"] = name
        __props__.__dict__["team_id"] = team_id
        __props__.__dict__["templates"] = templates
        __props__.__dict__["type"] = type
        return Integration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="defaultRoute")
    def default_route(self) -> pulumi.Output['outputs.IntegrationDefaultRoute']:
        """
        The Default route for all alerts from the given integration
        """
        return pulumi.get(self, "default_route")

    @_builtins.property
    @pulumi.getter(name="dynamicLabels")
    def dynamic_labels(self) -> pulumi.Output[Optional[Sequence[Mapping[str, _builtins.str]]]]:
        """
        A list of string-to-string mappings for dynamic labels. Each map must include one key named "key" and one key named "value" (using the `on_call_get_label` datasource).
        """
        return pulumi.get(self, "dynamic_labels")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Sequence[Mapping[str, _builtins.str]]]]:
        """
        A list of string-to-string mappings for static labels. Each map must include one key named "key" and one key named "value" (using the `on_call_get_label` datasource).
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def link(self) -> pulumi.Output[_builtins.str]:
        """
        The link for using in an integrated tool.
        """
        return pulumi.get(self, "link")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the service integration.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="teamId")
    def team_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the OnCall team (using the `on_call_get_team` datasource).
        """
        return pulumi.get(self, "team_id")

    @_builtins.property
    @pulumi.getter
    def templates(self) -> pulumi.Output[Optional['outputs.IntegrationTemplates']]:
        """
        Jinja2 templates for Alert payload. An empty templates block will be ignored.
        """
        return pulumi.get(self, "templates")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of integration. Can be grafana, grafana*alerting, webhook, alertmanager, kapacitor, fabric, newrelic, datadog, pagerduty, pingdom, elastalert, amazon*sns, curler, sentry, formatted*webhook, heartbeat, demo, manual, stackdriver, uptimerobot, sentry*platform, zabbix, prtg, slack*channel, inbound*email, direct_paging, jira, zendesk.
        """
        return pulumi.get(self, "type")

