# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSlosResult',
    'AwaitableGetSlosResult',
    'get_slos',
    'get_slos_output',
]

@pulumi.output_type
class GetSlosResult:
    """
    A collection of values returned by getSlos.
    """
    def __init__(__self__, id=None, slos=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if slos and not isinstance(slos, list):
            raise TypeError("Expected argument 'slos' to be a list")
        pulumi.set(__self__, "slos", slos)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def slos(self) -> Sequence['outputs.GetSlosSloResult']:
        """
        Returns a list of all SLOs"
        """
        return pulumi.get(self, "slos")


class AwaitableGetSlosResult(GetSlosResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSlosResult(
            id=self.id,
            slos=self.slos)


def get_slos(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSlosResult:
    """
    Datasource for retrieving all SLOs.

    * [Official documentation](https://grafana.com/docs/grafana-cloud/alerting-and-irm/slo/)
    * [API documentation](https://grafana.com/docs/grafana-cloud/alerting-and-irm/slo/api/)
    * [Additional Information On Alerting Rule Annotations and Labels](https://prometheus.io/docs/prometheus/latest/configuration/alerting_rules/#templating/)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_grafana as grafana
    import pulumiverse_grafana as grafana

    test = grafana.slo.SLO("test",
        name="Terraform Testing",
        description="Terraform Description",
        queries=[{
            "freeform": {
                "query": "sum(rate(apiserver_request_total{code!=\\"500\\"}[$__rate_interval])) / sum(rate(apiserver_request_total[$__rate_interval]))",
            },
            "type": "freeform",
        }],
        objectives=[{
            "value": 0.995,
            "window": "30d",
        }],
        destination_datasource={
            "uid": "grafanacloud-prom",
        },
        labels=[{
            "key": "custom",
            "value": "value",
        }],
        alerting={
            "fastburn": {
                "annotations": [{
                    "key": "name",
                    "value": "Critical - SLO Burn Rate Alert",
                }],
                "labels": [{
                    "key": "type",
                    "value": "slo",
                }],
            },
            "slowburn": {
                "annotations": [{
                    "key": "name",
                    "value": "Warning - SLO Burn Rate Alert",
                }],
                "labels": [{
                    "key": "type",
                    "value": "slo",
                }],
            },
        })
    slos = grafana.slo.get_slos()
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('grafana:slo/getSlos:getSlos', __args__, opts=opts, typ=GetSlosResult).value

    return AwaitableGetSlosResult(
        id=pulumi.get(__ret__, 'id'),
        slos=pulumi.get(__ret__, 'slos'))
def get_slos_output(opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSlosResult]:
    """
    Datasource for retrieving all SLOs.

    * [Official documentation](https://grafana.com/docs/grafana-cloud/alerting-and-irm/slo/)
    * [API documentation](https://grafana.com/docs/grafana-cloud/alerting-and-irm/slo/api/)
    * [Additional Information On Alerting Rule Annotations and Labels](https://prometheus.io/docs/prometheus/latest/configuration/alerting_rules/#templating/)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_grafana as grafana
    import pulumiverse_grafana as grafana

    test = grafana.slo.SLO("test",
        name="Terraform Testing",
        description="Terraform Description",
        queries=[{
            "freeform": {
                "query": "sum(rate(apiserver_request_total{code!=\\"500\\"}[$__rate_interval])) / sum(rate(apiserver_request_total[$__rate_interval]))",
            },
            "type": "freeform",
        }],
        objectives=[{
            "value": 0.995,
            "window": "30d",
        }],
        destination_datasource={
            "uid": "grafanacloud-prom",
        },
        labels=[{
            "key": "custom",
            "value": "value",
        }],
        alerting={
            "fastburn": {
                "annotations": [{
                    "key": "name",
                    "value": "Critical - SLO Burn Rate Alert",
                }],
                "labels": [{
                    "key": "type",
                    "value": "slo",
                }],
            },
            "slowburn": {
                "annotations": [{
                    "key": "name",
                    "value": "Warning - SLO Burn Rate Alert",
                }],
                "labels": [{
                    "key": "type",
                    "value": "slo",
                }],
            },
        })
    slos = grafana.slo.get_slos()
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('grafana:slo/getSlos:getSlos', __args__, opts=opts, typ=GetSlosResult)
    return __ret__.apply(lambda __response__: GetSlosResult(
        id=pulumi.get(__response__, 'id'),
        slos=pulumi.get(__response__, 'slos')))
