"""
**earthcarekit.read**

Reading utilities for EarthCARE product data.

---
"""

from ._read_any import read_any
from ._read_nc import read_nc
from ._read_polly import read_polly
from .product import (
    read_hdr_fixed_header,
    read_header_data,
    read_product,
    read_products,
    read_science_data,
    rebin_xmet_to_vertical_track,
    search_product,
)
from .product.file_info import (
    FileAgency,
    FileLatency,
    FileMissionID,
    FileType,
    ProductInfo,
    get_file_type,
    get_product_info,
    get_product_infos,
    is_earthcare_product,
)
from .product.level1.atl_nom_1b import add_depol_ratio
from .search import search_files_by_regex

__all__ = [
    "read_hdr_fixed_header",
    "read_header_data",
    "read_product",
    "read_products",
    "read_science_data",
    "read_nc",
    "rebin_xmet_to_vertical_track",
    "search_product",
    "FileAgency",
    "FileLatency",
    "FileMissionID",
    "FileType",
    "ProductInfo",
    "get_file_type",
    "get_product_info",
    "get_product_infos",
    "is_earthcare_product",
    "search_files_by_regex",
    "read_polly",
    "read_any",
    "add_depol_ratio",
]
