"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaInvokeAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * The action to write the data to an AWS Lambda function.
 */
class LambdaInvokeAction {
    /**
     * @param func the AWS Lambda function to be invoked by this action
     */
    constructor(func) {
        this.func = func;
    }
    /**
     * @internal
     */
    _bind(_scope, options) {
        this.func.grantInvoke(options.role);
        return {
            configuration: {
                lambda: {
                    functionArn: this.func.functionArn,
                },
            },
        };
    }
}
exports.LambdaInvokeAction = LambdaInvokeAction;
_a = JSII_RTTI_SYMBOL_1;
LambdaInvokeAction[_a] = { fqn: "@aws-cdk/aws-iotevents-actions-alpha.LambdaInvokeAction", version: "2.37.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGFtYmRhLWludm9rZS1hY3Rpb24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJsYW1iZGEtaW52b2tlLWFjdGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUlBOztHQUVHO0FBQ0gsTUFBYSxrQkFBa0I7SUFDN0I7O09BRUc7SUFDSCxZQUE2QixJQUFzQjtRQUF0QixTQUFJLEdBQUosSUFBSSxDQUFrQjtLQUNsRDtJQUVEOztPQUVHO0lBQ0ksS0FBSyxDQUFDLE1BQWlCLEVBQUUsT0FBb0M7UUFDbEUsSUFBSSxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDO1FBQ3BDLE9BQU87WUFDTCxhQUFhLEVBQUU7Z0JBQ2IsTUFBTSxFQUFFO29CQUNOLFdBQVcsRUFBRSxJQUFJLENBQUMsSUFBSSxDQUFDLFdBQVc7aUJBQ25DO2FBQ0Y7U0FDRixDQUFDO0tBQ0g7O0FBbkJILGdEQW9CQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGlvdGV2ZW50cyBmcm9tICdAYXdzLWNkay9hd3MtaW90ZXZlbnRzLWFscGhhJztcbmltcG9ydCAqIGFzIGxhbWJkYSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtbGFtYmRhJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG4vKipcbiAqIFRoZSBhY3Rpb24gdG8gd3JpdGUgdGhlIGRhdGEgdG8gYW4gQVdTIExhbWJkYSBmdW5jdGlvbi5cbiAqL1xuZXhwb3J0IGNsYXNzIExhbWJkYUludm9rZUFjdGlvbiBpbXBsZW1lbnRzIGlvdGV2ZW50cy5JQWN0aW9uIHtcbiAgLyoqXG4gICAqIEBwYXJhbSBmdW5jIHRoZSBBV1MgTGFtYmRhIGZ1bmN0aW9uIHRvIGJlIGludm9rZWQgYnkgdGhpcyBhY3Rpb25cbiAgICovXG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgZnVuYzogbGFtYmRhLklGdW5jdGlvbikge1xuICB9XG5cbiAgLyoqXG4gICAqIEBpbnRlcm5hbFxuICAgKi9cbiAgcHVibGljIF9iaW5kKF9zY29wZTogQ29uc3RydWN0LCBvcHRpb25zOiBpb3RldmVudHMuQWN0aW9uQmluZE9wdGlvbnMpOiBpb3RldmVudHMuQWN0aW9uQ29uZmlnIHtcbiAgICB0aGlzLmZ1bmMuZ3JhbnRJbnZva2Uob3B0aW9ucy5yb2xlKTtcbiAgICByZXR1cm4ge1xuICAgICAgY29uZmlndXJhdGlvbjoge1xuICAgICAgICBsYW1iZGE6IHtcbiAgICAgICAgICBmdW5jdGlvbkFybjogdGhpcy5mdW5jLmZ1bmN0aW9uQXJuLFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICB9O1xuICB9XG59XG4iXX0=