"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimerDuration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * The duration of the timer.
 */
class TimerDuration {
    /**
     * Create a timer-duration from Duration.
     *
     * The range of the duration is 60-31622400 seconds.
     * The evaluated result of the duration expression is rounded down to the nearest whole number.
     * For example, if you set the timer to 60.99 seconds, the evaluated result of the duration expression is 60 seconds.
     */
    static fromDuration(duration) {
        const seconds = duration.toSeconds();
        if (seconds < 60) {
            throw new Error(`duration cannot be less than 60 seconds, got: ${duration.toString()}`);
        }
        if (seconds > 31622400) {
            throw new Error(`duration cannot be greater than 31622400 seconds, got: ${duration.toString()}`);
        }
        return new TimerDurationImpl(seconds.toString());
    }
    /**
     * Create a timer-duration from Expression.
     *
     * You can use a string expression that includes numbers, variables ($variable.<variable-name>),
     * and input values ($input.<input-name>.<path-to-datum>) as the duration.
     *
     * The range of the duration is 60-31622400 seconds.
     * The evaluated result of the duration expression is rounded down to the nearest whole number.
     * For example, if you set the timer to 60.99 seconds, the evaluated result of the duration expression is 60 seconds.
     */
    static fromExpression(expression) {
        return new TimerDurationImpl(expression.evaluate());
    }
}
exports.TimerDuration = TimerDuration;
_a = JSII_RTTI_SYMBOL_1;
TimerDuration[_a] = { fqn: "@aws-cdk/aws-iotevents-actions-alpha.TimerDuration", version: "2.37.1-alpha.0" };
class TimerDurationImpl extends TimerDuration {
    constructor(durationExpression) {
        super();
        this.durationExpression = durationExpression;
    }
    _bind() {
        return this.durationExpression;
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGltZXItZHVyYXRpb24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ0aW1lci1kdXJhdGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUdBOztHQUVHO0FBQ0gsTUFBc0IsYUFBYTtJQUNqQzs7Ozs7O09BTUc7SUFDSSxNQUFNLENBQUMsWUFBWSxDQUFDLFFBQWtCO1FBQzNDLE1BQU0sT0FBTyxHQUFHLFFBQVEsQ0FBQyxTQUFTLEVBQUUsQ0FBQztRQUNyQyxJQUFJLE9BQU8sR0FBRyxFQUFFLEVBQUU7WUFDaEIsTUFBTSxJQUFJLEtBQUssQ0FBQyxpREFBaUQsUUFBUSxDQUFDLFFBQVEsRUFBRSxFQUFFLENBQUMsQ0FBQztTQUN6RjtRQUNELElBQUksT0FBTyxHQUFHLFFBQVEsRUFBRTtZQUN0QixNQUFNLElBQUksS0FBSyxDQUFDLDBEQUEwRCxRQUFRLENBQUMsUUFBUSxFQUFFLEVBQUUsQ0FBQyxDQUFDO1NBQ2xHO1FBQ0QsT0FBTyxJQUFJLGlCQUFpQixDQUFDLE9BQU8sQ0FBQyxRQUFRLEVBQUUsQ0FBQyxDQUFDO0tBQ2xEO0lBRUQ7Ozs7Ozs7OztPQVNHO0lBQ0ksTUFBTSxDQUFDLGNBQWMsQ0FBQyxVQUFnQztRQUMzRCxPQUFPLElBQUksaUJBQWlCLENBQUMsVUFBVSxDQUFDLFFBQVEsRUFBRSxDQUFDLENBQUM7S0FDckQ7O0FBL0JILHNDQXFDQzs7O0FBRUQsTUFBTSxpQkFBa0IsU0FBUSxhQUFhO0lBQzNDLFlBQTZCLGtCQUEwQjtRQUNyRCxLQUFLLEVBQUUsQ0FBQztRQURtQix1QkFBa0IsR0FBbEIsa0JBQWtCLENBQVE7S0FFdEQ7SUFFTSxLQUFLO1FBQ1YsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUM7S0FDaEM7Q0FDRiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGlvdGV2ZW50cyBmcm9tICdAYXdzLWNkay9hd3MtaW90ZXZlbnRzLWFscGhhJztcbmltcG9ydCB7IER1cmF0aW9uIH0gZnJvbSAnYXdzLWNkay1saWInO1xuXG4vKipcbiAqIFRoZSBkdXJhdGlvbiBvZiB0aGUgdGltZXIuXG4gKi9cbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBUaW1lckR1cmF0aW9uIHtcbiAgLyoqXG4gICAqIENyZWF0ZSBhIHRpbWVyLWR1cmF0aW9uIGZyb20gRHVyYXRpb24uXG4gICAqXG4gICAqIFRoZSByYW5nZSBvZiB0aGUgZHVyYXRpb24gaXMgNjAtMzE2MjI0MDAgc2Vjb25kcy5cbiAgICogVGhlIGV2YWx1YXRlZCByZXN1bHQgb2YgdGhlIGR1cmF0aW9uIGV4cHJlc3Npb24gaXMgcm91bmRlZCBkb3duIHRvIHRoZSBuZWFyZXN0IHdob2xlIG51bWJlci5cbiAgICogRm9yIGV4YW1wbGUsIGlmIHlvdSBzZXQgdGhlIHRpbWVyIHRvIDYwLjk5IHNlY29uZHMsIHRoZSBldmFsdWF0ZWQgcmVzdWx0IG9mIHRoZSBkdXJhdGlvbiBleHByZXNzaW9uIGlzIDYwIHNlY29uZHMuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21EdXJhdGlvbihkdXJhdGlvbjogRHVyYXRpb24pOiBUaW1lckR1cmF0aW9uIHtcbiAgICBjb25zdCBzZWNvbmRzID0gZHVyYXRpb24udG9TZWNvbmRzKCk7XG4gICAgaWYgKHNlY29uZHMgPCA2MCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKGBkdXJhdGlvbiBjYW5ub3QgYmUgbGVzcyB0aGFuIDYwIHNlY29uZHMsIGdvdDogJHtkdXJhdGlvbi50b1N0cmluZygpfWApO1xuICAgIH1cbiAgICBpZiAoc2Vjb25kcyA+IDMxNjIyNDAwKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoYGR1cmF0aW9uIGNhbm5vdCBiZSBncmVhdGVyIHRoYW4gMzE2MjI0MDAgc2Vjb25kcywgZ290OiAke2R1cmF0aW9uLnRvU3RyaW5nKCl9YCk7XG4gICAgfVxuICAgIHJldHVybiBuZXcgVGltZXJEdXJhdGlvbkltcGwoc2Vjb25kcy50b1N0cmluZygpKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBDcmVhdGUgYSB0aW1lci1kdXJhdGlvbiBmcm9tIEV4cHJlc3Npb24uXG4gICAqXG4gICAqIFlvdSBjYW4gdXNlIGEgc3RyaW5nIGV4cHJlc3Npb24gdGhhdCBpbmNsdWRlcyBudW1iZXJzLCB2YXJpYWJsZXMgKCR2YXJpYWJsZS48dmFyaWFibGUtbmFtZT4pLFxuICAgKiBhbmQgaW5wdXQgdmFsdWVzICgkaW5wdXQuPGlucHV0LW5hbWU+LjxwYXRoLXRvLWRhdHVtPikgYXMgdGhlIGR1cmF0aW9uLlxuICAgKlxuICAgKiBUaGUgcmFuZ2Ugb2YgdGhlIGR1cmF0aW9uIGlzIDYwLTMxNjIyNDAwIHNlY29uZHMuXG4gICAqIFRoZSBldmFsdWF0ZWQgcmVzdWx0IG9mIHRoZSBkdXJhdGlvbiBleHByZXNzaW9uIGlzIHJvdW5kZWQgZG93biB0byB0aGUgbmVhcmVzdCB3aG9sZSBudW1iZXIuXG4gICAqIEZvciBleGFtcGxlLCBpZiB5b3Ugc2V0IHRoZSB0aW1lciB0byA2MC45OSBzZWNvbmRzLCB0aGUgZXZhbHVhdGVkIHJlc3VsdCBvZiB0aGUgZHVyYXRpb24gZXhwcmVzc2lvbiBpcyA2MCBzZWNvbmRzLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBmcm9tRXhwcmVzc2lvbihleHByZXNzaW9uOiBpb3RldmVudHMuRXhwcmVzc2lvbik6IFRpbWVyRHVyYXRpb24ge1xuICAgIHJldHVybiBuZXcgVGltZXJEdXJhdGlvbkltcGwoZXhwcmVzc2lvbi5ldmFsdWF0ZSgpKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBAaW50ZXJuYWxcbiAgICovXG4gIHB1YmxpYyBhYnN0cmFjdCBfYmluZCgpOiBzdHJpbmc7XG59XG5cbmNsYXNzIFRpbWVyRHVyYXRpb25JbXBsIGV4dGVuZHMgVGltZXJEdXJhdGlvbiB7XG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgZHVyYXRpb25FeHByZXNzaW9uOiBzdHJpbmcpIHtcbiAgICBzdXBlcigpO1xuICB9XG5cbiAgcHVibGljIF9iaW5kKCkge1xuICAgIHJldHVybiB0aGlzLmR1cmF0aW9uRXhwcmVzc2lvbjtcbiAgfVxufVxuIl19