# Generated by Django 3.0.2 on 2020-06-06 15:34

import django.db.models.deletion
import markitup.fields
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id',
                 models.AutoField(auto_created=True, primary_key=True, serialize=False,
                                  verbose_name='ID')),
                ('name', models.CharField(max_length=250)),
            ],
        ),
        migrations.CreateModel(
            name='Entry',
            fields=[
                ('id',
                 models.AutoField(auto_created=True, primary_key=True, serialize=False,
                                  verbose_name='ID')),
                ('created',
                 models.DateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified',
                 models.DateTimeField(auto_now=True, verbose_name='modified')),
                ('title', models.CharField(max_length=255)),
                ('slug', models.SlugField(editable=False, max_length=255, unique=True)),
                ('resume',
                 markitup.fields.MarkupField(blank=True, no_rendered_field=True,
                                             null=True)),
                ('content', markitup.fields.MarkupField(no_rendered_field=True)),
                ('is_published', models.BooleanField(default=False)),
                ('published_timestamp',
                 models.DateTimeField(blank=True, editable=False, null=True)),
                ('feature_image',
                 models.ImageField(blank=True, upload_to='blog/images')),
                ('published_content', models.TextField()),
                ('_resume_rendered', models.TextField(blank=True, editable=False)),
                ('_content_rendered', models.TextField(blank=True, editable=False)),
                ('author', models.ForeignKey(
                    null=True, to=settings.AUTH_USER_MODEL,
                    on_delete=django.db.models.deletion.CASCADE)),
                ('categories', models.ManyToManyField(to='blog.Category')),
            ],
            options={
                'verbose_name_plural': 'entries',
            },
        ),
        migrations.CreateModel(
            name='EntryImage',
            fields=[
                ('id',
                 models.AutoField(auto_created=True, primary_key=True, serialize=False,
                                  verbose_name='ID')),
                ('created',
                 models.DateTimeField(auto_now_add=True, verbose_name='created')),
                ('modified',
                 models.DateTimeField(auto_now=True, verbose_name='modified')),
                ('image', models.ImageField(blank=True, upload_to='blog/images')),
                ('entry', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                            to='blog.Entry')),
            ],
        ),
    ]
