# Generated by Django 3.2.11 on 2022-05-05 03:23

import django.core.validators
import edc_model.models.fields.date_estimated
import edc_model.validators.date
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("effect_lists", "0008_delete_medicinesday14"),
        ("effect_subject", "0054_auto_20220504_1918"),
    ]

    operations = [
        migrations.RenameField(
            model_name="arvhistory",
            old_name="current_arv_regimen_other",
            new_name="current_art_regimen_other",
        ),
        migrations.RenameField(
            model_name="arvhistory",
            old_name="initial_arv_regimen_other",
            new_name="initial_art_regimen_other",
        ),
        migrations.RenameField(
            model_name="historicalarvhistory",
            old_name="current_arv_regimen_other",
            new_name="current_art_regimen_other",
        ),
        migrations.RenameField(
            model_name="historicalarvhistory",
            old_name="initial_arv_regimen_other",
            new_name="initial_art_regimen_other",
        ),
        migrations.RemoveField(
            model_name="arvhistory",
            name="current_arv_date",
        ),
        migrations.RemoveField(
            model_name="arvhistory",
            name="current_arv_date_estimated",
        ),
        migrations.RemoveField(
            model_name="arvhistory",
            name="current_arv_defaulted_date",
        ),
        migrations.RemoveField(
            model_name="arvhistory",
            name="current_arv_defaulted_date_estimated",
        ),
        migrations.RemoveField(
            model_name="arvhistory",
            name="current_arv_is_adherent",
        ),
        migrations.RemoveField(
            model_name="arvhistory",
            name="current_arv_is_defaulted",
        ),
        migrations.RemoveField(
            model_name="arvhistory",
            name="current_arv_regimen",
        ),
        migrations.RemoveField(
            model_name="arvhistory",
            name="current_arv_tablets_missed",
        ),
        migrations.RemoveField(
            model_name="arvhistory",
            name="ever_taken_arv",
        ),
        migrations.RemoveField(
            model_name="arvhistory",
            name="has_switched_regimen",
        ),
        migrations.RemoveField(
            model_name="arvhistory",
            name="initial_arv_date",
        ),
        migrations.RemoveField(
            model_name="arvhistory",
            name="initial_arv_date_estimated",
        ),
        migrations.RemoveField(
            model_name="arvhistory",
            name="initial_arv_regimen",
        ),
        migrations.RemoveField(
            model_name="arvhistory",
            name="last_cd4",
        ),
        migrations.RemoveField(
            model_name="arvhistory",
            name="last_viral_load",
        ),
        migrations.RemoveField(
            model_name="arvhistory",
            name="taking_arv_at_crag",
        ),
        migrations.RemoveField(
            model_name="arvhistory",
            name="vl_date_estimated",
        ),
        migrations.RemoveField(
            model_name="historicalarvhistory",
            name="current_arv_date",
        ),
        migrations.RemoveField(
            model_name="historicalarvhistory",
            name="current_arv_date_estimated",
        ),
        migrations.RemoveField(
            model_name="historicalarvhistory",
            name="current_arv_defaulted_date",
        ),
        migrations.RemoveField(
            model_name="historicalarvhistory",
            name="current_arv_defaulted_date_estimated",
        ),
        migrations.RemoveField(
            model_name="historicalarvhistory",
            name="current_arv_is_adherent",
        ),
        migrations.RemoveField(
            model_name="historicalarvhistory",
            name="current_arv_is_defaulted",
        ),
        migrations.RemoveField(
            model_name="historicalarvhistory",
            name="current_arv_tablets_missed",
        ),
        migrations.RemoveField(
            model_name="historicalarvhistory",
            name="ever_taken_arv",
        ),
        migrations.RemoveField(
            model_name="historicalarvhistory",
            name="has_switched_regimen",
        ),
        migrations.RemoveField(
            model_name="historicalarvhistory",
            name="initial_arv_date",
        ),
        migrations.RemoveField(
            model_name="historicalarvhistory",
            name="initial_arv_date_estimated",
        ),
        migrations.RemoveField(
            model_name="historicalarvhistory",
            name="last_cd4",
        ),
        migrations.RemoveField(
            model_name="historicalarvhistory",
            name="last_viral_load",
        ),
        migrations.RemoveField(
            model_name="historicalarvhistory",
            name="taking_arv_at_crag",
        ),
        migrations.RemoveField(
            model_name="historicalarvhistory",
            name="vl_date_estimated",
        ),
        migrations.AddField(
            model_name="arvhistory",
            name="art_doses_missed",
            field=models.IntegerField(
                blank=True,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(31),
                ],
                verbose_name="If not `adherent`, how many doses missed in the last month?",
            ),
        ),
        migrations.AddField(
            model_name="arvhistory",
            name="cd4_result",
            field=models.IntegerField(
                blank=True,
                help_text="mm<sup>3</sup>",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(99),
                ],
                verbose_name="CD4 result",
            ),
        ),
        migrations.AddField(
            model_name="arvhistory",
            name="current_art_date",
            field=models.DateField(
                blank=True,
                null=True,
                validators=[edc_model.validators.date.date_not_future],
                verbose_name="If switched, when was their <u>current or most recent</u> ART regimen started?",
            ),
        ),
        migrations.AddField(
            model_name="arvhistory",
            name="current_art_date_estimated",
            field=edc_model.models.fields.date_estimated.IsDateEstimatedFieldNa(
                choices=[
                    ("N/A", "Not applicable"),
                    ("not_estimated", "No."),
                    ("D", "Yes, estimated the Day"),
                    ("MD", "Yes, estimated Month and Day"),
                    ("YMD", "Yes, estimated Year, Month and Day"),
                ],
                default="N/A",
                help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                max_length=25,
                verbose_name="If switched, is the current ART start date estimated?",
            ),
        ),
        migrations.AddField(
            model_name="arvhistory",
            name="current_art_regimen",
            field=models.ManyToManyField(
                related_name="current_arv",
                to="effect_lists.ArvRegimens",
                verbose_name="If switched, what is their current (or most recent) ART regimen?",
            ),
        ),
        migrations.AddField(
            model_name="arvhistory",
            name="defaulted_date",
            field=models.DateField(
                blank=True,
                null=True,
                validators=[edc_model.validators.date.date_not_future],
                verbose_name="If `defaulted`, on what date did they default from their <u>current</u> ART regimen?",
            ),
        ),
        migrations.AddField(
            model_name="arvhistory",
            name="defaulted_date_estimated",
            field=edc_model.models.fields.date_estimated.IsDateEstimatedFieldNa(
                choices=[
                    ("N/A", "Not applicable"),
                    ("not_estimated", "No."),
                    ("D", "Yes, estimated the Day"),
                    ("MD", "Yes, estimated Month and Day"),
                    ("YMD", "Yes, estimated Year, Month and Day"),
                ],
                default="N/A",
                help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                max_length=25,
                verbose_name="Is the `defaulted` date estimated?",
            ),
        ),
        migrations.AddField(
            model_name="arvhistory",
            name="ever_on_art",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="Yes",
                max_length=5,
                verbose_name="Was the patient on ART <u>prior</u> to CrAg test?",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="arvhistory",
            name="has_cd4",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="Yes",
                max_length=15,
                verbose_name="Is the last CD4 result available?",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="arvhistory",
            name="has_defaulted",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                help_text="Defaulted means no ART for at least one month.",
                max_length=5,
                verbose_name="Has the patient <u>now</u> defaulted from their <u>current</u> ART regimen?",
            ),
        ),
        migrations.AddField(
            model_name="arvhistory",
            name="has_switched_art_regimen",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                max_length=5,
                verbose_name="Has the patient ever <u>switched</u> ART regimen?",
            ),
        ),
        migrations.AddField(
            model_name="arvhistory",
            name="has_viral_load_result",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="Yes",
                max_length=15,
                verbose_name="Is the last viral load result available?",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="arvhistory",
            name="initial_art_date",
            field=models.DateField(
                blank=True,
                null=True,
                validators=[edc_model.validators.date.date_not_future],
                verbose_name="When did the patient <u>start</u> ART for the first time.",
            ),
        ),
        migrations.AddField(
            model_name="arvhistory",
            name="initial_art_date_estimated",
            field=edc_model.models.fields.date_estimated.IsDateEstimatedFieldNa(
                choices=[
                    ("N/A", "Not applicable"),
                    ("not_estimated", "No."),
                    ("D", "Yes, estimated the Day"),
                    ("MD", "Yes, estimated Month and Day"),
                    ("YMD", "Yes, estimated Year, Month and Day"),
                ],
                default="N/A",
                help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                max_length=25,
                verbose_name="Is this ART start date estimated?",
            ),
        ),
        migrations.AddField(
            model_name="arvhistory",
            name="initial_art_regimen",
            field=models.ManyToManyField(
                related_name="initial_arv",
                to="effect_lists.ArvRegimens",
                verbose_name="Which drugs were prescribed for their <u>first</u> ART regimen?",
            ),
        ),
        migrations.AddField(
            model_name="arvhistory",
            name="is_adherent",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                max_length=5,
                verbose_name="If the patient is currently on ART, are they <u>adherent</u> to their <u>current</u> ART regimen?",
            ),
        ),
        migrations.AddField(
            model_name="arvhistory",
            name="on_art_at_crag",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="Yes",
                max_length=5,
                verbose_name="Was the patient on ART <u>at time of</u> CrAg test?",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="arvhistory",
            name="viral_load_date_estimated",
            field=edc_model.models.fields.date_estimated.IsDateEstimatedFieldNa(
                choices=[
                    ("N/A", "Not applicable"),
                    ("not_estimated", "No."),
                    ("D", "Yes, estimated the Day"),
                    ("MD", "Yes, estimated Month and Day"),
                    ("YMD", "Yes, estimated Year, Month and Day"),
                ],
                default="N/A",
                help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                max_length=25,
                verbose_name="Is the viral load date estimated?",
            ),
        ),
        migrations.AddField(
            model_name="arvhistory",
            name="viral_load_result",
            field=models.DecimalField(
                blank=True,
                decimal_places=3,
                help_text="copies/mL",
                max_digits=10,
                null=True,
                verbose_name="Viral load result",
            ),
        ),
        migrations.AddField(
            model_name="historicalarvhistory",
            name="art_doses_missed",
            field=models.IntegerField(
                blank=True,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(31),
                ],
                verbose_name="If not `adherent`, how many doses missed in the last month?",
            ),
        ),
        migrations.AddField(
            model_name="historicalarvhistory",
            name="cd4_result",
            field=models.IntegerField(
                blank=True,
                help_text="mm<sup>3</sup>",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(99),
                ],
                verbose_name="CD4 result",
            ),
        ),
        migrations.AddField(
            model_name="historicalarvhistory",
            name="current_art_date",
            field=models.DateField(
                blank=True,
                null=True,
                validators=[edc_model.validators.date.date_not_future],
                verbose_name="If switched, when was their <u>current or most recent</u> ART regimen started?",
            ),
        ),
        migrations.AddField(
            model_name="historicalarvhistory",
            name="current_art_date_estimated",
            field=edc_model.models.fields.date_estimated.IsDateEstimatedFieldNa(
                choices=[
                    ("N/A", "Not applicable"),
                    ("not_estimated", "No."),
                    ("D", "Yes, estimated the Day"),
                    ("MD", "Yes, estimated Month and Day"),
                    ("YMD", "Yes, estimated Year, Month and Day"),
                ],
                default="N/A",
                help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                max_length=25,
                verbose_name="If switched, is the current ART start date estimated?",
            ),
        ),
        migrations.AddField(
            model_name="historicalarvhistory",
            name="defaulted_date",
            field=models.DateField(
                blank=True,
                null=True,
                validators=[edc_model.validators.date.date_not_future],
                verbose_name="If `defaulted`, on what date did they default from their <u>current</u> ART regimen?",
            ),
        ),
        migrations.AddField(
            model_name="historicalarvhistory",
            name="defaulted_date_estimated",
            field=edc_model.models.fields.date_estimated.IsDateEstimatedFieldNa(
                choices=[
                    ("N/A", "Not applicable"),
                    ("not_estimated", "No."),
                    ("D", "Yes, estimated the Day"),
                    ("MD", "Yes, estimated Month and Day"),
                    ("YMD", "Yes, estimated Year, Month and Day"),
                ],
                default="N/A",
                help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                max_length=25,
                verbose_name="Is the `defaulted` date estimated?",
            ),
        ),
        migrations.AddField(
            model_name="historicalarvhistory",
            name="ever_on_art",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="Yes",
                max_length=5,
                verbose_name="Was the patient on ART <u>prior</u> to CrAg test?",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="historicalarvhistory",
            name="has_cd4",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="Yes",
                max_length=15,
                verbose_name="Is the last CD4 result available?",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="historicalarvhistory",
            name="has_defaulted",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                help_text="Defaulted means no ART for at least one month.",
                max_length=5,
                verbose_name="Has the patient <u>now</u> defaulted from their <u>current</u> ART regimen?",
            ),
        ),
        migrations.AddField(
            model_name="historicalarvhistory",
            name="has_switched_art_regimen",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                max_length=5,
                verbose_name="Has the patient ever <u>switched</u> ART regimen?",
            ),
        ),
        migrations.AddField(
            model_name="historicalarvhistory",
            name="has_viral_load_result",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="Yes",
                max_length=15,
                verbose_name="Is the last viral load result available?",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="historicalarvhistory",
            name="initial_art_date",
            field=models.DateField(
                blank=True,
                null=True,
                validators=[edc_model.validators.date.date_not_future],
                verbose_name="When did the patient <u>start</u> ART for the first time.",
            ),
        ),
        migrations.AddField(
            model_name="historicalarvhistory",
            name="initial_art_date_estimated",
            field=edc_model.models.fields.date_estimated.IsDateEstimatedFieldNa(
                choices=[
                    ("N/A", "Not applicable"),
                    ("not_estimated", "No."),
                    ("D", "Yes, estimated the Day"),
                    ("MD", "Yes, estimated Month and Day"),
                    ("YMD", "Yes, estimated Year, Month and Day"),
                ],
                default="N/A",
                help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                max_length=25,
                verbose_name="Is this ART start date estimated?",
            ),
        ),
        migrations.AddField(
            model_name="historicalarvhistory",
            name="is_adherent",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                max_length=5,
                verbose_name="If the patient is currently on ART, are they <u>adherent</u> to their <u>current</u> ART regimen?",
            ),
        ),
        migrations.AddField(
            model_name="historicalarvhistory",
            name="on_art_at_crag",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="Yes",
                max_length=5,
                verbose_name="Was the patient on ART <u>at time of</u> CrAg test?",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="historicalarvhistory",
            name="viral_load_date_estimated",
            field=edc_model.models.fields.date_estimated.IsDateEstimatedFieldNa(
                choices=[
                    ("N/A", "Not applicable"),
                    ("not_estimated", "No."),
                    ("D", "Yes, estimated the Day"),
                    ("MD", "Yes, estimated Month and Day"),
                    ("YMD", "Yes, estimated Year, Month and Day"),
                ],
                default="N/A",
                help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                max_length=25,
                verbose_name="Is the viral load date estimated?",
            ),
        ),
        migrations.AddField(
            model_name="historicalarvhistory",
            name="viral_load_result",
            field=models.DecimalField(
                blank=True,
                decimal_places=3,
                help_text="copies/mL",
                max_digits=10,
                null=True,
                verbose_name="Viral load result",
            ),
        ),
        migrations.AlterField(
            model_name="arvhistory",
            name="cd4_date_estimated",
            field=edc_model.models.fields.date_estimated.IsDateEstimatedFieldNa(
                choices=[
                    ("N/A", "Not applicable"),
                    ("not_estimated", "No."),
                    ("D", "Yes, estimated the Day"),
                    ("MD", "Yes, estimated Month and Day"),
                    ("YMD", "Yes, estimated Year, Month and Day"),
                ],
                default="N/A",
                help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                max_length=25,
                verbose_name="Is the CD4 date estimated?",
            ),
        ),
        migrations.AlterField(
            model_name="arvhistory",
            name="viral_load_date",
            field=models.DateField(
                blank=True,
                null=True,
                validators=[edc_model.validators.date.date_not_future],
                verbose_name="Viral load date",
            ),
        ),
        migrations.AlterField(
            model_name="historicalarvhistory",
            name="cd4_date_estimated",
            field=edc_model.models.fields.date_estimated.IsDateEstimatedFieldNa(
                choices=[
                    ("N/A", "Not applicable"),
                    ("not_estimated", "No."),
                    ("D", "Yes, estimated the Day"),
                    ("MD", "Yes, estimated Month and Day"),
                    ("YMD", "Yes, estimated Year, Month and Day"),
                ],
                default="N/A",
                help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                max_length=25,
                verbose_name="Is the CD4 date estimated?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalarvhistory",
            name="viral_load_date",
            field=models.DateField(
                blank=True,
                null=True,
                validators=[edc_model.validators.date.date_not_future],
                verbose_name="Viral load date",
            ),
        ),
    ]
