# Generated by Django 3.2 on 2022-09-20 14:59

import django.core.validators
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("effect_lists", "0012_auto_20220920_1659"),
        ("effect_subject", "0090_auto_20220915_1612"),
    ]

    operations = [
        migrations.AddField(
            model_name="historicalstudymedication",
            name="flucon_modified",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                max_length=15,
                verbose_name="Have there been any modifications to fluconazole dose since the last report?",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedication",
            name="flucon_next_dose",
            field=models.CharField(
                choices=[
                    ("today", "Today"),
                    ("tomorrow", "Tomorrow"),
                    ("N/A", "Not applicable"),
                ],
                default="N/A",
                max_length=15,
                verbose_name="First fluconazole dose administered",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedication",
            name="flucyt_dose_0400",
            field=models.IntegerField(
                blank=True,
                help_text="in mg",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="Dose at 04:00",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedication",
            name="flucyt_dose_1000",
            field=models.IntegerField(
                blank=True,
                help_text="in mg",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="Dose at 10:00",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedication",
            name="flucyt_dose_1600",
            field=models.IntegerField(
                blank=True,
                help_text="in mg",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="Dose at 16:00",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedication",
            name="flucyt_dose_2200",
            field=models.IntegerField(
                blank=True,
                help_text="in mg",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="Dose at 22:00",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedication",
            name="flucyt_dose_expected",
            field=models.IntegerField(
                blank=True,
                help_text="in mg/d. Validate against weight and rando arm 100mg/kg, round down to nearest 500mg total e.g. 47kg = 4700mg, participant gets 4500mg daily",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="Flucytosine dose expected",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedication",
            name="flucyt_modified",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                max_length=15,
                verbose_name="Have there been any modifications to flucytosine dose since the last report?",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedication",
            name="flucyt_next_dose",
            field=models.CharField(
                choices=[
                    ("0400", "at 04:00"),
                    ("1000", "at 10:00"),
                    ("1600", "at 16:00"),
                    ("2200", "at 22:00"),
                    ("N/A", "Not applicable"),
                ],
                default="N/A",
                max_length=5,
                verbose_name="First flucytosine dose administered",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedication",
            name="modifications_reason_other",
            field=models.TextField(
                blank=True,
                max_length=250,
                null=True,
                verbose_name="If other reason, please provide details ...",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedicationbaseline",
            name="flucon_modified",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                max_length=15,
                verbose_name="Have there been any modifications to fluconazole dose since the last report?",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedicationbaseline",
            name="flucon_next_dose",
            field=models.CharField(
                choices=[
                    ("today", "Today"),
                    ("tomorrow", "Tomorrow"),
                    ("N/A", "Not applicable"),
                ],
                default="N/A",
                max_length=15,
                verbose_name="First fluconazole dose administered",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedicationbaseline",
            name="flucyt_dose_0400",
            field=models.IntegerField(
                blank=True,
                help_text="in mg",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="Dose at 04:00",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedicationbaseline",
            name="flucyt_dose_1000",
            field=models.IntegerField(
                blank=True,
                help_text="in mg",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="Dose at 10:00",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedicationbaseline",
            name="flucyt_dose_1600",
            field=models.IntegerField(
                blank=True,
                help_text="in mg",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="Dose at 16:00",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedicationbaseline",
            name="flucyt_dose_2200",
            field=models.IntegerField(
                blank=True,
                help_text="in mg",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="Dose at 22:00",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedicationbaseline",
            name="flucyt_dose_expected",
            field=models.IntegerField(
                blank=True,
                help_text="in mg/d. Validate against weight and rando arm 100mg/kg, round down to nearest 500mg total e.g. 47kg = 4700mg, participant gets 4500mg daily",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="Flucytosine dose expected",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedicationbaseline",
            name="flucyt_modified",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                max_length=15,
                verbose_name="Have there been any modifications to flucytosine dose since the last report?",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedicationbaseline",
            name="flucyt_next_dose",
            field=models.CharField(
                choices=[
                    ("0400", "at 04:00"),
                    ("1000", "at 10:00"),
                    ("1600", "at 16:00"),
                    ("2200", "at 22:00"),
                    ("N/A", "Not applicable"),
                ],
                default="N/A",
                max_length=5,
                verbose_name="First flucytosine dose administered",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedicationbaseline",
            name="modifications_reason_other",
            field=models.TextField(
                blank=True,
                max_length=250,
                null=True,
                verbose_name="If other reason, please provide details ...",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedicationfollowup",
            name="flucon_modified",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                max_length=15,
                verbose_name="Have there been any modifications to fluconazole dose since the last report?",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedicationfollowup",
            name="flucon_next_dose",
            field=models.CharField(
                choices=[
                    ("today", "Today"),
                    ("tomorrow", "Tomorrow"),
                    ("N/A", "Not applicable"),
                ],
                default="N/A",
                max_length=15,
                verbose_name="First fluconazole dose administered",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedicationfollowup",
            name="flucyt_dose_0400",
            field=models.IntegerField(
                blank=True,
                help_text="in mg",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="Dose at 04:00",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedicationfollowup",
            name="flucyt_dose_1000",
            field=models.IntegerField(
                blank=True,
                help_text="in mg",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="Dose at 10:00",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedicationfollowup",
            name="flucyt_dose_1600",
            field=models.IntegerField(
                blank=True,
                help_text="in mg",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="Dose at 16:00",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedicationfollowup",
            name="flucyt_dose_2200",
            field=models.IntegerField(
                blank=True,
                help_text="in mg",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="Dose at 22:00",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedicationfollowup",
            name="flucyt_dose_expected",
            field=models.IntegerField(
                blank=True,
                help_text="in mg/d. Validate against weight and rando arm 100mg/kg, round down to nearest 500mg total e.g. 47kg = 4700mg, participant gets 4500mg daily",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="Flucytosine dose expected",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedicationfollowup",
            name="flucyt_modified",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                max_length=15,
                verbose_name="Have there been any modifications to flucytosine dose since the last report?",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedicationfollowup",
            name="flucyt_next_dose",
            field=models.CharField(
                choices=[
                    ("0400", "at 04:00"),
                    ("1000", "at 10:00"),
                    ("1600", "at 16:00"),
                    ("2200", "at 22:00"),
                    ("N/A", "Not applicable"),
                ],
                default="N/A",
                max_length=5,
                verbose_name="First flucytosine dose administered",
            ),
        ),
        migrations.AddField(
            model_name="historicalstudymedicationfollowup",
            name="modifications_reason_other",
            field=models.TextField(
                blank=True,
                max_length=250,
                null=True,
                verbose_name="If other reason, please provide details ...",
            ),
        ),
        migrations.AddField(
            model_name="studymedication",
            name="flucon_modified",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                max_length=15,
                verbose_name="Have there been any modifications to fluconazole dose since the last report?",
            ),
        ),
        migrations.AddField(
            model_name="studymedication",
            name="flucon_next_dose",
            field=models.CharField(
                choices=[
                    ("today", "Today"),
                    ("tomorrow", "Tomorrow"),
                    ("N/A", "Not applicable"),
                ],
                default="N/A",
                max_length=15,
                verbose_name="First fluconazole dose administered",
            ),
        ),
        migrations.AddField(
            model_name="studymedication",
            name="flucyt_dose_0400",
            field=models.IntegerField(
                blank=True,
                help_text="in mg",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="Dose at 04:00",
            ),
        ),
        migrations.AddField(
            model_name="studymedication",
            name="flucyt_dose_1000",
            field=models.IntegerField(
                blank=True,
                help_text="in mg",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="Dose at 10:00",
            ),
        ),
        migrations.AddField(
            model_name="studymedication",
            name="flucyt_dose_1600",
            field=models.IntegerField(
                blank=True,
                help_text="in mg",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="Dose at 16:00",
            ),
        ),
        migrations.AddField(
            model_name="studymedication",
            name="flucyt_dose_2200",
            field=models.IntegerField(
                blank=True,
                help_text="in mg",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="Dose at 22:00",
            ),
        ),
        migrations.AddField(
            model_name="studymedication",
            name="flucyt_dose_expected",
            field=models.IntegerField(
                blank=True,
                help_text="in mg/d. Validate against weight and rando arm 100mg/kg, round down to nearest 500mg total e.g. 47kg = 4700mg, participant gets 4500mg daily",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="Flucytosine dose expected",
            ),
        ),
        migrations.AddField(
            model_name="studymedication",
            name="flucyt_modified",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                default="N/A",
                max_length=15,
                verbose_name="Have there been any modifications to flucytosine dose since the last report?",
            ),
        ),
        migrations.AddField(
            model_name="studymedication",
            name="flucyt_next_dose",
            field=models.CharField(
                choices=[
                    ("0400", "at 04:00"),
                    ("1000", "at 10:00"),
                    ("1600", "at 16:00"),
                    ("2200", "at 22:00"),
                    ("N/A", "Not applicable"),
                ],
                default="N/A",
                max_length=5,
                verbose_name="First flucytosine dose administered",
            ),
        ),
        migrations.AddField(
            model_name="studymedication",
            name="modifications_reason",
            field=models.ManyToManyField(
                blank=True,
                help_text="Select all that apply.",
                to="effect_lists.DoseModificationReasons",
                verbose_name="Reason for dose change",
            ),
        ),
        migrations.AddField(
            model_name="studymedication",
            name="modifications_reason_other",
            field=models.TextField(
                blank=True,
                max_length=250,
                null=True,
                verbose_name="If other reason, please provide details ...",
            ),
        ),
        migrations.AlterField(
            model_name="historicalstudymedication",
            name="flucon_dose",
            field=models.IntegerField(
                blank=True,
                help_text="in mg/d",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(1200),
                ],
                verbose_name="Fluconazole dose",
            ),
        ),
        migrations.AlterField(
            model_name="historicalstudymedication",
            name="flucon_dose_datetime",
            field=models.DateTimeField(
                blank=True,
                null=True,
                verbose_name="Date and time first fluconazole dose administered",
            ),
        ),
        migrations.AlterField(
            model_name="historicalstudymedication",
            name="flucyt_dose",
            field=models.IntegerField(
                blank=True,
                help_text="in mg/d",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="Flucytosine dose prescribed",
            ),
        ),
        migrations.AlterField(
            model_name="historicalstudymedication",
            name="flucyt_dose_datetime",
            field=models.DateTimeField(
                blank=True,
                null=True,
                verbose_name="Date and time first flucytosine dose administered",
            ),
        ),
        migrations.AlterField(
            model_name="historicalstudymedication",
            name="modifications",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=15,
                null=True,
                verbose_name="Have there been any modifications to study medication since the last report?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalstudymedicationbaseline",
            name="flucon_dose",
            field=models.IntegerField(
                blank=True,
                help_text="in mg/d",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(1200),
                ],
                verbose_name="Fluconazole dose",
            ),
        ),
        migrations.AlterField(
            model_name="historicalstudymedicationbaseline",
            name="flucon_dose_datetime",
            field=models.DateTimeField(
                blank=True,
                null=True,
                verbose_name="Date and time first fluconazole dose administered",
            ),
        ),
        migrations.AlterField(
            model_name="historicalstudymedicationbaseline",
            name="flucyt_dose",
            field=models.IntegerField(
                blank=True,
                help_text="in mg/d",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="Flucytosine dose prescribed",
            ),
        ),
        migrations.AlterField(
            model_name="historicalstudymedicationbaseline",
            name="flucyt_dose_datetime",
            field=models.DateTimeField(
                blank=True,
                null=True,
                verbose_name="Date and time first flucytosine dose administered",
            ),
        ),
        migrations.AlterField(
            model_name="historicalstudymedicationbaseline",
            name="modifications",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=15,
                null=True,
                verbose_name="Have there been any modifications to study medication since the last report?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalstudymedicationfollowup",
            name="flucon_dose",
            field=models.IntegerField(
                blank=True,
                help_text="in mg/d",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(1200),
                ],
                verbose_name="Fluconazole dose",
            ),
        ),
        migrations.AlterField(
            model_name="historicalstudymedicationfollowup",
            name="flucon_dose_datetime",
            field=models.DateTimeField(
                blank=True,
                null=True,
                verbose_name="Date and time first fluconazole dose administered",
            ),
        ),
        migrations.AlterField(
            model_name="historicalstudymedicationfollowup",
            name="flucyt_dose",
            field=models.IntegerField(
                blank=True,
                help_text="in mg/d",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="Flucytosine dose prescribed",
            ),
        ),
        migrations.AlterField(
            model_name="historicalstudymedicationfollowup",
            name="flucyt_dose_datetime",
            field=models.DateTimeField(
                blank=True,
                null=True,
                verbose_name="Date and time first flucytosine dose administered",
            ),
        ),
        migrations.AlterField(
            model_name="historicalstudymedicationfollowup",
            name="modifications",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=15,
                null=True,
                verbose_name="Have there been any modifications to study medication since the last report?",
            ),
        ),
        migrations.AlterField(
            model_name="studymedication",
            name="flucon_dose",
            field=models.IntegerField(
                blank=True,
                help_text="in mg/d",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(1200),
                ],
                verbose_name="Fluconazole dose",
            ),
        ),
        migrations.AlterField(
            model_name="studymedication",
            name="flucon_dose_datetime",
            field=models.DateTimeField(
                blank=True,
                null=True,
                verbose_name="Date and time first fluconazole dose administered",
            ),
        ),
        migrations.AlterField(
            model_name="studymedication",
            name="flucyt_dose",
            field=models.IntegerField(
                blank=True,
                help_text="in mg/d",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="Flucytosine dose prescribed",
            ),
        ),
        migrations.AlterField(
            model_name="studymedication",
            name="flucyt_dose_datetime",
            field=models.DateTimeField(
                blank=True,
                null=True,
                verbose_name="Date and time first flucytosine dose administered",
            ),
        ),
        migrations.AlterField(
            model_name="studymedication",
            name="modifications",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=15,
                null=True,
                verbose_name="Have there been any modifications to study medication since the last report?",
            ),
        ),
    ]
