# Generated by Django 5.1.3 on 2025-01-10 16:49

import django.core.validators
from django.db import migrations, models
from tqdm import tqdm


class DataMigrationError(Exception):
    pass


def verify_vl_result_migration(apps, schema_editor):
    model_cls = apps.get_model("effect_subject.arvhistory")
    qs = model_cls.objects.all()
    total = qs.count()

    print(
        f"\nVerifying {total} Arv History `viral_load_result` against "
        "`retired_viral_load_result` ..."
    )
    for obj in tqdm(qs, total=total):
        if obj.viral_load_result != obj.retired_viral_load_result:
            raise DataMigrationError(
                "Error. Expected `viral_load_result` to equal `retired_viral_load_result`."
                f"Got {obj.viral_load_result=} and {obj.retired_viral_load_result=}."
            )
    print("Done verifying")


class Migration(migrations.Migration):
    """Note: Migrations effect_subject/migrations/0119-0123 are all
    related, and expected to be run together.  See also ticket #658.
    """

    dependencies = [
        ("effect_subject", "0122_set_vl_quantifier_na_if_na"),
    ]

    operations = [
        migrations.AlterField(
            model_name="arvhistory",
            name="retired_viral_load_result",
            field=models.DecimalField(
                blank=True,
                decimal_places=3,
                help_text="copies/mL (original `viral_load_result` DecimalField, retired/superseded in effect-edc 0.1.57 by `viral_load_result` IntegerField. See also #658)",
                max_digits=10,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(9999999),
                ],
                verbose_name="Viral load result (original `viral_load_result` DecimalField, retired/superseded in effect-edc 0.1.57 by `viral_load_result` IntegerField. See also #658)",
            ),
        ),
        migrations.AlterField(
            model_name="historicalarvhistory",
            name="retired_viral_load_result",
            field=models.DecimalField(
                blank=True,
                decimal_places=3,
                help_text="copies/mL (original `viral_load_result` DecimalField, retired/superseded in effect-edc 0.1.57 by `viral_load_result` IntegerField. See also #658)",
                max_digits=10,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(9999999),
                ],
                verbose_name="Viral load result (original `viral_load_result` DecimalField, retired/superseded in effect-edc 0.1.57 by `viral_load_result` IntegerField. See also #658)",
            ),
        ),
        migrations.RunPython(verify_vl_result_migration),
    ]
