
STOCK_BALANCE_MAPPING = {
    'DATES': '财报日期',
    # 流动资产部分
    'BALANCESTATEMENT_9': '货币资金',
    'BALANCESTATEMENT_67': '结算备付金',
    'BALANCESTATEMENT_181': '融出资金',
    'BALANCESTATEMENT_50': '拆出资金',
    'BALANCESTATEMENT_224': '交易性金融资产',
    'BALANCESTATEMENT_163': '以公允价值计量且其变动计入当期损益的金融资产',
    'BALANCESTATEMENT_10': '其中:交易性金融资产',
    'BALANCESTATEMENT_164': '其中:指定以公允价值计量且其变动计入当期损益的金融资产',
    'BALANCESTATEMENT_51': '衍生金融资产',
    'BALANCESTATEMENT_216': '应收票据及应收账款',
    'BALANCESTATEMENT_11': '应收票据',
    'BALANCESTATEMENT_12': '应收账款',
    'BALANCESTATEMENT_223': '应收款项融资',
    'BALANCESTATEMENT_14': '预付款项',
    'BALANCESTATEMENT_55': '应收保费',
    'BALANCESTATEMENT_57': '应收分保账款',
    'BALANCESTATEMENT_152': '应收分保合同准备金',
    'BALANCESTATEMENT_222': '其他应收款合计',
    'BALANCESTATEMENT_16': '其中:应收利息',
    'BALANCESTATEMENT_15': '其中:应收股利',
    'BALANCESTATEMENT_13': '其中:其他应收款',
    'BALANCESTATEMENT_156': '应收出口退税',
    'BALANCESTATEMENT_157': '应收补贴款',
    'BALANCESTATEMENT_158': '内部应收款',
    'BALANCESTATEMENT_52': '买入返售金融资产',
    'BALANCESTATEMENT_206': '以摊余成本计量的金融资产',
    'BALANCESTATEMENT_17': '存货',
    'BALANCESTATEMENT_207': '以公允价值计量且其变动计入其他综合收益的金融资产',
    'BALANCESTATEMENT_209': '合同资产',
    'BALANCESTATEMENT_202': '划分为持有待售的资产',
    'BALANCESTATEMENT_20': '一年内到期的非流动资产',
    'BALANCESTATEMENT_190': '代理业务资产',
    'BALANCESTATEMENT_21': '其他流动资产',
    'BALANCESTATEMENT_22': '流动资产其他项目',
    'BALANCESTATEMENT_23': '流动资产平衡项目',
    'BALANCESTATEMENT_25': '流动资产合计',
    # 非流动资产部分
    'BALANCESTATEMENT_53': '发放贷款及垫款',
    'BALANCESTATEMENT_217': '债权投资',
    'BALANCESTATEMENT_218': '其他债权投资',
    'BALANCESTATEMENT_211': '以摊余成本计量的金融资产(非流动)',
    'BALANCESTATEMENT_212': '以公允价值计量且其变动计入其他综合收益的金融资产(非流动)',
    'BALANCESTATEMENT_26': '可供出售金融资产',
    'BALANCESTATEMENT_27': '持有至到期投资',
    'BALANCESTATEMENT_30': '长期应收款',
    'BALANCESTATEMENT_29': '长期股权投资',
    'BALANCESTATEMENT_28': '投资性房地产',
    'BALANCESTATEMENT_31': '固定资产',
    'BALANCESTATEMENT_33': '在建工程',
    'BALANCESTATEMENT_32': '工程物资',
    'BALANCESTATEMENT_219': '其他权益工具投资',
    'BALANCESTATEMENT_220': '其他非流动金融资产',
    'BALANCESTATEMENT_34': '清理',
    'BALANCESTATEMENT_35': '生产性生物资产',
    'BALANCESTATEMENT_36': '油气资产',
    'BALANCESTATEMENT_225': '使用权资产',
    'BALANCESTATEMENT_37': '无形资产',
    'BALANCESTATEMENT_44': '非流动资产平衡项目',
    'BALANCESTATEMENT_38': '开发支出',
    'BALANCESTATEMENT_39': '商誉',
    'BALANCESTATEMENT_40': '长期待摊费用',
    'BALANCESTATEMENT_41': '递延所得税资产',
    'BALANCESTATEMENT_42': '其他非流动资产',
    'BALANCESTATEMENT_43': '非流动资产其他项目',
    'BALANCESTATEMENT_46': '非流动资产合计',
    'BALANCESTATEMENT_71': '资产其他项目',
    'BALANCESTATEMENT_72': '资产平衡项目',
    'BALANCESTATEMENT_74': '资产总计',
    # 流动负债
    'BALANCESTATEMENT_75': '短期借款',
    'BALANCESTATEMENT_105': '向中央银行借款',
    'BALANCESTATEMENT_153': '吸收存款及同业存放',
    'BALANCESTATEMENT_106': '拆入资金',
    'BALANCESTATEMENT_226': '交易性金融负债',
    'BALANCESTATEMENT_170': '以公允价值计量且其变动计入当期损益的金融负债',
    'BALANCESTATEMENT_76': '其中:交易性金融负债',
    'BALANCESTATEMENT_171': '其中:指定以公允价值计量且其变动计入当期损益的金融负债',
    'BALANCESTATEMENT_107': '衍生金融负债',
    'BALANCESTATEMENT_221': '应付票据及应付账款',
    'BALANCESTATEMENT_77': '应付票据',
    'BALANCESTATEMENT_78': '应付账款',
    'BALANCESTATEMENT_79': '预收款项',
    'BALANCESTATEMENT_213': '合同负债',
    'BALANCESTATEMENT_108': '卖出回购金融资产款',
    'BALANCESTATEMENT_113': '应付手续费及佣金',
    'BALANCESTATEMENT_80': '应付职工薪酬',
    'BALANCESTATEMENT_81': '应交税费',
    'BALANCESTATEMENT_227': '其他应付款合计',
    'BALANCESTATEMENT_82': '其中:应付利息',
    'BALANCESTATEMENT_83': '其中:应付股利',
    'BALANCESTATEMENT_84': '其中:其他应付款',
    'BALANCESTATEMENT_114': '应付分保账款',
    'BALANCESTATEMENT_188': '内部应付款',
    'BALANCESTATEMENT_189': '预计流动负债',
    'BALANCESTATEMENT_154': '保险合同准备金',
    'BALANCESTATEMENT_123': '代理买卖证券款',
    'BALANCESTATEMENT_124': '代理承销证券款',
    'BALANCESTATEMENT_87': '一年内的递延收益',
    'BALANCESTATEMENT_208': '以摊余成本计量的金融负债',
    'BALANCESTATEMENT_147': '应付短期债券',
    'BALANCESTATEMENT_203': '划分为持有待售的负债',
    'BALANCESTATEMENT_88': '一年内到期的非流动负债',
    'BALANCESTATEMENT_191': '代理业务负债',
    'BALANCESTATEMENT_89': '其他流动负债',
    'BALANCESTATEMENT_90': '流动负债其他项目',
    'BALANCESTATEMENT_91': '流动负债平衡项目',
    'BALANCESTATEMENT_93': '流动负债合计',
    # 非流动负债
    'BALANCESTATEMENT_94': '长期借款',
    'BALANCESTATEMENT_215': '以摊余成本计量的金融负债(非流动)',
    'BALANCESTATEMENT_95': '应付债券',
    'BALANCESTATEMENT_193': '其中:优先股(应付债券)',
    'BALANCESTATEMENT_194': '其中:永续债(应付债券)',
    'BALANCESTATEMENT_228': '租赁负债',
    'BALANCESTATEMENT_96': '长期应付款',
    'BALANCESTATEMENT_201': '长期应付职工薪酬',
    'BALANCESTATEMENT_97': '专项应付款',
    'BALANCESTATEMENT_86': '预计非流动负债',
    'BALANCESTATEMENT_148': '递延收益',
    'BALANCESTATEMENT_98': '递延所得税负债',
    'BALANCESTATEMENT_99': '其他非流动负债',
    'BALANCESTATEMENT_100': '非流动负债其他项目',
    'BALANCESTATEMENT_101': '非流动负债平衡项目',
    'BALANCESTATEMENT_103': '非流动负债合计',
    'BALANCESTATEMENT_125': '负债其他项目',
    'BALANCESTATEMENT_126': '负债平衡项目',
    'BALANCESTATEMENT_128': '负债合计',
    # 所有者权益
    'BALANCESTATEMENT_129': '实收资本(股本)',
    'BALANCESTATEMENT_195': '其他权益工具',
    'BALANCESTATEMENT_196': '其中:优先股(其他权益工具)',
    'BALANCESTATEMENT_197': '其中:永续债(其他权益工具)',
    'BALANCESTATEMENT_198': '其中:其他(其他权益工具)',
    'BALANCESTATEMENT_130': '资本公积',
    'BALANCESTATEMENT_199': '其他综合收益',
    'BALANCESTATEMENT_133': '库存股',
    'BALANCESTATEMENT_159': '专项储备',
    'BALANCESTATEMENT_131': '盈余公积',
    'BALANCESTATEMENT_134': '一般风险准备',
    'BALANCESTATEMENT_151': '未确定的投资损失',
    'BALANCESTATEMENT_132': '未分配利润',
    'BALANCESTATEMENT_160': '拟分配现金股利',
    'BALANCESTATEMENT_135': '外币报表折算差额',
    'BALANCESTATEMENT_161': '归属于母公司股东权益其他项目',
    'BALANCESTATEMENT_162': '归属于母公司股东权益平衡项目',
    'BALANCESTATEMENT_140': '归属于母公司股东权益合计',
    'BALANCESTATEMENT_136': '少数股东权益',
    'BALANCESTATEMENT_137': '股东权益其他项目',
    'BALANCESTATEMENT_138': '股东权益平衡项目',
    'BALANCESTATEMENT_141': '股东权益合计',
    'BALANCESTATEMENT_142': '负债和股东权益其他项目',
    'BALANCESTATEMENT_143': '负债和股东权益平衡项目',
    'BALANCESTATEMENT_145': '负债和股东权益合计',
}


STOCK_INCOME_MAPPING = {
    'DATES': '财报日期',
    'INCOMESTATEMENT_83': '营业总收入',
    'INCOMESTATEMENT_9': '营业收入',
    'INCOMESTATEMENT_19': '利息收入',
    'INCOMESTATEMENT_28': '已赚保费',
    'INCOMESTATEMENT_22': '手续费及佣金收入',
    'INCOMESTATEMENT_85': '其他业务收入',
    'INCOMESTATEMENT_88': '营业总收入其他项目',
    'INCOMESTATEMENT_84': '营业总成本',
    'INCOMESTATEMENT_10': '营业成本',
    'INCOMESTATEMENT_20': '利息支出',
    'INCOMESTATEMENT_23': '手续费及佣金支出',
    'INCOMESTATEMENT_89': '研发费用',
    'INCOMESTATEMENT_39': '退保金',
    'INCOMESTATEMENT_33': '赔付支出净额',
    'INCOMESTATEMENT_35': '提取保险合同准备金净额',
    'INCOMESTATEMENT_40': '保单红利支出',
    'INCOMESTATEMENT_38': '分保费用',
    'INCOMESTATEMENT_86': '其他业务成本',
    'INCOMESTATEMENT_11': '税金及附加',
    'INCOMESTATEMENT_12': '销售费用',
    'INCOMESTATEMENT_13': '管理费用',
    'INCOMESTATEMENT_14': '财务费用',
    'INCOMESTATEMENT_127': '其中:利息支出',
    'INCOMESTATEMENT_128': '其中:利息收入',
    'INCOMESTATEMENT_15': '资产减值损失',
    'INCOMESTATEMENT_129': '信用减值损失',
    'INCOMESTATEMENT_90': '营业总成本其他项目',
    'INCOMESTATEMENT_16': '公允价值变动收益',
    'INCOMESTATEMENT_17': '投资收益',
    'INCOMESTATEMENT_82': '对联营企业和合营企业的投资收益',
    'INCOMESTATEMENT_130': '净敞口套期收益',
    'INCOMESTATEMENT_25': '汇兑收益',
    'INCOMESTATEMENT_180': '资产减值损失(新)',
    'INCOMESTATEMENT_182': '信用减值损失(新)',
    'INCOMESTATEMENT_123': '资产处置收益',
    'INCOMESTATEMENT_124': '其他收益',
    'INCOMESTATEMENT_45': '营业利润其他项目',
    'INCOMESTATEMENT_46': '营业利润平衡项目',
    'INCOMESTATEMENT_48': '营业利润',
    'INCOMESTATEMENT_49': '营业外收入',
    'INCOMESTATEMENT_118': '非流动资产处置利得',
    'INCOMESTATEMENT_50': '营业外支出',
    'INCOMESTATEMENT_51': '非流动资产处置净损失',
    'INCOMESTATEMENT_52': '影响利润总额的其他项目',
    'INCOMESTATEMENT_53': '利润总额平衡项目',
    'INCOMESTATEMENT_55': '利润总额',
    'INCOMESTATEMENT_56': '所得税',
    'INCOMESTATEMENT_87': '未确认投资损失',
    'INCOMESTATEMENT_57': '影响净利润的其他项目',
    'INCOMESTATEMENT_120': '净利润差额(合计平衡项目2)',
    'INCOMESTATEMENT_60': '净利润',
    'INCOMESTATEMENT_125': '持续经营净利润',
    'INCOMESTATEMENT_126': '终止经营净利润',
    'INCOMESTATEMENT_91': '被合并方在合并前实现利润',
    'INCOMESTATEMENT_61': '归属于母公司股东的净利润',
    'INCOMESTATEMENT_62': '少数股东损益',
    'INCOMESTATEMENT_92': '净利润其他项目',
    'INCOMESTATEMENT_58': '净利润差额(合计平衡项目)',
    'INCOMESTATEMENT_80': '基本每股收益',
    'INCOMESTATEMENT_81': '稀释每股收益',
    'INCOMESTATEMENT_114': '其他综合收益',
    'INCOMESTATEMENT_116': '归属于母公司股东的其他综合收益',
    'INCOMESTATEMENT_115': '归属于少数股东的其他综合收益',
    'INCOMESTATEMENT_113': '综合收益总额',
    'INCOMESTATEMENT_93': '归属于母公司所有者的综合收益总额',
    'INCOMESTATEMENT_94': '归属于少数股东的综合收益总额',
    'INCOMESTATEMENT_139': '以摊余成本计量的金融资产终止确认收益',
}


STOCK_CASH_FLOW_MAPPING = {
    'DATES': '财报日期',
    'CASHFLOWSTATEMENT_9': '销售商品、提供劳务收到的现金',
    'CASHFLOWSTATEMENT_12': '客户存款和同业存放款项净增加额',
    'CASHFLOWSTATEMENT_13': '向中央银行借款净增加额',
    'CASHFLOWSTATEMENT_14': '向其他金融机构拆入资金净增加额',
    'CASHFLOWSTATEMENT_16': '收到原保险合同保费取得的现金',
    'CASHFLOWSTATEMENT_17': '收到再保险业务现金净额',
    'CASHFLOWSTATEMENT_64': '保户储金及投资款净增加额',
    'CASHFLOWSTATEMENT_18': '处置交易性金融资产净增加额',
    'CASHFLOWSTATEMENT_186': '收取利息、手续费及佣金的现金',
    'CASHFLOWSTATEMENT_20': '拆入资金净增加额',
    'CASHFLOWSTATEMENT_120': '发放贷款及垫款的净减少额',
    'CASHFLOWSTATEMENT_21': '回购业务资金净增加额',
    'CASHFLOWSTATEMENT_10': '收到的税费返还',
    'CASHFLOWSTATEMENT_11': '收到其他与经营活动有关的现金',
    'CASHFLOWSTATEMENT_22': '经营活动现金流入其他项目',
    'CASHFLOWSTATEMENT_23': '经营活动现金流入平衡项目',
    'CASHFLOWSTATEMENT_25': '经营活动现金流入小计',
    'CASHFLOWSTATEMENT_26': '购买商品、接受劳务支付的现金',
    'CASHFLOWSTATEMENT_30': '客户贷款及垫款净增加额',
    'CASHFLOWSTATEMENT_31': '存放中央银行和同业款项净增加额',
    'CASHFLOWSTATEMENT_32': '支付原保险合同赔付款项的现金',
    'CASHFLOWSTATEMENT_33': '支付利息、手续费及佣金的现金',
    'CASHFLOWSTATEMENT_195': '支付保单红利的现金',
    'CASHFLOWSTATEMENT_27': '支付给职工以及为职工支付的现金',
    'CASHFLOWSTATEMENT_28': '支付的各项税费',
    'CASHFLOWSTATEMENT_29': '支付其他与经营活动有关的现金',
    'CASHFLOWSTATEMENT_34': '经营活动现金流出其他项目',
    'CASHFLOWSTATEMENT_35': '经营活动现金流出平衡项目',
    'CASHFLOWSTATEMENT_37': '经营活动现金流出小计',
    'CASHFLOWSTATEMENT_121': '经营活动产生的现金流量净额其他项目',
    'CASHFLOWSTATEMENT_38': '经营活动产生的现金流量净额平衡项目',
    'CASHFLOWSTATEMENT_39': '经营活动产生的现金流量净额',
    # 投资活动产生的现金流量部分
    'CASHFLOWSTATEMENT_40': '收回投资收到的现金',
    'CASHFLOWSTATEMENT_41': '取得投资收益收到的现金',
    'CASHFLOWSTATEMENT_42': '处置固定资产、无形资产和其他长期资产收回的现金净额',
    'CASHFLOWSTATEMENT_43': '处置子公司及其他营业单位收到的现金净额',
    'CASHFLOWSTATEMENT_232': '减少质押和定期存款所收到的现金',
    'CASHFLOWSTATEMENT_44': '收到其他与投资活动有关的现金',
    'CASHFLOWSTATEMENT_45': '投资活动现金流入其他项目',
    'CASHFLOWSTATEMENT_46': '投资活动现金流入平衡项目',
    'CASHFLOWSTATEMENT_48': '投资活动现金流入小计',
    'CASHFLOWSTATEMENT_49': '购建固定资产、无形资产和其他长期资产支付的现金',
    'CASHFLOWSTATEMENT_50': '投资支付的现金',
    'CASHFLOWSTATEMENT_53': '质押贷款净增加额',
    'CASHFLOWSTATEMENT_51': '取得子公司及其他营业单位支付的现金净额',
    'CASHFLOWSTATEMENT_233': '增加质押和定期存款所支付的现金',
    'CASHFLOWSTATEMENT_52': '支付其他与投资活动有关的现金',
    'CASHFLOWSTATEMENT_54': '投资活动现金流出其他项目',
    'CASHFLOWSTATEMENT_55': '投资活动现金流出平衡项目',
    'CASHFLOWSTATEMENT_57': '投资活动现金流出小计',
    'CASHFLOWSTATEMENT_122': '投资活动产生的现金流量净额其他项目',
    'CASHFLOWSTATEMENT_58': '投资活动产生的现金流量净额平衡项目',
    'CASHFLOWSTATEMENT_59': '投资活动产生的现金流量净额',
    # 筹资活动产生的现金流量部分
    'CASHFLOWSTATEMENT_60': '吸收投资收到的现金',
    'CASHFLOWSTATEMENT_118': '其中:子公司吸收少数股东投资收到的现金',
    'CASHFLOWSTATEMENT_61': '取得借款收到的现金',
    'CASHFLOWSTATEMENT_63': '发行债券收到的现金',
    'CASHFLOWSTATEMENT_62': '收到其他与筹资活动有关的现金',
    'CASHFLOWSTATEMENT_65': '筹资活动现金流入其他项目',
    'CASHFLOWSTATEMENT_66': '筹资活动现金流入平衡项目',
    'CASHFLOWSTATEMENT_68': '筹资活动现金流入小计',
    'CASHFLOWSTATEMENT_69': '偿还债务支付的现金',
    'CASHFLOWSTATEMENT_70': '分配股利、利润或偿付利息支付的现金',
    'CASHFLOWSTATEMENT_119': '其中:子公司支付给少数股东的股利、利润',
    'CASHFLOWSTATEMENT_123': '购买子公司少数股权而支付的现金',
    'CASHFLOWSTATEMENT_71': '支付其他与筹资活动有关的现金',
    'CASHFLOWSTATEMENT_124': '其中:子公司减资支付给少数股东的现金',
    'CASHFLOWSTATEMENT_72': '筹资活动现金流出其他项目',
    'CASHFLOWSTATEMENT_73': '筹资活动现金流出平衡项目',
    'CASHFLOWSTATEMENT_75': '筹资活动现金流出小计',
    'CASHFLOWSTATEMENT_125': '筹资活动产生的现金流量净额其他项目',
    'CASHFLOWSTATEMENT_76': '筹资活动产生的现金流量净额平衡项目',
    'CASHFLOWSTATEMENT_77': '筹资活动产生的现金流量净额',
    # 现金及现金等价物净增加
    'CASHFLOWSTATEMENT_78': '汇率变动对现金及现金等价物的影响',
    'CASHFLOWSTATEMENT_79': '现金及现金等价物净增加额其他项目',
    'CASHFLOWSTATEMENT_80': '现金及现金等价物净增加额平衡项目',
    'CASHFLOWSTATEMENT_82': '现金及现金等价物净增加额',
    'CASHFLOWSTATEMENT_83': '期初现金及现金等价物余额',
    'CASHFLOWSTATEMENT_126': '期末现金及现金等价物余额其他项目',
    'CASHFLOWSTATEMENT_127': '期末现金及现金等价物余额平衡项目',
    'CASHFLOWSTATEMENT_84': '期末现金及现金等价物余额',
    # 补充资料
    'CASHFLOWSTATEMENT_85': '净利润-现金流量表',
    'CASHFLOWSTATEMENT_86': '资产减值准备',
    'CASHFLOWSTATEMENT_206': '固定资产和投资性房地产折旧',
    'CASHFLOWSTATEMENT_87': '其中：固定资产折旧、油气资产折耗、生产性生物资产折旧',
    'CASHFLOWSTATEMENT_207': '其中：投资性房地产折旧',
    'CASHFLOWSTATEMENT_88': '无形资产摊销',
    'CASHFLOWSTATEMENT_89': '长期待摊费用摊销',
    'CASHFLOWSTATEMENT_208': '递延收益摊销',
    'CASHFLOWSTATEMENT_90': '待摊费用的减少',
    'CASHFLOWSTATEMENT_91': '预提费用的增加',
    'CASHFLOWSTATEMENT_92': '处置固定资产、无形资产和其他长期资产的损失',
    'CASHFLOWSTATEMENT_93': '固定资产报废损失',
    'CASHFLOWSTATEMENT_94': '公允价值变动损失',
    'CASHFLOWSTATEMENT_95': '财务费用-现金流量表',
    'CASHFLOWSTATEMENT_96': '投资损失',
    'CASHFLOWSTATEMENT_209': '递延所得税',
    'CASHFLOWSTATEMENT_97': '其中：递延所得税资产减少',
    'CASHFLOWSTATEMENT_98': '其中：递延所得税负债增加',
    'CASHFLOWSTATEMENT_210': '预计负债的增加',
    'CASHFLOWSTATEMENT_99': '存货的减少',
    'CASHFLOWSTATEMENT_100': '经营性应收项目的减少',
    'CASHFLOWSTATEMENT_101': '经营性应付项目的增加',
    'CASHFLOWSTATEMENT_117': '其他',
    'CASHFLOWSTATEMENT_102': '经营活动产生的现金流量净额其他项目',
    'CASHFLOWSTATEMENT_103': '经营活动产生的现金流量净额平衡项目',
    'CASHFLOWSTATEMENT_105': '间接法—经营活动产生的现金流量净额',
    'CASHFLOWSTATEMENT_106': '债务转为资本',
    'CASHFLOWSTATEMENT_107': '一年内到期的可转换公司债券',
    'CASHFLOWSTATEMENT_108': '融资租入固定资产',
    'CASHFLOWSTATEMENT_212': '不涉及现金收支的投资和筹资活动金额其他项目',
    'CASHFLOWSTATEMENT_109': '现金的期末余额',
    'CASHFLOWSTATEMENT_110': '现金的期初余额',
    'CASHFLOWSTATEMENT_111': '现金等价物的期末余额',
    'CASHFLOWSTATEMENT_112': '现金等价物的期初余额',
    'CASHFLOWSTATEMENT_113': '现金及现金等价物净增加额其他项目',
    'CASHFLOWSTATEMENT_114': '现金及现金等价物净增加额平衡项目',
    'CASHFLOWSTATEMENT_116': '间接法—现金及现金等价物的净增加额',
}


STOCK_INCOME_QUARTERLY_MAPPING = {
    'DATES': '财报日期',
    'INCOMESTATEMENTQ_83': '单季度.营业总收入',
    'INCOMESTATEMENTQ_9': '单季度.营业收入',
    'INCOMESTATEMENTQ_19': '单季度.利息收入',
    'INCOMESTATEMENTQ_28': '单季度.已赚保费',
    'INCOMESTATEMENTQ_22': '单季度.手续费及佣金收入',
    'INCOMESTATEMENTQ_85': '单季度.其他业务收入',
    'INCOMESTATEMENTQ_88': '单季度.营业总收入其他项目',
    'INCOMESTATEMENTQ_84': '单季度.营业总成本',
    'INCOMESTATEMENTQ_10': '单季度.营业成本',
    'INCOMESTATEMENTQ_20': '单季度.利息支出',
    'INCOMESTATEMENTQ_23': '单季度.手续费及佣金支出',
    'INCOMESTATEMENTQ_89': '单季度.研发费用',
    'INCOMESTATEMENTQ_39': '单季度.退保金',
    'INCOMESTATEMENTQ_33': '单季度.赔付支出净额',
    'INCOMESTATEMENTQ_35': '单季度.提取保险合同准备金净额',
    'INCOMESTATEMENTQ_40': '单季度.保单红利支出',
    'INCOMESTATEMENTQ_38': '单季度.分保费用',
    'INCOMESTATEMENTQ_86': '单季度.其他业务成本',
    'INCOMESTATEMENTQ_11': '单季度.税金及附加',
    'INCOMESTATEMENTQ_12': '单季度.销售费用',
    'INCOMESTATEMENTQ_13': '单季度.管理费用',
    'INCOMESTATEMENTQ_14': '单季度.财务费用',
    'INCOMESTATEMENTQ_127': '单季度.其中:利息费用',
    'INCOMESTATEMENTQ_128': '单季度.其中:利息收入',
    'INCOMESTATEMENTQ_15': '单季度.资产减值损失',
    'INCOMESTATEMENTQ_129': '单季度.信用减值损失',
    'INCOMESTATEMENTQ_90': '单季度.营业总成本其他项目',
    'INCOMESTATEMENTQ_16': '单季度.公允价值变动净收益',
    'INCOMESTATEMENTQ_17': '单季度.投资净收益',
    'INCOMESTATEMENTQ_82': '单季度.对联营企业和合营企业的投资收益',
    'INCOMESTATEMENTQ_130': '单季度.净敞口套期收益',
    'INCOMESTATEMENTQ_25': '单季度.汇兑收益',
    'INCOMESTATEMENTQ_123': '单季度.资产处置收益',
    'INCOMESTATEMENTQ_124': '单季度.其他收益',
    'INCOMESTATEMENTQ_45': '单季度.营业利润其他项目',
    'INCOMESTATEMENTQ_46': '单季度.营业利润平衡项目',
    'INCOMESTATEMENTQ_48': '单季度.营业利润',
    'INCOMESTATEMENTQ_49': '单季度.营业外收入',
    'INCOMESTATEMENTQ_118': '单季度.非流动资产处置利得',
    'INCOMESTATEMENTQ_50': '单季度.营业外支出',
    'INCOMESTATEMENTQ_51': '单季度.非流动资产处置净损失',
    'INCOMESTATEMENTQ_52': '单季度.影响利润总额的其他项目',
    'INCOMESTATEMENTQ_53': '单季度.利润总额平衡项目',
    'INCOMESTATEMENTQ_55': '单季度.利润总额',
    'INCOMESTATEMENTQ_56': '单季度.所得税费用',
    'INCOMESTATEMENTQ_87': '单季度.未确认的投资损失',
    'INCOMESTATEMENTQ_57': '单季度.影响净利润的其他项目',
    'INCOMESTATEMENTQ_120': '单季度.净利润差额(合计平衡项目2)',
    'INCOMESTATEMENTQ_60': '单季度.净利润',
    'INCOMESTATEMENTQ_125': '单季度.持续经营净利润',
    'INCOMESTATEMENTQ_126': '单季度.终止经营净利润',
    'INCOMESTATEMENTQ_91': '单季度.被合并方在合并前实现利润',
    'INCOMESTATEMENTQ_61': '单季度.归属于母公司股东的净利润',
    'INCOMESTATEMENTQ_62': '单季度.少数股东损益',
    'INCOMESTATEMENTQ_92': '单季度.净利润其他项目',
    'INCOMESTATEMENTQ_80': '单季度.基本每股收益',
    'INCOMESTATEMENTQ_81': '单季度.稀释每股收益',
    'INCOMESTATEMENTQ_114': '单季度.其他综合收益',
    'INCOMESTATEMENTQ_116': '单季度.归属于母公司股东的其他综合收益',
    'INCOMESTATEMENTQ_115': '单季度.归属于少数股东的其他综合收益总额',
    'INCOMESTATEMENTQ_113': '单季度.综合收益总额',
    'INCOMESTATEMENTQ_93': '单季度.归属于母公司所有者的综合收益总额',
    'INCOMESTATEMENTQ_94': '单季度.归属于少数股东的综合收益总额',
    'INCOMESTATEMENTQ_182': '单季度.信用减值损失(新)',
    'INCOMESTATEMENTQ_180': '单季度.资产减值损失(新)',
}


STOCK_CASH_FLOW_QUARTERLY_MAPPING = {
    'DATES': '财报日期',
    'CASHFLOWSTATEMENTQ_9': '单季度.销售商品、提供劳务收到的现金',
    'CASHFLOWSTATEMENTQ_12': '单季度.客户存款和同业存放款项净增加额',
    'CASHFLOWSTATEMENTQ_13': '单季度.向中央银行借款净增加额',
    'CASHFLOWSTATEMENTQ_14': '单季度.向其他金融机构拆入资金净增加额',
    'CASHFLOWSTATEMENTQ_16': '单季度.收到原保险合同保费取得的现金',
    'CASHFLOWSTATEMENTQ_17': '单季度.收到再保险业务现金净额',
    'CASHFLOWSTATEMENTQ_64': '单季度.保户储金及投资款净增加额',
    'CASHFLOWSTATEMENTQ_18': '单季度.处置交易性金融资产净增加额',
    'CASHFLOWSTATEMENTQ_186': '单季度.收取利息、手续费及佣金的现金',
    'CASHFLOWSTATEMENTQ_20': '单季度.拆入资金净增加额',
    'CASHFLOWSTATEMENTQ_120': '单季度.发放贷款及垫款的净减少额',
    'CASHFLOWSTATEMENTQ_21': '单季度.回购业务资金净增加额',
    'CASHFLOWSTATEMENTQ_10': '单季度.收到的税费返还',
    'CASHFLOWSTATEMENTQ_11': '单季度.收到的其他与经营活动有关的现金',
    'CASHFLOWSTATEMENTQ_22': '单季度.经营活动现金流入其他项目',
    'CASHFLOWSTATEMENTQ_23': '单季度.经营活动现金流入平衡项目',
    'CASHFLOWSTATEMENTQ_25': '单季度.经营活动现金流入小计',
    'CASHFLOWSTATEMENTQ_26': '单季度.购买商品、接受劳务支付的现金',
    'CASHFLOWSTATEMENTQ_30': '单季度.客户贷款及垫款净增加额',
    'CASHFLOWSTATEMENTQ_31': '单季度.存放中央银行和同业款项净增加额',
    'CASHFLOWSTATEMENTQ_32': '单季度.支付原保险合同赔付款项的现金',
    'CASHFLOWSTATEMENTQ_33': '单季度.支付利息、手续费及佣金的现金',
    'CASHFLOWSTATEMENTQ_195': '单季度.支付保单红利的现金',
    'CASHFLOWSTATEMENTQ_27': '单季度.支付给职工以及为职工支付的现金',
    'CASHFLOWSTATEMENTQ_28': '单季度.支付的各项税费',
    'CASHFLOWSTATEMENTQ_29': '单季度.支付的其他与经营活动有关的现金',
    'CASHFLOWSTATEMENTQ_34': '单季度.经营活动现金流出其他项目',
    'CASHFLOWSTATEMENTQ_35': '单季度.经营活动现金流出平衡项目',
    'CASHFLOWSTATEMENTQ_37': '单季度.经营活动现金流出小计',
    'CASHFLOWSTATEMENTQ_121': '单季度.经营活动产生的现金流量净额其他项目',
    'CASHFLOWSTATEMENTQ_38': '单季度.经营活动产生的现金流量净额平衡项目',
    'CASHFLOWSTATEMENTQ_39': '单季度.经营活动产生的现金流量净额',
    'CASHFLOWSTATEMENTQ_192': '银行业务及证券业务拆借资金净减少额',
    # 投资活动产生的现金流量
    'CASHFLOWSTATEMENTQ_40': '单季度.收回投资收到的现金',
    'CASHFLOWSTATEMENTQ_41': '单季度.取得投资收益收到的现金',
    'CASHFLOWSTATEMENTQ_42': '单季度.处置固定资产、无形资产和其他长期资产所收回的现金净额',
    'CASHFLOWSTATEMENTQ_43': '单季度.处置子公司及其他营业单位收到的现金净额',
    'CASHFLOWSTATEMENTQ_232': '单季度.减少质押和定期存款所收到的现金',
    'CASHFLOWSTATEMENTQ_44': '单季度.收到的其他与投资活动有关的现金',
    'CASHFLOWSTATEMENTQ_45': '单季度.投资活动现金流入其他项目',
    'CASHFLOWSTATEMENTQ_46': '单季度.投资活动现金流入平衡项目',
    'CASHFLOWSTATEMENTQ_48': '单季度.投资活动现金流入小计',
    'CASHFLOWSTATEMENTQ_49': '单季度.购建固定资产、无形资产和其他长期资产所支付的现金',
    'CASHFLOWSTATEMENTQ_50': '单季度.投资所支付的现金',
    'CASHFLOWSTATEMENTQ_53': '单季度.质押贷款净增加额',
    'CASHFLOWSTATEMENTQ_51': '单季度.取得子公司及其他营业单位支付的现金净额',
    'CASHFLOWSTATEMENTQ_233': '单季度.增加质押和定期存款所支付的现金',
    'CASHFLOWSTATEMENTQ_52': '单季度.支付的其他与投资活动有关的现金',
    'CASHFLOWSTATEMENTQ_54': '单季度.投资活动现金流出其他项目',
    'CASHFLOWSTATEMENTQ_57': '单季度.投资活动现金流出小计',
    'CASHFLOWSTATEMENTQ_55': '单季度.投资活动现金流出平衡项目',
    'CASHFLOWSTATEMENTQ_122': '单季度.投资活动产生的现金流量净额其他项目',
    'CASHFLOWSTATEMENTQ_59': '单季度.投资活动产生的现金流量净额',
    'CASHFLOWSTATEMENTQ_58': '单季度.投资活动产生的现金流量净额平衡项目',
    # 筹资活动产生的现金流量
    'CASHFLOWSTATEMENTQ_60': '单季度.吸收投资收到的现金',
    'CASHFLOWSTATEMENTQ_118': '单季度.子公司吸收少数股东投资收到的现金',
    'CASHFLOWSTATEMENTQ_61': '单季度.取得借款收到的现金',
    'CASHFLOWSTATEMENTQ_63': '单季度.发行债券收到的现金',
    'CASHFLOWSTATEMENTQ_62': '单季度.收到其他与筹资活动有关的现金',
    'CASHFLOWSTATEMENTQ_65': '单季度.筹资活动现金流入其他项目',
    'CASHFLOWSTATEMENTQ_66': '单季度.筹资活动现金流入平衡项目',
    'CASHFLOWSTATEMENTQ_68': '单季度.筹资活动现金流入小计',
    'CASHFLOWSTATEMENTQ_69': '单季度.偿还债务支付的现金',
    'CASHFLOWSTATEMENTQ_70': '单季度.分配股利、利润或偿付利息所支付的现金',
    'CASHFLOWSTATEMENTQ_119': '单季度.子公司支付给少数股东的股利、利润',
    'CASHFLOWSTATEMENTQ_123': '单季度.购买子公司少数股权而支付的现金',
    'CASHFLOWSTATEMENTQ_71': '单季度.支付其他与筹资活动有关的现金',
    'CASHFLOWSTATEMENTQ_124': '单季度.子公司减资支付给少数股东的现金',
    'CASHFLOWSTATEMENTQ_72': '单季度.筹资活动现金流出其他项目',
    'CASHFLOWSTATEMENTQ_73': '单季度.筹资活动现金流出平衡项目',
    'CASHFLOWSTATEMENTQ_75': '单季度.筹资活动现金流出小计',
    'CASHFLOWSTATEMENTQ_125': '单季度.筹资活动产生的现金流量净额其他项目',
    'CASHFLOWSTATEMENTQ_76': '单季度.筹资活动产生的现金流量净额平衡项目',
    'CASHFLOWSTATEMENTQ_77': '单季度.筹资活动产生的现金流量净额',
    # 现金及现金等价物净增加值
    'CASHFLOWSTATEMENTQ_78': '单季度.汇率变动对现金及现金等价物的影响',
    'CASHFLOWSTATEMENTQ_79': '单季度.现金及现金等价物净增加额其他项目',
    'CASHFLOWSTATEMENTQ_80': '单季度.现金及现金等价物净增加额平衡项目',
    'CASHFLOWSTATEMENTQ_82': '单季度.现金及现金等价物净增加额',
    'CASHFLOWSTATEMENTQ_83': '单季度.期初现金及现金等价物余额',
    'CASHFLOWSTATEMENTQ_126': '单季度.期末现金及现金等价物余额其他项目',
    'CASHFLOWSTATEMENTQ_127': '单季度.期末现金及现金等价物余额平衡项目',
    'CASHFLOWSTATEMENTQ_84': '单季度.期末现金及现金等价物余额',
}


USED_BALANCE_COLUMNS = [
    '货币资金'
]

ROE有效阈值 = 0.8



