# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['FlinkJarApplicationDeploymentArgs', 'FlinkJarApplicationDeployment']

@pulumi.input_type
class FlinkJarApplicationDeploymentArgs:
    def __init__(__self__, *,
                 application_id: pulumi.Input[_builtins.str],
                 project: pulumi.Input[_builtins.str],
                 service_name: pulumi.Input[_builtins.str],
                 version_id: pulumi.Input[_builtins.str],
                 entry_class: Optional[pulumi.Input[_builtins.str]] = None,
                 parallelism: Optional[pulumi.Input[_builtins.int]] = None,
                 program_args: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 restart_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 starting_savepoint: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FlinkJarApplicationDeployment resource.
        :param pulumi.Input[_builtins.str] application_id: Application Id. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] project: Project name. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] service_name: Service name. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] version_id: ApplicationVersion ID. Maximum length: `36`. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] entry_class: The fully qualified name of the entry class to pass during Flink job submission through the entryClass parameter. Maximum length: `128`.
        :param pulumi.Input[_builtins.int] parallelism: Reading of Flink parallel execution documentation is recommended before setting this value to other than 1. Please do not set this value higher than (total number of nodes x number*of*task_slots), or every new job created will fail.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] program_args: Arguments to pass during Flink job submission through the programArgsList parameter.
        :param pulumi.Input[_builtins.bool] restart_enabled: Specifies whether a Flink Job is restarted in case it fails. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] starting_savepoint: Job savepoint. Maximum length: `2048`.
        """
        pulumi.set(__self__, "application_id", application_id)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "version_id", version_id)
        if entry_class is not None:
            pulumi.set(__self__, "entry_class", entry_class)
        if parallelism is not None:
            pulumi.set(__self__, "parallelism", parallelism)
        if program_args is not None:
            pulumi.set(__self__, "program_args", program_args)
        if restart_enabled is not None:
            pulumi.set(__self__, "restart_enabled", restart_enabled)
        if starting_savepoint is not None:
            pulumi.set(__self__, "starting_savepoint", starting_savepoint)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Input[_builtins.str]:
        """
        Application Id. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "application_id", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        Project name. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[_builtins.str]:
        """
        Service name. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Input[_builtins.str]:
        """
        ApplicationVersion ID. Maximum length: `36`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "version_id", value)

    @_builtins.property
    @pulumi.getter(name="entryClass")
    def entry_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the entry class to pass during Flink job submission through the entryClass parameter. Maximum length: `128`.
        """
        return pulumi.get(self, "entry_class")

    @entry_class.setter
    def entry_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entry_class", value)

    @_builtins.property
    @pulumi.getter
    def parallelism(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Reading of Flink parallel execution documentation is recommended before setting this value to other than 1. Please do not set this value higher than (total number of nodes x number*of*task_slots), or every new job created will fail.
        """
        return pulumi.get(self, "parallelism")

    @parallelism.setter
    def parallelism(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "parallelism", value)

    @_builtins.property
    @pulumi.getter(name="programArgs")
    def program_args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Arguments to pass during Flink job submission through the programArgsList parameter.
        """
        return pulumi.get(self, "program_args")

    @program_args.setter
    def program_args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "program_args", value)

    @_builtins.property
    @pulumi.getter(name="restartEnabled")
    def restart_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether a Flink Job is restarted in case it fails. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "restart_enabled")

    @restart_enabled.setter
    def restart_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "restart_enabled", value)

    @_builtins.property
    @pulumi.getter(name="startingSavepoint")
    def starting_savepoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Job savepoint. Maximum length: `2048`.
        """
        return pulumi.get(self, "starting_savepoint")

    @starting_savepoint.setter
    def starting_savepoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "starting_savepoint", value)


@pulumi.input_type
class _FlinkJarApplicationDeploymentState:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 deployment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 entry_class: Optional[pulumi.Input[_builtins.str]] = None,
                 error_msg: Optional[pulumi.Input[_builtins.str]] = None,
                 job_id: Optional[pulumi.Input[_builtins.str]] = None,
                 last_savepoint: Optional[pulumi.Input[_builtins.str]] = None,
                 parallelism: Optional[pulumi.Input[_builtins.int]] = None,
                 program_args: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 restart_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 starting_savepoint: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 version_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FlinkJarApplicationDeployment resources.
        :param pulumi.Input[_builtins.str] application_id: Application Id. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of this entity in ISO 8601 format, always in UTC.
        :param pulumi.Input[_builtins.str] created_by: The creator of this entity.
        :param pulumi.Input[_builtins.str] deployment_id: Deployment ID.
        :param pulumi.Input[_builtins.str] entry_class: The fully qualified name of the entry class to pass during Flink job submission through the entryClass parameter. Maximum length: `128`.
        :param pulumi.Input[_builtins.str] error_msg: Error message describing what caused deployment to fail.
        :param pulumi.Input[_builtins.str] job_id: Job ID.
        :param pulumi.Input[_builtins.str] last_savepoint: Job savepoint.
        :param pulumi.Input[_builtins.int] parallelism: Reading of Flink parallel execution documentation is recommended before setting this value to other than 1. Please do not set this value higher than (total number of nodes x number*of*task_slots), or every new job created will fail.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] program_args: Arguments to pass during Flink job submission through the programArgsList parameter.
        :param pulumi.Input[_builtins.str] project: Project name. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.bool] restart_enabled: Specifies whether a Flink Job is restarted in case it fails. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] service_name: Service name. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] starting_savepoint: Job savepoint. Maximum length: `2048`.
        :param pulumi.Input[_builtins.str] status: Deployment status. The possible values are `CANCELED`, `CANCELLING`, `CANCELLING_REQUESTED`, `CREATED`, `DELETE_REQUESTED`, `DELETING`, `FAILED`, `FAILING`, `FINISHED`, `INITIALIZING`, `RECONCILING`, `RESTARTING`, `RUNNING`, `SAVING`, `SAVING_AND_STOP`, `SAVING_AND_STOP_REQUESTED` and `SUSPENDED`.
        :param pulumi.Input[_builtins.str] version_id: ApplicationVersion ID. Maximum length: `36`. Changing this property forces recreation of the resource.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if deployment_id is not None:
            pulumi.set(__self__, "deployment_id", deployment_id)
        if entry_class is not None:
            pulumi.set(__self__, "entry_class", entry_class)
        if error_msg is not None:
            pulumi.set(__self__, "error_msg", error_msg)
        if job_id is not None:
            pulumi.set(__self__, "job_id", job_id)
        if last_savepoint is not None:
            pulumi.set(__self__, "last_savepoint", last_savepoint)
        if parallelism is not None:
            pulumi.set(__self__, "parallelism", parallelism)
        if program_args is not None:
            pulumi.set(__self__, "program_args", program_args)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if restart_enabled is not None:
            pulumi.set(__self__, "restart_enabled", restart_enabled)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if starting_savepoint is not None:
            pulumi.set(__self__, "starting_savepoint", starting_savepoint)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Application Id. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_id", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of this entity in ISO 8601 format, always in UTC.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creator of this entity.
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Deployment ID.
        """
        return pulumi.get(self, "deployment_id")

    @deployment_id.setter
    def deployment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deployment_id", value)

    @_builtins.property
    @pulumi.getter(name="entryClass")
    def entry_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified name of the entry class to pass during Flink job submission through the entryClass parameter. Maximum length: `128`.
        """
        return pulumi.get(self, "entry_class")

    @entry_class.setter
    def entry_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entry_class", value)

    @_builtins.property
    @pulumi.getter(name="errorMsg")
    def error_msg(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Error message describing what caused deployment to fail.
        """
        return pulumi.get(self, "error_msg")

    @error_msg.setter
    def error_msg(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "error_msg", value)

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Job ID.
        """
        return pulumi.get(self, "job_id")

    @job_id.setter
    def job_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "job_id", value)

    @_builtins.property
    @pulumi.getter(name="lastSavepoint")
    def last_savepoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Job savepoint.
        """
        return pulumi.get(self, "last_savepoint")

    @last_savepoint.setter
    def last_savepoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "last_savepoint", value)

    @_builtins.property
    @pulumi.getter
    def parallelism(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Reading of Flink parallel execution documentation is recommended before setting this value to other than 1. Please do not set this value higher than (total number of nodes x number*of*task_slots), or every new job created will fail.
        """
        return pulumi.get(self, "parallelism")

    @parallelism.setter
    def parallelism(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "parallelism", value)

    @_builtins.property
    @pulumi.getter(name="programArgs")
    def program_args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Arguments to pass during Flink job submission through the programArgsList parameter.
        """
        return pulumi.get(self, "program_args")

    @program_args.setter
    def program_args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "program_args", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project name. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="restartEnabled")
    def restart_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether a Flink Job is restarted in case it fails. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "restart_enabled")

    @restart_enabled.setter
    def restart_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "restart_enabled", value)

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service name. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_name", value)

    @_builtins.property
    @pulumi.getter(name="startingSavepoint")
    def starting_savepoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Job savepoint. Maximum length: `2048`.
        """
        return pulumi.get(self, "starting_savepoint")

    @starting_savepoint.setter
    def starting_savepoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "starting_savepoint", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Deployment status. The possible values are `CANCELED`, `CANCELLING`, `CANCELLING_REQUESTED`, `CREATED`, `DELETE_REQUESTED`, `DELETING`, `FAILED`, `FAILING`, `FINISHED`, `INITIALIZING`, `RECONCILING`, `RESTARTING`, `RUNNING`, `SAVING`, `SAVING_AND_STOP`, `SAVING_AND_STOP_REQUESTED` and `SUSPENDED`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ApplicationVersion ID. Maximum length: `36`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_id", value)


@pulumi.type_token("aiven:index/flinkJarApplicationDeployment:FlinkJarApplicationDeployment")
class FlinkJarApplicationDeployment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 entry_class: Optional[pulumi.Input[_builtins.str]] = None,
                 parallelism: Optional[pulumi.Input[_builtins.int]] = None,
                 program_args: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 restart_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 starting_savepoint: Optional[pulumi.Input[_builtins.str]] = None,
                 version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages the deployment of an Aiven for Apache Flink® application.

        **This resource is in the beta stage and may change without notice.** Set
        the `PROVIDER_AIVEN_ENABLE_BETA` environment variable to use the resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        example = aiven.Flink("example",
            project=example_aiven_project["project"],
            service_name="example-flink-service",
            cloud_name="google-europe-west1",
            plan="business-4",
            maintenance_window_dow="monday",
            maintenance_window_time="04:00:00",
            flink_user_config={
                "custom_code": True,
            })
        example_flink_jar_application = aiven.FlinkJarApplication("example",
            project=example.project,
            service_name=example.service_name,
            name="example-app-jar")
        example_flink_jar_application_version = aiven.FlinkJarApplicationVersion("example",
            project=example.project,
            service_name=example.service_name,
            application_id=example_flink_jar_application.application_id,
            source="./example.jar")
        example_flink_jar_application_deployment = aiven.FlinkJarApplicationDeployment("example",
            project=example.project,
            service_name=example.service_name,
            application_id=example_flink_jar_application.application_id,
            version_id=example_flink_jar_application_version.application_version_id)
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/flinkJarApplicationDeployment:FlinkJarApplicationDeployment example PROJECT/SERVICE_NAME/APPLICATION_ID/DEPLOYMENT_ID
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_id: Application Id. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] entry_class: The fully qualified name of the entry class to pass during Flink job submission through the entryClass parameter. Maximum length: `128`.
        :param pulumi.Input[_builtins.int] parallelism: Reading of Flink parallel execution documentation is recommended before setting this value to other than 1. Please do not set this value higher than (total number of nodes x number*of*task_slots), or every new job created will fail.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] program_args: Arguments to pass during Flink job submission through the programArgsList parameter.
        :param pulumi.Input[_builtins.str] project: Project name. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.bool] restart_enabled: Specifies whether a Flink Job is restarted in case it fails. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] service_name: Service name. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] starting_savepoint: Job savepoint. Maximum length: `2048`.
        :param pulumi.Input[_builtins.str] version_id: ApplicationVersion ID. Maximum length: `36`. Changing this property forces recreation of the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FlinkJarApplicationDeploymentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages the deployment of an Aiven for Apache Flink® application.

        **This resource is in the beta stage and may change without notice.** Set
        the `PROVIDER_AIVEN_ENABLE_BETA` environment variable to use the resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        example = aiven.Flink("example",
            project=example_aiven_project["project"],
            service_name="example-flink-service",
            cloud_name="google-europe-west1",
            plan="business-4",
            maintenance_window_dow="monday",
            maintenance_window_time="04:00:00",
            flink_user_config={
                "custom_code": True,
            })
        example_flink_jar_application = aiven.FlinkJarApplication("example",
            project=example.project,
            service_name=example.service_name,
            name="example-app-jar")
        example_flink_jar_application_version = aiven.FlinkJarApplicationVersion("example",
            project=example.project,
            service_name=example.service_name,
            application_id=example_flink_jar_application.application_id,
            source="./example.jar")
        example_flink_jar_application_deployment = aiven.FlinkJarApplicationDeployment("example",
            project=example.project,
            service_name=example.service_name,
            application_id=example_flink_jar_application.application_id,
            version_id=example_flink_jar_application_version.application_version_id)
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/flinkJarApplicationDeployment:FlinkJarApplicationDeployment example PROJECT/SERVICE_NAME/APPLICATION_ID/DEPLOYMENT_ID
        ```

        :param str resource_name: The name of the resource.
        :param FlinkJarApplicationDeploymentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FlinkJarApplicationDeploymentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 entry_class: Optional[pulumi.Input[_builtins.str]] = None,
                 parallelism: Optional[pulumi.Input[_builtins.int]] = None,
                 program_args: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 restart_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 starting_savepoint: Optional[pulumi.Input[_builtins.str]] = None,
                 version_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FlinkJarApplicationDeploymentArgs.__new__(FlinkJarApplicationDeploymentArgs)

            if application_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_id'")
            __props__.__dict__["application_id"] = application_id
            __props__.__dict__["entry_class"] = entry_class
            __props__.__dict__["parallelism"] = parallelism
            __props__.__dict__["program_args"] = program_args
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["restart_enabled"] = restart_enabled
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["starting_savepoint"] = starting_savepoint
            if version_id is None and not opts.urn:
                raise TypeError("Missing required property 'version_id'")
            __props__.__dict__["version_id"] = version_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["deployment_id"] = None
            __props__.__dict__["error_msg"] = None
            __props__.__dict__["job_id"] = None
            __props__.__dict__["last_savepoint"] = None
            __props__.__dict__["status"] = None
        super(FlinkJarApplicationDeployment, __self__).__init__(
            'aiven:index/flinkJarApplicationDeployment:FlinkJarApplicationDeployment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_id: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            deployment_id: Optional[pulumi.Input[_builtins.str]] = None,
            entry_class: Optional[pulumi.Input[_builtins.str]] = None,
            error_msg: Optional[pulumi.Input[_builtins.str]] = None,
            job_id: Optional[pulumi.Input[_builtins.str]] = None,
            last_savepoint: Optional[pulumi.Input[_builtins.str]] = None,
            parallelism: Optional[pulumi.Input[_builtins.int]] = None,
            program_args: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            restart_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            service_name: Optional[pulumi.Input[_builtins.str]] = None,
            starting_savepoint: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            version_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'FlinkJarApplicationDeployment':
        """
        Get an existing FlinkJarApplicationDeployment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_id: Application Id. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] created_at: The creation timestamp of this entity in ISO 8601 format, always in UTC.
        :param pulumi.Input[_builtins.str] created_by: The creator of this entity.
        :param pulumi.Input[_builtins.str] deployment_id: Deployment ID.
        :param pulumi.Input[_builtins.str] entry_class: The fully qualified name of the entry class to pass during Flink job submission through the entryClass parameter. Maximum length: `128`.
        :param pulumi.Input[_builtins.str] error_msg: Error message describing what caused deployment to fail.
        :param pulumi.Input[_builtins.str] job_id: Job ID.
        :param pulumi.Input[_builtins.str] last_savepoint: Job savepoint.
        :param pulumi.Input[_builtins.int] parallelism: Reading of Flink parallel execution documentation is recommended before setting this value to other than 1. Please do not set this value higher than (total number of nodes x number*of*task_slots), or every new job created will fail.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] program_args: Arguments to pass during Flink job submission through the programArgsList parameter.
        :param pulumi.Input[_builtins.str] project: Project name. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.bool] restart_enabled: Specifies whether a Flink Job is restarted in case it fails. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] service_name: Service name. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] starting_savepoint: Job savepoint. Maximum length: `2048`.
        :param pulumi.Input[_builtins.str] status: Deployment status. The possible values are `CANCELED`, `CANCELLING`, `CANCELLING_REQUESTED`, `CREATED`, `DELETE_REQUESTED`, `DELETING`, `FAILED`, `FAILING`, `FINISHED`, `INITIALIZING`, `RECONCILING`, `RESTARTING`, `RUNNING`, `SAVING`, `SAVING_AND_STOP`, `SAVING_AND_STOP_REQUESTED` and `SUSPENDED`.
        :param pulumi.Input[_builtins.str] version_id: ApplicationVersion ID. Maximum length: `36`. Changing this property forces recreation of the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FlinkJarApplicationDeploymentState.__new__(_FlinkJarApplicationDeploymentState)

        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["deployment_id"] = deployment_id
        __props__.__dict__["entry_class"] = entry_class
        __props__.__dict__["error_msg"] = error_msg
        __props__.__dict__["job_id"] = job_id
        __props__.__dict__["last_savepoint"] = last_savepoint
        __props__.__dict__["parallelism"] = parallelism
        __props__.__dict__["program_args"] = program_args
        __props__.__dict__["project"] = project
        __props__.__dict__["restart_enabled"] = restart_enabled
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["starting_savepoint"] = starting_savepoint
        __props__.__dict__["status"] = status
        __props__.__dict__["version_id"] = version_id
        return FlinkJarApplicationDeployment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[_builtins.str]:
        """
        Application Id. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of this entity in ISO 8601 format, always in UTC.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        The creator of this entity.
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> pulumi.Output[_builtins.str]:
        """
        Deployment ID.
        """
        return pulumi.get(self, "deployment_id")

    @_builtins.property
    @pulumi.getter(name="entryClass")
    def entry_class(self) -> pulumi.Output[_builtins.str]:
        """
        The fully qualified name of the entry class to pass during Flink job submission through the entryClass parameter. Maximum length: `128`.
        """
        return pulumi.get(self, "entry_class")

    @_builtins.property
    @pulumi.getter(name="errorMsg")
    def error_msg(self) -> pulumi.Output[_builtins.str]:
        """
        Error message describing what caused deployment to fail.
        """
        return pulumi.get(self, "error_msg")

    @_builtins.property
    @pulumi.getter(name="jobId")
    def job_id(self) -> pulumi.Output[_builtins.str]:
        """
        Job ID.
        """
        return pulumi.get(self, "job_id")

    @_builtins.property
    @pulumi.getter(name="lastSavepoint")
    def last_savepoint(self) -> pulumi.Output[_builtins.str]:
        """
        Job savepoint.
        """
        return pulumi.get(self, "last_savepoint")

    @_builtins.property
    @pulumi.getter
    def parallelism(self) -> pulumi.Output[_builtins.int]:
        """
        Reading of Flink parallel execution documentation is recommended before setting this value to other than 1. Please do not set this value higher than (total number of nodes x number*of*task_slots), or every new job created will fail.
        """
        return pulumi.get(self, "parallelism")

    @_builtins.property
    @pulumi.getter(name="programArgs")
    def program_args(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Arguments to pass during Flink job submission through the programArgsList parameter.
        """
        return pulumi.get(self, "program_args")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        Project name. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="restartEnabled")
    def restart_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether a Flink Job is restarted in case it fails. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "restart_enabled")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[_builtins.str]:
        """
        Service name. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @_builtins.property
    @pulumi.getter(name="startingSavepoint")
    def starting_savepoint(self) -> pulumi.Output[_builtins.str]:
        """
        Job savepoint. Maximum length: `2048`.
        """
        return pulumi.get(self, "starting_savepoint")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Deployment status. The possible values are `CANCELED`, `CANCELLING`, `CANCELLING_REQUESTED`, `CREATED`, `DELETE_REQUESTED`, `DELETING`, `FAILED`, `FAILING`, `FINISHED`, `INITIALIZING`, `RECONCILING`, `RESTARTING`, `RUNNING`, `SAVING`, `SAVING_AND_STOP`, `SAVING_AND_STOP_REQUESTED` and `SUSPENDED`.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Output[_builtins.str]:
        """
        ApplicationVersion ID. Maximum length: `36`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "version_id")

