# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAccountResult',
    'AwaitableGetAccountResult',
    'get_account',
    'get_account_output',
]

@pulumi.output_type
class GetAccountResult:
    """
    A collection of values returned by getAccount.
    """
    def __init__(__self__, account_id=None, create_time=None, id=None, is_account_owner=None, name=None, owner_team_id=None, primary_billing_group_id=None, tenant_id=None, update_time=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_account_owner and not isinstance(is_account_owner, bool):
            raise TypeError("Expected argument 'is_account_owner' to be a bool")
        pulumi.set(__self__, "is_account_owner", is_account_owner)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if owner_team_id and not isinstance(owner_team_id, str):
            raise TypeError("Expected argument 'owner_team_id' to be a str")
        pulumi.set(__self__, "owner_team_id", owner_team_id)
        if primary_billing_group_id and not isinstance(primary_billing_group_id, str):
            raise TypeError("Expected argument 'primary_billing_group_id' to be a str")
        pulumi.set(__self__, "primary_billing_group_id", primary_billing_group_id)
        if tenant_id and not isinstance(tenant_id, str):
            raise TypeError("Expected argument 'tenant_id' to be a str")
        pulumi.set(__self__, "tenant_id", tenant_id)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Account id
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        Time of creation
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isAccountOwner")
    def is_account_owner(self) -> _builtins.bool:
        """
        If true, user is part of the owners team for this account
        """
        return pulumi.get(self, "is_account_owner")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Account name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ownerTeamId")
    def owner_team_id(self) -> _builtins.str:
        """
        Owner team id
        """
        return pulumi.get(self, "owner_team_id")

    @_builtins.property
    @pulumi.getter(name="primaryBillingGroupId")
    def primary_billing_group_id(self) -> _builtins.str:
        """
        Billing group id
        """
        return pulumi.get(self, "primary_billing_group_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        Tenant id
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        """
        Time of last update
        """
        return pulumi.get(self, "update_time")


class AwaitableGetAccountResult(GetAccountResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountResult(
            account_id=self.account_id,
            create_time=self.create_time,
            id=self.id,
            is_account_owner=self.is_account_owner,
            name=self.name,
            owner_team_id=self.owner_team_id,
            primary_billing_group_id=self.primary_billing_group_id,
            tenant_id=self.tenant_id,
            update_time=self.update_time)


def get_account(name: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountResult:
    """
    The Account data source provides information about the existing Aiven Account.

    > **This resource is deprecated**
    This resource will be removed in v5.0.0. Use `Organization` instead.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    account1 = aiven.get_account(name="<ACCOUNT_NAME>")
    ```


    :param _builtins.str name: Account name
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getAccount:getAccount', __args__, opts=opts, typ=GetAccountResult).value

    return AwaitableGetAccountResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        create_time=pulumi.get(__ret__, 'create_time'),
        id=pulumi.get(__ret__, 'id'),
        is_account_owner=pulumi.get(__ret__, 'is_account_owner'),
        name=pulumi.get(__ret__, 'name'),
        owner_team_id=pulumi.get(__ret__, 'owner_team_id'),
        primary_billing_group_id=pulumi.get(__ret__, 'primary_billing_group_id'),
        tenant_id=pulumi.get(__ret__, 'tenant_id'),
        update_time=pulumi.get(__ret__, 'update_time'))
def get_account_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountResult]:
    """
    The Account data source provides information about the existing Aiven Account.

    > **This resource is deprecated**
    This resource will be removed in v5.0.0. Use `Organization` instead.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    account1 = aiven.get_account(name="<ACCOUNT_NAME>")
    ```


    :param _builtins.str name: Account name
    """
    __args__ = dict()
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aiven:index/getAccount:getAccount', __args__, opts=opts, typ=GetAccountResult)
    return __ret__.apply(lambda __response__: GetAccountResult(
        account_id=pulumi.get(__response__, 'account_id'),
        create_time=pulumi.get(__response__, 'create_time'),
        id=pulumi.get(__response__, 'id'),
        is_account_owner=pulumi.get(__response__, 'is_account_owner'),
        name=pulumi.get(__response__, 'name'),
        owner_team_id=pulumi.get(__response__, 'owner_team_id'),
        primary_billing_group_id=pulumi.get(__response__, 'primary_billing_group_id'),
        tenant_id=pulumi.get(__response__, 'tenant_id'),
        update_time=pulumi.get(__response__, 'update_time')))
