# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetAccountAuthenticationResult',
    'AwaitableGetAccountAuthenticationResult',
    'get_account_authentication',
    'get_account_authentication_output',
]

@pulumi.output_type
class GetAccountAuthenticationResult:
    """
    A collection of values returned by getAccountAuthentication.
    """
    def __init__(__self__, account_id=None, authentication_id=None, auto_join_team_id=None, create_time=None, enabled=None, id=None, name=None, saml_acs_url=None, saml_certificate=None, saml_digest_algorithm=None, saml_entity_id=None, saml_field_mappings=None, saml_idp_login_allowed=None, saml_idp_url=None, saml_metadata_url=None, saml_signature_algorithm=None, saml_variant=None, type=None, update_time=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if authentication_id and not isinstance(authentication_id, str):
            raise TypeError("Expected argument 'authentication_id' to be a str")
        pulumi.set(__self__, "authentication_id", authentication_id)
        if auto_join_team_id and not isinstance(auto_join_team_id, str):
            raise TypeError("Expected argument 'auto_join_team_id' to be a str")
        pulumi.set(__self__, "auto_join_team_id", auto_join_team_id)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if saml_acs_url and not isinstance(saml_acs_url, str):
            raise TypeError("Expected argument 'saml_acs_url' to be a str")
        pulumi.set(__self__, "saml_acs_url", saml_acs_url)
        if saml_certificate and not isinstance(saml_certificate, str):
            raise TypeError("Expected argument 'saml_certificate' to be a str")
        pulumi.set(__self__, "saml_certificate", saml_certificate)
        if saml_digest_algorithm and not isinstance(saml_digest_algorithm, str):
            raise TypeError("Expected argument 'saml_digest_algorithm' to be a str")
        pulumi.set(__self__, "saml_digest_algorithm", saml_digest_algorithm)
        if saml_entity_id and not isinstance(saml_entity_id, str):
            raise TypeError("Expected argument 'saml_entity_id' to be a str")
        pulumi.set(__self__, "saml_entity_id", saml_entity_id)
        if saml_field_mappings and not isinstance(saml_field_mappings, list):
            raise TypeError("Expected argument 'saml_field_mappings' to be a list")
        pulumi.set(__self__, "saml_field_mappings", saml_field_mappings)
        if saml_idp_login_allowed and not isinstance(saml_idp_login_allowed, bool):
            raise TypeError("Expected argument 'saml_idp_login_allowed' to be a bool")
        pulumi.set(__self__, "saml_idp_login_allowed", saml_idp_login_allowed)
        if saml_idp_url and not isinstance(saml_idp_url, str):
            raise TypeError("Expected argument 'saml_idp_url' to be a str")
        pulumi.set(__self__, "saml_idp_url", saml_idp_url)
        if saml_metadata_url and not isinstance(saml_metadata_url, str):
            raise TypeError("Expected argument 'saml_metadata_url' to be a str")
        pulumi.set(__self__, "saml_metadata_url", saml_metadata_url)
        if saml_signature_algorithm and not isinstance(saml_signature_algorithm, str):
            raise TypeError("Expected argument 'saml_signature_algorithm' to be a str")
        pulumi.set(__self__, "saml_signature_algorithm", saml_signature_algorithm)
        if saml_variant and not isinstance(saml_variant, str):
            raise TypeError("Expected argument 'saml_variant' to be a str")
        pulumi.set(__self__, "saml_variant", saml_variant)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        The unique id of the account.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="authenticationId")
    def authentication_id(self) -> _builtins.str:
        """
        Account authentication id
        """
        return pulumi.get(self, "authentication_id")

    @_builtins.property
    @pulumi.getter(name="autoJoinTeamId")
    def auto_join_team_id(self) -> _builtins.str:
        """
        Team ID
        """
        return pulumi.get(self, "auto_join_team_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> _builtins.str:
        """
        Time of creation
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Status of account authentication method. The default value is `false`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the account authentication.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="samlAcsUrl")
    def saml_acs_url(self) -> _builtins.str:
        """
        SAML Assertion Consumer Service URL
        """
        return pulumi.get(self, "saml_acs_url")

    @_builtins.property
    @pulumi.getter(name="samlCertificate")
    def saml_certificate(self) -> _builtins.str:
        """
        SAML Certificate
        """
        return pulumi.get(self, "saml_certificate")

    @_builtins.property
    @pulumi.getter(name="samlDigestAlgorithm")
    def saml_digest_algorithm(self) -> _builtins.str:
        """
        Digest algorithm. This is an advanced option that typically does not need to be set.
        """
        return pulumi.get(self, "saml_digest_algorithm")

    @_builtins.property
    @pulumi.getter(name="samlEntityId")
    def saml_entity_id(self) -> _builtins.str:
        """
        SAML Entity id
        """
        return pulumi.get(self, "saml_entity_id")

    @_builtins.property
    @pulumi.getter(name="samlFieldMappings")
    def saml_field_mappings(self) -> Sequence['outputs.GetAccountAuthenticationSamlFieldMappingResult']:
        """
        Map IdP fields
        """
        return pulumi.get(self, "saml_field_mappings")

    @_builtins.property
    @pulumi.getter(name="samlIdpLoginAllowed")
    def saml_idp_login_allowed(self) -> _builtins.bool:
        """
        Set to 'true' to enable IdP initiated login
        """
        return pulumi.get(self, "saml_idp_login_allowed")

    @_builtins.property
    @pulumi.getter(name="samlIdpUrl")
    def saml_idp_url(self) -> _builtins.str:
        """
        SAML Idp URL
        """
        return pulumi.get(self, "saml_idp_url")

    @_builtins.property
    @pulumi.getter(name="samlMetadataUrl")
    def saml_metadata_url(self) -> _builtins.str:
        """
        SAML Metadata URL
        """
        return pulumi.get(self, "saml_metadata_url")

    @_builtins.property
    @pulumi.getter(name="samlSignatureAlgorithm")
    def saml_signature_algorithm(self) -> _builtins.str:
        """
        Signature algorithm. This is an advanced option that typically does not need to be set.
        """
        return pulumi.get(self, "saml_signature_algorithm")

    @_builtins.property
    @pulumi.getter(name="samlVariant")
    def saml_variant(self) -> _builtins.str:
        """
        SAML server variant
        """
        return pulumi.get(self, "saml_variant")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The account authentication type. The possible values are `internal` and `saml`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> _builtins.str:
        """
        Time of last update
        """
        return pulumi.get(self, "update_time")


class AwaitableGetAccountAuthenticationResult(GetAccountAuthenticationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountAuthenticationResult(
            account_id=self.account_id,
            authentication_id=self.authentication_id,
            auto_join_team_id=self.auto_join_team_id,
            create_time=self.create_time,
            enabled=self.enabled,
            id=self.id,
            name=self.name,
            saml_acs_url=self.saml_acs_url,
            saml_certificate=self.saml_certificate,
            saml_digest_algorithm=self.saml_digest_algorithm,
            saml_entity_id=self.saml_entity_id,
            saml_field_mappings=self.saml_field_mappings,
            saml_idp_login_allowed=self.saml_idp_login_allowed,
            saml_idp_url=self.saml_idp_url,
            saml_metadata_url=self.saml_metadata_url,
            saml_signature_algorithm=self.saml_signature_algorithm,
            saml_variant=self.saml_variant,
            type=self.type,
            update_time=self.update_time)


def get_account_authentication(account_id: Optional[_builtins.str] = None,
                               name: Optional[_builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountAuthenticationResult:
    """
    The Account Authentication data source provides information about the existing Aiven Account Authentication.

    > **This resource is deprecated**
    This resource is deprecated


    :param _builtins.str account_id: The unique id of the account.
    :param _builtins.str name: The name of the account authentication.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getAccountAuthentication:getAccountAuthentication', __args__, opts=opts, typ=GetAccountAuthenticationResult).value

    return AwaitableGetAccountAuthenticationResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        authentication_id=pulumi.get(__ret__, 'authentication_id'),
        auto_join_team_id=pulumi.get(__ret__, 'auto_join_team_id'),
        create_time=pulumi.get(__ret__, 'create_time'),
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        saml_acs_url=pulumi.get(__ret__, 'saml_acs_url'),
        saml_certificate=pulumi.get(__ret__, 'saml_certificate'),
        saml_digest_algorithm=pulumi.get(__ret__, 'saml_digest_algorithm'),
        saml_entity_id=pulumi.get(__ret__, 'saml_entity_id'),
        saml_field_mappings=pulumi.get(__ret__, 'saml_field_mappings'),
        saml_idp_login_allowed=pulumi.get(__ret__, 'saml_idp_login_allowed'),
        saml_idp_url=pulumi.get(__ret__, 'saml_idp_url'),
        saml_metadata_url=pulumi.get(__ret__, 'saml_metadata_url'),
        saml_signature_algorithm=pulumi.get(__ret__, 'saml_signature_algorithm'),
        saml_variant=pulumi.get(__ret__, 'saml_variant'),
        type=pulumi.get(__ret__, 'type'),
        update_time=pulumi.get(__ret__, 'update_time'))
def get_account_authentication_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                      name: Optional[pulumi.Input[_builtins.str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountAuthenticationResult]:
    """
    The Account Authentication data source provides information about the existing Aiven Account Authentication.

    > **This resource is deprecated**
    This resource is deprecated


    :param _builtins.str account_id: The unique id of the account.
    :param _builtins.str name: The name of the account authentication.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aiven:index/getAccountAuthentication:getAccountAuthentication', __args__, opts=opts, typ=GetAccountAuthenticationResult)
    return __ret__.apply(lambda __response__: GetAccountAuthenticationResult(
        account_id=pulumi.get(__response__, 'account_id'),
        authentication_id=pulumi.get(__response__, 'authentication_id'),
        auto_join_team_id=pulumi.get(__response__, 'auto_join_team_id'),
        create_time=pulumi.get(__response__, 'create_time'),
        enabled=pulumi.get(__response__, 'enabled'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        saml_acs_url=pulumi.get(__response__, 'saml_acs_url'),
        saml_certificate=pulumi.get(__response__, 'saml_certificate'),
        saml_digest_algorithm=pulumi.get(__response__, 'saml_digest_algorithm'),
        saml_entity_id=pulumi.get(__response__, 'saml_entity_id'),
        saml_field_mappings=pulumi.get(__response__, 'saml_field_mappings'),
        saml_idp_login_allowed=pulumi.get(__response__, 'saml_idp_login_allowed'),
        saml_idp_url=pulumi.get(__response__, 'saml_idp_url'),
        saml_metadata_url=pulumi.get(__response__, 'saml_metadata_url'),
        saml_signature_algorithm=pulumi.get(__response__, 'saml_signature_algorithm'),
        saml_variant=pulumi.get(__response__, 'saml_variant'),
        type=pulumi.get(__response__, 'type'),
        update_time=pulumi.get(__response__, 'update_time')))
