# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAccountTeamProjectResult',
    'AwaitableGetAccountTeamProjectResult',
    'get_account_team_project',
    'get_account_team_project_output',
]

@pulumi.output_type
class GetAccountTeamProjectResult:
    """
    A collection of values returned by getAccountTeamProject.
    """
    def __init__(__self__, account_id=None, id=None, project_name=None, team_id=None, team_type=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project_name and not isinstance(project_name, str):
            raise TypeError("Expected argument 'project_name' to be a str")
        pulumi.set(__self__, "project_name", project_name)
        if team_id and not isinstance(team_id, str):
            raise TypeError("Expected argument 'team_id' to be a str")
        pulumi.set(__self__, "team_id", team_id)
        if team_type and not isinstance(team_type, str):
            raise TypeError("Expected argument 'team_type' to be a str")
        pulumi.set(__self__, "team_type", team_type)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        The unique account id
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="projectName")
    def project_name(self) -> _builtins.str:
        """
        The name of an already existing project
        """
        return pulumi.get(self, "project_name")

    @_builtins.property
    @pulumi.getter(name="teamId")
    def team_id(self) -> _builtins.str:
        """
        An account team id
        """
        return pulumi.get(self, "team_id")

    @_builtins.property
    @pulumi.getter(name="teamType")
    def team_type(self) -> _builtins.str:
        """
        The Account team project type. The possible values are `admin`, `developer`, `operator`, `organization:app_users:write`, `organization:audit_logs:read`, `organization:billing:read`, `organization:billing:write`, `organization:domains:write`, `organization:groups:write`, `organization:networking:read`, `organization:networking:write`, `organization:projects:write`, `organization:users:write`, `project:audit_logs:read`, `project:integrations:read`, `project:integrations:write`, `project:networking:read`, `project:networking:write`, `project:permissions:read`, `project:services:read`, `project:services:write`, `read_only`, `role:organization:admin`, `role:services:maintenance`, `role:services:recover`, `service:configuration:write`, `service:data:write`, `service:logs:read`, `service:secrets:read` and `service:users:write`.
        """
        return pulumi.get(self, "team_type")


class AwaitableGetAccountTeamProjectResult(GetAccountTeamProjectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountTeamProjectResult(
            account_id=self.account_id,
            id=self.id,
            project_name=self.project_name,
            team_id=self.team_id,
            team_type=self.team_type)


def get_account_team_project(account_id: Optional[_builtins.str] = None,
                             project_name: Optional[_builtins.str] = None,
                             team_id: Optional[_builtins.str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountTeamProjectResult:
    """
    The Account Team Project data source provides information about the existing Account Team Project.

    !> **Teams have been deprecated and are being migrated to groups**
    **On 30 September 2024** the Account Owners team will transition to super admin. Super admin have full access to the organization.
    The Account Owners and super admin are synced, so the removal of the Account Owners team will have no impact on existing permissions.
    **From 4 November 2024** you won't be able to create new teams or update existing ones. Existing teams will be migrated to groups after
    this date. **On 2 December 2024** all teams will be deleted and the teams feature will be completely removed. View the
    migration guide for more information on the changes and migrating to groups.

    > **Important**
    You can't delete the Account Owners team. **Deleting all other teams in your organization will disable the teams feature.**
    You won't be able to create new teams or access your Account Owners team.


    :param _builtins.str account_id: The unique account id
    :param _builtins.str project_name: The name of an already existing project
    :param _builtins.str team_id: An account team id
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['projectName'] = project_name
    __args__['teamId'] = team_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getAccountTeamProject:getAccountTeamProject', __args__, opts=opts, typ=GetAccountTeamProjectResult).value

    return AwaitableGetAccountTeamProjectResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        id=pulumi.get(__ret__, 'id'),
        project_name=pulumi.get(__ret__, 'project_name'),
        team_id=pulumi.get(__ret__, 'team_id'),
        team_type=pulumi.get(__ret__, 'team_type'))
def get_account_team_project_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    project_name: Optional[pulumi.Input[_builtins.str]] = None,
                                    team_id: Optional[pulumi.Input[_builtins.str]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountTeamProjectResult]:
    """
    The Account Team Project data source provides information about the existing Account Team Project.

    !> **Teams have been deprecated and are being migrated to groups**
    **On 30 September 2024** the Account Owners team will transition to super admin. Super admin have full access to the organization.
    The Account Owners and super admin are synced, so the removal of the Account Owners team will have no impact on existing permissions.
    **From 4 November 2024** you won't be able to create new teams or update existing ones. Existing teams will be migrated to groups after
    this date. **On 2 December 2024** all teams will be deleted and the teams feature will be completely removed. View the
    migration guide for more information on the changes and migrating to groups.

    > **Important**
    You can't delete the Account Owners team. **Deleting all other teams in your organization will disable the teams feature.**
    You won't be able to create new teams or access your Account Owners team.


    :param _builtins.str account_id: The unique account id
    :param _builtins.str project_name: The name of an already existing project
    :param _builtins.str team_id: An account team id
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['projectName'] = project_name
    __args__['teamId'] = team_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aiven:index/getAccountTeamProject:getAccountTeamProject', __args__, opts=opts, typ=GetAccountTeamProjectResult)
    return __ret__.apply(lambda __response__: GetAccountTeamProjectResult(
        account_id=pulumi.get(__response__, 'account_id'),
        id=pulumi.get(__response__, 'id'),
        project_name=pulumi.get(__response__, 'project_name'),
        team_id=pulumi.get(__response__, 'team_id'),
        team_type=pulumi.get(__response__, 'team_type')))
