# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAwsPrivatelinkResult',
    'AwaitableGetAwsPrivatelinkResult',
    'get_aws_privatelink',
    'get_aws_privatelink_output',
]

@pulumi.output_type
class GetAwsPrivatelinkResult:
    """
    A collection of values returned by getAwsPrivatelink.
    """
    def __init__(__self__, aws_service_id=None, aws_service_name=None, id=None, principals=None, project=None, service_name=None):
        if aws_service_id and not isinstance(aws_service_id, str):
            raise TypeError("Expected argument 'aws_service_id' to be a str")
        pulumi.set(__self__, "aws_service_id", aws_service_id)
        if aws_service_name and not isinstance(aws_service_name, str):
            raise TypeError("Expected argument 'aws_service_name' to be a str")
        pulumi.set(__self__, "aws_service_name", aws_service_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if principals and not isinstance(principals, list):
            raise TypeError("Expected argument 'principals' to be a list")
        pulumi.set(__self__, "principals", principals)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)

    @_builtins.property
    @pulumi.getter(name="awsServiceId")
    def aws_service_id(self) -> _builtins.str:
        """
        AWS service ID.
        """
        return pulumi.get(self, "aws_service_id")

    @_builtins.property
    @pulumi.getter(name="awsServiceName")
    def aws_service_name(self) -> _builtins.str:
        """
        AWS service name.
        """
        return pulumi.get(self, "aws_service_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def principals(self) -> Sequence[_builtins.str]:
        """
        List of the ARNs of the AWS accounts or IAM users allowed to connect to the VPC endpoint.
        """
        return pulumi.get(self, "principals")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        """
        The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        """
        The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")


class AwaitableGetAwsPrivatelinkResult(GetAwsPrivatelinkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAwsPrivatelinkResult(
            aws_service_id=self.aws_service_id,
            aws_service_name=self.aws_service_name,
            id=self.id,
            principals=self.principals,
            project=self.project,
            service_name=self.service_name)


def get_aws_privatelink(project: Optional[_builtins.str] = None,
                        service_name: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAwsPrivatelinkResult:
    """
    Gets information about an AWS PrivateLink connection for an Aiven service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    main = aiven.get_aws_privatelink(project=example_project["project"],
        service_name=example_kafka["serviceName"])
    ```


    :param _builtins.str project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param _builtins.str service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getAwsPrivatelink:getAwsPrivatelink', __args__, opts=opts, typ=GetAwsPrivatelinkResult).value

    return AwaitableGetAwsPrivatelinkResult(
        aws_service_id=pulumi.get(__ret__, 'aws_service_id'),
        aws_service_name=pulumi.get(__ret__, 'aws_service_name'),
        id=pulumi.get(__ret__, 'id'),
        principals=pulumi.get(__ret__, 'principals'),
        project=pulumi.get(__ret__, 'project'),
        service_name=pulumi.get(__ret__, 'service_name'))
def get_aws_privatelink_output(project: Optional[pulumi.Input[_builtins.str]] = None,
                               service_name: Optional[pulumi.Input[_builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAwsPrivatelinkResult]:
    """
    Gets information about an AWS PrivateLink connection for an Aiven service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    main = aiven.get_aws_privatelink(project=example_project["project"],
        service_name=example_kafka["serviceName"])
    ```


    :param _builtins.str project: The name of the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    :param _builtins.str service_name: The name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. Changing this property forces recreation of the resource.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aiven:index/getAwsPrivatelink:getAwsPrivatelink', __args__, opts=opts, typ=GetAwsPrivatelinkResult)
    return __ret__.apply(lambda __response__: GetAwsPrivatelinkResult(
        aws_service_id=pulumi.get(__response__, 'aws_service_id'),
        aws_service_name=pulumi.get(__response__, 'aws_service_name'),
        id=pulumi.get(__response__, 'id'),
        principals=pulumi.get(__response__, 'principals'),
        project=pulumi.get(__response__, 'project'),
        service_name=pulumi.get(__response__, 'service_name')))
