# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetProjectVpcResult',
    'AwaitableGetProjectVpcResult',
    'get_project_vpc',
    'get_project_vpc_output',
]

@pulumi.output_type
class GetProjectVpcResult:
    """
    A collection of values returned by getProjectVpc.
    """
    def __init__(__self__, cloud_name=None, id=None, network_cidr=None, project=None, state=None, vpc_id=None):
        if cloud_name and not isinstance(cloud_name, str):
            raise TypeError("Expected argument 'cloud_name' to be a str")
        pulumi.set(__self__, "cloud_name", cloud_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if network_cidr and not isinstance(network_cidr, str):
            raise TypeError("Expected argument 'network_cidr' to be a str")
        pulumi.set(__self__, "network_cidr", network_cidr)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="cloudName")
    def cloud_name(self) -> Optional[_builtins.str]:
        """
        The cloud provider and region where the service is hosted in the format `CLOUD_PROVIDER-REGION_NAME`. For example, `google-europe-west1` or `aws-us-east-2`.
        """
        return pulumi.get(self, "cloud_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="networkCidr")
    def network_cidr(self) -> _builtins.str:
        """
        Network address range used by the VPC. For example, `192.168.0.0/24`.
        """
        return pulumi.get(self, "network_cidr")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        """
        Identifies the project this resource belongs to.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        State of the VPC. The possible values are `ACTIVE`, `APPROVED`, `DELETED` and `DELETING`.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        """
        The ID of the VPC. This can be used to filter out the other VPCs if there are more than one for the project and cloud.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableGetProjectVpcResult(GetProjectVpcResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectVpcResult(
            cloud_name=self.cloud_name,
            id=self.id,
            network_cidr=self.network_cidr,
            project=self.project,
            state=self.state,
            vpc_id=self.vpc_id)


def get_project_vpc(cloud_name: Optional[_builtins.str] = None,
                    project: Optional[_builtins.str] = None,
                    vpc_id: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectVpcResult:
    """
    Gets information about the VPC for an Aiven project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    example_vpc = aiven.get_project_vpc(project=example_project["project"],
        cloud_name="google-europe-west1")
    ```


    :param _builtins.str cloud_name: The cloud provider and region where the service is hosted in the format `CLOUD_PROVIDER-REGION_NAME`. For example, `google-europe-west1` or `aws-us-east-2`.
    :param _builtins.str project: Identifies the project this resource belongs to.
    :param _builtins.str vpc_id: The ID of the VPC. This can be used to filter out the other VPCs if there are more than one for the project and cloud.
    """
    __args__ = dict()
    __args__['cloudName'] = cloud_name
    __args__['project'] = project
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aiven:index/getProjectVpc:getProjectVpc', __args__, opts=opts, typ=GetProjectVpcResult).value

    return AwaitableGetProjectVpcResult(
        cloud_name=pulumi.get(__ret__, 'cloud_name'),
        id=pulumi.get(__ret__, 'id'),
        network_cidr=pulumi.get(__ret__, 'network_cidr'),
        project=pulumi.get(__ret__, 'project'),
        state=pulumi.get(__ret__, 'state'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))
def get_project_vpc_output(cloud_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           vpc_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProjectVpcResult]:
    """
    Gets information about the VPC for an Aiven project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    example_vpc = aiven.get_project_vpc(project=example_project["project"],
        cloud_name="google-europe-west1")
    ```


    :param _builtins.str cloud_name: The cloud provider and region where the service is hosted in the format `CLOUD_PROVIDER-REGION_NAME`. For example, `google-europe-west1` or `aws-us-east-2`.
    :param _builtins.str project: Identifies the project this resource belongs to.
    :param _builtins.str vpc_id: The ID of the VPC. This can be used to filter out the other VPCs if there are more than one for the project and cloud.
    """
    __args__ = dict()
    __args__['cloudName'] = cloud_name
    __args__['project'] = project
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aiven:index/getProjectVpc:getProjectVpc', __args__, opts=opts, typ=GetProjectVpcResult)
    return __ret__.apply(lambda __response__: GetProjectVpcResult(
        cloud_name=pulumi.get(__response__, 'cloud_name'),
        id=pulumi.get(__response__, 'id'),
        network_cidr=pulumi.get(__response__, 'network_cidr'),
        project=pulumi.get(__response__, 'project'),
        state=pulumi.get(__response__, 'state'),
        vpc_id=pulumi.get(__response__, 'vpc_id')))
