# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OrganizationAddressArgs', 'OrganizationAddress']

@pulumi.input_type
class OrganizationAddressArgs:
    def __init__(__self__, *,
                 address_lines: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 city: pulumi.Input[_builtins.str],
                 country_code: pulumi.Input[_builtins.str],
                 organization_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['OrganizationAddressTimeoutsArgs']] = None,
                 zip_code: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a OrganizationAddress resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] address_lines: Address Lines.
        :param pulumi.Input[_builtins.str] city: City.
        :param pulumi.Input[_builtins.str] country_code: Country Code.
        :param pulumi.Input[_builtins.str] organization_id: ID of an organization. Maximum length: `36`. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] name: Name of a company. Maximum length: `128`.
        :param pulumi.Input[_builtins.str] state: State. Maximum length: `128`.
        :param pulumi.Input[_builtins.str] zip_code: Zip Code. Maximum length: `32`.
        """
        pulumi.set(__self__, "address_lines", address_lines)
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "country_code", country_code)
        pulumi.set(__self__, "organization_id", organization_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if zip_code is not None:
            pulumi.set(__self__, "zip_code", zip_code)

    @_builtins.property
    @pulumi.getter(name="addressLines")
    def address_lines(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Address Lines.
        """
        return pulumi.get(self, "address_lines")

    @address_lines.setter
    def address_lines(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "address_lines", value)

    @_builtins.property
    @pulumi.getter
    def city(self) -> pulumi.Input[_builtins.str]:
        """
        City.
        """
        return pulumi.get(self, "city")

    @city.setter
    def city(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "city", value)

    @_builtins.property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> pulumi.Input[_builtins.str]:
        """
        Country Code.
        """
        return pulumi.get(self, "country_code")

    @country_code.setter
    def country_code(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "country_code", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of an organization. Maximum length: `36`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of a company. Maximum length: `128`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        State. Maximum length: `128`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['OrganizationAddressTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['OrganizationAddressTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="zipCode")
    def zip_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Zip Code. Maximum length: `32`.
        """
        return pulumi.get(self, "zip_code")

    @zip_code.setter
    def zip_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zip_code", value)


@pulumi.input_type
class _OrganizationAddressState:
    def __init__(__self__, *,
                 address_id: Optional[pulumi.Input[_builtins.str]] = None,
                 address_lines: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 city: Optional[pulumi.Input[_builtins.str]] = None,
                 country_code: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input['OrganizationAddressTimeoutsArgs']] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None,
                 zip_code: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OrganizationAddress resources.
        :param pulumi.Input[_builtins.str] address_id: Address ID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] address_lines: Address Lines.
        :param pulumi.Input[_builtins.str] city: City.
        :param pulumi.Input[_builtins.str] country_code: Country Code.
        :param pulumi.Input[_builtins.str] create_time: Create Time.
        :param pulumi.Input[_builtins.str] name: Name of a company. Maximum length: `128`.
        :param pulumi.Input[_builtins.str] organization_id: ID of an organization. Maximum length: `36`. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] state: State. Maximum length: `128`.
        :param pulumi.Input[_builtins.str] update_time: Update Time.
        :param pulumi.Input[_builtins.str] zip_code: Zip Code. Maximum length: `32`.
        """
        if address_id is not None:
            pulumi.set(__self__, "address_id", address_id)
        if address_lines is not None:
            pulumi.set(__self__, "address_lines", address_lines)
        if city is not None:
            pulumi.set(__self__, "city", city)
        if country_code is not None:
            pulumi.set(__self__, "country_code", country_code)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if zip_code is not None:
            pulumi.set(__self__, "zip_code", zip_code)

    @_builtins.property
    @pulumi.getter(name="addressId")
    def address_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Address ID.
        """
        return pulumi.get(self, "address_id")

    @address_id.setter
    def address_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address_id", value)

    @_builtins.property
    @pulumi.getter(name="addressLines")
    def address_lines(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Address Lines.
        """
        return pulumi.get(self, "address_lines")

    @address_lines.setter
    def address_lines(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "address_lines", value)

    @_builtins.property
    @pulumi.getter
    def city(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        City.
        """
        return pulumi.get(self, "city")

    @city.setter
    def city(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "city", value)

    @_builtins.property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Country Code.
        """
        return pulumi.get(self, "country_code")

    @country_code.setter
    def country_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "country_code", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Create Time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of a company. Maximum length: `128`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of an organization. Maximum length: `36`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        State. Maximum length: `128`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['OrganizationAddressTimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['OrganizationAddressTimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Update Time.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)

    @_builtins.property
    @pulumi.getter(name="zipCode")
    def zip_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Zip Code. Maximum length: `32`.
        """
        return pulumi.get(self, "zip_code")

    @zip_code.setter
    def zip_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zip_code", value)


@pulumi.type_token("aiven:index/organizationAddress:OrganizationAddress")
class OrganizationAddress(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_lines: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 city: Optional[pulumi.Input[_builtins.str]] = None,
                 country_code: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['OrganizationAddressTimeoutsArgs', 'OrganizationAddressTimeoutsArgsDict']]] = None,
                 zip_code: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages an organization address.

        **This resource is in the beta stage and may change without notice.** Set
        the `PROVIDER_AIVEN_ENABLE_BETA` environment variable to use the resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] address_lines: Address Lines.
        :param pulumi.Input[_builtins.str] city: City.
        :param pulumi.Input[_builtins.str] country_code: Country Code.
        :param pulumi.Input[_builtins.str] name: Name of a company. Maximum length: `128`.
        :param pulumi.Input[_builtins.str] organization_id: ID of an organization. Maximum length: `36`. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] state: State. Maximum length: `128`.
        :param pulumi.Input[_builtins.str] zip_code: Zip Code. Maximum length: `32`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationAddressArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages an organization address.

        **This resource is in the beta stage and may change without notice.** Set
        the `PROVIDER_AIVEN_ENABLE_BETA` environment variable to use the resource.

        :param str resource_name: The name of the resource.
        :param OrganizationAddressArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationAddressArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_lines: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 city: Optional[pulumi.Input[_builtins.str]] = None,
                 country_code: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 timeouts: Optional[pulumi.Input[Union['OrganizationAddressTimeoutsArgs', 'OrganizationAddressTimeoutsArgsDict']]] = None,
                 zip_code: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationAddressArgs.__new__(OrganizationAddressArgs)

            if address_lines is None and not opts.urn:
                raise TypeError("Missing required property 'address_lines'")
            __props__.__dict__["address_lines"] = address_lines
            if city is None and not opts.urn:
                raise TypeError("Missing required property 'city'")
            __props__.__dict__["city"] = city
            if country_code is None and not opts.urn:
                raise TypeError("Missing required property 'country_code'")
            __props__.__dict__["country_code"] = country_code
            __props__.__dict__["name"] = name
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            __props__.__dict__["state"] = state
            __props__.__dict__["timeouts"] = timeouts
            __props__.__dict__["zip_code"] = zip_code
            __props__.__dict__["address_id"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["update_time"] = None
        super(OrganizationAddress, __self__).__init__(
            'aiven:index/organizationAddress:OrganizationAddress',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address_id: Optional[pulumi.Input[_builtins.str]] = None,
            address_lines: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            city: Optional[pulumi.Input[_builtins.str]] = None,
            country_code: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            timeouts: Optional[pulumi.Input[Union['OrganizationAddressTimeoutsArgs', 'OrganizationAddressTimeoutsArgsDict']]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None,
            zip_code: Optional[pulumi.Input[_builtins.str]] = None) -> 'OrganizationAddress':
        """
        Get an existing OrganizationAddress resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address_id: Address ID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] address_lines: Address Lines.
        :param pulumi.Input[_builtins.str] city: City.
        :param pulumi.Input[_builtins.str] country_code: Country Code.
        :param pulumi.Input[_builtins.str] create_time: Create Time.
        :param pulumi.Input[_builtins.str] name: Name of a company. Maximum length: `128`.
        :param pulumi.Input[_builtins.str] organization_id: ID of an organization. Maximum length: `36`. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] state: State. Maximum length: `128`.
        :param pulumi.Input[_builtins.str] update_time: Update Time.
        :param pulumi.Input[_builtins.str] zip_code: Zip Code. Maximum length: `32`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationAddressState.__new__(_OrganizationAddressState)

        __props__.__dict__["address_id"] = address_id
        __props__.__dict__["address_lines"] = address_lines
        __props__.__dict__["city"] = city
        __props__.__dict__["country_code"] = country_code
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["name"] = name
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["state"] = state
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["zip_code"] = zip_code
        return OrganizationAddress(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="addressId")
    def address_id(self) -> pulumi.Output[_builtins.str]:
        """
        Address ID.
        """
        return pulumi.get(self, "address_id")

    @_builtins.property
    @pulumi.getter(name="addressLines")
    def address_lines(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Address Lines.
        """
        return pulumi.get(self, "address_lines")

    @_builtins.property
    @pulumi.getter
    def city(self) -> pulumi.Output[_builtins.str]:
        """
        City.
        """
        return pulumi.get(self, "city")

    @_builtins.property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> pulumi.Output[_builtins.str]:
        """
        Country Code.
        """
        return pulumi.get(self, "country_code")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Create Time.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of a company. Maximum length: `128`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of an organization. Maximum length: `36`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        State. Maximum length: `128`.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.OrganizationAddressTimeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Update Time.
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter(name="zipCode")
    def zip_code(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Zip Code. Maximum length: `32`.
        """
        return pulumi.get(self, "zip_code")

