# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['OrganizationVpcArgs', 'OrganizationVpc']

@pulumi.input_type
class OrganizationVpcArgs:
    def __init__(__self__, *,
                 cloud_name: pulumi.Input[_builtins.str],
                 network_cidr: pulumi.Input[_builtins.str],
                 organization_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a OrganizationVpc resource.
        :param pulumi.Input[_builtins.str] cloud_name: The cloud provider and region where the service is hosted in the format `CLOUD_PROVIDER-REGION_NAME`. For example, `google-europe-west1` or `aws-us-east-2`. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] network_cidr: Network address range used by the VPC. For example, `192.168.0.0/24`.
        :param pulumi.Input[_builtins.str] organization_id: The ID of the organization.
        """
        pulumi.set(__self__, "cloud_name", cloud_name)
        pulumi.set(__self__, "network_cidr", network_cidr)
        pulumi.set(__self__, "organization_id", organization_id)

    @_builtins.property
    @pulumi.getter(name="cloudName")
    def cloud_name(self) -> pulumi.Input[_builtins.str]:
        """
        The cloud provider and region where the service is hosted in the format `CLOUD_PROVIDER-REGION_NAME`. For example, `google-europe-west1` or `aws-us-east-2`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "cloud_name")

    @cloud_name.setter
    def cloud_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cloud_name", value)

    @_builtins.property
    @pulumi.getter(name="networkCidr")
    def network_cidr(self) -> pulumi.Input[_builtins.str]:
        """
        Network address range used by the VPC. For example, `192.168.0.0/24`.
        """
        return pulumi.get(self, "network_cidr")

    @network_cidr.setter
    def network_cidr(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_cidr", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the organization.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization_id", value)


@pulumi.input_type
class _OrganizationVpcState:
    def __init__(__self__, *,
                 cloud_name: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 network_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OrganizationVpc resources.
        :param pulumi.Input[_builtins.str] cloud_name: The cloud provider and region where the service is hosted in the format `CLOUD_PROVIDER-REGION_NAME`. For example, `google-europe-west1` or `aws-us-east-2`. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] create_time: Time of creation of the VPC.
        :param pulumi.Input[_builtins.str] network_cidr: Network address range used by the VPC. For example, `192.168.0.0/24`.
        :param pulumi.Input[_builtins.str] organization_id: The ID of the organization.
        :param pulumi.Input[_builtins.str] organization_vpc_id: The ID of the Aiven Organization VPC.
        :param pulumi.Input[_builtins.str] state: State of the VPC. The possible values are `ACTIVE`, `APPROVED`, `DELETED` and `DELETING`.
        :param pulumi.Input[_builtins.str] update_time: Time of the last update of the VPC.
        """
        if cloud_name is not None:
            pulumi.set(__self__, "cloud_name", cloud_name)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if network_cidr is not None:
            pulumi.set(__self__, "network_cidr", network_cidr)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if organization_vpc_id is not None:
            pulumi.set(__self__, "organization_vpc_id", organization_vpc_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="cloudName")
    def cloud_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cloud provider and region where the service is hosted in the format `CLOUD_PROVIDER-REGION_NAME`. For example, `google-europe-west1` or `aws-us-east-2`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "cloud_name")

    @cloud_name.setter
    def cloud_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_name", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time of creation of the VPC.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="networkCidr")
    def network_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Network address range used by the VPC. For example, `192.168.0.0/24`.
        """
        return pulumi.get(self, "network_cidr")

    @network_cidr.setter
    def network_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_cidr", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the organization.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="organizationVpcId")
    def organization_vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Aiven Organization VPC.
        """
        return pulumi.get(self, "organization_vpc_id")

    @organization_vpc_id.setter
    def organization_vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_vpc_id", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        State of the VPC. The possible values are `ACTIVE`, `APPROVED`, `DELETED` and `DELETING`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time of the last update of the VPC.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("aiven:index/organizationVpc:OrganizationVpc")
class OrganizationVpc(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages a VPC for an Aiven organization.

        **This resource is in the beta stage and may change without notice.** Set
        the `PROVIDER_AIVEN_ENABLE_BETA` environment variable to use the resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        example_vpc = aiven.OrganizationVpc("example_vpc",
            organization_id=example["id"],
            cloud_name="aws-eu-central-1",
            network_cidr="10.0.0.0/24")
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/organizationVpc:OrganizationVpc example ORGANIZATION_ID/ORGANIZATION_VPC_ID
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cloud_name: The cloud provider and region where the service is hosted in the format `CLOUD_PROVIDER-REGION_NAME`. For example, `google-europe-west1` or `aws-us-east-2`. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] network_cidr: Network address range used by the VPC. For example, `192.168.0.0/24`.
        :param pulumi.Input[_builtins.str] organization_id: The ID of the organization.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationVpcArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages a VPC for an Aiven organization.

        **This resource is in the beta stage and may change without notice.** Set
        the `PROVIDER_AIVEN_ENABLE_BETA` environment variable to use the resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        example_vpc = aiven.OrganizationVpc("example_vpc",
            organization_id=example["id"],
            cloud_name="aws-eu-central-1",
            network_cidr="10.0.0.0/24")
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/organizationVpc:OrganizationVpc example ORGANIZATION_ID/ORGANIZATION_VPC_ID
        ```

        :param str resource_name: The name of the resource.
        :param OrganizationVpcArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationVpcArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationVpcArgs.__new__(OrganizationVpcArgs)

            if cloud_name is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_name'")
            __props__.__dict__["cloud_name"] = cloud_name
            if network_cidr is None and not opts.urn:
                raise TypeError("Missing required property 'network_cidr'")
            __props__.__dict__["network_cidr"] = network_cidr
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["organization_vpc_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["update_time"] = None
        super(OrganizationVpc, __self__).__init__(
            'aiven:index/organizationVpc:OrganizationVpc',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cloud_name: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            network_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None,
            organization_vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'OrganizationVpc':
        """
        Get an existing OrganizationVpc resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cloud_name: The cloud provider and region where the service is hosted in the format `CLOUD_PROVIDER-REGION_NAME`. For example, `google-europe-west1` or `aws-us-east-2`. Changing this property forces recreation of the resource.
        :param pulumi.Input[_builtins.str] create_time: Time of creation of the VPC.
        :param pulumi.Input[_builtins.str] network_cidr: Network address range used by the VPC. For example, `192.168.0.0/24`.
        :param pulumi.Input[_builtins.str] organization_id: The ID of the organization.
        :param pulumi.Input[_builtins.str] organization_vpc_id: The ID of the Aiven Organization VPC.
        :param pulumi.Input[_builtins.str] state: State of the VPC. The possible values are `ACTIVE`, `APPROVED`, `DELETED` and `DELETING`.
        :param pulumi.Input[_builtins.str] update_time: Time of the last update of the VPC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationVpcState.__new__(_OrganizationVpcState)

        __props__.__dict__["cloud_name"] = cloud_name
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["network_cidr"] = network_cidr
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["organization_vpc_id"] = organization_vpc_id
        __props__.__dict__["state"] = state
        __props__.__dict__["update_time"] = update_time
        return OrganizationVpc(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cloudName")
    def cloud_name(self) -> pulumi.Output[_builtins.str]:
        """
        The cloud provider and region where the service is hosted in the format `CLOUD_PROVIDER-REGION_NAME`. For example, `google-europe-west1` or `aws-us-east-2`. Changing this property forces recreation of the resource.
        """
        return pulumi.get(self, "cloud_name")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time of creation of the VPC.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="networkCidr")
    def network_cidr(self) -> pulumi.Output[_builtins.str]:
        """
        Network address range used by the VPC. For example, `192.168.0.0/24`.
        """
        return pulumi.get(self, "network_cidr")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the organization.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="organizationVpcId")
    def organization_vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Aiven Organization VPC.
        """
        return pulumi.get(self, "organization_vpc_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        State of the VPC. The possible values are `ACTIVE`, `APPROVED`, `DELETED` and `DELETING`.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Time of the last update of the VPC.
        """
        return pulumi.get(self, "update_time")

