# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceIntegrationArgs', 'ServiceIntegration']

@pulumi.input_type
class ServiceIntegrationArgs:
    def __init__(__self__, *,
                 integration_type: pulumi.Input[_builtins.str],
                 project: pulumi.Input[_builtins.str],
                 clickhouse_credentials_user_config: Optional[pulumi.Input['ServiceIntegrationClickhouseCredentialsUserConfigArgs']] = None,
                 clickhouse_kafka_user_config: Optional[pulumi.Input['ServiceIntegrationClickhouseKafkaUserConfigArgs']] = None,
                 clickhouse_postgresql_user_config: Optional[pulumi.Input['ServiceIntegrationClickhousePostgresqlUserConfigArgs']] = None,
                 datadog_user_config: Optional[pulumi.Input['ServiceIntegrationDatadogUserConfigArgs']] = None,
                 destination_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_service_project: Optional[pulumi.Input[_builtins.str]] = None,
                 external_aws_cloudwatch_logs_user_config: Optional[pulumi.Input['ServiceIntegrationExternalAwsCloudwatchLogsUserConfigArgs']] = None,
                 external_aws_cloudwatch_metrics_user_config: Optional[pulumi.Input['ServiceIntegrationExternalAwsCloudwatchMetricsUserConfigArgs']] = None,
                 external_elasticsearch_logs_user_config: Optional[pulumi.Input['ServiceIntegrationExternalElasticsearchLogsUserConfigArgs']] = None,
                 external_opensearch_logs_user_config: Optional[pulumi.Input['ServiceIntegrationExternalOpensearchLogsUserConfigArgs']] = None,
                 flink_external_postgresql_user_config: Optional[pulumi.Input['ServiceIntegrationFlinkExternalPostgresqlUserConfigArgs']] = None,
                 kafka_connect_user_config: Optional[pulumi.Input['ServiceIntegrationKafkaConnectUserConfigArgs']] = None,
                 kafka_logs_user_config: Optional[pulumi.Input['ServiceIntegrationKafkaLogsUserConfigArgs']] = None,
                 kafka_mirrormaker_user_config: Optional[pulumi.Input['ServiceIntegrationKafkaMirrormakerUserConfigArgs']] = None,
                 logs_user_config: Optional[pulumi.Input['ServiceIntegrationLogsUserConfigArgs']] = None,
                 metrics_user_config: Optional[pulumi.Input['ServiceIntegrationMetricsUserConfigArgs']] = None,
                 prometheus_user_config: Optional[pulumi.Input['ServiceIntegrationPrometheusUserConfigArgs']] = None,
                 source_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_service_project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ServiceIntegration resource.
        :param pulumi.Input[_builtins.str] integration_type: Type of the service integration. The possible values are `alertmanager`, `autoscaler`, `caching`, `cassandra_cross_service_cluster`, `clickhouse_credentials`, `clickhouse_kafka`, `clickhouse_postgresql`, `dashboard`, `datadog`, `datasource`, `disaster_recovery`, `external_aws_cloudwatch_logs`, `external_aws_cloudwatch_metrics`, `external_elasticsearch_logs`, `external_google_cloud_logging`, `external_opensearch_logs`, `flink`, `flink_external_bigquery`, `flink_external_kafka`, `flink_external_postgresql`, `internal_connectivity`, `jolokia`, `kafka_connect`, `kafka_connect_postgresql`, `kafka_logs`, `kafka_mirrormaker`, `logs`, `m3aggregator`, `m3coordinator`, `metrics`, `opensearch_cross_cluster_replication`, `opensearch_cross_cluster_search`, `prometheus`, `read_replica`, `rsyslog`, `schema_registry_proxy`, `stresstester`, `thanos_distributed_query`, `thanos_migrate`, `thanoscompactor`, `thanosquery`, `thanosruler`, `thanosstore`, `vector` and `vmalert`.
        :param pulumi.Input[_builtins.str] project: Project the integration belongs to.
        :param pulumi.Input['ServiceIntegrationClickhouseCredentialsUserConfigArgs'] clickhouse_credentials_user_config: ClickhouseCredentials user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationClickhouseKafkaUserConfigArgs'] clickhouse_kafka_user_config: ClickhouseKafka user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationClickhousePostgresqlUserConfigArgs'] clickhouse_postgresql_user_config: ClickhousePostgresql user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationDatadogUserConfigArgs'] datadog_user_config: Datadog user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[_builtins.str] destination_endpoint_id: Destination endpoint for the integration.
        :param pulumi.Input[_builtins.str] destination_service_name: Destination service for the integration.
        :param pulumi.Input[_builtins.str] destination_service_project: Destination service project name
        :param pulumi.Input['ServiceIntegrationExternalAwsCloudwatchLogsUserConfigArgs'] external_aws_cloudwatch_logs_user_config: ExternalAwsCloudwatchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationExternalAwsCloudwatchMetricsUserConfigArgs'] external_aws_cloudwatch_metrics_user_config: ExternalAwsCloudwatchMetrics user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationExternalElasticsearchLogsUserConfigArgs'] external_elasticsearch_logs_user_config: ExternalElasticsearchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationExternalOpensearchLogsUserConfigArgs'] external_opensearch_logs_user_config: ExternalOpensearchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationFlinkExternalPostgresqlUserConfigArgs'] flink_external_postgresql_user_config: FlinkExternalPostgresql user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationKafkaConnectUserConfigArgs'] kafka_connect_user_config: KafkaConnect user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationKafkaLogsUserConfigArgs'] kafka_logs_user_config: KafkaLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationKafkaMirrormakerUserConfigArgs'] kafka_mirrormaker_user_config: KafkaMirrormaker user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationLogsUserConfigArgs'] logs_user_config: Logs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationMetricsUserConfigArgs'] metrics_user_config: Metrics user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationPrometheusUserConfigArgs'] prometheus_user_config: Prometheus user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[_builtins.str] source_endpoint_id: Source endpoint for the integration.
        :param pulumi.Input[_builtins.str] source_service_name: Source service for the integration (if any)
        :param pulumi.Input[_builtins.str] source_service_project: Source service project name
        """
        pulumi.set(__self__, "integration_type", integration_type)
        pulumi.set(__self__, "project", project)
        if clickhouse_credentials_user_config is not None:
            pulumi.set(__self__, "clickhouse_credentials_user_config", clickhouse_credentials_user_config)
        if clickhouse_kafka_user_config is not None:
            pulumi.set(__self__, "clickhouse_kafka_user_config", clickhouse_kafka_user_config)
        if clickhouse_postgresql_user_config is not None:
            pulumi.set(__self__, "clickhouse_postgresql_user_config", clickhouse_postgresql_user_config)
        if datadog_user_config is not None:
            pulumi.set(__self__, "datadog_user_config", datadog_user_config)
        if destination_endpoint_id is not None:
            pulumi.set(__self__, "destination_endpoint_id", destination_endpoint_id)
        if destination_service_name is not None:
            pulumi.set(__self__, "destination_service_name", destination_service_name)
        if destination_service_project is not None:
            pulumi.set(__self__, "destination_service_project", destination_service_project)
        if external_aws_cloudwatch_logs_user_config is not None:
            pulumi.set(__self__, "external_aws_cloudwatch_logs_user_config", external_aws_cloudwatch_logs_user_config)
        if external_aws_cloudwatch_metrics_user_config is not None:
            pulumi.set(__self__, "external_aws_cloudwatch_metrics_user_config", external_aws_cloudwatch_metrics_user_config)
        if external_elasticsearch_logs_user_config is not None:
            pulumi.set(__self__, "external_elasticsearch_logs_user_config", external_elasticsearch_logs_user_config)
        if external_opensearch_logs_user_config is not None:
            pulumi.set(__self__, "external_opensearch_logs_user_config", external_opensearch_logs_user_config)
        if flink_external_postgresql_user_config is not None:
            pulumi.set(__self__, "flink_external_postgresql_user_config", flink_external_postgresql_user_config)
        if kafka_connect_user_config is not None:
            pulumi.set(__self__, "kafka_connect_user_config", kafka_connect_user_config)
        if kafka_logs_user_config is not None:
            pulumi.set(__self__, "kafka_logs_user_config", kafka_logs_user_config)
        if kafka_mirrormaker_user_config is not None:
            pulumi.set(__self__, "kafka_mirrormaker_user_config", kafka_mirrormaker_user_config)
        if logs_user_config is not None:
            pulumi.set(__self__, "logs_user_config", logs_user_config)
        if metrics_user_config is not None:
            pulumi.set(__self__, "metrics_user_config", metrics_user_config)
        if prometheus_user_config is not None:
            pulumi.set(__self__, "prometheus_user_config", prometheus_user_config)
        if source_endpoint_id is not None:
            pulumi.set(__self__, "source_endpoint_id", source_endpoint_id)
        if source_service_name is not None:
            pulumi.set(__self__, "source_service_name", source_service_name)
        if source_service_project is not None:
            pulumi.set(__self__, "source_service_project", source_service_project)

    @_builtins.property
    @pulumi.getter(name="integrationType")
    def integration_type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the service integration. The possible values are `alertmanager`, `autoscaler`, `caching`, `cassandra_cross_service_cluster`, `clickhouse_credentials`, `clickhouse_kafka`, `clickhouse_postgresql`, `dashboard`, `datadog`, `datasource`, `disaster_recovery`, `external_aws_cloudwatch_logs`, `external_aws_cloudwatch_metrics`, `external_elasticsearch_logs`, `external_google_cloud_logging`, `external_opensearch_logs`, `flink`, `flink_external_bigquery`, `flink_external_kafka`, `flink_external_postgresql`, `internal_connectivity`, `jolokia`, `kafka_connect`, `kafka_connect_postgresql`, `kafka_logs`, `kafka_mirrormaker`, `logs`, `m3aggregator`, `m3coordinator`, `metrics`, `opensearch_cross_cluster_replication`, `opensearch_cross_cluster_search`, `prometheus`, `read_replica`, `rsyslog`, `schema_registry_proxy`, `stresstester`, `thanos_distributed_query`, `thanos_migrate`, `thanoscompactor`, `thanosquery`, `thanosruler`, `thanosstore`, `vector` and `vmalert`.
        """
        return pulumi.get(self, "integration_type")

    @integration_type.setter
    def integration_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "integration_type", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        Project the integration belongs to.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="clickhouseCredentialsUserConfig")
    def clickhouse_credentials_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationClickhouseCredentialsUserConfigArgs']]:
        """
        ClickhouseCredentials user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "clickhouse_credentials_user_config")

    @clickhouse_credentials_user_config.setter
    def clickhouse_credentials_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationClickhouseCredentialsUserConfigArgs']]):
        pulumi.set(self, "clickhouse_credentials_user_config", value)

    @_builtins.property
    @pulumi.getter(name="clickhouseKafkaUserConfig")
    def clickhouse_kafka_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationClickhouseKafkaUserConfigArgs']]:
        """
        ClickhouseKafka user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "clickhouse_kafka_user_config")

    @clickhouse_kafka_user_config.setter
    def clickhouse_kafka_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationClickhouseKafkaUserConfigArgs']]):
        pulumi.set(self, "clickhouse_kafka_user_config", value)

    @_builtins.property
    @pulumi.getter(name="clickhousePostgresqlUserConfig")
    def clickhouse_postgresql_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationClickhousePostgresqlUserConfigArgs']]:
        """
        ClickhousePostgresql user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "clickhouse_postgresql_user_config")

    @clickhouse_postgresql_user_config.setter
    def clickhouse_postgresql_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationClickhousePostgresqlUserConfigArgs']]):
        pulumi.set(self, "clickhouse_postgresql_user_config", value)

    @_builtins.property
    @pulumi.getter(name="datadogUserConfig")
    def datadog_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationDatadogUserConfigArgs']]:
        """
        Datadog user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "datadog_user_config")

    @datadog_user_config.setter
    def datadog_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationDatadogUserConfigArgs']]):
        pulumi.set(self, "datadog_user_config", value)

    @_builtins.property
    @pulumi.getter(name="destinationEndpointId")
    def destination_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Destination endpoint for the integration.
        """
        return pulumi.get(self, "destination_endpoint_id")

    @destination_endpoint_id.setter
    def destination_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="destinationServiceName")
    def destination_service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Destination service for the integration.
        """
        return pulumi.get(self, "destination_service_name")

    @destination_service_name.setter
    def destination_service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_service_name", value)

    @_builtins.property
    @pulumi.getter(name="destinationServiceProject")
    def destination_service_project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Destination service project name
        """
        return pulumi.get(self, "destination_service_project")

    @destination_service_project.setter
    def destination_service_project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_service_project", value)

    @_builtins.property
    @pulumi.getter(name="externalAwsCloudwatchLogsUserConfig")
    def external_aws_cloudwatch_logs_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationExternalAwsCloudwatchLogsUserConfigArgs']]:
        """
        ExternalAwsCloudwatchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_aws_cloudwatch_logs_user_config")

    @external_aws_cloudwatch_logs_user_config.setter
    def external_aws_cloudwatch_logs_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationExternalAwsCloudwatchLogsUserConfigArgs']]):
        pulumi.set(self, "external_aws_cloudwatch_logs_user_config", value)

    @_builtins.property
    @pulumi.getter(name="externalAwsCloudwatchMetricsUserConfig")
    def external_aws_cloudwatch_metrics_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationExternalAwsCloudwatchMetricsUserConfigArgs']]:
        """
        ExternalAwsCloudwatchMetrics user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_aws_cloudwatch_metrics_user_config")

    @external_aws_cloudwatch_metrics_user_config.setter
    def external_aws_cloudwatch_metrics_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationExternalAwsCloudwatchMetricsUserConfigArgs']]):
        pulumi.set(self, "external_aws_cloudwatch_metrics_user_config", value)

    @_builtins.property
    @pulumi.getter(name="externalElasticsearchLogsUserConfig")
    def external_elasticsearch_logs_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationExternalElasticsearchLogsUserConfigArgs']]:
        """
        ExternalElasticsearchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_elasticsearch_logs_user_config")

    @external_elasticsearch_logs_user_config.setter
    def external_elasticsearch_logs_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationExternalElasticsearchLogsUserConfigArgs']]):
        pulumi.set(self, "external_elasticsearch_logs_user_config", value)

    @_builtins.property
    @pulumi.getter(name="externalOpensearchLogsUserConfig")
    def external_opensearch_logs_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationExternalOpensearchLogsUserConfigArgs']]:
        """
        ExternalOpensearchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_opensearch_logs_user_config")

    @external_opensearch_logs_user_config.setter
    def external_opensearch_logs_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationExternalOpensearchLogsUserConfigArgs']]):
        pulumi.set(self, "external_opensearch_logs_user_config", value)

    @_builtins.property
    @pulumi.getter(name="flinkExternalPostgresqlUserConfig")
    def flink_external_postgresql_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationFlinkExternalPostgresqlUserConfigArgs']]:
        """
        FlinkExternalPostgresql user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "flink_external_postgresql_user_config")

    @flink_external_postgresql_user_config.setter
    def flink_external_postgresql_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationFlinkExternalPostgresqlUserConfigArgs']]):
        pulumi.set(self, "flink_external_postgresql_user_config", value)

    @_builtins.property
    @pulumi.getter(name="kafkaConnectUserConfig")
    def kafka_connect_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationKafkaConnectUserConfigArgs']]:
        """
        KafkaConnect user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "kafka_connect_user_config")

    @kafka_connect_user_config.setter
    def kafka_connect_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationKafkaConnectUserConfigArgs']]):
        pulumi.set(self, "kafka_connect_user_config", value)

    @_builtins.property
    @pulumi.getter(name="kafkaLogsUserConfig")
    def kafka_logs_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationKafkaLogsUserConfigArgs']]:
        """
        KafkaLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "kafka_logs_user_config")

    @kafka_logs_user_config.setter
    def kafka_logs_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationKafkaLogsUserConfigArgs']]):
        pulumi.set(self, "kafka_logs_user_config", value)

    @_builtins.property
    @pulumi.getter(name="kafkaMirrormakerUserConfig")
    def kafka_mirrormaker_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationKafkaMirrormakerUserConfigArgs']]:
        """
        KafkaMirrormaker user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "kafka_mirrormaker_user_config")

    @kafka_mirrormaker_user_config.setter
    def kafka_mirrormaker_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationKafkaMirrormakerUserConfigArgs']]):
        pulumi.set(self, "kafka_mirrormaker_user_config", value)

    @_builtins.property
    @pulumi.getter(name="logsUserConfig")
    def logs_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationLogsUserConfigArgs']]:
        """
        Logs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "logs_user_config")

    @logs_user_config.setter
    def logs_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationLogsUserConfigArgs']]):
        pulumi.set(self, "logs_user_config", value)

    @_builtins.property
    @pulumi.getter(name="metricsUserConfig")
    def metrics_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationMetricsUserConfigArgs']]:
        """
        Metrics user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "metrics_user_config")

    @metrics_user_config.setter
    def metrics_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationMetricsUserConfigArgs']]):
        pulumi.set(self, "metrics_user_config", value)

    @_builtins.property
    @pulumi.getter(name="prometheusUserConfig")
    def prometheus_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationPrometheusUserConfigArgs']]:
        """
        Prometheus user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "prometheus_user_config")

    @prometheus_user_config.setter
    def prometheus_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationPrometheusUserConfigArgs']]):
        pulumi.set(self, "prometheus_user_config", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointId")
    def source_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Source endpoint for the integration.
        """
        return pulumi.get(self, "source_endpoint_id")

    @source_endpoint_id.setter
    def source_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceServiceName")
    def source_service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Source service for the integration (if any)
        """
        return pulumi.get(self, "source_service_name")

    @source_service_name.setter
    def source_service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_service_name", value)

    @_builtins.property
    @pulumi.getter(name="sourceServiceProject")
    def source_service_project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Source service project name
        """
        return pulumi.get(self, "source_service_project")

    @source_service_project.setter
    def source_service_project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_service_project", value)


@pulumi.input_type
class _ServiceIntegrationState:
    def __init__(__self__, *,
                 clickhouse_credentials_user_config: Optional[pulumi.Input['ServiceIntegrationClickhouseCredentialsUserConfigArgs']] = None,
                 clickhouse_kafka_user_config: Optional[pulumi.Input['ServiceIntegrationClickhouseKafkaUserConfigArgs']] = None,
                 clickhouse_postgresql_user_config: Optional[pulumi.Input['ServiceIntegrationClickhousePostgresqlUserConfigArgs']] = None,
                 datadog_user_config: Optional[pulumi.Input['ServiceIntegrationDatadogUserConfigArgs']] = None,
                 destination_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_service_project: Optional[pulumi.Input[_builtins.str]] = None,
                 external_aws_cloudwatch_logs_user_config: Optional[pulumi.Input['ServiceIntegrationExternalAwsCloudwatchLogsUserConfigArgs']] = None,
                 external_aws_cloudwatch_metrics_user_config: Optional[pulumi.Input['ServiceIntegrationExternalAwsCloudwatchMetricsUserConfigArgs']] = None,
                 external_elasticsearch_logs_user_config: Optional[pulumi.Input['ServiceIntegrationExternalElasticsearchLogsUserConfigArgs']] = None,
                 external_opensearch_logs_user_config: Optional[pulumi.Input['ServiceIntegrationExternalOpensearchLogsUserConfigArgs']] = None,
                 flink_external_postgresql_user_config: Optional[pulumi.Input['ServiceIntegrationFlinkExternalPostgresqlUserConfigArgs']] = None,
                 integration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 integration_type: Optional[pulumi.Input[_builtins.str]] = None,
                 kafka_connect_user_config: Optional[pulumi.Input['ServiceIntegrationKafkaConnectUserConfigArgs']] = None,
                 kafka_logs_user_config: Optional[pulumi.Input['ServiceIntegrationKafkaLogsUserConfigArgs']] = None,
                 kafka_mirrormaker_user_config: Optional[pulumi.Input['ServiceIntegrationKafkaMirrormakerUserConfigArgs']] = None,
                 logs_user_config: Optional[pulumi.Input['ServiceIntegrationLogsUserConfigArgs']] = None,
                 metrics_user_config: Optional[pulumi.Input['ServiceIntegrationMetricsUserConfigArgs']] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 prometheus_user_config: Optional[pulumi.Input['ServiceIntegrationPrometheusUserConfigArgs']] = None,
                 source_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_service_project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServiceIntegration resources.
        :param pulumi.Input['ServiceIntegrationClickhouseCredentialsUserConfigArgs'] clickhouse_credentials_user_config: ClickhouseCredentials user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationClickhouseKafkaUserConfigArgs'] clickhouse_kafka_user_config: ClickhouseKafka user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationClickhousePostgresqlUserConfigArgs'] clickhouse_postgresql_user_config: ClickhousePostgresql user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationDatadogUserConfigArgs'] datadog_user_config: Datadog user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[_builtins.str] destination_endpoint_id: Destination endpoint for the integration.
        :param pulumi.Input[_builtins.str] destination_service_name: Destination service for the integration.
        :param pulumi.Input[_builtins.str] destination_service_project: Destination service project name
        :param pulumi.Input['ServiceIntegrationExternalAwsCloudwatchLogsUserConfigArgs'] external_aws_cloudwatch_logs_user_config: ExternalAwsCloudwatchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationExternalAwsCloudwatchMetricsUserConfigArgs'] external_aws_cloudwatch_metrics_user_config: ExternalAwsCloudwatchMetrics user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationExternalElasticsearchLogsUserConfigArgs'] external_elasticsearch_logs_user_config: ExternalElasticsearchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationExternalOpensearchLogsUserConfigArgs'] external_opensearch_logs_user_config: ExternalOpensearchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationFlinkExternalPostgresqlUserConfigArgs'] flink_external_postgresql_user_config: FlinkExternalPostgresql user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[_builtins.str] integration_id: The ID of the Aiven service integration.
        :param pulumi.Input[_builtins.str] integration_type: Type of the service integration. The possible values are `alertmanager`, `autoscaler`, `caching`, `cassandra_cross_service_cluster`, `clickhouse_credentials`, `clickhouse_kafka`, `clickhouse_postgresql`, `dashboard`, `datadog`, `datasource`, `disaster_recovery`, `external_aws_cloudwatch_logs`, `external_aws_cloudwatch_metrics`, `external_elasticsearch_logs`, `external_google_cloud_logging`, `external_opensearch_logs`, `flink`, `flink_external_bigquery`, `flink_external_kafka`, `flink_external_postgresql`, `internal_connectivity`, `jolokia`, `kafka_connect`, `kafka_connect_postgresql`, `kafka_logs`, `kafka_mirrormaker`, `logs`, `m3aggregator`, `m3coordinator`, `metrics`, `opensearch_cross_cluster_replication`, `opensearch_cross_cluster_search`, `prometheus`, `read_replica`, `rsyslog`, `schema_registry_proxy`, `stresstester`, `thanos_distributed_query`, `thanos_migrate`, `thanoscompactor`, `thanosquery`, `thanosruler`, `thanosstore`, `vector` and `vmalert`.
        :param pulumi.Input['ServiceIntegrationKafkaConnectUserConfigArgs'] kafka_connect_user_config: KafkaConnect user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationKafkaLogsUserConfigArgs'] kafka_logs_user_config: KafkaLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationKafkaMirrormakerUserConfigArgs'] kafka_mirrormaker_user_config: KafkaMirrormaker user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationLogsUserConfigArgs'] logs_user_config: Logs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input['ServiceIntegrationMetricsUserConfigArgs'] metrics_user_config: Metrics user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[_builtins.str] project: Project the integration belongs to.
        :param pulumi.Input['ServiceIntegrationPrometheusUserConfigArgs'] prometheus_user_config: Prometheus user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[_builtins.str] source_endpoint_id: Source endpoint for the integration.
        :param pulumi.Input[_builtins.str] source_service_name: Source service for the integration (if any)
        :param pulumi.Input[_builtins.str] source_service_project: Source service project name
        """
        if clickhouse_credentials_user_config is not None:
            pulumi.set(__self__, "clickhouse_credentials_user_config", clickhouse_credentials_user_config)
        if clickhouse_kafka_user_config is not None:
            pulumi.set(__self__, "clickhouse_kafka_user_config", clickhouse_kafka_user_config)
        if clickhouse_postgresql_user_config is not None:
            pulumi.set(__self__, "clickhouse_postgresql_user_config", clickhouse_postgresql_user_config)
        if datadog_user_config is not None:
            pulumi.set(__self__, "datadog_user_config", datadog_user_config)
        if destination_endpoint_id is not None:
            pulumi.set(__self__, "destination_endpoint_id", destination_endpoint_id)
        if destination_service_name is not None:
            pulumi.set(__self__, "destination_service_name", destination_service_name)
        if destination_service_project is not None:
            pulumi.set(__self__, "destination_service_project", destination_service_project)
        if external_aws_cloudwatch_logs_user_config is not None:
            pulumi.set(__self__, "external_aws_cloudwatch_logs_user_config", external_aws_cloudwatch_logs_user_config)
        if external_aws_cloudwatch_metrics_user_config is not None:
            pulumi.set(__self__, "external_aws_cloudwatch_metrics_user_config", external_aws_cloudwatch_metrics_user_config)
        if external_elasticsearch_logs_user_config is not None:
            pulumi.set(__self__, "external_elasticsearch_logs_user_config", external_elasticsearch_logs_user_config)
        if external_opensearch_logs_user_config is not None:
            pulumi.set(__self__, "external_opensearch_logs_user_config", external_opensearch_logs_user_config)
        if flink_external_postgresql_user_config is not None:
            pulumi.set(__self__, "flink_external_postgresql_user_config", flink_external_postgresql_user_config)
        if integration_id is not None:
            pulumi.set(__self__, "integration_id", integration_id)
        if integration_type is not None:
            pulumi.set(__self__, "integration_type", integration_type)
        if kafka_connect_user_config is not None:
            pulumi.set(__self__, "kafka_connect_user_config", kafka_connect_user_config)
        if kafka_logs_user_config is not None:
            pulumi.set(__self__, "kafka_logs_user_config", kafka_logs_user_config)
        if kafka_mirrormaker_user_config is not None:
            pulumi.set(__self__, "kafka_mirrormaker_user_config", kafka_mirrormaker_user_config)
        if logs_user_config is not None:
            pulumi.set(__self__, "logs_user_config", logs_user_config)
        if metrics_user_config is not None:
            pulumi.set(__self__, "metrics_user_config", metrics_user_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if prometheus_user_config is not None:
            pulumi.set(__self__, "prometheus_user_config", prometheus_user_config)
        if source_endpoint_id is not None:
            pulumi.set(__self__, "source_endpoint_id", source_endpoint_id)
        if source_service_name is not None:
            pulumi.set(__self__, "source_service_name", source_service_name)
        if source_service_project is not None:
            pulumi.set(__self__, "source_service_project", source_service_project)

    @_builtins.property
    @pulumi.getter(name="clickhouseCredentialsUserConfig")
    def clickhouse_credentials_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationClickhouseCredentialsUserConfigArgs']]:
        """
        ClickhouseCredentials user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "clickhouse_credentials_user_config")

    @clickhouse_credentials_user_config.setter
    def clickhouse_credentials_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationClickhouseCredentialsUserConfigArgs']]):
        pulumi.set(self, "clickhouse_credentials_user_config", value)

    @_builtins.property
    @pulumi.getter(name="clickhouseKafkaUserConfig")
    def clickhouse_kafka_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationClickhouseKafkaUserConfigArgs']]:
        """
        ClickhouseKafka user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "clickhouse_kafka_user_config")

    @clickhouse_kafka_user_config.setter
    def clickhouse_kafka_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationClickhouseKafkaUserConfigArgs']]):
        pulumi.set(self, "clickhouse_kafka_user_config", value)

    @_builtins.property
    @pulumi.getter(name="clickhousePostgresqlUserConfig")
    def clickhouse_postgresql_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationClickhousePostgresqlUserConfigArgs']]:
        """
        ClickhousePostgresql user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "clickhouse_postgresql_user_config")

    @clickhouse_postgresql_user_config.setter
    def clickhouse_postgresql_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationClickhousePostgresqlUserConfigArgs']]):
        pulumi.set(self, "clickhouse_postgresql_user_config", value)

    @_builtins.property
    @pulumi.getter(name="datadogUserConfig")
    def datadog_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationDatadogUserConfigArgs']]:
        """
        Datadog user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "datadog_user_config")

    @datadog_user_config.setter
    def datadog_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationDatadogUserConfigArgs']]):
        pulumi.set(self, "datadog_user_config", value)

    @_builtins.property
    @pulumi.getter(name="destinationEndpointId")
    def destination_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Destination endpoint for the integration.
        """
        return pulumi.get(self, "destination_endpoint_id")

    @destination_endpoint_id.setter
    def destination_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="destinationServiceName")
    def destination_service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Destination service for the integration.
        """
        return pulumi.get(self, "destination_service_name")

    @destination_service_name.setter
    def destination_service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_service_name", value)

    @_builtins.property
    @pulumi.getter(name="destinationServiceProject")
    def destination_service_project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Destination service project name
        """
        return pulumi.get(self, "destination_service_project")

    @destination_service_project.setter
    def destination_service_project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_service_project", value)

    @_builtins.property
    @pulumi.getter(name="externalAwsCloudwatchLogsUserConfig")
    def external_aws_cloudwatch_logs_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationExternalAwsCloudwatchLogsUserConfigArgs']]:
        """
        ExternalAwsCloudwatchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_aws_cloudwatch_logs_user_config")

    @external_aws_cloudwatch_logs_user_config.setter
    def external_aws_cloudwatch_logs_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationExternalAwsCloudwatchLogsUserConfigArgs']]):
        pulumi.set(self, "external_aws_cloudwatch_logs_user_config", value)

    @_builtins.property
    @pulumi.getter(name="externalAwsCloudwatchMetricsUserConfig")
    def external_aws_cloudwatch_metrics_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationExternalAwsCloudwatchMetricsUserConfigArgs']]:
        """
        ExternalAwsCloudwatchMetrics user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_aws_cloudwatch_metrics_user_config")

    @external_aws_cloudwatch_metrics_user_config.setter
    def external_aws_cloudwatch_metrics_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationExternalAwsCloudwatchMetricsUserConfigArgs']]):
        pulumi.set(self, "external_aws_cloudwatch_metrics_user_config", value)

    @_builtins.property
    @pulumi.getter(name="externalElasticsearchLogsUserConfig")
    def external_elasticsearch_logs_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationExternalElasticsearchLogsUserConfigArgs']]:
        """
        ExternalElasticsearchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_elasticsearch_logs_user_config")

    @external_elasticsearch_logs_user_config.setter
    def external_elasticsearch_logs_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationExternalElasticsearchLogsUserConfigArgs']]):
        pulumi.set(self, "external_elasticsearch_logs_user_config", value)

    @_builtins.property
    @pulumi.getter(name="externalOpensearchLogsUserConfig")
    def external_opensearch_logs_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationExternalOpensearchLogsUserConfigArgs']]:
        """
        ExternalOpensearchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_opensearch_logs_user_config")

    @external_opensearch_logs_user_config.setter
    def external_opensearch_logs_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationExternalOpensearchLogsUserConfigArgs']]):
        pulumi.set(self, "external_opensearch_logs_user_config", value)

    @_builtins.property
    @pulumi.getter(name="flinkExternalPostgresqlUserConfig")
    def flink_external_postgresql_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationFlinkExternalPostgresqlUserConfigArgs']]:
        """
        FlinkExternalPostgresql user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "flink_external_postgresql_user_config")

    @flink_external_postgresql_user_config.setter
    def flink_external_postgresql_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationFlinkExternalPostgresqlUserConfigArgs']]):
        pulumi.set(self, "flink_external_postgresql_user_config", value)

    @_builtins.property
    @pulumi.getter(name="integrationId")
    def integration_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Aiven service integration.
        """
        return pulumi.get(self, "integration_id")

    @integration_id.setter
    def integration_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "integration_id", value)

    @_builtins.property
    @pulumi.getter(name="integrationType")
    def integration_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of the service integration. The possible values are `alertmanager`, `autoscaler`, `caching`, `cassandra_cross_service_cluster`, `clickhouse_credentials`, `clickhouse_kafka`, `clickhouse_postgresql`, `dashboard`, `datadog`, `datasource`, `disaster_recovery`, `external_aws_cloudwatch_logs`, `external_aws_cloudwatch_metrics`, `external_elasticsearch_logs`, `external_google_cloud_logging`, `external_opensearch_logs`, `flink`, `flink_external_bigquery`, `flink_external_kafka`, `flink_external_postgresql`, `internal_connectivity`, `jolokia`, `kafka_connect`, `kafka_connect_postgresql`, `kafka_logs`, `kafka_mirrormaker`, `logs`, `m3aggregator`, `m3coordinator`, `metrics`, `opensearch_cross_cluster_replication`, `opensearch_cross_cluster_search`, `prometheus`, `read_replica`, `rsyslog`, `schema_registry_proxy`, `stresstester`, `thanos_distributed_query`, `thanos_migrate`, `thanoscompactor`, `thanosquery`, `thanosruler`, `thanosstore`, `vector` and `vmalert`.
        """
        return pulumi.get(self, "integration_type")

    @integration_type.setter
    def integration_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "integration_type", value)

    @_builtins.property
    @pulumi.getter(name="kafkaConnectUserConfig")
    def kafka_connect_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationKafkaConnectUserConfigArgs']]:
        """
        KafkaConnect user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "kafka_connect_user_config")

    @kafka_connect_user_config.setter
    def kafka_connect_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationKafkaConnectUserConfigArgs']]):
        pulumi.set(self, "kafka_connect_user_config", value)

    @_builtins.property
    @pulumi.getter(name="kafkaLogsUserConfig")
    def kafka_logs_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationKafkaLogsUserConfigArgs']]:
        """
        KafkaLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "kafka_logs_user_config")

    @kafka_logs_user_config.setter
    def kafka_logs_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationKafkaLogsUserConfigArgs']]):
        pulumi.set(self, "kafka_logs_user_config", value)

    @_builtins.property
    @pulumi.getter(name="kafkaMirrormakerUserConfig")
    def kafka_mirrormaker_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationKafkaMirrormakerUserConfigArgs']]:
        """
        KafkaMirrormaker user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "kafka_mirrormaker_user_config")

    @kafka_mirrormaker_user_config.setter
    def kafka_mirrormaker_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationKafkaMirrormakerUserConfigArgs']]):
        pulumi.set(self, "kafka_mirrormaker_user_config", value)

    @_builtins.property
    @pulumi.getter(name="logsUserConfig")
    def logs_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationLogsUserConfigArgs']]:
        """
        Logs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "logs_user_config")

    @logs_user_config.setter
    def logs_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationLogsUserConfigArgs']]):
        pulumi.set(self, "logs_user_config", value)

    @_builtins.property
    @pulumi.getter(name="metricsUserConfig")
    def metrics_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationMetricsUserConfigArgs']]:
        """
        Metrics user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "metrics_user_config")

    @metrics_user_config.setter
    def metrics_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationMetricsUserConfigArgs']]):
        pulumi.set(self, "metrics_user_config", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project the integration belongs to.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="prometheusUserConfig")
    def prometheus_user_config(self) -> Optional[pulumi.Input['ServiceIntegrationPrometheusUserConfigArgs']]:
        """
        Prometheus user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "prometheus_user_config")

    @prometheus_user_config.setter
    def prometheus_user_config(self, value: Optional[pulumi.Input['ServiceIntegrationPrometheusUserConfigArgs']]):
        pulumi.set(self, "prometheus_user_config", value)

    @_builtins.property
    @pulumi.getter(name="sourceEndpointId")
    def source_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Source endpoint for the integration.
        """
        return pulumi.get(self, "source_endpoint_id")

    @source_endpoint_id.setter
    def source_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceServiceName")
    def source_service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Source service for the integration (if any)
        """
        return pulumi.get(self, "source_service_name")

    @source_service_name.setter
    def source_service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_service_name", value)

    @_builtins.property
    @pulumi.getter(name="sourceServiceProject")
    def source_service_project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Source service project name
        """
        return pulumi.get(self, "source_service_project")

    @source_service_project.setter
    def source_service_project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_service_project", value)


@pulumi.type_token("aiven:index/serviceIntegration:ServiceIntegration")
class ServiceIntegration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 clickhouse_credentials_user_config: Optional[pulumi.Input[Union['ServiceIntegrationClickhouseCredentialsUserConfigArgs', 'ServiceIntegrationClickhouseCredentialsUserConfigArgsDict']]] = None,
                 clickhouse_kafka_user_config: Optional[pulumi.Input[Union['ServiceIntegrationClickhouseKafkaUserConfigArgs', 'ServiceIntegrationClickhouseKafkaUserConfigArgsDict']]] = None,
                 clickhouse_postgresql_user_config: Optional[pulumi.Input[Union['ServiceIntegrationClickhousePostgresqlUserConfigArgs', 'ServiceIntegrationClickhousePostgresqlUserConfigArgsDict']]] = None,
                 datadog_user_config: Optional[pulumi.Input[Union['ServiceIntegrationDatadogUserConfigArgs', 'ServiceIntegrationDatadogUserConfigArgsDict']]] = None,
                 destination_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_service_project: Optional[pulumi.Input[_builtins.str]] = None,
                 external_aws_cloudwatch_logs_user_config: Optional[pulumi.Input[Union['ServiceIntegrationExternalAwsCloudwatchLogsUserConfigArgs', 'ServiceIntegrationExternalAwsCloudwatchLogsUserConfigArgsDict']]] = None,
                 external_aws_cloudwatch_metrics_user_config: Optional[pulumi.Input[Union['ServiceIntegrationExternalAwsCloudwatchMetricsUserConfigArgs', 'ServiceIntegrationExternalAwsCloudwatchMetricsUserConfigArgsDict']]] = None,
                 external_elasticsearch_logs_user_config: Optional[pulumi.Input[Union['ServiceIntegrationExternalElasticsearchLogsUserConfigArgs', 'ServiceIntegrationExternalElasticsearchLogsUserConfigArgsDict']]] = None,
                 external_opensearch_logs_user_config: Optional[pulumi.Input[Union['ServiceIntegrationExternalOpensearchLogsUserConfigArgs', 'ServiceIntegrationExternalOpensearchLogsUserConfigArgsDict']]] = None,
                 flink_external_postgresql_user_config: Optional[pulumi.Input[Union['ServiceIntegrationFlinkExternalPostgresqlUserConfigArgs', 'ServiceIntegrationFlinkExternalPostgresqlUserConfigArgsDict']]] = None,
                 integration_type: Optional[pulumi.Input[_builtins.str]] = None,
                 kafka_connect_user_config: Optional[pulumi.Input[Union['ServiceIntegrationKafkaConnectUserConfigArgs', 'ServiceIntegrationKafkaConnectUserConfigArgsDict']]] = None,
                 kafka_logs_user_config: Optional[pulumi.Input[Union['ServiceIntegrationKafkaLogsUserConfigArgs', 'ServiceIntegrationKafkaLogsUserConfigArgsDict']]] = None,
                 kafka_mirrormaker_user_config: Optional[pulumi.Input[Union['ServiceIntegrationKafkaMirrormakerUserConfigArgs', 'ServiceIntegrationKafkaMirrormakerUserConfigArgsDict']]] = None,
                 logs_user_config: Optional[pulumi.Input[Union['ServiceIntegrationLogsUserConfigArgs', 'ServiceIntegrationLogsUserConfigArgsDict']]] = None,
                 metrics_user_config: Optional[pulumi.Input[Union['ServiceIntegrationMetricsUserConfigArgs', 'ServiceIntegrationMetricsUserConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 prometheus_user_config: Optional[pulumi.Input[Union['ServiceIntegrationPrometheusUserConfigArgs', 'ServiceIntegrationPrometheusUserConfigArgsDict']]] = None,
                 source_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_service_project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        # Integrate Kafka and Thanos services for metrics
        example_integration = aiven.ServiceIntegration("example_integration",
            project=example_project["project"],
            integration_type="metrics",
            source_service_name=example_kafka["serviceName"],
            destination_service_name=example_thanos["serviceName"])
        # Use disk autoscaler with a PostgreSQL service
        autoscaler_endpoint = aiven.ServiceIntegrationEndpoint("autoscaler_endpoint",
            project=example_project["project"],
            endpoint_name="disk-autoscaler-200GiB",
            endpoint_type="autoscaler",
            autoscaler_user_config={
                "autoscalings": [{
                    "cap_gb": 200,
                    "type": "autoscale_disk",
                }],
            })
        autoscaler_integration = aiven.ServiceIntegration("autoscaler_integration",
            project=example_project["project"],
            integration_type="autoscaler",
            source_service_name=example_pg["serviceName"],
            destination_endpoint_id=autoscaler_endpoint.id)
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/serviceIntegration:ServiceIntegration example_integration PROJECT/INTEGRATION_ID
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ServiceIntegrationClickhouseCredentialsUserConfigArgs', 'ServiceIntegrationClickhouseCredentialsUserConfigArgsDict']] clickhouse_credentials_user_config: ClickhouseCredentials user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationClickhouseKafkaUserConfigArgs', 'ServiceIntegrationClickhouseKafkaUserConfigArgsDict']] clickhouse_kafka_user_config: ClickhouseKafka user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationClickhousePostgresqlUserConfigArgs', 'ServiceIntegrationClickhousePostgresqlUserConfigArgsDict']] clickhouse_postgresql_user_config: ClickhousePostgresql user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationDatadogUserConfigArgs', 'ServiceIntegrationDatadogUserConfigArgsDict']] datadog_user_config: Datadog user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[_builtins.str] destination_endpoint_id: Destination endpoint for the integration.
        :param pulumi.Input[_builtins.str] destination_service_name: Destination service for the integration.
        :param pulumi.Input[_builtins.str] destination_service_project: Destination service project name
        :param pulumi.Input[Union['ServiceIntegrationExternalAwsCloudwatchLogsUserConfigArgs', 'ServiceIntegrationExternalAwsCloudwatchLogsUserConfigArgsDict']] external_aws_cloudwatch_logs_user_config: ExternalAwsCloudwatchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationExternalAwsCloudwatchMetricsUserConfigArgs', 'ServiceIntegrationExternalAwsCloudwatchMetricsUserConfigArgsDict']] external_aws_cloudwatch_metrics_user_config: ExternalAwsCloudwatchMetrics user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationExternalElasticsearchLogsUserConfigArgs', 'ServiceIntegrationExternalElasticsearchLogsUserConfigArgsDict']] external_elasticsearch_logs_user_config: ExternalElasticsearchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationExternalOpensearchLogsUserConfigArgs', 'ServiceIntegrationExternalOpensearchLogsUserConfigArgsDict']] external_opensearch_logs_user_config: ExternalOpensearchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationFlinkExternalPostgresqlUserConfigArgs', 'ServiceIntegrationFlinkExternalPostgresqlUserConfigArgsDict']] flink_external_postgresql_user_config: FlinkExternalPostgresql user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[_builtins.str] integration_type: Type of the service integration. The possible values are `alertmanager`, `autoscaler`, `caching`, `cassandra_cross_service_cluster`, `clickhouse_credentials`, `clickhouse_kafka`, `clickhouse_postgresql`, `dashboard`, `datadog`, `datasource`, `disaster_recovery`, `external_aws_cloudwatch_logs`, `external_aws_cloudwatch_metrics`, `external_elasticsearch_logs`, `external_google_cloud_logging`, `external_opensearch_logs`, `flink`, `flink_external_bigquery`, `flink_external_kafka`, `flink_external_postgresql`, `internal_connectivity`, `jolokia`, `kafka_connect`, `kafka_connect_postgresql`, `kafka_logs`, `kafka_mirrormaker`, `logs`, `m3aggregator`, `m3coordinator`, `metrics`, `opensearch_cross_cluster_replication`, `opensearch_cross_cluster_search`, `prometheus`, `read_replica`, `rsyslog`, `schema_registry_proxy`, `stresstester`, `thanos_distributed_query`, `thanos_migrate`, `thanoscompactor`, `thanosquery`, `thanosruler`, `thanosstore`, `vector` and `vmalert`.
        :param pulumi.Input[Union['ServiceIntegrationKafkaConnectUserConfigArgs', 'ServiceIntegrationKafkaConnectUserConfigArgsDict']] kafka_connect_user_config: KafkaConnect user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationKafkaLogsUserConfigArgs', 'ServiceIntegrationKafkaLogsUserConfigArgsDict']] kafka_logs_user_config: KafkaLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationKafkaMirrormakerUserConfigArgs', 'ServiceIntegrationKafkaMirrormakerUserConfigArgsDict']] kafka_mirrormaker_user_config: KafkaMirrormaker user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationLogsUserConfigArgs', 'ServiceIntegrationLogsUserConfigArgsDict']] logs_user_config: Logs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationMetricsUserConfigArgs', 'ServiceIntegrationMetricsUserConfigArgsDict']] metrics_user_config: Metrics user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[_builtins.str] project: Project the integration belongs to.
        :param pulumi.Input[Union['ServiceIntegrationPrometheusUserConfigArgs', 'ServiceIntegrationPrometheusUserConfigArgsDict']] prometheus_user_config: Prometheus user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[_builtins.str] source_endpoint_id: Source endpoint for the integration.
        :param pulumi.Input[_builtins.str] source_service_name: Source service for the integration (if any)
        :param pulumi.Input[_builtins.str] source_service_project: Source service project name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceIntegrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_aiven as aiven

        # Integrate Kafka and Thanos services for metrics
        example_integration = aiven.ServiceIntegration("example_integration",
            project=example_project["project"],
            integration_type="metrics",
            source_service_name=example_kafka["serviceName"],
            destination_service_name=example_thanos["serviceName"])
        # Use disk autoscaler with a PostgreSQL service
        autoscaler_endpoint = aiven.ServiceIntegrationEndpoint("autoscaler_endpoint",
            project=example_project["project"],
            endpoint_name="disk-autoscaler-200GiB",
            endpoint_type="autoscaler",
            autoscaler_user_config={
                "autoscalings": [{
                    "cap_gb": 200,
                    "type": "autoscale_disk",
                }],
            })
        autoscaler_integration = aiven.ServiceIntegration("autoscaler_integration",
            project=example_project["project"],
            integration_type="autoscaler",
            source_service_name=example_pg["serviceName"],
            destination_endpoint_id=autoscaler_endpoint.id)
        ```

        ## Import

        ```sh
        $ pulumi import aiven:index/serviceIntegration:ServiceIntegration example_integration PROJECT/INTEGRATION_ID
        ```

        :param str resource_name: The name of the resource.
        :param ServiceIntegrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceIntegrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 clickhouse_credentials_user_config: Optional[pulumi.Input[Union['ServiceIntegrationClickhouseCredentialsUserConfigArgs', 'ServiceIntegrationClickhouseCredentialsUserConfigArgsDict']]] = None,
                 clickhouse_kafka_user_config: Optional[pulumi.Input[Union['ServiceIntegrationClickhouseKafkaUserConfigArgs', 'ServiceIntegrationClickhouseKafkaUserConfigArgsDict']]] = None,
                 clickhouse_postgresql_user_config: Optional[pulumi.Input[Union['ServiceIntegrationClickhousePostgresqlUserConfigArgs', 'ServiceIntegrationClickhousePostgresqlUserConfigArgsDict']]] = None,
                 datadog_user_config: Optional[pulumi.Input[Union['ServiceIntegrationDatadogUserConfigArgs', 'ServiceIntegrationDatadogUserConfigArgsDict']]] = None,
                 destination_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_service_project: Optional[pulumi.Input[_builtins.str]] = None,
                 external_aws_cloudwatch_logs_user_config: Optional[pulumi.Input[Union['ServiceIntegrationExternalAwsCloudwatchLogsUserConfigArgs', 'ServiceIntegrationExternalAwsCloudwatchLogsUserConfigArgsDict']]] = None,
                 external_aws_cloudwatch_metrics_user_config: Optional[pulumi.Input[Union['ServiceIntegrationExternalAwsCloudwatchMetricsUserConfigArgs', 'ServiceIntegrationExternalAwsCloudwatchMetricsUserConfigArgsDict']]] = None,
                 external_elasticsearch_logs_user_config: Optional[pulumi.Input[Union['ServiceIntegrationExternalElasticsearchLogsUserConfigArgs', 'ServiceIntegrationExternalElasticsearchLogsUserConfigArgsDict']]] = None,
                 external_opensearch_logs_user_config: Optional[pulumi.Input[Union['ServiceIntegrationExternalOpensearchLogsUserConfigArgs', 'ServiceIntegrationExternalOpensearchLogsUserConfigArgsDict']]] = None,
                 flink_external_postgresql_user_config: Optional[pulumi.Input[Union['ServiceIntegrationFlinkExternalPostgresqlUserConfigArgs', 'ServiceIntegrationFlinkExternalPostgresqlUserConfigArgsDict']]] = None,
                 integration_type: Optional[pulumi.Input[_builtins.str]] = None,
                 kafka_connect_user_config: Optional[pulumi.Input[Union['ServiceIntegrationKafkaConnectUserConfigArgs', 'ServiceIntegrationKafkaConnectUserConfigArgsDict']]] = None,
                 kafka_logs_user_config: Optional[pulumi.Input[Union['ServiceIntegrationKafkaLogsUserConfigArgs', 'ServiceIntegrationKafkaLogsUserConfigArgsDict']]] = None,
                 kafka_mirrormaker_user_config: Optional[pulumi.Input[Union['ServiceIntegrationKafkaMirrormakerUserConfigArgs', 'ServiceIntegrationKafkaMirrormakerUserConfigArgsDict']]] = None,
                 logs_user_config: Optional[pulumi.Input[Union['ServiceIntegrationLogsUserConfigArgs', 'ServiceIntegrationLogsUserConfigArgsDict']]] = None,
                 metrics_user_config: Optional[pulumi.Input[Union['ServiceIntegrationMetricsUserConfigArgs', 'ServiceIntegrationMetricsUserConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 prometheus_user_config: Optional[pulumi.Input[Union['ServiceIntegrationPrometheusUserConfigArgs', 'ServiceIntegrationPrometheusUserConfigArgsDict']]] = None,
                 source_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_service_project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceIntegrationArgs.__new__(ServiceIntegrationArgs)

            __props__.__dict__["clickhouse_credentials_user_config"] = clickhouse_credentials_user_config
            __props__.__dict__["clickhouse_kafka_user_config"] = clickhouse_kafka_user_config
            __props__.__dict__["clickhouse_postgresql_user_config"] = clickhouse_postgresql_user_config
            __props__.__dict__["datadog_user_config"] = datadog_user_config
            __props__.__dict__["destination_endpoint_id"] = destination_endpoint_id
            __props__.__dict__["destination_service_name"] = destination_service_name
            __props__.__dict__["destination_service_project"] = destination_service_project
            __props__.__dict__["external_aws_cloudwatch_logs_user_config"] = external_aws_cloudwatch_logs_user_config
            __props__.__dict__["external_aws_cloudwatch_metrics_user_config"] = external_aws_cloudwatch_metrics_user_config
            __props__.__dict__["external_elasticsearch_logs_user_config"] = external_elasticsearch_logs_user_config
            __props__.__dict__["external_opensearch_logs_user_config"] = external_opensearch_logs_user_config
            __props__.__dict__["flink_external_postgresql_user_config"] = flink_external_postgresql_user_config
            if integration_type is None and not opts.urn:
                raise TypeError("Missing required property 'integration_type'")
            __props__.__dict__["integration_type"] = integration_type
            __props__.__dict__["kafka_connect_user_config"] = kafka_connect_user_config
            __props__.__dict__["kafka_logs_user_config"] = kafka_logs_user_config
            __props__.__dict__["kafka_mirrormaker_user_config"] = kafka_mirrormaker_user_config
            __props__.__dict__["logs_user_config"] = logs_user_config
            __props__.__dict__["metrics_user_config"] = metrics_user_config
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["prometheus_user_config"] = prometheus_user_config
            __props__.__dict__["source_endpoint_id"] = source_endpoint_id
            __props__.__dict__["source_service_name"] = source_service_name
            __props__.__dict__["source_service_project"] = source_service_project
            __props__.__dict__["integration_id"] = None
        super(ServiceIntegration, __self__).__init__(
            'aiven:index/serviceIntegration:ServiceIntegration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            clickhouse_credentials_user_config: Optional[pulumi.Input[Union['ServiceIntegrationClickhouseCredentialsUserConfigArgs', 'ServiceIntegrationClickhouseCredentialsUserConfigArgsDict']]] = None,
            clickhouse_kafka_user_config: Optional[pulumi.Input[Union['ServiceIntegrationClickhouseKafkaUserConfigArgs', 'ServiceIntegrationClickhouseKafkaUserConfigArgsDict']]] = None,
            clickhouse_postgresql_user_config: Optional[pulumi.Input[Union['ServiceIntegrationClickhousePostgresqlUserConfigArgs', 'ServiceIntegrationClickhousePostgresqlUserConfigArgsDict']]] = None,
            datadog_user_config: Optional[pulumi.Input[Union['ServiceIntegrationDatadogUserConfigArgs', 'ServiceIntegrationDatadogUserConfigArgsDict']]] = None,
            destination_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
            destination_service_name: Optional[pulumi.Input[_builtins.str]] = None,
            destination_service_project: Optional[pulumi.Input[_builtins.str]] = None,
            external_aws_cloudwatch_logs_user_config: Optional[pulumi.Input[Union['ServiceIntegrationExternalAwsCloudwatchLogsUserConfigArgs', 'ServiceIntegrationExternalAwsCloudwatchLogsUserConfigArgsDict']]] = None,
            external_aws_cloudwatch_metrics_user_config: Optional[pulumi.Input[Union['ServiceIntegrationExternalAwsCloudwatchMetricsUserConfigArgs', 'ServiceIntegrationExternalAwsCloudwatchMetricsUserConfigArgsDict']]] = None,
            external_elasticsearch_logs_user_config: Optional[pulumi.Input[Union['ServiceIntegrationExternalElasticsearchLogsUserConfigArgs', 'ServiceIntegrationExternalElasticsearchLogsUserConfigArgsDict']]] = None,
            external_opensearch_logs_user_config: Optional[pulumi.Input[Union['ServiceIntegrationExternalOpensearchLogsUserConfigArgs', 'ServiceIntegrationExternalOpensearchLogsUserConfigArgsDict']]] = None,
            flink_external_postgresql_user_config: Optional[pulumi.Input[Union['ServiceIntegrationFlinkExternalPostgresqlUserConfigArgs', 'ServiceIntegrationFlinkExternalPostgresqlUserConfigArgsDict']]] = None,
            integration_id: Optional[pulumi.Input[_builtins.str]] = None,
            integration_type: Optional[pulumi.Input[_builtins.str]] = None,
            kafka_connect_user_config: Optional[pulumi.Input[Union['ServiceIntegrationKafkaConnectUserConfigArgs', 'ServiceIntegrationKafkaConnectUserConfigArgsDict']]] = None,
            kafka_logs_user_config: Optional[pulumi.Input[Union['ServiceIntegrationKafkaLogsUserConfigArgs', 'ServiceIntegrationKafkaLogsUserConfigArgsDict']]] = None,
            kafka_mirrormaker_user_config: Optional[pulumi.Input[Union['ServiceIntegrationKafkaMirrormakerUserConfigArgs', 'ServiceIntegrationKafkaMirrormakerUserConfigArgsDict']]] = None,
            logs_user_config: Optional[pulumi.Input[Union['ServiceIntegrationLogsUserConfigArgs', 'ServiceIntegrationLogsUserConfigArgsDict']]] = None,
            metrics_user_config: Optional[pulumi.Input[Union['ServiceIntegrationMetricsUserConfigArgs', 'ServiceIntegrationMetricsUserConfigArgsDict']]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            prometheus_user_config: Optional[pulumi.Input[Union['ServiceIntegrationPrometheusUserConfigArgs', 'ServiceIntegrationPrometheusUserConfigArgsDict']]] = None,
            source_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
            source_service_name: Optional[pulumi.Input[_builtins.str]] = None,
            source_service_project: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServiceIntegration':
        """
        Get an existing ServiceIntegration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ServiceIntegrationClickhouseCredentialsUserConfigArgs', 'ServiceIntegrationClickhouseCredentialsUserConfigArgsDict']] clickhouse_credentials_user_config: ClickhouseCredentials user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationClickhouseKafkaUserConfigArgs', 'ServiceIntegrationClickhouseKafkaUserConfigArgsDict']] clickhouse_kafka_user_config: ClickhouseKafka user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationClickhousePostgresqlUserConfigArgs', 'ServiceIntegrationClickhousePostgresqlUserConfigArgsDict']] clickhouse_postgresql_user_config: ClickhousePostgresql user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationDatadogUserConfigArgs', 'ServiceIntegrationDatadogUserConfigArgsDict']] datadog_user_config: Datadog user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[_builtins.str] destination_endpoint_id: Destination endpoint for the integration.
        :param pulumi.Input[_builtins.str] destination_service_name: Destination service for the integration.
        :param pulumi.Input[_builtins.str] destination_service_project: Destination service project name
        :param pulumi.Input[Union['ServiceIntegrationExternalAwsCloudwatchLogsUserConfigArgs', 'ServiceIntegrationExternalAwsCloudwatchLogsUserConfigArgsDict']] external_aws_cloudwatch_logs_user_config: ExternalAwsCloudwatchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationExternalAwsCloudwatchMetricsUserConfigArgs', 'ServiceIntegrationExternalAwsCloudwatchMetricsUserConfigArgsDict']] external_aws_cloudwatch_metrics_user_config: ExternalAwsCloudwatchMetrics user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationExternalElasticsearchLogsUserConfigArgs', 'ServiceIntegrationExternalElasticsearchLogsUserConfigArgsDict']] external_elasticsearch_logs_user_config: ExternalElasticsearchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationExternalOpensearchLogsUserConfigArgs', 'ServiceIntegrationExternalOpensearchLogsUserConfigArgsDict']] external_opensearch_logs_user_config: ExternalOpensearchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationFlinkExternalPostgresqlUserConfigArgs', 'ServiceIntegrationFlinkExternalPostgresqlUserConfigArgsDict']] flink_external_postgresql_user_config: FlinkExternalPostgresql user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[_builtins.str] integration_id: The ID of the Aiven service integration.
        :param pulumi.Input[_builtins.str] integration_type: Type of the service integration. The possible values are `alertmanager`, `autoscaler`, `caching`, `cassandra_cross_service_cluster`, `clickhouse_credentials`, `clickhouse_kafka`, `clickhouse_postgresql`, `dashboard`, `datadog`, `datasource`, `disaster_recovery`, `external_aws_cloudwatch_logs`, `external_aws_cloudwatch_metrics`, `external_elasticsearch_logs`, `external_google_cloud_logging`, `external_opensearch_logs`, `flink`, `flink_external_bigquery`, `flink_external_kafka`, `flink_external_postgresql`, `internal_connectivity`, `jolokia`, `kafka_connect`, `kafka_connect_postgresql`, `kafka_logs`, `kafka_mirrormaker`, `logs`, `m3aggregator`, `m3coordinator`, `metrics`, `opensearch_cross_cluster_replication`, `opensearch_cross_cluster_search`, `prometheus`, `read_replica`, `rsyslog`, `schema_registry_proxy`, `stresstester`, `thanos_distributed_query`, `thanos_migrate`, `thanoscompactor`, `thanosquery`, `thanosruler`, `thanosstore`, `vector` and `vmalert`.
        :param pulumi.Input[Union['ServiceIntegrationKafkaConnectUserConfigArgs', 'ServiceIntegrationKafkaConnectUserConfigArgsDict']] kafka_connect_user_config: KafkaConnect user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationKafkaLogsUserConfigArgs', 'ServiceIntegrationKafkaLogsUserConfigArgsDict']] kafka_logs_user_config: KafkaLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationKafkaMirrormakerUserConfigArgs', 'ServiceIntegrationKafkaMirrormakerUserConfigArgsDict']] kafka_mirrormaker_user_config: KafkaMirrormaker user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationLogsUserConfigArgs', 'ServiceIntegrationLogsUserConfigArgsDict']] logs_user_config: Logs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[Union['ServiceIntegrationMetricsUserConfigArgs', 'ServiceIntegrationMetricsUserConfigArgsDict']] metrics_user_config: Metrics user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[_builtins.str] project: Project the integration belongs to.
        :param pulumi.Input[Union['ServiceIntegrationPrometheusUserConfigArgs', 'ServiceIntegrationPrometheusUserConfigArgsDict']] prometheus_user_config: Prometheus user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        :param pulumi.Input[_builtins.str] source_endpoint_id: Source endpoint for the integration.
        :param pulumi.Input[_builtins.str] source_service_name: Source service for the integration (if any)
        :param pulumi.Input[_builtins.str] source_service_project: Source service project name
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceIntegrationState.__new__(_ServiceIntegrationState)

        __props__.__dict__["clickhouse_credentials_user_config"] = clickhouse_credentials_user_config
        __props__.__dict__["clickhouse_kafka_user_config"] = clickhouse_kafka_user_config
        __props__.__dict__["clickhouse_postgresql_user_config"] = clickhouse_postgresql_user_config
        __props__.__dict__["datadog_user_config"] = datadog_user_config
        __props__.__dict__["destination_endpoint_id"] = destination_endpoint_id
        __props__.__dict__["destination_service_name"] = destination_service_name
        __props__.__dict__["destination_service_project"] = destination_service_project
        __props__.__dict__["external_aws_cloudwatch_logs_user_config"] = external_aws_cloudwatch_logs_user_config
        __props__.__dict__["external_aws_cloudwatch_metrics_user_config"] = external_aws_cloudwatch_metrics_user_config
        __props__.__dict__["external_elasticsearch_logs_user_config"] = external_elasticsearch_logs_user_config
        __props__.__dict__["external_opensearch_logs_user_config"] = external_opensearch_logs_user_config
        __props__.__dict__["flink_external_postgresql_user_config"] = flink_external_postgresql_user_config
        __props__.__dict__["integration_id"] = integration_id
        __props__.__dict__["integration_type"] = integration_type
        __props__.__dict__["kafka_connect_user_config"] = kafka_connect_user_config
        __props__.__dict__["kafka_logs_user_config"] = kafka_logs_user_config
        __props__.__dict__["kafka_mirrormaker_user_config"] = kafka_mirrormaker_user_config
        __props__.__dict__["logs_user_config"] = logs_user_config
        __props__.__dict__["metrics_user_config"] = metrics_user_config
        __props__.__dict__["project"] = project
        __props__.__dict__["prometheus_user_config"] = prometheus_user_config
        __props__.__dict__["source_endpoint_id"] = source_endpoint_id
        __props__.__dict__["source_service_name"] = source_service_name
        __props__.__dict__["source_service_project"] = source_service_project
        return ServiceIntegration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clickhouseCredentialsUserConfig")
    def clickhouse_credentials_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationClickhouseCredentialsUserConfig']]:
        """
        ClickhouseCredentials user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "clickhouse_credentials_user_config")

    @_builtins.property
    @pulumi.getter(name="clickhouseKafkaUserConfig")
    def clickhouse_kafka_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationClickhouseKafkaUserConfig']]:
        """
        ClickhouseKafka user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "clickhouse_kafka_user_config")

    @_builtins.property
    @pulumi.getter(name="clickhousePostgresqlUserConfig")
    def clickhouse_postgresql_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationClickhousePostgresqlUserConfig']]:
        """
        ClickhousePostgresql user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "clickhouse_postgresql_user_config")

    @_builtins.property
    @pulumi.getter(name="datadogUserConfig")
    def datadog_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationDatadogUserConfig']]:
        """
        Datadog user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "datadog_user_config")

    @_builtins.property
    @pulumi.getter(name="destinationEndpointId")
    def destination_endpoint_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Destination endpoint for the integration.
        """
        return pulumi.get(self, "destination_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="destinationServiceName")
    def destination_service_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Destination service for the integration.
        """
        return pulumi.get(self, "destination_service_name")

    @_builtins.property
    @pulumi.getter(name="destinationServiceProject")
    def destination_service_project(self) -> pulumi.Output[_builtins.str]:
        """
        Destination service project name
        """
        return pulumi.get(self, "destination_service_project")

    @_builtins.property
    @pulumi.getter(name="externalAwsCloudwatchLogsUserConfig")
    def external_aws_cloudwatch_logs_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationExternalAwsCloudwatchLogsUserConfig']]:
        """
        ExternalAwsCloudwatchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_aws_cloudwatch_logs_user_config")

    @_builtins.property
    @pulumi.getter(name="externalAwsCloudwatchMetricsUserConfig")
    def external_aws_cloudwatch_metrics_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationExternalAwsCloudwatchMetricsUserConfig']]:
        """
        ExternalAwsCloudwatchMetrics user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_aws_cloudwatch_metrics_user_config")

    @_builtins.property
    @pulumi.getter(name="externalElasticsearchLogsUserConfig")
    def external_elasticsearch_logs_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationExternalElasticsearchLogsUserConfig']]:
        """
        ExternalElasticsearchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_elasticsearch_logs_user_config")

    @_builtins.property
    @pulumi.getter(name="externalOpensearchLogsUserConfig")
    def external_opensearch_logs_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationExternalOpensearchLogsUserConfig']]:
        """
        ExternalOpensearchLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "external_opensearch_logs_user_config")

    @_builtins.property
    @pulumi.getter(name="flinkExternalPostgresqlUserConfig")
    def flink_external_postgresql_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationFlinkExternalPostgresqlUserConfig']]:
        """
        FlinkExternalPostgresql user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "flink_external_postgresql_user_config")

    @_builtins.property
    @pulumi.getter(name="integrationId")
    def integration_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Aiven service integration.
        """
        return pulumi.get(self, "integration_id")

    @_builtins.property
    @pulumi.getter(name="integrationType")
    def integration_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of the service integration. The possible values are `alertmanager`, `autoscaler`, `caching`, `cassandra_cross_service_cluster`, `clickhouse_credentials`, `clickhouse_kafka`, `clickhouse_postgresql`, `dashboard`, `datadog`, `datasource`, `disaster_recovery`, `external_aws_cloudwatch_logs`, `external_aws_cloudwatch_metrics`, `external_elasticsearch_logs`, `external_google_cloud_logging`, `external_opensearch_logs`, `flink`, `flink_external_bigquery`, `flink_external_kafka`, `flink_external_postgresql`, `internal_connectivity`, `jolokia`, `kafka_connect`, `kafka_connect_postgresql`, `kafka_logs`, `kafka_mirrormaker`, `logs`, `m3aggregator`, `m3coordinator`, `metrics`, `opensearch_cross_cluster_replication`, `opensearch_cross_cluster_search`, `prometheus`, `read_replica`, `rsyslog`, `schema_registry_proxy`, `stresstester`, `thanos_distributed_query`, `thanos_migrate`, `thanoscompactor`, `thanosquery`, `thanosruler`, `thanosstore`, `vector` and `vmalert`.
        """
        return pulumi.get(self, "integration_type")

    @_builtins.property
    @pulumi.getter(name="kafkaConnectUserConfig")
    def kafka_connect_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationKafkaConnectUserConfig']]:
        """
        KafkaConnect user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "kafka_connect_user_config")

    @_builtins.property
    @pulumi.getter(name="kafkaLogsUserConfig")
    def kafka_logs_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationKafkaLogsUserConfig']]:
        """
        KafkaLogs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "kafka_logs_user_config")

    @_builtins.property
    @pulumi.getter(name="kafkaMirrormakerUserConfig")
    def kafka_mirrormaker_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationKafkaMirrormakerUserConfig']]:
        """
        KafkaMirrormaker user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "kafka_mirrormaker_user_config")

    @_builtins.property
    @pulumi.getter(name="logsUserConfig")
    def logs_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationLogsUserConfig']]:
        """
        Logs user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "logs_user_config")

    @_builtins.property
    @pulumi.getter(name="metricsUserConfig")
    def metrics_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationMetricsUserConfig']]:
        """
        Metrics user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "metrics_user_config")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        Project the integration belongs to.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="prometheusUserConfig")
    def prometheus_user_config(self) -> pulumi.Output[Optional['outputs.ServiceIntegrationPrometheusUserConfig']]:
        """
        Prometheus user configurable settings. **Warning:** There's no way to reset advanced configuration options to default. Options that you add cannot be removed later
        """
        return pulumi.get(self, "prometheus_user_config")

    @_builtins.property
    @pulumi.getter(name="sourceEndpointId")
    def source_endpoint_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Source endpoint for the integration.
        """
        return pulumi.get(self, "source_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="sourceServiceName")
    def source_service_name(self) -> pulumi.Output[_builtins.str]:
        """
        Source service for the integration (if any)
        """
        return pulumi.get(self, "source_service_name")

    @_builtins.property
    @pulumi.getter(name="sourceServiceProject")
    def source_service_project(self) -> pulumi.Output[_builtins.str]:
        """
        Source service project name
        """
        return pulumi.get(self, "source_service_project")

