# Quple

A framework for quantum machine learning using the google Cirq and tensorflow quantum library

Documentation can be found [here](https://alkaidcheng.github.io/quple.github.io/docs/Quple_GSoC_report.pdf).

## Installing the package

To install `quple`, simply do
```
pip install quple
```

## Colab Notebook Tutorials

### Tutorial-01 Quantum Circuit
* [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/AlkaidCheng/GSOC_MLHEP/blob/master/examples/T01-Quantum_Circuit.ipynb)

### Tutorial-02 Parameterised Quantum Circuit (PQC)
* [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/AlkaidCheng/GSOC_MLHEP/blob/master/examples/T02-Parameterised_Circuit.ipynb)

### Tutorial-03 Interaction Graphs
* [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/AlkaidCheng/GSOC_MLHEP/blob/master/examples/T03-Interaction_Graphs.ipynb)

### Tutorial-04 Encoding Function
* [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/AlkaidCheng/GSOC_MLHEP/blob/master/examples/T04-Encoding_Map.ipynb)

### Tutorial-05 Encoding Circuit
* [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/AlkaidCheng/GSOC_MLHEP/blob/master/examples/T05-Encoding_Circuit.ipynb)

### Tutorial-06 Variational Circuit
* [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/AlkaidCheng/GSOC_MLHEP/blob/master/examples/T06-Variational_Circuit.ipynb)

### Tutorial-07 Circuit Descriptors
* [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/AlkaidCheng/GSOC_MLHEP/blob/master/examples/T07-Circuit_Descriptors.ipynb)

### Tutorial-08 Variational Quantum Classifier
* [![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/AlkaidCheng/GSOC_MLHEP/blob/master/examples/T08-Variational_Quantum_Classifier.ipynb)

