# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatabasePostgresqlV2Args', 'DatabasePostgresqlV2']

@pulumi.input_type
class DatabasePostgresqlV2Args:
    def __init__(__self__, *,
                 engine_id: pulumi.Input[_builtins.str],
                 label: pulumi.Input[_builtins.str],
                 region: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cluster_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_autovacuum_analyze_scale_factor: Optional[pulumi.Input[_builtins.float]] = None,
                 engine_config_pg_autovacuum_analyze_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_autovacuum_max_workers: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_autovacuum_naptime: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_autovacuum_vacuum_cost_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_autovacuum_vacuum_cost_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_autovacuum_vacuum_scale_factor: Optional[pulumi.Input[_builtins.float]] = None,
                 engine_config_pg_autovacuum_vacuum_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_bgwriter_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_bgwriter_flush_after: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_bgwriter_lru_maxpages: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_bgwriter_lru_multiplier: Optional[pulumi.Input[_builtins.float]] = None,
                 engine_config_pg_deadlock_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_default_toast_compression: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_pg_idle_in_transaction_session_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_jit: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine_config_pg_max_files_per_process: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_locks_per_transaction: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_logical_replication_workers: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_parallel_workers: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_parallel_workers_per_gather: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_pred_locks_per_transaction: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_replication_slots: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_slot_wal_keep_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_stack_depth: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_standby_archive_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_standby_streaming_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_wal_senders: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_worker_processes: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_password_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_pg_pg_partman_bgw_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_pg_partman_bgw_role: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_pg_pg_stat_monitor_pgsm_enable_query_plan: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine_config_pg_pg_stat_monitor_pgsm_max_buckets: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_pg_stat_statements_track: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_pg_stat_monitor_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine_config_pg_temp_file_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_pg_track_activity_query_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_track_commit_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_pg_track_functions: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_pg_track_io_timing: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_pg_wal_sender_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_wal_writer_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pglookout_max_failover_replication_time_lag: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_shared_buffers_percentage: Optional[pulumi.Input[_builtins.float]] = None,
                 engine_config_work_mem: Optional[pulumi.Input[_builtins.int]] = None,
                 fork_restore_time: Optional[pulumi.Input[_builtins.str]] = None,
                 fork_source: Optional[pulumi.Input[_builtins.int]] = None,
                 suspended: Optional[pulumi.Input[_builtins.bool]] = None,
                 timeouts: Optional[pulumi.Input['DatabasePostgresqlV2TimeoutsArgs']] = None,
                 updates: Optional[pulumi.Input['DatabasePostgresqlV2UpdatesArgs']] = None):
        """
        The set of arguments for constructing a DatabasePostgresqlV2 resource.
        :param pulumi.Input[_builtins.str] engine_id: The Managed Database engine in engine/version format. (e.g. `postgresql/16`)
        :param pulumi.Input[_builtins.str] label: A unique, user-defined string referring to the Managed Database.
        :param pulumi.Input[_builtins.str] region: The region to use for the Managed Database.
        :param pulumi.Input[_builtins.str] type: The Linode Instance type used for the nodes of the Managed Database.
               
               - - -
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allow_lists: A list of IP addresses that can access the Managed Database. Each item can be a single IP address or a range in CIDR format. Use `DatabaseAccessControls` to manage your allow list separately.
        :param pulumi.Input[_builtins.int] cluster_size: The number of Linode Instance nodes deployed to the Managed Database. (default `1`)
        :param pulumi.Input[_builtins.float] engine_config_pg_autovacuum_analyze_scale_factor: Specifies a fraction of the table size to add to autovacuum_analyze_threshold when deciding whether to trigger an ANALYZE. The default is 0.2 (20% of table size)
        :param pulumi.Input[_builtins.int] engine_config_pg_autovacuum_analyze_threshold: Specifies the minimum number of inserted, updated or deleted tuples needed to trigger an ANALYZE in any one table. The default is 50 tuples.
        :param pulumi.Input[_builtins.int] engine_config_pg_autovacuum_max_workers: Specifies the maximum number of autovacuum processes (other than the autovacuum launcher) that may be running at any one time. The default is three. This parameter can only be set at server start.
        :param pulumi.Input[_builtins.int] engine_config_pg_autovacuum_naptime: Specifies the minimum delay between autovacuum runs on any given database. The delay is measured in seconds, and the default is one minute
        :param pulumi.Input[_builtins.int] engine_config_pg_autovacuum_vacuum_cost_delay: Specifies the cost delay value that will be used in automatic VACUUM operations. If -1 is specified, the regular vacuum_cost_delay value will be used. The default value is 20 milliseconds
        :param pulumi.Input[_builtins.int] engine_config_pg_autovacuum_vacuum_cost_limit: Specifies the cost limit value that will be used in automatic VACUUM operations. If -1 is specified (which is the default), the regular vacuum_cost_limit value will be used.
        :param pulumi.Input[_builtins.float] engine_config_pg_autovacuum_vacuum_scale_factor: Specifies a fraction of the table size to add to autovacuum_vacuum_threshold when deciding whether to trigger a VACUUM. The default is 0.2 (20% of table size)
        :param pulumi.Input[_builtins.int] engine_config_pg_autovacuum_vacuum_threshold: Specifies the minimum number of updated or deleted tuples needed to trigger a VACUUM in any one table. The default is 50 tuples.
        :param pulumi.Input[_builtins.int] engine_config_pg_bgwriter_delay: Specifies the delay between activity rounds for the background writer in milliseconds. Default is 200.
        :param pulumi.Input[_builtins.int] engine_config_pg_bgwriter_flush_after: Whenever more than bgwriter_flush_after bytes have been written by the background writer, attempt to force the OS to issue these writes to the underlying storage. Specified in kilobytes, default is 512. Setting of 0 disables forced writeback.
        :param pulumi.Input[_builtins.int] engine_config_pg_bgwriter_lru_maxpages: In each round, no more than this many buffers will be written by the background writer. Setting this to zero disables background writing. Default is 100.
        :param pulumi.Input[_builtins.float] engine_config_pg_bgwriter_lru_multiplier: The average recent need for new buffers is multiplied by bgwriter_lru_multiplier to arrive at an estimate of the number that will be needed during the next round, (up to bgwriter_lru_maxpages). 1.0 represents a “just in time” policy of writing exactly the number of buffers predicted to be needed. Larger values provide some cushion against spikes in demand, while smaller values intentionally leave writes to be done by server processes. The default is 2.0.
        :param pulumi.Input[_builtins.int] engine_config_pg_deadlock_timeout: This is the amount of time, in milliseconds, to wait on a lock before checking to see if there is a deadlock condition.
        :param pulumi.Input[_builtins.str] engine_config_pg_default_toast_compression: Specifies the default TOAST compression method for values of compressible columns (the default is lz4).
        :param pulumi.Input[_builtins.int] engine_config_pg_idle_in_transaction_session_timeout: Time out sessions with open transactions after this number of milliseconds.
        :param pulumi.Input[_builtins.bool] engine_config_pg_jit: Controls system-wide use of Just-in-Time Compilation (JIT).
        :param pulumi.Input[_builtins.int] engine_config_pg_max_files_per_process: PostgreSQL maximum number of files that can be open per process.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_locks_per_transaction: PostgreSQL maximum locks per transaction.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_logical_replication_workers: PostgreSQL maximum logical replication workers (taken from the pool of max_parallel_workers).
        :param pulumi.Input[_builtins.int] engine_config_pg_max_parallel_workers: Sets the maximum number of workers that the system can support for parallel queries.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_parallel_workers_per_gather: Sets the maximum number of workers that can be started by a single Gather or Gather Merge node.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_pred_locks_per_transaction: PostgreSQL maximum predicate locks per transaction.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_replication_slots: PostgreSQL maximum replication slots.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_slot_wal_keep_size: PostgreSQL maximum WAL size (MB) reserved for replication slots. Default is -1 (unlimited). wal_keep_size minimum WAL size setting takes precedence over this.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_stack_depth: Maximum depth of the stack in bytes.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_standby_archive_delay: Max standby archive delay in milliseconds.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_standby_streaming_delay: Max standby streaming delay in milliseconds.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_wal_senders: PostgreSQL maximum WAL senders.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_worker_processes: Sets the maximum number of background processes that the system can support.
        :param pulumi.Input[_builtins.str] engine_config_pg_password_encryption: Chooses the algorithm for encrypting passwords. (default `md5`)
        :param pulumi.Input[_builtins.int] engine_config_pg_pg_partman_bgw_interval: Sets the time interval to run pg_partman's scheduled tasks.
        :param pulumi.Input[_builtins.str] engine_config_pg_pg_partman_bgw_role: Controls which role to use for pg_partman's scheduled background tasks.
        :param pulumi.Input[_builtins.bool] engine_config_pg_pg_stat_monitor_pgsm_enable_query_plan: Enables or disables query plan monitoring.
        :param pulumi.Input[_builtins.int] engine_config_pg_pg_stat_monitor_pgsm_max_buckets: Sets the maximum number of buckets.
        :param pulumi.Input[_builtins.str] engine_config_pg_pg_stat_statements_track: Controls which statements are counted. Specify top to track top-level statements (those issued directly by clients), all to also track nested statements (such as statements invoked within functions), or none to disable statement statistics collection. The default value is top.
        :param pulumi.Input[_builtins.bool] engine_config_pg_stat_monitor_enable: Enable the pg_stat_monitor extension. Enabling this extension will cause the cluster to be restarted. When this extension is enabled, pg_stat_statements results for utility commands are unreliable. (default `false`)
        :param pulumi.Input[_builtins.int] engine_config_pg_temp_file_limit: PostgreSQL temporary file limit in KiB, -1 for unlimited.
        :param pulumi.Input[_builtins.str] engine_config_pg_timezone: PostgreSQL service timezone.
        :param pulumi.Input[_builtins.int] engine_config_pg_track_activity_query_size: Specifies the number of bytes reserved to track the currently executing command for each active session.
        :param pulumi.Input[_builtins.str] engine_config_pg_track_commit_timestamp: Record commit time of transactions.
        :param pulumi.Input[_builtins.str] engine_config_pg_track_functions: Enables tracking of function call counts and time used.
        :param pulumi.Input[_builtins.str] engine_config_pg_track_io_timing: Enables timing of database I/O calls. This parameter is off by default, because it will repeatedly query the operating system for the current time, which may cause significant overhead on some platforms.
        :param pulumi.Input[_builtins.int] engine_config_pg_wal_sender_timeout: Terminate replication connections that are inactive for longer than this amount of time, in milliseconds. Setting this value to zero disables the timeout.
        :param pulumi.Input[_builtins.int] engine_config_pg_wal_writer_delay: WAL flush interval in milliseconds. Note that setting this value to lower than the default 200ms may negatively impact performance.
        :param pulumi.Input[_builtins.int] engine_config_pglookout_max_failover_replication_time_lag: Number of seconds of master unavailability before triggering database failover to standby. (default `60`)
        :param pulumi.Input[_builtins.float] engine_config_shared_buffers_percentage: Percentage of total RAM that the database server uses for shared memory buffers. Valid range is 20-60 (float), which corresponds to 20% - 60%. This setting adjusts the shared_buffers configuration value.
        :param pulumi.Input[_builtins.int] engine_config_work_mem: Sets the maximum amount of memory to be used by a query operation (such as a sort or hash table) before writing to temporary disk files, in MB. Default is 1MB + 0.075% of total RAM (up to 32MB).
        :param pulumi.Input[_builtins.str] fork_restore_time: The database timestamp from which it was restored.
        :param pulumi.Input[_builtins.int] fork_source: The ID of the database that was forked from.
               
               * `updates` - (Optional) Configuration settings for automated patch update maintenance for the Managed Database.
        :param pulumi.Input[_builtins.bool] suspended: Whether this Managed Database should be suspended.
        :param pulumi.Input['DatabasePostgresqlV2UpdatesArgs'] updates: Configuration settings for automated patch update maintenance for the Managed Database.
        """
        pulumi.set(__self__, "engine_id", engine_id)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "type", type)
        if allow_lists is not None:
            pulumi.set(__self__, "allow_lists", allow_lists)
        if cluster_size is not None:
            pulumi.set(__self__, "cluster_size", cluster_size)
        if engine_config_pg_autovacuum_analyze_scale_factor is not None:
            pulumi.set(__self__, "engine_config_pg_autovacuum_analyze_scale_factor", engine_config_pg_autovacuum_analyze_scale_factor)
        if engine_config_pg_autovacuum_analyze_threshold is not None:
            pulumi.set(__self__, "engine_config_pg_autovacuum_analyze_threshold", engine_config_pg_autovacuum_analyze_threshold)
        if engine_config_pg_autovacuum_max_workers is not None:
            pulumi.set(__self__, "engine_config_pg_autovacuum_max_workers", engine_config_pg_autovacuum_max_workers)
        if engine_config_pg_autovacuum_naptime is not None:
            pulumi.set(__self__, "engine_config_pg_autovacuum_naptime", engine_config_pg_autovacuum_naptime)
        if engine_config_pg_autovacuum_vacuum_cost_delay is not None:
            pulumi.set(__self__, "engine_config_pg_autovacuum_vacuum_cost_delay", engine_config_pg_autovacuum_vacuum_cost_delay)
        if engine_config_pg_autovacuum_vacuum_cost_limit is not None:
            pulumi.set(__self__, "engine_config_pg_autovacuum_vacuum_cost_limit", engine_config_pg_autovacuum_vacuum_cost_limit)
        if engine_config_pg_autovacuum_vacuum_scale_factor is not None:
            pulumi.set(__self__, "engine_config_pg_autovacuum_vacuum_scale_factor", engine_config_pg_autovacuum_vacuum_scale_factor)
        if engine_config_pg_autovacuum_vacuum_threshold is not None:
            pulumi.set(__self__, "engine_config_pg_autovacuum_vacuum_threshold", engine_config_pg_autovacuum_vacuum_threshold)
        if engine_config_pg_bgwriter_delay is not None:
            pulumi.set(__self__, "engine_config_pg_bgwriter_delay", engine_config_pg_bgwriter_delay)
        if engine_config_pg_bgwriter_flush_after is not None:
            pulumi.set(__self__, "engine_config_pg_bgwriter_flush_after", engine_config_pg_bgwriter_flush_after)
        if engine_config_pg_bgwriter_lru_maxpages is not None:
            pulumi.set(__self__, "engine_config_pg_bgwriter_lru_maxpages", engine_config_pg_bgwriter_lru_maxpages)
        if engine_config_pg_bgwriter_lru_multiplier is not None:
            pulumi.set(__self__, "engine_config_pg_bgwriter_lru_multiplier", engine_config_pg_bgwriter_lru_multiplier)
        if engine_config_pg_deadlock_timeout is not None:
            pulumi.set(__self__, "engine_config_pg_deadlock_timeout", engine_config_pg_deadlock_timeout)
        if engine_config_pg_default_toast_compression is not None:
            pulumi.set(__self__, "engine_config_pg_default_toast_compression", engine_config_pg_default_toast_compression)
        if engine_config_pg_idle_in_transaction_session_timeout is not None:
            pulumi.set(__self__, "engine_config_pg_idle_in_transaction_session_timeout", engine_config_pg_idle_in_transaction_session_timeout)
        if engine_config_pg_jit is not None:
            pulumi.set(__self__, "engine_config_pg_jit", engine_config_pg_jit)
        if engine_config_pg_max_files_per_process is not None:
            pulumi.set(__self__, "engine_config_pg_max_files_per_process", engine_config_pg_max_files_per_process)
        if engine_config_pg_max_locks_per_transaction is not None:
            pulumi.set(__self__, "engine_config_pg_max_locks_per_transaction", engine_config_pg_max_locks_per_transaction)
        if engine_config_pg_max_logical_replication_workers is not None:
            pulumi.set(__self__, "engine_config_pg_max_logical_replication_workers", engine_config_pg_max_logical_replication_workers)
        if engine_config_pg_max_parallel_workers is not None:
            pulumi.set(__self__, "engine_config_pg_max_parallel_workers", engine_config_pg_max_parallel_workers)
        if engine_config_pg_max_parallel_workers_per_gather is not None:
            pulumi.set(__self__, "engine_config_pg_max_parallel_workers_per_gather", engine_config_pg_max_parallel_workers_per_gather)
        if engine_config_pg_max_pred_locks_per_transaction is not None:
            pulumi.set(__self__, "engine_config_pg_max_pred_locks_per_transaction", engine_config_pg_max_pred_locks_per_transaction)
        if engine_config_pg_max_replication_slots is not None:
            pulumi.set(__self__, "engine_config_pg_max_replication_slots", engine_config_pg_max_replication_slots)
        if engine_config_pg_max_slot_wal_keep_size is not None:
            pulumi.set(__self__, "engine_config_pg_max_slot_wal_keep_size", engine_config_pg_max_slot_wal_keep_size)
        if engine_config_pg_max_stack_depth is not None:
            pulumi.set(__self__, "engine_config_pg_max_stack_depth", engine_config_pg_max_stack_depth)
        if engine_config_pg_max_standby_archive_delay is not None:
            pulumi.set(__self__, "engine_config_pg_max_standby_archive_delay", engine_config_pg_max_standby_archive_delay)
        if engine_config_pg_max_standby_streaming_delay is not None:
            pulumi.set(__self__, "engine_config_pg_max_standby_streaming_delay", engine_config_pg_max_standby_streaming_delay)
        if engine_config_pg_max_wal_senders is not None:
            pulumi.set(__self__, "engine_config_pg_max_wal_senders", engine_config_pg_max_wal_senders)
        if engine_config_pg_max_worker_processes is not None:
            pulumi.set(__self__, "engine_config_pg_max_worker_processes", engine_config_pg_max_worker_processes)
        if engine_config_pg_password_encryption is not None:
            pulumi.set(__self__, "engine_config_pg_password_encryption", engine_config_pg_password_encryption)
        if engine_config_pg_pg_partman_bgw_interval is not None:
            pulumi.set(__self__, "engine_config_pg_pg_partman_bgw_interval", engine_config_pg_pg_partman_bgw_interval)
        if engine_config_pg_pg_partman_bgw_role is not None:
            pulumi.set(__self__, "engine_config_pg_pg_partman_bgw_role", engine_config_pg_pg_partman_bgw_role)
        if engine_config_pg_pg_stat_monitor_pgsm_enable_query_plan is not None:
            pulumi.set(__self__, "engine_config_pg_pg_stat_monitor_pgsm_enable_query_plan", engine_config_pg_pg_stat_monitor_pgsm_enable_query_plan)
        if engine_config_pg_pg_stat_monitor_pgsm_max_buckets is not None:
            pulumi.set(__self__, "engine_config_pg_pg_stat_monitor_pgsm_max_buckets", engine_config_pg_pg_stat_monitor_pgsm_max_buckets)
        if engine_config_pg_pg_stat_statements_track is not None:
            pulumi.set(__self__, "engine_config_pg_pg_stat_statements_track", engine_config_pg_pg_stat_statements_track)
        if engine_config_pg_stat_monitor_enable is not None:
            pulumi.set(__self__, "engine_config_pg_stat_monitor_enable", engine_config_pg_stat_monitor_enable)
        if engine_config_pg_temp_file_limit is not None:
            pulumi.set(__self__, "engine_config_pg_temp_file_limit", engine_config_pg_temp_file_limit)
        if engine_config_pg_timezone is not None:
            pulumi.set(__self__, "engine_config_pg_timezone", engine_config_pg_timezone)
        if engine_config_pg_track_activity_query_size is not None:
            pulumi.set(__self__, "engine_config_pg_track_activity_query_size", engine_config_pg_track_activity_query_size)
        if engine_config_pg_track_commit_timestamp is not None:
            pulumi.set(__self__, "engine_config_pg_track_commit_timestamp", engine_config_pg_track_commit_timestamp)
        if engine_config_pg_track_functions is not None:
            pulumi.set(__self__, "engine_config_pg_track_functions", engine_config_pg_track_functions)
        if engine_config_pg_track_io_timing is not None:
            pulumi.set(__self__, "engine_config_pg_track_io_timing", engine_config_pg_track_io_timing)
        if engine_config_pg_wal_sender_timeout is not None:
            pulumi.set(__self__, "engine_config_pg_wal_sender_timeout", engine_config_pg_wal_sender_timeout)
        if engine_config_pg_wal_writer_delay is not None:
            pulumi.set(__self__, "engine_config_pg_wal_writer_delay", engine_config_pg_wal_writer_delay)
        if engine_config_pglookout_max_failover_replication_time_lag is not None:
            pulumi.set(__self__, "engine_config_pglookout_max_failover_replication_time_lag", engine_config_pglookout_max_failover_replication_time_lag)
        if engine_config_shared_buffers_percentage is not None:
            pulumi.set(__self__, "engine_config_shared_buffers_percentage", engine_config_shared_buffers_percentage)
        if engine_config_work_mem is not None:
            pulumi.set(__self__, "engine_config_work_mem", engine_config_work_mem)
        if fork_restore_time is not None:
            pulumi.set(__self__, "fork_restore_time", fork_restore_time)
        if fork_source is not None:
            pulumi.set(__self__, "fork_source", fork_source)
        if suspended is not None:
            pulumi.set(__self__, "suspended", suspended)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if updates is not None:
            pulumi.set(__self__, "updates", updates)

    @_builtins.property
    @pulumi.getter(name="engineId")
    def engine_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Managed Database engine in engine/version format. (e.g. `postgresql/16`)
        """
        return pulumi.get(self, "engine_id")

    @engine_id.setter
    def engine_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "engine_id", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Input[_builtins.str]:
        """
        A unique, user-defined string referring to the Managed Database.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        The region to use for the Managed Database.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The Linode Instance type used for the nodes of the Managed Database.

        - - -
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="allowLists")
    def allow_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of IP addresses that can access the Managed Database. Each item can be a single IP address or a range in CIDR format. Use `DatabaseAccessControls` to manage your allow list separately.
        """
        return pulumi.get(self, "allow_lists")

    @allow_lists.setter
    def allow_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allow_lists", value)

    @_builtins.property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of Linode Instance nodes deployed to the Managed Database. (default `1`)
        """
        return pulumi.get(self, "cluster_size")

    @cluster_size.setter
    def cluster_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cluster_size", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgAutovacuumAnalyzeScaleFactor")
    def engine_config_pg_autovacuum_analyze_scale_factor(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Specifies a fraction of the table size to add to autovacuum_analyze_threshold when deciding whether to trigger an ANALYZE. The default is 0.2 (20% of table size)
        """
        return pulumi.get(self, "engine_config_pg_autovacuum_analyze_scale_factor")

    @engine_config_pg_autovacuum_analyze_scale_factor.setter
    def engine_config_pg_autovacuum_analyze_scale_factor(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "engine_config_pg_autovacuum_analyze_scale_factor", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgAutovacuumAnalyzeThreshold")
    def engine_config_pg_autovacuum_analyze_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the minimum number of inserted, updated or deleted tuples needed to trigger an ANALYZE in any one table. The default is 50 tuples.
        """
        return pulumi.get(self, "engine_config_pg_autovacuum_analyze_threshold")

    @engine_config_pg_autovacuum_analyze_threshold.setter
    def engine_config_pg_autovacuum_analyze_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_autovacuum_analyze_threshold", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgAutovacuumMaxWorkers")
    def engine_config_pg_autovacuum_max_workers(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum number of autovacuum processes (other than the autovacuum launcher) that may be running at any one time. The default is three. This parameter can only be set at server start.
        """
        return pulumi.get(self, "engine_config_pg_autovacuum_max_workers")

    @engine_config_pg_autovacuum_max_workers.setter
    def engine_config_pg_autovacuum_max_workers(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_autovacuum_max_workers", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgAutovacuumNaptime")
    def engine_config_pg_autovacuum_naptime(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the minimum delay between autovacuum runs on any given database. The delay is measured in seconds, and the default is one minute
        """
        return pulumi.get(self, "engine_config_pg_autovacuum_naptime")

    @engine_config_pg_autovacuum_naptime.setter
    def engine_config_pg_autovacuum_naptime(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_autovacuum_naptime", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgAutovacuumVacuumCostDelay")
    def engine_config_pg_autovacuum_vacuum_cost_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the cost delay value that will be used in automatic VACUUM operations. If -1 is specified, the regular vacuum_cost_delay value will be used. The default value is 20 milliseconds
        """
        return pulumi.get(self, "engine_config_pg_autovacuum_vacuum_cost_delay")

    @engine_config_pg_autovacuum_vacuum_cost_delay.setter
    def engine_config_pg_autovacuum_vacuum_cost_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_autovacuum_vacuum_cost_delay", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgAutovacuumVacuumCostLimit")
    def engine_config_pg_autovacuum_vacuum_cost_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the cost limit value that will be used in automatic VACUUM operations. If -1 is specified (which is the default), the regular vacuum_cost_limit value will be used.
        """
        return pulumi.get(self, "engine_config_pg_autovacuum_vacuum_cost_limit")

    @engine_config_pg_autovacuum_vacuum_cost_limit.setter
    def engine_config_pg_autovacuum_vacuum_cost_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_autovacuum_vacuum_cost_limit", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgAutovacuumVacuumScaleFactor")
    def engine_config_pg_autovacuum_vacuum_scale_factor(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Specifies a fraction of the table size to add to autovacuum_vacuum_threshold when deciding whether to trigger a VACUUM. The default is 0.2 (20% of table size)
        """
        return pulumi.get(self, "engine_config_pg_autovacuum_vacuum_scale_factor")

    @engine_config_pg_autovacuum_vacuum_scale_factor.setter
    def engine_config_pg_autovacuum_vacuum_scale_factor(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "engine_config_pg_autovacuum_vacuum_scale_factor", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgAutovacuumVacuumThreshold")
    def engine_config_pg_autovacuum_vacuum_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the minimum number of updated or deleted tuples needed to trigger a VACUUM in any one table. The default is 50 tuples.
        """
        return pulumi.get(self, "engine_config_pg_autovacuum_vacuum_threshold")

    @engine_config_pg_autovacuum_vacuum_threshold.setter
    def engine_config_pg_autovacuum_vacuum_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_autovacuum_vacuum_threshold", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgBgwriterDelay")
    def engine_config_pg_bgwriter_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the delay between activity rounds for the background writer in milliseconds. Default is 200.
        """
        return pulumi.get(self, "engine_config_pg_bgwriter_delay")

    @engine_config_pg_bgwriter_delay.setter
    def engine_config_pg_bgwriter_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_bgwriter_delay", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgBgwriterFlushAfter")
    def engine_config_pg_bgwriter_flush_after(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Whenever more than bgwriter_flush_after bytes have been written by the background writer, attempt to force the OS to issue these writes to the underlying storage. Specified in kilobytes, default is 512. Setting of 0 disables forced writeback.
        """
        return pulumi.get(self, "engine_config_pg_bgwriter_flush_after")

    @engine_config_pg_bgwriter_flush_after.setter
    def engine_config_pg_bgwriter_flush_after(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_bgwriter_flush_after", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgBgwriterLruMaxpages")
    def engine_config_pg_bgwriter_lru_maxpages(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        In each round, no more than this many buffers will be written by the background writer. Setting this to zero disables background writing. Default is 100.
        """
        return pulumi.get(self, "engine_config_pg_bgwriter_lru_maxpages")

    @engine_config_pg_bgwriter_lru_maxpages.setter
    def engine_config_pg_bgwriter_lru_maxpages(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_bgwriter_lru_maxpages", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgBgwriterLruMultiplier")
    def engine_config_pg_bgwriter_lru_multiplier(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The average recent need for new buffers is multiplied by bgwriter_lru_multiplier to arrive at an estimate of the number that will be needed during the next round, (up to bgwriter_lru_maxpages). 1.0 represents a “just in time” policy of writing exactly the number of buffers predicted to be needed. Larger values provide some cushion against spikes in demand, while smaller values intentionally leave writes to be done by server processes. The default is 2.0.
        """
        return pulumi.get(self, "engine_config_pg_bgwriter_lru_multiplier")

    @engine_config_pg_bgwriter_lru_multiplier.setter
    def engine_config_pg_bgwriter_lru_multiplier(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "engine_config_pg_bgwriter_lru_multiplier", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgDeadlockTimeout")
    def engine_config_pg_deadlock_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        This is the amount of time, in milliseconds, to wait on a lock before checking to see if there is a deadlock condition.
        """
        return pulumi.get(self, "engine_config_pg_deadlock_timeout")

    @engine_config_pg_deadlock_timeout.setter
    def engine_config_pg_deadlock_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_deadlock_timeout", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgDefaultToastCompression")
    def engine_config_pg_default_toast_compression(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the default TOAST compression method for values of compressible columns (the default is lz4).
        """
        return pulumi.get(self, "engine_config_pg_default_toast_compression")

    @engine_config_pg_default_toast_compression.setter
    def engine_config_pg_default_toast_compression(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_config_pg_default_toast_compression", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgIdleInTransactionSessionTimeout")
    def engine_config_pg_idle_in_transaction_session_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time out sessions with open transactions after this number of milliseconds.
        """
        return pulumi.get(self, "engine_config_pg_idle_in_transaction_session_timeout")

    @engine_config_pg_idle_in_transaction_session_timeout.setter
    def engine_config_pg_idle_in_transaction_session_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_idle_in_transaction_session_timeout", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgJit")
    def engine_config_pg_jit(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Controls system-wide use of Just-in-Time Compilation (JIT).
        """
        return pulumi.get(self, "engine_config_pg_jit")

    @engine_config_pg_jit.setter
    def engine_config_pg_jit(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "engine_config_pg_jit", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxFilesPerProcess")
    def engine_config_pg_max_files_per_process(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PostgreSQL maximum number of files that can be open per process.
        """
        return pulumi.get(self, "engine_config_pg_max_files_per_process")

    @engine_config_pg_max_files_per_process.setter
    def engine_config_pg_max_files_per_process(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_max_files_per_process", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxLocksPerTransaction")
    def engine_config_pg_max_locks_per_transaction(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PostgreSQL maximum locks per transaction.
        """
        return pulumi.get(self, "engine_config_pg_max_locks_per_transaction")

    @engine_config_pg_max_locks_per_transaction.setter
    def engine_config_pg_max_locks_per_transaction(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_max_locks_per_transaction", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxLogicalReplicationWorkers")
    def engine_config_pg_max_logical_replication_workers(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PostgreSQL maximum logical replication workers (taken from the pool of max_parallel_workers).
        """
        return pulumi.get(self, "engine_config_pg_max_logical_replication_workers")

    @engine_config_pg_max_logical_replication_workers.setter
    def engine_config_pg_max_logical_replication_workers(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_max_logical_replication_workers", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxParallelWorkers")
    def engine_config_pg_max_parallel_workers(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sets the maximum number of workers that the system can support for parallel queries.
        """
        return pulumi.get(self, "engine_config_pg_max_parallel_workers")

    @engine_config_pg_max_parallel_workers.setter
    def engine_config_pg_max_parallel_workers(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_max_parallel_workers", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxParallelWorkersPerGather")
    def engine_config_pg_max_parallel_workers_per_gather(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sets the maximum number of workers that can be started by a single Gather or Gather Merge node.
        """
        return pulumi.get(self, "engine_config_pg_max_parallel_workers_per_gather")

    @engine_config_pg_max_parallel_workers_per_gather.setter
    def engine_config_pg_max_parallel_workers_per_gather(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_max_parallel_workers_per_gather", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxPredLocksPerTransaction")
    def engine_config_pg_max_pred_locks_per_transaction(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PostgreSQL maximum predicate locks per transaction.
        """
        return pulumi.get(self, "engine_config_pg_max_pred_locks_per_transaction")

    @engine_config_pg_max_pred_locks_per_transaction.setter
    def engine_config_pg_max_pred_locks_per_transaction(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_max_pred_locks_per_transaction", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxReplicationSlots")
    def engine_config_pg_max_replication_slots(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PostgreSQL maximum replication slots.
        """
        return pulumi.get(self, "engine_config_pg_max_replication_slots")

    @engine_config_pg_max_replication_slots.setter
    def engine_config_pg_max_replication_slots(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_max_replication_slots", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxSlotWalKeepSize")
    def engine_config_pg_max_slot_wal_keep_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PostgreSQL maximum WAL size (MB) reserved for replication slots. Default is -1 (unlimited). wal_keep_size minimum WAL size setting takes precedence over this.
        """
        return pulumi.get(self, "engine_config_pg_max_slot_wal_keep_size")

    @engine_config_pg_max_slot_wal_keep_size.setter
    def engine_config_pg_max_slot_wal_keep_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_max_slot_wal_keep_size", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxStackDepth")
    def engine_config_pg_max_stack_depth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum depth of the stack in bytes.
        """
        return pulumi.get(self, "engine_config_pg_max_stack_depth")

    @engine_config_pg_max_stack_depth.setter
    def engine_config_pg_max_stack_depth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_max_stack_depth", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxStandbyArchiveDelay")
    def engine_config_pg_max_standby_archive_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Max standby archive delay in milliseconds.
        """
        return pulumi.get(self, "engine_config_pg_max_standby_archive_delay")

    @engine_config_pg_max_standby_archive_delay.setter
    def engine_config_pg_max_standby_archive_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_max_standby_archive_delay", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxStandbyStreamingDelay")
    def engine_config_pg_max_standby_streaming_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Max standby streaming delay in milliseconds.
        """
        return pulumi.get(self, "engine_config_pg_max_standby_streaming_delay")

    @engine_config_pg_max_standby_streaming_delay.setter
    def engine_config_pg_max_standby_streaming_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_max_standby_streaming_delay", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxWalSenders")
    def engine_config_pg_max_wal_senders(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PostgreSQL maximum WAL senders.
        """
        return pulumi.get(self, "engine_config_pg_max_wal_senders")

    @engine_config_pg_max_wal_senders.setter
    def engine_config_pg_max_wal_senders(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_max_wal_senders", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxWorkerProcesses")
    def engine_config_pg_max_worker_processes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sets the maximum number of background processes that the system can support.
        """
        return pulumi.get(self, "engine_config_pg_max_worker_processes")

    @engine_config_pg_max_worker_processes.setter
    def engine_config_pg_max_worker_processes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_max_worker_processes", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgPasswordEncryption")
    def engine_config_pg_password_encryption(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Chooses the algorithm for encrypting passwords. (default `md5`)
        """
        return pulumi.get(self, "engine_config_pg_password_encryption")

    @engine_config_pg_password_encryption.setter
    def engine_config_pg_password_encryption(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_config_pg_password_encryption", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgPgPartmanBgwInterval")
    def engine_config_pg_pg_partman_bgw_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sets the time interval to run pg_partman's scheduled tasks.
        """
        return pulumi.get(self, "engine_config_pg_pg_partman_bgw_interval")

    @engine_config_pg_pg_partman_bgw_interval.setter
    def engine_config_pg_pg_partman_bgw_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_pg_partman_bgw_interval", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgPgPartmanBgwRole")
    def engine_config_pg_pg_partman_bgw_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls which role to use for pg_partman's scheduled background tasks.
        """
        return pulumi.get(self, "engine_config_pg_pg_partman_bgw_role")

    @engine_config_pg_pg_partman_bgw_role.setter
    def engine_config_pg_pg_partman_bgw_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_config_pg_pg_partman_bgw_role", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgPgStatMonitorPgsmEnableQueryPlan")
    def engine_config_pg_pg_stat_monitor_pgsm_enable_query_plan(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables or disables query plan monitoring.
        """
        return pulumi.get(self, "engine_config_pg_pg_stat_monitor_pgsm_enable_query_plan")

    @engine_config_pg_pg_stat_monitor_pgsm_enable_query_plan.setter
    def engine_config_pg_pg_stat_monitor_pgsm_enable_query_plan(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "engine_config_pg_pg_stat_monitor_pgsm_enable_query_plan", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgPgStatMonitorPgsmMaxBuckets")
    def engine_config_pg_pg_stat_monitor_pgsm_max_buckets(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sets the maximum number of buckets.
        """
        return pulumi.get(self, "engine_config_pg_pg_stat_monitor_pgsm_max_buckets")

    @engine_config_pg_pg_stat_monitor_pgsm_max_buckets.setter
    def engine_config_pg_pg_stat_monitor_pgsm_max_buckets(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_pg_stat_monitor_pgsm_max_buckets", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgPgStatStatementsTrack")
    def engine_config_pg_pg_stat_statements_track(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls which statements are counted. Specify top to track top-level statements (those issued directly by clients), all to also track nested statements (such as statements invoked within functions), or none to disable statement statistics collection. The default value is top.
        """
        return pulumi.get(self, "engine_config_pg_pg_stat_statements_track")

    @engine_config_pg_pg_stat_statements_track.setter
    def engine_config_pg_pg_stat_statements_track(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_config_pg_pg_stat_statements_track", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgStatMonitorEnable")
    def engine_config_pg_stat_monitor_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable the pg_stat_monitor extension. Enabling this extension will cause the cluster to be restarted. When this extension is enabled, pg_stat_statements results for utility commands are unreliable. (default `false`)
        """
        return pulumi.get(self, "engine_config_pg_stat_monitor_enable")

    @engine_config_pg_stat_monitor_enable.setter
    def engine_config_pg_stat_monitor_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "engine_config_pg_stat_monitor_enable", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgTempFileLimit")
    def engine_config_pg_temp_file_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PostgreSQL temporary file limit in KiB, -1 for unlimited.
        """
        return pulumi.get(self, "engine_config_pg_temp_file_limit")

    @engine_config_pg_temp_file_limit.setter
    def engine_config_pg_temp_file_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_temp_file_limit", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgTimezone")
    def engine_config_pg_timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        PostgreSQL service timezone.
        """
        return pulumi.get(self, "engine_config_pg_timezone")

    @engine_config_pg_timezone.setter
    def engine_config_pg_timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_config_pg_timezone", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgTrackActivityQuerySize")
    def engine_config_pg_track_activity_query_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of bytes reserved to track the currently executing command for each active session.
        """
        return pulumi.get(self, "engine_config_pg_track_activity_query_size")

    @engine_config_pg_track_activity_query_size.setter
    def engine_config_pg_track_activity_query_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_track_activity_query_size", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgTrackCommitTimestamp")
    def engine_config_pg_track_commit_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Record commit time of transactions.
        """
        return pulumi.get(self, "engine_config_pg_track_commit_timestamp")

    @engine_config_pg_track_commit_timestamp.setter
    def engine_config_pg_track_commit_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_config_pg_track_commit_timestamp", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgTrackFunctions")
    def engine_config_pg_track_functions(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables tracking of function call counts and time used.
        """
        return pulumi.get(self, "engine_config_pg_track_functions")

    @engine_config_pg_track_functions.setter
    def engine_config_pg_track_functions(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_config_pg_track_functions", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgTrackIoTiming")
    def engine_config_pg_track_io_timing(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables timing of database I/O calls. This parameter is off by default, because it will repeatedly query the operating system for the current time, which may cause significant overhead on some platforms.
        """
        return pulumi.get(self, "engine_config_pg_track_io_timing")

    @engine_config_pg_track_io_timing.setter
    def engine_config_pg_track_io_timing(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_config_pg_track_io_timing", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgWalSenderTimeout")
    def engine_config_pg_wal_sender_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Terminate replication connections that are inactive for longer than this amount of time, in milliseconds. Setting this value to zero disables the timeout.
        """
        return pulumi.get(self, "engine_config_pg_wal_sender_timeout")

    @engine_config_pg_wal_sender_timeout.setter
    def engine_config_pg_wal_sender_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_wal_sender_timeout", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgWalWriterDelay")
    def engine_config_pg_wal_writer_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        WAL flush interval in milliseconds. Note that setting this value to lower than the default 200ms may negatively impact performance.
        """
        return pulumi.get(self, "engine_config_pg_wal_writer_delay")

    @engine_config_pg_wal_writer_delay.setter
    def engine_config_pg_wal_writer_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_wal_writer_delay", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPglookoutMaxFailoverReplicationTimeLag")
    def engine_config_pglookout_max_failover_replication_time_lag(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of seconds of master unavailability before triggering database failover to standby. (default `60`)
        """
        return pulumi.get(self, "engine_config_pglookout_max_failover_replication_time_lag")

    @engine_config_pglookout_max_failover_replication_time_lag.setter
    def engine_config_pglookout_max_failover_replication_time_lag(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pglookout_max_failover_replication_time_lag", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigSharedBuffersPercentage")
    def engine_config_shared_buffers_percentage(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Percentage of total RAM that the database server uses for shared memory buffers. Valid range is 20-60 (float), which corresponds to 20% - 60%. This setting adjusts the shared_buffers configuration value.
        """
        return pulumi.get(self, "engine_config_shared_buffers_percentage")

    @engine_config_shared_buffers_percentage.setter
    def engine_config_shared_buffers_percentage(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "engine_config_shared_buffers_percentage", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigWorkMem")
    def engine_config_work_mem(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sets the maximum amount of memory to be used by a query operation (such as a sort or hash table) before writing to temporary disk files, in MB. Default is 1MB + 0.075% of total RAM (up to 32MB).
        """
        return pulumi.get(self, "engine_config_work_mem")

    @engine_config_work_mem.setter
    def engine_config_work_mem(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_work_mem", value)

    @_builtins.property
    @pulumi.getter(name="forkRestoreTime")
    def fork_restore_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database timestamp from which it was restored.
        """
        return pulumi.get(self, "fork_restore_time")

    @fork_restore_time.setter
    def fork_restore_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fork_restore_time", value)

    @_builtins.property
    @pulumi.getter(name="forkSource")
    def fork_source(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the database that was forked from.

        * `updates` - (Optional) Configuration settings for automated patch update maintenance for the Managed Database.
        """
        return pulumi.get(self, "fork_source")

    @fork_source.setter
    def fork_source(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "fork_source", value)

    @_builtins.property
    @pulumi.getter
    def suspended(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this Managed Database should be suspended.
        """
        return pulumi.get(self, "suspended")

    @suspended.setter
    def suspended(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "suspended", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['DatabasePostgresqlV2TimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['DatabasePostgresqlV2TimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter
    def updates(self) -> Optional[pulumi.Input['DatabasePostgresqlV2UpdatesArgs']]:
        """
        Configuration settings for automated patch update maintenance for the Managed Database.
        """
        return pulumi.get(self, "updates")

    @updates.setter
    def updates(self, value: Optional[pulumi.Input['DatabasePostgresqlV2UpdatesArgs']]):
        pulumi.set(self, "updates", value)


@pulumi.input_type
class _DatabasePostgresqlV2State:
    def __init__(__self__, *,
                 allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_size: Optional[pulumi.Input[_builtins.int]] = None,
                 created: Optional[pulumi.Input[_builtins.str]] = None,
                 encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_pg_autovacuum_analyze_scale_factor: Optional[pulumi.Input[_builtins.float]] = None,
                 engine_config_pg_autovacuum_analyze_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_autovacuum_max_workers: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_autovacuum_naptime: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_autovacuum_vacuum_cost_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_autovacuum_vacuum_cost_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_autovacuum_vacuum_scale_factor: Optional[pulumi.Input[_builtins.float]] = None,
                 engine_config_pg_autovacuum_vacuum_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_bgwriter_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_bgwriter_flush_after: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_bgwriter_lru_maxpages: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_bgwriter_lru_multiplier: Optional[pulumi.Input[_builtins.float]] = None,
                 engine_config_pg_deadlock_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_default_toast_compression: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_pg_idle_in_transaction_session_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_jit: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine_config_pg_max_files_per_process: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_locks_per_transaction: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_logical_replication_workers: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_parallel_workers: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_parallel_workers_per_gather: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_pred_locks_per_transaction: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_replication_slots: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_slot_wal_keep_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_stack_depth: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_standby_archive_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_standby_streaming_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_wal_senders: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_worker_processes: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_password_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_pg_pg_partman_bgw_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_pg_partman_bgw_role: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_pg_pg_stat_monitor_pgsm_enable_query_plan: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine_config_pg_pg_stat_monitor_pgsm_max_buckets: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_pg_stat_statements_track: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_pg_stat_monitor_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine_config_pg_temp_file_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_pg_track_activity_query_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_track_commit_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_pg_track_functions: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_pg_track_io_timing: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_pg_wal_sender_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_wal_writer_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pglookout_max_failover_replication_time_lag: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_shared_buffers_percentage: Optional[pulumi.Input[_builtins.float]] = None,
                 engine_config_work_mem: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fork_restore_time: Optional[pulumi.Input[_builtins.str]] = None,
                 fork_source: Optional[pulumi.Input[_builtins.int]] = None,
                 host_primary: Optional[pulumi.Input[_builtins.str]] = None,
                 host_secondary: Optional[pulumi.Input[_builtins.str]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 members: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 oldest_restore_time: Optional[pulumi.Input[_builtins.str]] = None,
                 pending_updates: Optional[pulumi.Input[Sequence[pulumi.Input['DatabasePostgresqlV2PendingUpdateArgs']]]] = None,
                 platform: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 root_password: Optional[pulumi.Input[_builtins.str]] = None,
                 root_username: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_connection: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 suspended: Optional[pulumi.Input[_builtins.bool]] = None,
                 timeouts: Optional[pulumi.Input['DatabasePostgresqlV2TimeoutsArgs']] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 updated: Optional[pulumi.Input[_builtins.str]] = None,
                 updates: Optional[pulumi.Input['DatabasePostgresqlV2UpdatesArgs']] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DatabasePostgresqlV2 resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allow_lists: A list of IP addresses that can access the Managed Database. Each item can be a single IP address or a range in CIDR format. Use `DatabaseAccessControls` to manage your allow list separately.
        :param pulumi.Input[_builtins.str] ca_cert: The base64-encoded SSL CA certificate for the Managed Database.
        :param pulumi.Input[_builtins.int] cluster_size: The number of Linode Instance nodes deployed to the Managed Database. (default `1`)
        :param pulumi.Input[_builtins.str] created: When this Managed Database was created.
        :param pulumi.Input[_builtins.bool] encrypted: Whether the Managed Databases is encrypted.
        :param pulumi.Input[_builtins.str] engine: The Managed Database engine. (e.g. `postgresql`)
        :param pulumi.Input[_builtins.float] engine_config_pg_autovacuum_analyze_scale_factor: Specifies a fraction of the table size to add to autovacuum_analyze_threshold when deciding whether to trigger an ANALYZE. The default is 0.2 (20% of table size)
        :param pulumi.Input[_builtins.int] engine_config_pg_autovacuum_analyze_threshold: Specifies the minimum number of inserted, updated or deleted tuples needed to trigger an ANALYZE in any one table. The default is 50 tuples.
        :param pulumi.Input[_builtins.int] engine_config_pg_autovacuum_max_workers: Specifies the maximum number of autovacuum processes (other than the autovacuum launcher) that may be running at any one time. The default is three. This parameter can only be set at server start.
        :param pulumi.Input[_builtins.int] engine_config_pg_autovacuum_naptime: Specifies the minimum delay between autovacuum runs on any given database. The delay is measured in seconds, and the default is one minute
        :param pulumi.Input[_builtins.int] engine_config_pg_autovacuum_vacuum_cost_delay: Specifies the cost delay value that will be used in automatic VACUUM operations. If -1 is specified, the regular vacuum_cost_delay value will be used. The default value is 20 milliseconds
        :param pulumi.Input[_builtins.int] engine_config_pg_autovacuum_vacuum_cost_limit: Specifies the cost limit value that will be used in automatic VACUUM operations. If -1 is specified (which is the default), the regular vacuum_cost_limit value will be used.
        :param pulumi.Input[_builtins.float] engine_config_pg_autovacuum_vacuum_scale_factor: Specifies a fraction of the table size to add to autovacuum_vacuum_threshold when deciding whether to trigger a VACUUM. The default is 0.2 (20% of table size)
        :param pulumi.Input[_builtins.int] engine_config_pg_autovacuum_vacuum_threshold: Specifies the minimum number of updated or deleted tuples needed to trigger a VACUUM in any one table. The default is 50 tuples.
        :param pulumi.Input[_builtins.int] engine_config_pg_bgwriter_delay: Specifies the delay between activity rounds for the background writer in milliseconds. Default is 200.
        :param pulumi.Input[_builtins.int] engine_config_pg_bgwriter_flush_after: Whenever more than bgwriter_flush_after bytes have been written by the background writer, attempt to force the OS to issue these writes to the underlying storage. Specified in kilobytes, default is 512. Setting of 0 disables forced writeback.
        :param pulumi.Input[_builtins.int] engine_config_pg_bgwriter_lru_maxpages: In each round, no more than this many buffers will be written by the background writer. Setting this to zero disables background writing. Default is 100.
        :param pulumi.Input[_builtins.float] engine_config_pg_bgwriter_lru_multiplier: The average recent need for new buffers is multiplied by bgwriter_lru_multiplier to arrive at an estimate of the number that will be needed during the next round, (up to bgwriter_lru_maxpages). 1.0 represents a “just in time” policy of writing exactly the number of buffers predicted to be needed. Larger values provide some cushion against spikes in demand, while smaller values intentionally leave writes to be done by server processes. The default is 2.0.
        :param pulumi.Input[_builtins.int] engine_config_pg_deadlock_timeout: This is the amount of time, in milliseconds, to wait on a lock before checking to see if there is a deadlock condition.
        :param pulumi.Input[_builtins.str] engine_config_pg_default_toast_compression: Specifies the default TOAST compression method for values of compressible columns (the default is lz4).
        :param pulumi.Input[_builtins.int] engine_config_pg_idle_in_transaction_session_timeout: Time out sessions with open transactions after this number of milliseconds.
        :param pulumi.Input[_builtins.bool] engine_config_pg_jit: Controls system-wide use of Just-in-Time Compilation (JIT).
        :param pulumi.Input[_builtins.int] engine_config_pg_max_files_per_process: PostgreSQL maximum number of files that can be open per process.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_locks_per_transaction: PostgreSQL maximum locks per transaction.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_logical_replication_workers: PostgreSQL maximum logical replication workers (taken from the pool of max_parallel_workers).
        :param pulumi.Input[_builtins.int] engine_config_pg_max_parallel_workers: Sets the maximum number of workers that the system can support for parallel queries.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_parallel_workers_per_gather: Sets the maximum number of workers that can be started by a single Gather or Gather Merge node.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_pred_locks_per_transaction: PostgreSQL maximum predicate locks per transaction.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_replication_slots: PostgreSQL maximum replication slots.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_slot_wal_keep_size: PostgreSQL maximum WAL size (MB) reserved for replication slots. Default is -1 (unlimited). wal_keep_size minimum WAL size setting takes precedence over this.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_stack_depth: Maximum depth of the stack in bytes.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_standby_archive_delay: Max standby archive delay in milliseconds.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_standby_streaming_delay: Max standby streaming delay in milliseconds.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_wal_senders: PostgreSQL maximum WAL senders.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_worker_processes: Sets the maximum number of background processes that the system can support.
        :param pulumi.Input[_builtins.str] engine_config_pg_password_encryption: Chooses the algorithm for encrypting passwords. (default `md5`)
        :param pulumi.Input[_builtins.int] engine_config_pg_pg_partman_bgw_interval: Sets the time interval to run pg_partman's scheduled tasks.
        :param pulumi.Input[_builtins.str] engine_config_pg_pg_partman_bgw_role: Controls which role to use for pg_partman's scheduled background tasks.
        :param pulumi.Input[_builtins.bool] engine_config_pg_pg_stat_monitor_pgsm_enable_query_plan: Enables or disables query plan monitoring.
        :param pulumi.Input[_builtins.int] engine_config_pg_pg_stat_monitor_pgsm_max_buckets: Sets the maximum number of buckets.
        :param pulumi.Input[_builtins.str] engine_config_pg_pg_stat_statements_track: Controls which statements are counted. Specify top to track top-level statements (those issued directly by clients), all to also track nested statements (such as statements invoked within functions), or none to disable statement statistics collection. The default value is top.
        :param pulumi.Input[_builtins.bool] engine_config_pg_stat_monitor_enable: Enable the pg_stat_monitor extension. Enabling this extension will cause the cluster to be restarted. When this extension is enabled, pg_stat_statements results for utility commands are unreliable. (default `false`)
        :param pulumi.Input[_builtins.int] engine_config_pg_temp_file_limit: PostgreSQL temporary file limit in KiB, -1 for unlimited.
        :param pulumi.Input[_builtins.str] engine_config_pg_timezone: PostgreSQL service timezone.
        :param pulumi.Input[_builtins.int] engine_config_pg_track_activity_query_size: Specifies the number of bytes reserved to track the currently executing command for each active session.
        :param pulumi.Input[_builtins.str] engine_config_pg_track_commit_timestamp: Record commit time of transactions.
        :param pulumi.Input[_builtins.str] engine_config_pg_track_functions: Enables tracking of function call counts and time used.
        :param pulumi.Input[_builtins.str] engine_config_pg_track_io_timing: Enables timing of database I/O calls. This parameter is off by default, because it will repeatedly query the operating system for the current time, which may cause significant overhead on some platforms.
        :param pulumi.Input[_builtins.int] engine_config_pg_wal_sender_timeout: Terminate replication connections that are inactive for longer than this amount of time, in milliseconds. Setting this value to zero disables the timeout.
        :param pulumi.Input[_builtins.int] engine_config_pg_wal_writer_delay: WAL flush interval in milliseconds. Note that setting this value to lower than the default 200ms may negatively impact performance.
        :param pulumi.Input[_builtins.int] engine_config_pglookout_max_failover_replication_time_lag: Number of seconds of master unavailability before triggering database failover to standby. (default `60`)
        :param pulumi.Input[_builtins.float] engine_config_shared_buffers_percentage: Percentage of total RAM that the database server uses for shared memory buffers. Valid range is 20-60 (float), which corresponds to 20% - 60%. This setting adjusts the shared_buffers configuration value.
        :param pulumi.Input[_builtins.int] engine_config_work_mem: Sets the maximum amount of memory to be used by a query operation (such as a sort or hash table) before writing to temporary disk files, in MB. Default is 1MB + 0.075% of total RAM (up to 32MB).
        :param pulumi.Input[_builtins.str] engine_id: The Managed Database engine in engine/version format. (e.g. `postgresql/16`)
        :param pulumi.Input[_builtins.str] fork_restore_time: The database timestamp from which it was restored.
        :param pulumi.Input[_builtins.int] fork_source: The ID of the database that was forked from.
               
               * `updates` - (Optional) Configuration settings for automated patch update maintenance for the Managed Database.
        :param pulumi.Input[_builtins.str] host_primary: The primary host for the Managed Database.
        :param pulumi.Input[_builtins.str] host_secondary: The secondary/private host for the managed database.
        :param pulumi.Input[_builtins.str] label: A unique, user-defined string referring to the Managed Database.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] members: A mapping between IP addresses and strings designating them as primary or failover.
        :param pulumi.Input[_builtins.str] oldest_restore_time: The oldest time to which a database can be restored.
        :param pulumi.Input[Sequence[pulumi.Input['DatabasePostgresqlV2PendingUpdateArgs']]] pending_updates: A set of pending updates.
        :param pulumi.Input[_builtins.str] platform: The back-end platform for relational databases used by the service.
        :param pulumi.Input[_builtins.int] port: The access port for this Managed Database.
        :param pulumi.Input[_builtins.str] region: The region to use for the Managed Database.
        :param pulumi.Input[_builtins.str] root_password: The randomly-generated root password for the Managed Database instance.
        :param pulumi.Input[_builtins.str] root_username: The root username for the Managed Database instance.
        :param pulumi.Input[_builtins.bool] ssl_connection: Whether to require SSL credentials to establish a connection to the Managed Database.
        :param pulumi.Input[_builtins.str] status: The operating status of the Managed Database.
        :param pulumi.Input[_builtins.bool] suspended: Whether this Managed Database should be suspended.
        :param pulumi.Input[_builtins.str] type: The Linode Instance type used for the nodes of the Managed Database.
               
               - - -
        :param pulumi.Input[_builtins.str] updated: When this Managed Database was last updated.
        :param pulumi.Input['DatabasePostgresqlV2UpdatesArgs'] updates: Configuration settings for automated patch update maintenance for the Managed Database.
        :param pulumi.Input[_builtins.str] version: The Managed Database engine version. (e.g. `13.2`)
        """
        if allow_lists is not None:
            pulumi.set(__self__, "allow_lists", allow_lists)
        if ca_cert is not None:
            pulumi.set(__self__, "ca_cert", ca_cert)
        if cluster_size is not None:
            pulumi.set(__self__, "cluster_size", cluster_size)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_config_pg_autovacuum_analyze_scale_factor is not None:
            pulumi.set(__self__, "engine_config_pg_autovacuum_analyze_scale_factor", engine_config_pg_autovacuum_analyze_scale_factor)
        if engine_config_pg_autovacuum_analyze_threshold is not None:
            pulumi.set(__self__, "engine_config_pg_autovacuum_analyze_threshold", engine_config_pg_autovacuum_analyze_threshold)
        if engine_config_pg_autovacuum_max_workers is not None:
            pulumi.set(__self__, "engine_config_pg_autovacuum_max_workers", engine_config_pg_autovacuum_max_workers)
        if engine_config_pg_autovacuum_naptime is not None:
            pulumi.set(__self__, "engine_config_pg_autovacuum_naptime", engine_config_pg_autovacuum_naptime)
        if engine_config_pg_autovacuum_vacuum_cost_delay is not None:
            pulumi.set(__self__, "engine_config_pg_autovacuum_vacuum_cost_delay", engine_config_pg_autovacuum_vacuum_cost_delay)
        if engine_config_pg_autovacuum_vacuum_cost_limit is not None:
            pulumi.set(__self__, "engine_config_pg_autovacuum_vacuum_cost_limit", engine_config_pg_autovacuum_vacuum_cost_limit)
        if engine_config_pg_autovacuum_vacuum_scale_factor is not None:
            pulumi.set(__self__, "engine_config_pg_autovacuum_vacuum_scale_factor", engine_config_pg_autovacuum_vacuum_scale_factor)
        if engine_config_pg_autovacuum_vacuum_threshold is not None:
            pulumi.set(__self__, "engine_config_pg_autovacuum_vacuum_threshold", engine_config_pg_autovacuum_vacuum_threshold)
        if engine_config_pg_bgwriter_delay is not None:
            pulumi.set(__self__, "engine_config_pg_bgwriter_delay", engine_config_pg_bgwriter_delay)
        if engine_config_pg_bgwriter_flush_after is not None:
            pulumi.set(__self__, "engine_config_pg_bgwriter_flush_after", engine_config_pg_bgwriter_flush_after)
        if engine_config_pg_bgwriter_lru_maxpages is not None:
            pulumi.set(__self__, "engine_config_pg_bgwriter_lru_maxpages", engine_config_pg_bgwriter_lru_maxpages)
        if engine_config_pg_bgwriter_lru_multiplier is not None:
            pulumi.set(__self__, "engine_config_pg_bgwriter_lru_multiplier", engine_config_pg_bgwriter_lru_multiplier)
        if engine_config_pg_deadlock_timeout is not None:
            pulumi.set(__self__, "engine_config_pg_deadlock_timeout", engine_config_pg_deadlock_timeout)
        if engine_config_pg_default_toast_compression is not None:
            pulumi.set(__self__, "engine_config_pg_default_toast_compression", engine_config_pg_default_toast_compression)
        if engine_config_pg_idle_in_transaction_session_timeout is not None:
            pulumi.set(__self__, "engine_config_pg_idle_in_transaction_session_timeout", engine_config_pg_idle_in_transaction_session_timeout)
        if engine_config_pg_jit is not None:
            pulumi.set(__self__, "engine_config_pg_jit", engine_config_pg_jit)
        if engine_config_pg_max_files_per_process is not None:
            pulumi.set(__self__, "engine_config_pg_max_files_per_process", engine_config_pg_max_files_per_process)
        if engine_config_pg_max_locks_per_transaction is not None:
            pulumi.set(__self__, "engine_config_pg_max_locks_per_transaction", engine_config_pg_max_locks_per_transaction)
        if engine_config_pg_max_logical_replication_workers is not None:
            pulumi.set(__self__, "engine_config_pg_max_logical_replication_workers", engine_config_pg_max_logical_replication_workers)
        if engine_config_pg_max_parallel_workers is not None:
            pulumi.set(__self__, "engine_config_pg_max_parallel_workers", engine_config_pg_max_parallel_workers)
        if engine_config_pg_max_parallel_workers_per_gather is not None:
            pulumi.set(__self__, "engine_config_pg_max_parallel_workers_per_gather", engine_config_pg_max_parallel_workers_per_gather)
        if engine_config_pg_max_pred_locks_per_transaction is not None:
            pulumi.set(__self__, "engine_config_pg_max_pred_locks_per_transaction", engine_config_pg_max_pred_locks_per_transaction)
        if engine_config_pg_max_replication_slots is not None:
            pulumi.set(__self__, "engine_config_pg_max_replication_slots", engine_config_pg_max_replication_slots)
        if engine_config_pg_max_slot_wal_keep_size is not None:
            pulumi.set(__self__, "engine_config_pg_max_slot_wal_keep_size", engine_config_pg_max_slot_wal_keep_size)
        if engine_config_pg_max_stack_depth is not None:
            pulumi.set(__self__, "engine_config_pg_max_stack_depth", engine_config_pg_max_stack_depth)
        if engine_config_pg_max_standby_archive_delay is not None:
            pulumi.set(__self__, "engine_config_pg_max_standby_archive_delay", engine_config_pg_max_standby_archive_delay)
        if engine_config_pg_max_standby_streaming_delay is not None:
            pulumi.set(__self__, "engine_config_pg_max_standby_streaming_delay", engine_config_pg_max_standby_streaming_delay)
        if engine_config_pg_max_wal_senders is not None:
            pulumi.set(__self__, "engine_config_pg_max_wal_senders", engine_config_pg_max_wal_senders)
        if engine_config_pg_max_worker_processes is not None:
            pulumi.set(__self__, "engine_config_pg_max_worker_processes", engine_config_pg_max_worker_processes)
        if engine_config_pg_password_encryption is not None:
            pulumi.set(__self__, "engine_config_pg_password_encryption", engine_config_pg_password_encryption)
        if engine_config_pg_pg_partman_bgw_interval is not None:
            pulumi.set(__self__, "engine_config_pg_pg_partman_bgw_interval", engine_config_pg_pg_partman_bgw_interval)
        if engine_config_pg_pg_partman_bgw_role is not None:
            pulumi.set(__self__, "engine_config_pg_pg_partman_bgw_role", engine_config_pg_pg_partman_bgw_role)
        if engine_config_pg_pg_stat_monitor_pgsm_enable_query_plan is not None:
            pulumi.set(__self__, "engine_config_pg_pg_stat_monitor_pgsm_enable_query_plan", engine_config_pg_pg_stat_monitor_pgsm_enable_query_plan)
        if engine_config_pg_pg_stat_monitor_pgsm_max_buckets is not None:
            pulumi.set(__self__, "engine_config_pg_pg_stat_monitor_pgsm_max_buckets", engine_config_pg_pg_stat_monitor_pgsm_max_buckets)
        if engine_config_pg_pg_stat_statements_track is not None:
            pulumi.set(__self__, "engine_config_pg_pg_stat_statements_track", engine_config_pg_pg_stat_statements_track)
        if engine_config_pg_stat_monitor_enable is not None:
            pulumi.set(__self__, "engine_config_pg_stat_monitor_enable", engine_config_pg_stat_monitor_enable)
        if engine_config_pg_temp_file_limit is not None:
            pulumi.set(__self__, "engine_config_pg_temp_file_limit", engine_config_pg_temp_file_limit)
        if engine_config_pg_timezone is not None:
            pulumi.set(__self__, "engine_config_pg_timezone", engine_config_pg_timezone)
        if engine_config_pg_track_activity_query_size is not None:
            pulumi.set(__self__, "engine_config_pg_track_activity_query_size", engine_config_pg_track_activity_query_size)
        if engine_config_pg_track_commit_timestamp is not None:
            pulumi.set(__self__, "engine_config_pg_track_commit_timestamp", engine_config_pg_track_commit_timestamp)
        if engine_config_pg_track_functions is not None:
            pulumi.set(__self__, "engine_config_pg_track_functions", engine_config_pg_track_functions)
        if engine_config_pg_track_io_timing is not None:
            pulumi.set(__self__, "engine_config_pg_track_io_timing", engine_config_pg_track_io_timing)
        if engine_config_pg_wal_sender_timeout is not None:
            pulumi.set(__self__, "engine_config_pg_wal_sender_timeout", engine_config_pg_wal_sender_timeout)
        if engine_config_pg_wal_writer_delay is not None:
            pulumi.set(__self__, "engine_config_pg_wal_writer_delay", engine_config_pg_wal_writer_delay)
        if engine_config_pglookout_max_failover_replication_time_lag is not None:
            pulumi.set(__self__, "engine_config_pglookout_max_failover_replication_time_lag", engine_config_pglookout_max_failover_replication_time_lag)
        if engine_config_shared_buffers_percentage is not None:
            pulumi.set(__self__, "engine_config_shared_buffers_percentage", engine_config_shared_buffers_percentage)
        if engine_config_work_mem is not None:
            pulumi.set(__self__, "engine_config_work_mem", engine_config_work_mem)
        if engine_id is not None:
            pulumi.set(__self__, "engine_id", engine_id)
        if fork_restore_time is not None:
            pulumi.set(__self__, "fork_restore_time", fork_restore_time)
        if fork_source is not None:
            pulumi.set(__self__, "fork_source", fork_source)
        if host_primary is not None:
            pulumi.set(__self__, "host_primary", host_primary)
        if host_secondary is not None:
            pulumi.set(__self__, "host_secondary", host_secondary)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if oldest_restore_time is not None:
            pulumi.set(__self__, "oldest_restore_time", oldest_restore_time)
        if pending_updates is not None:
            pulumi.set(__self__, "pending_updates", pending_updates)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if root_password is not None:
            pulumi.set(__self__, "root_password", root_password)
        if root_username is not None:
            pulumi.set(__self__, "root_username", root_username)
        if ssl_connection is not None:
            pulumi.set(__self__, "ssl_connection", ssl_connection)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if suspended is not None:
            pulumi.set(__self__, "suspended", suspended)
        if timeouts is not None:
            pulumi.set(__self__, "timeouts", timeouts)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated is not None:
            pulumi.set(__self__, "updated", updated)
        if updates is not None:
            pulumi.set(__self__, "updates", updates)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="allowLists")
    def allow_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of IP addresses that can access the Managed Database. Each item can be a single IP address or a range in CIDR format. Use `DatabaseAccessControls` to manage your allow list separately.
        """
        return pulumi.get(self, "allow_lists")

    @allow_lists.setter
    def allow_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allow_lists", value)

    @_builtins.property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The base64-encoded SSL CA certificate for the Managed Database.
        """
        return pulumi.get(self, "ca_cert")

    @ca_cert.setter
    def ca_cert(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ca_cert", value)

    @_builtins.property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of Linode Instance nodes deployed to the Managed Database. (default `1`)
        """
        return pulumi.get(self, "cluster_size")

    @cluster_size.setter
    def cluster_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cluster_size", value)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When this Managed Database was created.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the Managed Databases is encrypted.
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "encrypted", value)

    @_builtins.property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Managed Database engine. (e.g. `postgresql`)
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgAutovacuumAnalyzeScaleFactor")
    def engine_config_pg_autovacuum_analyze_scale_factor(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Specifies a fraction of the table size to add to autovacuum_analyze_threshold when deciding whether to trigger an ANALYZE. The default is 0.2 (20% of table size)
        """
        return pulumi.get(self, "engine_config_pg_autovacuum_analyze_scale_factor")

    @engine_config_pg_autovacuum_analyze_scale_factor.setter
    def engine_config_pg_autovacuum_analyze_scale_factor(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "engine_config_pg_autovacuum_analyze_scale_factor", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgAutovacuumAnalyzeThreshold")
    def engine_config_pg_autovacuum_analyze_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the minimum number of inserted, updated or deleted tuples needed to trigger an ANALYZE in any one table. The default is 50 tuples.
        """
        return pulumi.get(self, "engine_config_pg_autovacuum_analyze_threshold")

    @engine_config_pg_autovacuum_analyze_threshold.setter
    def engine_config_pg_autovacuum_analyze_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_autovacuum_analyze_threshold", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgAutovacuumMaxWorkers")
    def engine_config_pg_autovacuum_max_workers(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum number of autovacuum processes (other than the autovacuum launcher) that may be running at any one time. The default is three. This parameter can only be set at server start.
        """
        return pulumi.get(self, "engine_config_pg_autovacuum_max_workers")

    @engine_config_pg_autovacuum_max_workers.setter
    def engine_config_pg_autovacuum_max_workers(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_autovacuum_max_workers", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgAutovacuumNaptime")
    def engine_config_pg_autovacuum_naptime(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the minimum delay between autovacuum runs on any given database. The delay is measured in seconds, and the default is one minute
        """
        return pulumi.get(self, "engine_config_pg_autovacuum_naptime")

    @engine_config_pg_autovacuum_naptime.setter
    def engine_config_pg_autovacuum_naptime(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_autovacuum_naptime", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgAutovacuumVacuumCostDelay")
    def engine_config_pg_autovacuum_vacuum_cost_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the cost delay value that will be used in automatic VACUUM operations. If -1 is specified, the regular vacuum_cost_delay value will be used. The default value is 20 milliseconds
        """
        return pulumi.get(self, "engine_config_pg_autovacuum_vacuum_cost_delay")

    @engine_config_pg_autovacuum_vacuum_cost_delay.setter
    def engine_config_pg_autovacuum_vacuum_cost_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_autovacuum_vacuum_cost_delay", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgAutovacuumVacuumCostLimit")
    def engine_config_pg_autovacuum_vacuum_cost_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the cost limit value that will be used in automatic VACUUM operations. If -1 is specified (which is the default), the regular vacuum_cost_limit value will be used.
        """
        return pulumi.get(self, "engine_config_pg_autovacuum_vacuum_cost_limit")

    @engine_config_pg_autovacuum_vacuum_cost_limit.setter
    def engine_config_pg_autovacuum_vacuum_cost_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_autovacuum_vacuum_cost_limit", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgAutovacuumVacuumScaleFactor")
    def engine_config_pg_autovacuum_vacuum_scale_factor(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Specifies a fraction of the table size to add to autovacuum_vacuum_threshold when deciding whether to trigger a VACUUM. The default is 0.2 (20% of table size)
        """
        return pulumi.get(self, "engine_config_pg_autovacuum_vacuum_scale_factor")

    @engine_config_pg_autovacuum_vacuum_scale_factor.setter
    def engine_config_pg_autovacuum_vacuum_scale_factor(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "engine_config_pg_autovacuum_vacuum_scale_factor", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgAutovacuumVacuumThreshold")
    def engine_config_pg_autovacuum_vacuum_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the minimum number of updated or deleted tuples needed to trigger a VACUUM in any one table. The default is 50 tuples.
        """
        return pulumi.get(self, "engine_config_pg_autovacuum_vacuum_threshold")

    @engine_config_pg_autovacuum_vacuum_threshold.setter
    def engine_config_pg_autovacuum_vacuum_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_autovacuum_vacuum_threshold", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgBgwriterDelay")
    def engine_config_pg_bgwriter_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the delay between activity rounds for the background writer in milliseconds. Default is 200.
        """
        return pulumi.get(self, "engine_config_pg_bgwriter_delay")

    @engine_config_pg_bgwriter_delay.setter
    def engine_config_pg_bgwriter_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_bgwriter_delay", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgBgwriterFlushAfter")
    def engine_config_pg_bgwriter_flush_after(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Whenever more than bgwriter_flush_after bytes have been written by the background writer, attempt to force the OS to issue these writes to the underlying storage. Specified in kilobytes, default is 512. Setting of 0 disables forced writeback.
        """
        return pulumi.get(self, "engine_config_pg_bgwriter_flush_after")

    @engine_config_pg_bgwriter_flush_after.setter
    def engine_config_pg_bgwriter_flush_after(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_bgwriter_flush_after", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgBgwriterLruMaxpages")
    def engine_config_pg_bgwriter_lru_maxpages(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        In each round, no more than this many buffers will be written by the background writer. Setting this to zero disables background writing. Default is 100.
        """
        return pulumi.get(self, "engine_config_pg_bgwriter_lru_maxpages")

    @engine_config_pg_bgwriter_lru_maxpages.setter
    def engine_config_pg_bgwriter_lru_maxpages(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_bgwriter_lru_maxpages", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgBgwriterLruMultiplier")
    def engine_config_pg_bgwriter_lru_multiplier(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The average recent need for new buffers is multiplied by bgwriter_lru_multiplier to arrive at an estimate of the number that will be needed during the next round, (up to bgwriter_lru_maxpages). 1.0 represents a “just in time” policy of writing exactly the number of buffers predicted to be needed. Larger values provide some cushion against spikes in demand, while smaller values intentionally leave writes to be done by server processes. The default is 2.0.
        """
        return pulumi.get(self, "engine_config_pg_bgwriter_lru_multiplier")

    @engine_config_pg_bgwriter_lru_multiplier.setter
    def engine_config_pg_bgwriter_lru_multiplier(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "engine_config_pg_bgwriter_lru_multiplier", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgDeadlockTimeout")
    def engine_config_pg_deadlock_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        This is the amount of time, in milliseconds, to wait on a lock before checking to see if there is a deadlock condition.
        """
        return pulumi.get(self, "engine_config_pg_deadlock_timeout")

    @engine_config_pg_deadlock_timeout.setter
    def engine_config_pg_deadlock_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_deadlock_timeout", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgDefaultToastCompression")
    def engine_config_pg_default_toast_compression(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the default TOAST compression method for values of compressible columns (the default is lz4).
        """
        return pulumi.get(self, "engine_config_pg_default_toast_compression")

    @engine_config_pg_default_toast_compression.setter
    def engine_config_pg_default_toast_compression(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_config_pg_default_toast_compression", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgIdleInTransactionSessionTimeout")
    def engine_config_pg_idle_in_transaction_session_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time out sessions with open transactions after this number of milliseconds.
        """
        return pulumi.get(self, "engine_config_pg_idle_in_transaction_session_timeout")

    @engine_config_pg_idle_in_transaction_session_timeout.setter
    def engine_config_pg_idle_in_transaction_session_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_idle_in_transaction_session_timeout", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgJit")
    def engine_config_pg_jit(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Controls system-wide use of Just-in-Time Compilation (JIT).
        """
        return pulumi.get(self, "engine_config_pg_jit")

    @engine_config_pg_jit.setter
    def engine_config_pg_jit(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "engine_config_pg_jit", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxFilesPerProcess")
    def engine_config_pg_max_files_per_process(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PostgreSQL maximum number of files that can be open per process.
        """
        return pulumi.get(self, "engine_config_pg_max_files_per_process")

    @engine_config_pg_max_files_per_process.setter
    def engine_config_pg_max_files_per_process(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_max_files_per_process", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxLocksPerTransaction")
    def engine_config_pg_max_locks_per_transaction(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PostgreSQL maximum locks per transaction.
        """
        return pulumi.get(self, "engine_config_pg_max_locks_per_transaction")

    @engine_config_pg_max_locks_per_transaction.setter
    def engine_config_pg_max_locks_per_transaction(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_max_locks_per_transaction", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxLogicalReplicationWorkers")
    def engine_config_pg_max_logical_replication_workers(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PostgreSQL maximum logical replication workers (taken from the pool of max_parallel_workers).
        """
        return pulumi.get(self, "engine_config_pg_max_logical_replication_workers")

    @engine_config_pg_max_logical_replication_workers.setter
    def engine_config_pg_max_logical_replication_workers(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_max_logical_replication_workers", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxParallelWorkers")
    def engine_config_pg_max_parallel_workers(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sets the maximum number of workers that the system can support for parallel queries.
        """
        return pulumi.get(self, "engine_config_pg_max_parallel_workers")

    @engine_config_pg_max_parallel_workers.setter
    def engine_config_pg_max_parallel_workers(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_max_parallel_workers", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxParallelWorkersPerGather")
    def engine_config_pg_max_parallel_workers_per_gather(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sets the maximum number of workers that can be started by a single Gather or Gather Merge node.
        """
        return pulumi.get(self, "engine_config_pg_max_parallel_workers_per_gather")

    @engine_config_pg_max_parallel_workers_per_gather.setter
    def engine_config_pg_max_parallel_workers_per_gather(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_max_parallel_workers_per_gather", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxPredLocksPerTransaction")
    def engine_config_pg_max_pred_locks_per_transaction(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PostgreSQL maximum predicate locks per transaction.
        """
        return pulumi.get(self, "engine_config_pg_max_pred_locks_per_transaction")

    @engine_config_pg_max_pred_locks_per_transaction.setter
    def engine_config_pg_max_pred_locks_per_transaction(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_max_pred_locks_per_transaction", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxReplicationSlots")
    def engine_config_pg_max_replication_slots(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PostgreSQL maximum replication slots.
        """
        return pulumi.get(self, "engine_config_pg_max_replication_slots")

    @engine_config_pg_max_replication_slots.setter
    def engine_config_pg_max_replication_slots(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_max_replication_slots", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxSlotWalKeepSize")
    def engine_config_pg_max_slot_wal_keep_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PostgreSQL maximum WAL size (MB) reserved for replication slots. Default is -1 (unlimited). wal_keep_size minimum WAL size setting takes precedence over this.
        """
        return pulumi.get(self, "engine_config_pg_max_slot_wal_keep_size")

    @engine_config_pg_max_slot_wal_keep_size.setter
    def engine_config_pg_max_slot_wal_keep_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_max_slot_wal_keep_size", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxStackDepth")
    def engine_config_pg_max_stack_depth(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum depth of the stack in bytes.
        """
        return pulumi.get(self, "engine_config_pg_max_stack_depth")

    @engine_config_pg_max_stack_depth.setter
    def engine_config_pg_max_stack_depth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_max_stack_depth", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxStandbyArchiveDelay")
    def engine_config_pg_max_standby_archive_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Max standby archive delay in milliseconds.
        """
        return pulumi.get(self, "engine_config_pg_max_standby_archive_delay")

    @engine_config_pg_max_standby_archive_delay.setter
    def engine_config_pg_max_standby_archive_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_max_standby_archive_delay", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxStandbyStreamingDelay")
    def engine_config_pg_max_standby_streaming_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Max standby streaming delay in milliseconds.
        """
        return pulumi.get(self, "engine_config_pg_max_standby_streaming_delay")

    @engine_config_pg_max_standby_streaming_delay.setter
    def engine_config_pg_max_standby_streaming_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_max_standby_streaming_delay", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxWalSenders")
    def engine_config_pg_max_wal_senders(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PostgreSQL maximum WAL senders.
        """
        return pulumi.get(self, "engine_config_pg_max_wal_senders")

    @engine_config_pg_max_wal_senders.setter
    def engine_config_pg_max_wal_senders(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_max_wal_senders", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxWorkerProcesses")
    def engine_config_pg_max_worker_processes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sets the maximum number of background processes that the system can support.
        """
        return pulumi.get(self, "engine_config_pg_max_worker_processes")

    @engine_config_pg_max_worker_processes.setter
    def engine_config_pg_max_worker_processes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_max_worker_processes", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgPasswordEncryption")
    def engine_config_pg_password_encryption(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Chooses the algorithm for encrypting passwords. (default `md5`)
        """
        return pulumi.get(self, "engine_config_pg_password_encryption")

    @engine_config_pg_password_encryption.setter
    def engine_config_pg_password_encryption(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_config_pg_password_encryption", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgPgPartmanBgwInterval")
    def engine_config_pg_pg_partman_bgw_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sets the time interval to run pg_partman's scheduled tasks.
        """
        return pulumi.get(self, "engine_config_pg_pg_partman_bgw_interval")

    @engine_config_pg_pg_partman_bgw_interval.setter
    def engine_config_pg_pg_partman_bgw_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_pg_partman_bgw_interval", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgPgPartmanBgwRole")
    def engine_config_pg_pg_partman_bgw_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls which role to use for pg_partman's scheduled background tasks.
        """
        return pulumi.get(self, "engine_config_pg_pg_partman_bgw_role")

    @engine_config_pg_pg_partman_bgw_role.setter
    def engine_config_pg_pg_partman_bgw_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_config_pg_pg_partman_bgw_role", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgPgStatMonitorPgsmEnableQueryPlan")
    def engine_config_pg_pg_stat_monitor_pgsm_enable_query_plan(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables or disables query plan monitoring.
        """
        return pulumi.get(self, "engine_config_pg_pg_stat_monitor_pgsm_enable_query_plan")

    @engine_config_pg_pg_stat_monitor_pgsm_enable_query_plan.setter
    def engine_config_pg_pg_stat_monitor_pgsm_enable_query_plan(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "engine_config_pg_pg_stat_monitor_pgsm_enable_query_plan", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgPgStatMonitorPgsmMaxBuckets")
    def engine_config_pg_pg_stat_monitor_pgsm_max_buckets(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sets the maximum number of buckets.
        """
        return pulumi.get(self, "engine_config_pg_pg_stat_monitor_pgsm_max_buckets")

    @engine_config_pg_pg_stat_monitor_pgsm_max_buckets.setter
    def engine_config_pg_pg_stat_monitor_pgsm_max_buckets(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_pg_stat_monitor_pgsm_max_buckets", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgPgStatStatementsTrack")
    def engine_config_pg_pg_stat_statements_track(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Controls which statements are counted. Specify top to track top-level statements (those issued directly by clients), all to also track nested statements (such as statements invoked within functions), or none to disable statement statistics collection. The default value is top.
        """
        return pulumi.get(self, "engine_config_pg_pg_stat_statements_track")

    @engine_config_pg_pg_stat_statements_track.setter
    def engine_config_pg_pg_stat_statements_track(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_config_pg_pg_stat_statements_track", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgStatMonitorEnable")
    def engine_config_pg_stat_monitor_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable the pg_stat_monitor extension. Enabling this extension will cause the cluster to be restarted. When this extension is enabled, pg_stat_statements results for utility commands are unreliable. (default `false`)
        """
        return pulumi.get(self, "engine_config_pg_stat_monitor_enable")

    @engine_config_pg_stat_monitor_enable.setter
    def engine_config_pg_stat_monitor_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "engine_config_pg_stat_monitor_enable", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgTempFileLimit")
    def engine_config_pg_temp_file_limit(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        PostgreSQL temporary file limit in KiB, -1 for unlimited.
        """
        return pulumi.get(self, "engine_config_pg_temp_file_limit")

    @engine_config_pg_temp_file_limit.setter
    def engine_config_pg_temp_file_limit(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_temp_file_limit", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgTimezone")
    def engine_config_pg_timezone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        PostgreSQL service timezone.
        """
        return pulumi.get(self, "engine_config_pg_timezone")

    @engine_config_pg_timezone.setter
    def engine_config_pg_timezone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_config_pg_timezone", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgTrackActivityQuerySize")
    def engine_config_pg_track_activity_query_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of bytes reserved to track the currently executing command for each active session.
        """
        return pulumi.get(self, "engine_config_pg_track_activity_query_size")

    @engine_config_pg_track_activity_query_size.setter
    def engine_config_pg_track_activity_query_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_track_activity_query_size", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgTrackCommitTimestamp")
    def engine_config_pg_track_commit_timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Record commit time of transactions.
        """
        return pulumi.get(self, "engine_config_pg_track_commit_timestamp")

    @engine_config_pg_track_commit_timestamp.setter
    def engine_config_pg_track_commit_timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_config_pg_track_commit_timestamp", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgTrackFunctions")
    def engine_config_pg_track_functions(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables tracking of function call counts and time used.
        """
        return pulumi.get(self, "engine_config_pg_track_functions")

    @engine_config_pg_track_functions.setter
    def engine_config_pg_track_functions(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_config_pg_track_functions", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgTrackIoTiming")
    def engine_config_pg_track_io_timing(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enables timing of database I/O calls. This parameter is off by default, because it will repeatedly query the operating system for the current time, which may cause significant overhead on some platforms.
        """
        return pulumi.get(self, "engine_config_pg_track_io_timing")

    @engine_config_pg_track_io_timing.setter
    def engine_config_pg_track_io_timing(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_config_pg_track_io_timing", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgWalSenderTimeout")
    def engine_config_pg_wal_sender_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Terminate replication connections that are inactive for longer than this amount of time, in milliseconds. Setting this value to zero disables the timeout.
        """
        return pulumi.get(self, "engine_config_pg_wal_sender_timeout")

    @engine_config_pg_wal_sender_timeout.setter
    def engine_config_pg_wal_sender_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_wal_sender_timeout", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPgWalWriterDelay")
    def engine_config_pg_wal_writer_delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        WAL flush interval in milliseconds. Note that setting this value to lower than the default 200ms may negatively impact performance.
        """
        return pulumi.get(self, "engine_config_pg_wal_writer_delay")

    @engine_config_pg_wal_writer_delay.setter
    def engine_config_pg_wal_writer_delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pg_wal_writer_delay", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigPglookoutMaxFailoverReplicationTimeLag")
    def engine_config_pglookout_max_failover_replication_time_lag(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of seconds of master unavailability before triggering database failover to standby. (default `60`)
        """
        return pulumi.get(self, "engine_config_pglookout_max_failover_replication_time_lag")

    @engine_config_pglookout_max_failover_replication_time_lag.setter
    def engine_config_pglookout_max_failover_replication_time_lag(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_pglookout_max_failover_replication_time_lag", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigSharedBuffersPercentage")
    def engine_config_shared_buffers_percentage(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Percentage of total RAM that the database server uses for shared memory buffers. Valid range is 20-60 (float), which corresponds to 20% - 60%. This setting adjusts the shared_buffers configuration value.
        """
        return pulumi.get(self, "engine_config_shared_buffers_percentage")

    @engine_config_shared_buffers_percentage.setter
    def engine_config_shared_buffers_percentage(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "engine_config_shared_buffers_percentage", value)

    @_builtins.property
    @pulumi.getter(name="engineConfigWorkMem")
    def engine_config_work_mem(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Sets the maximum amount of memory to be used by a query operation (such as a sort or hash table) before writing to temporary disk files, in MB. Default is 1MB + 0.075% of total RAM (up to 32MB).
        """
        return pulumi.get(self, "engine_config_work_mem")

    @engine_config_work_mem.setter
    def engine_config_work_mem(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "engine_config_work_mem", value)

    @_builtins.property
    @pulumi.getter(name="engineId")
    def engine_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Managed Database engine in engine/version format. (e.g. `postgresql/16`)
        """
        return pulumi.get(self, "engine_id")

    @engine_id.setter
    def engine_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_id", value)

    @_builtins.property
    @pulumi.getter(name="forkRestoreTime")
    def fork_restore_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The database timestamp from which it was restored.
        """
        return pulumi.get(self, "fork_restore_time")

    @fork_restore_time.setter
    def fork_restore_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fork_restore_time", value)

    @_builtins.property
    @pulumi.getter(name="forkSource")
    def fork_source(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the database that was forked from.

        * `updates` - (Optional) Configuration settings for automated patch update maintenance for the Managed Database.
        """
        return pulumi.get(self, "fork_source")

    @fork_source.setter
    def fork_source(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "fork_source", value)

    @_builtins.property
    @pulumi.getter(name="hostPrimary")
    def host_primary(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The primary host for the Managed Database.
        """
        return pulumi.get(self, "host_primary")

    @host_primary.setter
    def host_primary(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_primary", value)

    @_builtins.property
    @pulumi.getter(name="hostSecondary")
    def host_secondary(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secondary/private host for the managed database.
        """
        return pulumi.get(self, "host_secondary")

    @host_secondary.setter
    def host_secondary(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_secondary", value)

    @_builtins.property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique, user-defined string referring to the Managed Database.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "label", value)

    @_builtins.property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping between IP addresses and strings designating them as primary or failover.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "members", value)

    @_builtins.property
    @pulumi.getter(name="oldestRestoreTime")
    def oldest_restore_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The oldest time to which a database can be restored.
        """
        return pulumi.get(self, "oldest_restore_time")

    @oldest_restore_time.setter
    def oldest_restore_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "oldest_restore_time", value)

    @_builtins.property
    @pulumi.getter(name="pendingUpdates")
    def pending_updates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabasePostgresqlV2PendingUpdateArgs']]]]:
        """
        A set of pending updates.
        """
        return pulumi.get(self, "pending_updates")

    @pending_updates.setter
    def pending_updates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabasePostgresqlV2PendingUpdateArgs']]]]):
        pulumi.set(self, "pending_updates", value)

    @_builtins.property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The back-end platform for relational databases used by the service.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "platform", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The access port for this Managed Database.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region to use for the Managed Database.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="rootPassword")
    def root_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The randomly-generated root password for the Managed Database instance.
        """
        return pulumi.get(self, "root_password")

    @root_password.setter
    def root_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "root_password", value)

    @_builtins.property
    @pulumi.getter(name="rootUsername")
    def root_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The root username for the Managed Database instance.
        """
        return pulumi.get(self, "root_username")

    @root_username.setter
    def root_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "root_username", value)

    @_builtins.property
    @pulumi.getter(name="sslConnection")
    def ssl_connection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to require SSL credentials to establish a connection to the Managed Database.
        """
        return pulumi.get(self, "ssl_connection")

    @ssl_connection.setter
    def ssl_connection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ssl_connection", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operating status of the Managed Database.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def suspended(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this Managed Database should be suspended.
        """
        return pulumi.get(self, "suspended")

    @suspended.setter
    def suspended(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "suspended", value)

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> Optional[pulumi.Input['DatabasePostgresqlV2TimeoutsArgs']]:
        return pulumi.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: Optional[pulumi.Input['DatabasePostgresqlV2TimeoutsArgs']]):
        pulumi.set(self, "timeouts", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Linode Instance type used for the nodes of the Managed Database.

        - - -
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When this Managed Database was last updated.
        """
        return pulumi.get(self, "updated")

    @updated.setter
    def updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated", value)

    @_builtins.property
    @pulumi.getter
    def updates(self) -> Optional[pulumi.Input['DatabasePostgresqlV2UpdatesArgs']]:
        """
        Configuration settings for automated patch update maintenance for the Managed Database.
        """
        return pulumi.get(self, "updates")

    @updates.setter
    def updates(self, value: Optional[pulumi.Input['DatabasePostgresqlV2UpdatesArgs']]):
        pulumi.set(self, "updates", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Managed Database engine version. (e.g. `13.2`)
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("linode:index/databasePostgresqlV2:DatabasePostgresqlV2")
class DatabasePostgresqlV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cluster_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_autovacuum_analyze_scale_factor: Optional[pulumi.Input[_builtins.float]] = None,
                 engine_config_pg_autovacuum_analyze_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_autovacuum_max_workers: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_autovacuum_naptime: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_autovacuum_vacuum_cost_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_autovacuum_vacuum_cost_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_autovacuum_vacuum_scale_factor: Optional[pulumi.Input[_builtins.float]] = None,
                 engine_config_pg_autovacuum_vacuum_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_bgwriter_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_bgwriter_flush_after: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_bgwriter_lru_maxpages: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_bgwriter_lru_multiplier: Optional[pulumi.Input[_builtins.float]] = None,
                 engine_config_pg_deadlock_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_default_toast_compression: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_pg_idle_in_transaction_session_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_jit: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine_config_pg_max_files_per_process: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_locks_per_transaction: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_logical_replication_workers: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_parallel_workers: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_parallel_workers_per_gather: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_pred_locks_per_transaction: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_replication_slots: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_slot_wal_keep_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_stack_depth: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_standby_archive_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_standby_streaming_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_wal_senders: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_worker_processes: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_password_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_pg_pg_partman_bgw_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_pg_partman_bgw_role: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_pg_pg_stat_monitor_pgsm_enable_query_plan: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine_config_pg_pg_stat_monitor_pgsm_max_buckets: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_pg_stat_statements_track: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_pg_stat_monitor_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine_config_pg_temp_file_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_pg_track_activity_query_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_track_commit_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_pg_track_functions: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_pg_track_io_timing: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_pg_wal_sender_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_wal_writer_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pglookout_max_failover_replication_time_lag: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_shared_buffers_percentage: Optional[pulumi.Input[_builtins.float]] = None,
                 engine_config_work_mem: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fork_restore_time: Optional[pulumi.Input[_builtins.str]] = None,
                 fork_source: Optional[pulumi.Input[_builtins.int]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 suspended: Optional[pulumi.Input[_builtins.bool]] = None,
                 timeouts: Optional[pulumi.Input[Union['DatabasePostgresqlV2TimeoutsArgs', 'DatabasePostgresqlV2TimeoutsArgsDict']]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 updates: Optional[pulumi.Input[Union['DatabasePostgresqlV2UpdatesArgs', 'DatabasePostgresqlV2UpdatesArgsDict']]] = None,
                 __props__=None):
        """
        Provides a Linode PostgreSQL Database resource. This can be used to create, modify, and delete Linode PostgreSQL Databases.
        For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/post-databases-postgre-sql-instances).

        Please keep in mind that Managed Databases can take up to half an hour to provision.

        ## Example Usage

        Creating a simple PostgreSQL database that does not allow connections:

        ```python
        import pulumi
        import pulumi_linode as linode

        foobar = linode.DatabasePostgresqlV2("foobar",
            label="mydatabase",
            engine_id="postgresql/16",
            region="us-mia",
            type="g6-nanode-1")
        ```

        Creating a simple PostgreSQL database that allows connections from all IPv4 addresses:

        ```python
        import pulumi
        import pulumi_linode as linode

        foobar = linode.DatabasePostgresqlV2("foobar",
            label="mydatabase",
            engine_id="postgresql/16",
            region="us-mia",
            type="g6-nanode-1",
            allow_lists=["0.0.0.0/0"])
        ```

        Creating a complex PostgreSQL database:

        ## Import

        Linode PostgreSQL Databases can be imported using the `id`, e.g.

        ```sh
        $ pulumi import linode:index/databasePostgresqlV2:DatabasePostgresqlV2 foobar 1234567
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allow_lists: A list of IP addresses that can access the Managed Database. Each item can be a single IP address or a range in CIDR format. Use `DatabaseAccessControls` to manage your allow list separately.
        :param pulumi.Input[_builtins.int] cluster_size: The number of Linode Instance nodes deployed to the Managed Database. (default `1`)
        :param pulumi.Input[_builtins.float] engine_config_pg_autovacuum_analyze_scale_factor: Specifies a fraction of the table size to add to autovacuum_analyze_threshold when deciding whether to trigger an ANALYZE. The default is 0.2 (20% of table size)
        :param pulumi.Input[_builtins.int] engine_config_pg_autovacuum_analyze_threshold: Specifies the minimum number of inserted, updated or deleted tuples needed to trigger an ANALYZE in any one table. The default is 50 tuples.
        :param pulumi.Input[_builtins.int] engine_config_pg_autovacuum_max_workers: Specifies the maximum number of autovacuum processes (other than the autovacuum launcher) that may be running at any one time. The default is three. This parameter can only be set at server start.
        :param pulumi.Input[_builtins.int] engine_config_pg_autovacuum_naptime: Specifies the minimum delay between autovacuum runs on any given database. The delay is measured in seconds, and the default is one minute
        :param pulumi.Input[_builtins.int] engine_config_pg_autovacuum_vacuum_cost_delay: Specifies the cost delay value that will be used in automatic VACUUM operations. If -1 is specified, the regular vacuum_cost_delay value will be used. The default value is 20 milliseconds
        :param pulumi.Input[_builtins.int] engine_config_pg_autovacuum_vacuum_cost_limit: Specifies the cost limit value that will be used in automatic VACUUM operations. If -1 is specified (which is the default), the regular vacuum_cost_limit value will be used.
        :param pulumi.Input[_builtins.float] engine_config_pg_autovacuum_vacuum_scale_factor: Specifies a fraction of the table size to add to autovacuum_vacuum_threshold when deciding whether to trigger a VACUUM. The default is 0.2 (20% of table size)
        :param pulumi.Input[_builtins.int] engine_config_pg_autovacuum_vacuum_threshold: Specifies the minimum number of updated or deleted tuples needed to trigger a VACUUM in any one table. The default is 50 tuples.
        :param pulumi.Input[_builtins.int] engine_config_pg_bgwriter_delay: Specifies the delay between activity rounds for the background writer in milliseconds. Default is 200.
        :param pulumi.Input[_builtins.int] engine_config_pg_bgwriter_flush_after: Whenever more than bgwriter_flush_after bytes have been written by the background writer, attempt to force the OS to issue these writes to the underlying storage. Specified in kilobytes, default is 512. Setting of 0 disables forced writeback.
        :param pulumi.Input[_builtins.int] engine_config_pg_bgwriter_lru_maxpages: In each round, no more than this many buffers will be written by the background writer. Setting this to zero disables background writing. Default is 100.
        :param pulumi.Input[_builtins.float] engine_config_pg_bgwriter_lru_multiplier: The average recent need for new buffers is multiplied by bgwriter_lru_multiplier to arrive at an estimate of the number that will be needed during the next round, (up to bgwriter_lru_maxpages). 1.0 represents a “just in time” policy of writing exactly the number of buffers predicted to be needed. Larger values provide some cushion against spikes in demand, while smaller values intentionally leave writes to be done by server processes. The default is 2.0.
        :param pulumi.Input[_builtins.int] engine_config_pg_deadlock_timeout: This is the amount of time, in milliseconds, to wait on a lock before checking to see if there is a deadlock condition.
        :param pulumi.Input[_builtins.str] engine_config_pg_default_toast_compression: Specifies the default TOAST compression method for values of compressible columns (the default is lz4).
        :param pulumi.Input[_builtins.int] engine_config_pg_idle_in_transaction_session_timeout: Time out sessions with open transactions after this number of milliseconds.
        :param pulumi.Input[_builtins.bool] engine_config_pg_jit: Controls system-wide use of Just-in-Time Compilation (JIT).
        :param pulumi.Input[_builtins.int] engine_config_pg_max_files_per_process: PostgreSQL maximum number of files that can be open per process.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_locks_per_transaction: PostgreSQL maximum locks per transaction.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_logical_replication_workers: PostgreSQL maximum logical replication workers (taken from the pool of max_parallel_workers).
        :param pulumi.Input[_builtins.int] engine_config_pg_max_parallel_workers: Sets the maximum number of workers that the system can support for parallel queries.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_parallel_workers_per_gather: Sets the maximum number of workers that can be started by a single Gather or Gather Merge node.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_pred_locks_per_transaction: PostgreSQL maximum predicate locks per transaction.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_replication_slots: PostgreSQL maximum replication slots.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_slot_wal_keep_size: PostgreSQL maximum WAL size (MB) reserved for replication slots. Default is -1 (unlimited). wal_keep_size minimum WAL size setting takes precedence over this.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_stack_depth: Maximum depth of the stack in bytes.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_standby_archive_delay: Max standby archive delay in milliseconds.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_standby_streaming_delay: Max standby streaming delay in milliseconds.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_wal_senders: PostgreSQL maximum WAL senders.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_worker_processes: Sets the maximum number of background processes that the system can support.
        :param pulumi.Input[_builtins.str] engine_config_pg_password_encryption: Chooses the algorithm for encrypting passwords. (default `md5`)
        :param pulumi.Input[_builtins.int] engine_config_pg_pg_partman_bgw_interval: Sets the time interval to run pg_partman's scheduled tasks.
        :param pulumi.Input[_builtins.str] engine_config_pg_pg_partman_bgw_role: Controls which role to use for pg_partman's scheduled background tasks.
        :param pulumi.Input[_builtins.bool] engine_config_pg_pg_stat_monitor_pgsm_enable_query_plan: Enables or disables query plan monitoring.
        :param pulumi.Input[_builtins.int] engine_config_pg_pg_stat_monitor_pgsm_max_buckets: Sets the maximum number of buckets.
        :param pulumi.Input[_builtins.str] engine_config_pg_pg_stat_statements_track: Controls which statements are counted. Specify top to track top-level statements (those issued directly by clients), all to also track nested statements (such as statements invoked within functions), or none to disable statement statistics collection. The default value is top.
        :param pulumi.Input[_builtins.bool] engine_config_pg_stat_monitor_enable: Enable the pg_stat_monitor extension. Enabling this extension will cause the cluster to be restarted. When this extension is enabled, pg_stat_statements results for utility commands are unreliable. (default `false`)
        :param pulumi.Input[_builtins.int] engine_config_pg_temp_file_limit: PostgreSQL temporary file limit in KiB, -1 for unlimited.
        :param pulumi.Input[_builtins.str] engine_config_pg_timezone: PostgreSQL service timezone.
        :param pulumi.Input[_builtins.int] engine_config_pg_track_activity_query_size: Specifies the number of bytes reserved to track the currently executing command for each active session.
        :param pulumi.Input[_builtins.str] engine_config_pg_track_commit_timestamp: Record commit time of transactions.
        :param pulumi.Input[_builtins.str] engine_config_pg_track_functions: Enables tracking of function call counts and time used.
        :param pulumi.Input[_builtins.str] engine_config_pg_track_io_timing: Enables timing of database I/O calls. This parameter is off by default, because it will repeatedly query the operating system for the current time, which may cause significant overhead on some platforms.
        :param pulumi.Input[_builtins.int] engine_config_pg_wal_sender_timeout: Terminate replication connections that are inactive for longer than this amount of time, in milliseconds. Setting this value to zero disables the timeout.
        :param pulumi.Input[_builtins.int] engine_config_pg_wal_writer_delay: WAL flush interval in milliseconds. Note that setting this value to lower than the default 200ms may negatively impact performance.
        :param pulumi.Input[_builtins.int] engine_config_pglookout_max_failover_replication_time_lag: Number of seconds of master unavailability before triggering database failover to standby. (default `60`)
        :param pulumi.Input[_builtins.float] engine_config_shared_buffers_percentage: Percentage of total RAM that the database server uses for shared memory buffers. Valid range is 20-60 (float), which corresponds to 20% - 60%. This setting adjusts the shared_buffers configuration value.
        :param pulumi.Input[_builtins.int] engine_config_work_mem: Sets the maximum amount of memory to be used by a query operation (such as a sort or hash table) before writing to temporary disk files, in MB. Default is 1MB + 0.075% of total RAM (up to 32MB).
        :param pulumi.Input[_builtins.str] engine_id: The Managed Database engine in engine/version format. (e.g. `postgresql/16`)
        :param pulumi.Input[_builtins.str] fork_restore_time: The database timestamp from which it was restored.
        :param pulumi.Input[_builtins.int] fork_source: The ID of the database that was forked from.
               
               * `updates` - (Optional) Configuration settings for automated patch update maintenance for the Managed Database.
        :param pulumi.Input[_builtins.str] label: A unique, user-defined string referring to the Managed Database.
        :param pulumi.Input[_builtins.str] region: The region to use for the Managed Database.
        :param pulumi.Input[_builtins.bool] suspended: Whether this Managed Database should be suspended.
        :param pulumi.Input[_builtins.str] type: The Linode Instance type used for the nodes of the Managed Database.
               
               - - -
        :param pulumi.Input[Union['DatabasePostgresqlV2UpdatesArgs', 'DatabasePostgresqlV2UpdatesArgsDict']] updates: Configuration settings for automated patch update maintenance for the Managed Database.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabasePostgresqlV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Linode PostgreSQL Database resource. This can be used to create, modify, and delete Linode PostgreSQL Databases.
        For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/post-databases-postgre-sql-instances).

        Please keep in mind that Managed Databases can take up to half an hour to provision.

        ## Example Usage

        Creating a simple PostgreSQL database that does not allow connections:

        ```python
        import pulumi
        import pulumi_linode as linode

        foobar = linode.DatabasePostgresqlV2("foobar",
            label="mydatabase",
            engine_id="postgresql/16",
            region="us-mia",
            type="g6-nanode-1")
        ```

        Creating a simple PostgreSQL database that allows connections from all IPv4 addresses:

        ```python
        import pulumi
        import pulumi_linode as linode

        foobar = linode.DatabasePostgresqlV2("foobar",
            label="mydatabase",
            engine_id="postgresql/16",
            region="us-mia",
            type="g6-nanode-1",
            allow_lists=["0.0.0.0/0"])
        ```

        Creating a complex PostgreSQL database:

        ## Import

        Linode PostgreSQL Databases can be imported using the `id`, e.g.

        ```sh
        $ pulumi import linode:index/databasePostgresqlV2:DatabasePostgresqlV2 foobar 1234567
        ```

        :param str resource_name: The name of the resource.
        :param DatabasePostgresqlV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabasePostgresqlV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cluster_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_autovacuum_analyze_scale_factor: Optional[pulumi.Input[_builtins.float]] = None,
                 engine_config_pg_autovacuum_analyze_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_autovacuum_max_workers: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_autovacuum_naptime: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_autovacuum_vacuum_cost_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_autovacuum_vacuum_cost_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_autovacuum_vacuum_scale_factor: Optional[pulumi.Input[_builtins.float]] = None,
                 engine_config_pg_autovacuum_vacuum_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_bgwriter_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_bgwriter_flush_after: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_bgwriter_lru_maxpages: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_bgwriter_lru_multiplier: Optional[pulumi.Input[_builtins.float]] = None,
                 engine_config_pg_deadlock_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_default_toast_compression: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_pg_idle_in_transaction_session_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_jit: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine_config_pg_max_files_per_process: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_locks_per_transaction: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_logical_replication_workers: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_parallel_workers: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_parallel_workers_per_gather: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_pred_locks_per_transaction: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_replication_slots: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_slot_wal_keep_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_stack_depth: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_standby_archive_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_standby_streaming_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_wal_senders: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_max_worker_processes: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_password_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_pg_pg_partman_bgw_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_pg_partman_bgw_role: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_pg_pg_stat_monitor_pgsm_enable_query_plan: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine_config_pg_pg_stat_monitor_pgsm_max_buckets: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_pg_stat_statements_track: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_pg_stat_monitor_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine_config_pg_temp_file_limit: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_timezone: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_pg_track_activity_query_size: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_track_commit_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_pg_track_functions: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_pg_track_io_timing: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_config_pg_wal_sender_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pg_wal_writer_delay: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_pglookout_max_failover_replication_time_lag: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_config_shared_buffers_percentage: Optional[pulumi.Input[_builtins.float]] = None,
                 engine_config_work_mem: Optional[pulumi.Input[_builtins.int]] = None,
                 engine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fork_restore_time: Optional[pulumi.Input[_builtins.str]] = None,
                 fork_source: Optional[pulumi.Input[_builtins.int]] = None,
                 label: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 suspended: Optional[pulumi.Input[_builtins.bool]] = None,
                 timeouts: Optional[pulumi.Input[Union['DatabasePostgresqlV2TimeoutsArgs', 'DatabasePostgresqlV2TimeoutsArgsDict']]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 updates: Optional[pulumi.Input[Union['DatabasePostgresqlV2UpdatesArgs', 'DatabasePostgresqlV2UpdatesArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabasePostgresqlV2Args.__new__(DatabasePostgresqlV2Args)

            __props__.__dict__["allow_lists"] = allow_lists
            __props__.__dict__["cluster_size"] = cluster_size
            __props__.__dict__["engine_config_pg_autovacuum_analyze_scale_factor"] = engine_config_pg_autovacuum_analyze_scale_factor
            __props__.__dict__["engine_config_pg_autovacuum_analyze_threshold"] = engine_config_pg_autovacuum_analyze_threshold
            __props__.__dict__["engine_config_pg_autovacuum_max_workers"] = engine_config_pg_autovacuum_max_workers
            __props__.__dict__["engine_config_pg_autovacuum_naptime"] = engine_config_pg_autovacuum_naptime
            __props__.__dict__["engine_config_pg_autovacuum_vacuum_cost_delay"] = engine_config_pg_autovacuum_vacuum_cost_delay
            __props__.__dict__["engine_config_pg_autovacuum_vacuum_cost_limit"] = engine_config_pg_autovacuum_vacuum_cost_limit
            __props__.__dict__["engine_config_pg_autovacuum_vacuum_scale_factor"] = engine_config_pg_autovacuum_vacuum_scale_factor
            __props__.__dict__["engine_config_pg_autovacuum_vacuum_threshold"] = engine_config_pg_autovacuum_vacuum_threshold
            __props__.__dict__["engine_config_pg_bgwriter_delay"] = engine_config_pg_bgwriter_delay
            __props__.__dict__["engine_config_pg_bgwriter_flush_after"] = engine_config_pg_bgwriter_flush_after
            __props__.__dict__["engine_config_pg_bgwriter_lru_maxpages"] = engine_config_pg_bgwriter_lru_maxpages
            __props__.__dict__["engine_config_pg_bgwriter_lru_multiplier"] = engine_config_pg_bgwriter_lru_multiplier
            __props__.__dict__["engine_config_pg_deadlock_timeout"] = engine_config_pg_deadlock_timeout
            __props__.__dict__["engine_config_pg_default_toast_compression"] = engine_config_pg_default_toast_compression
            __props__.__dict__["engine_config_pg_idle_in_transaction_session_timeout"] = engine_config_pg_idle_in_transaction_session_timeout
            __props__.__dict__["engine_config_pg_jit"] = engine_config_pg_jit
            __props__.__dict__["engine_config_pg_max_files_per_process"] = engine_config_pg_max_files_per_process
            __props__.__dict__["engine_config_pg_max_locks_per_transaction"] = engine_config_pg_max_locks_per_transaction
            __props__.__dict__["engine_config_pg_max_logical_replication_workers"] = engine_config_pg_max_logical_replication_workers
            __props__.__dict__["engine_config_pg_max_parallel_workers"] = engine_config_pg_max_parallel_workers
            __props__.__dict__["engine_config_pg_max_parallel_workers_per_gather"] = engine_config_pg_max_parallel_workers_per_gather
            __props__.__dict__["engine_config_pg_max_pred_locks_per_transaction"] = engine_config_pg_max_pred_locks_per_transaction
            __props__.__dict__["engine_config_pg_max_replication_slots"] = engine_config_pg_max_replication_slots
            __props__.__dict__["engine_config_pg_max_slot_wal_keep_size"] = engine_config_pg_max_slot_wal_keep_size
            __props__.__dict__["engine_config_pg_max_stack_depth"] = engine_config_pg_max_stack_depth
            __props__.__dict__["engine_config_pg_max_standby_archive_delay"] = engine_config_pg_max_standby_archive_delay
            __props__.__dict__["engine_config_pg_max_standby_streaming_delay"] = engine_config_pg_max_standby_streaming_delay
            __props__.__dict__["engine_config_pg_max_wal_senders"] = engine_config_pg_max_wal_senders
            __props__.__dict__["engine_config_pg_max_worker_processes"] = engine_config_pg_max_worker_processes
            __props__.__dict__["engine_config_pg_password_encryption"] = engine_config_pg_password_encryption
            __props__.__dict__["engine_config_pg_pg_partman_bgw_interval"] = engine_config_pg_pg_partman_bgw_interval
            __props__.__dict__["engine_config_pg_pg_partman_bgw_role"] = engine_config_pg_pg_partman_bgw_role
            __props__.__dict__["engine_config_pg_pg_stat_monitor_pgsm_enable_query_plan"] = engine_config_pg_pg_stat_monitor_pgsm_enable_query_plan
            __props__.__dict__["engine_config_pg_pg_stat_monitor_pgsm_max_buckets"] = engine_config_pg_pg_stat_monitor_pgsm_max_buckets
            __props__.__dict__["engine_config_pg_pg_stat_statements_track"] = engine_config_pg_pg_stat_statements_track
            __props__.__dict__["engine_config_pg_stat_monitor_enable"] = engine_config_pg_stat_monitor_enable
            __props__.__dict__["engine_config_pg_temp_file_limit"] = engine_config_pg_temp_file_limit
            __props__.__dict__["engine_config_pg_timezone"] = engine_config_pg_timezone
            __props__.__dict__["engine_config_pg_track_activity_query_size"] = engine_config_pg_track_activity_query_size
            __props__.__dict__["engine_config_pg_track_commit_timestamp"] = engine_config_pg_track_commit_timestamp
            __props__.__dict__["engine_config_pg_track_functions"] = engine_config_pg_track_functions
            __props__.__dict__["engine_config_pg_track_io_timing"] = engine_config_pg_track_io_timing
            __props__.__dict__["engine_config_pg_wal_sender_timeout"] = engine_config_pg_wal_sender_timeout
            __props__.__dict__["engine_config_pg_wal_writer_delay"] = engine_config_pg_wal_writer_delay
            __props__.__dict__["engine_config_pglookout_max_failover_replication_time_lag"] = engine_config_pglookout_max_failover_replication_time_lag
            __props__.__dict__["engine_config_shared_buffers_percentage"] = engine_config_shared_buffers_percentage
            __props__.__dict__["engine_config_work_mem"] = engine_config_work_mem
            if engine_id is None and not opts.urn:
                raise TypeError("Missing required property 'engine_id'")
            __props__.__dict__["engine_id"] = engine_id
            __props__.__dict__["fork_restore_time"] = fork_restore_time
            __props__.__dict__["fork_source"] = fork_source
            if label is None and not opts.urn:
                raise TypeError("Missing required property 'label'")
            __props__.__dict__["label"] = label
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["suspended"] = suspended
            __props__.__dict__["timeouts"] = timeouts
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["updates"] = updates
            __props__.__dict__["ca_cert"] = None
            __props__.__dict__["created"] = None
            __props__.__dict__["encrypted"] = None
            __props__.__dict__["engine"] = None
            __props__.__dict__["host_primary"] = None
            __props__.__dict__["host_secondary"] = None
            __props__.__dict__["members"] = None
            __props__.__dict__["oldest_restore_time"] = None
            __props__.__dict__["pending_updates"] = None
            __props__.__dict__["platform"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["root_password"] = None
            __props__.__dict__["root_username"] = None
            __props__.__dict__["ssl_connection"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated"] = None
            __props__.__dict__["version"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["caCert", "rootPassword", "rootUsername"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(DatabasePostgresqlV2, __self__).__init__(
            'linode:index/databasePostgresqlV2:DatabasePostgresqlV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ca_cert: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_size: Optional[pulumi.Input[_builtins.int]] = None,
            created: Optional[pulumi.Input[_builtins.str]] = None,
            encrypted: Optional[pulumi.Input[_builtins.bool]] = None,
            engine: Optional[pulumi.Input[_builtins.str]] = None,
            engine_config_pg_autovacuum_analyze_scale_factor: Optional[pulumi.Input[_builtins.float]] = None,
            engine_config_pg_autovacuum_analyze_threshold: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_pg_autovacuum_max_workers: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_pg_autovacuum_naptime: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_pg_autovacuum_vacuum_cost_delay: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_pg_autovacuum_vacuum_cost_limit: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_pg_autovacuum_vacuum_scale_factor: Optional[pulumi.Input[_builtins.float]] = None,
            engine_config_pg_autovacuum_vacuum_threshold: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_pg_bgwriter_delay: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_pg_bgwriter_flush_after: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_pg_bgwriter_lru_maxpages: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_pg_bgwriter_lru_multiplier: Optional[pulumi.Input[_builtins.float]] = None,
            engine_config_pg_deadlock_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_pg_default_toast_compression: Optional[pulumi.Input[_builtins.str]] = None,
            engine_config_pg_idle_in_transaction_session_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_pg_jit: Optional[pulumi.Input[_builtins.bool]] = None,
            engine_config_pg_max_files_per_process: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_pg_max_locks_per_transaction: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_pg_max_logical_replication_workers: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_pg_max_parallel_workers: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_pg_max_parallel_workers_per_gather: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_pg_max_pred_locks_per_transaction: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_pg_max_replication_slots: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_pg_max_slot_wal_keep_size: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_pg_max_stack_depth: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_pg_max_standby_archive_delay: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_pg_max_standby_streaming_delay: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_pg_max_wal_senders: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_pg_max_worker_processes: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_pg_password_encryption: Optional[pulumi.Input[_builtins.str]] = None,
            engine_config_pg_pg_partman_bgw_interval: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_pg_pg_partman_bgw_role: Optional[pulumi.Input[_builtins.str]] = None,
            engine_config_pg_pg_stat_monitor_pgsm_enable_query_plan: Optional[pulumi.Input[_builtins.bool]] = None,
            engine_config_pg_pg_stat_monitor_pgsm_max_buckets: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_pg_pg_stat_statements_track: Optional[pulumi.Input[_builtins.str]] = None,
            engine_config_pg_stat_monitor_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            engine_config_pg_temp_file_limit: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_pg_timezone: Optional[pulumi.Input[_builtins.str]] = None,
            engine_config_pg_track_activity_query_size: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_pg_track_commit_timestamp: Optional[pulumi.Input[_builtins.str]] = None,
            engine_config_pg_track_functions: Optional[pulumi.Input[_builtins.str]] = None,
            engine_config_pg_track_io_timing: Optional[pulumi.Input[_builtins.str]] = None,
            engine_config_pg_wal_sender_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_pg_wal_writer_delay: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_pglookout_max_failover_replication_time_lag: Optional[pulumi.Input[_builtins.int]] = None,
            engine_config_shared_buffers_percentage: Optional[pulumi.Input[_builtins.float]] = None,
            engine_config_work_mem: Optional[pulumi.Input[_builtins.int]] = None,
            engine_id: Optional[pulumi.Input[_builtins.str]] = None,
            fork_restore_time: Optional[pulumi.Input[_builtins.str]] = None,
            fork_source: Optional[pulumi.Input[_builtins.int]] = None,
            host_primary: Optional[pulumi.Input[_builtins.str]] = None,
            host_secondary: Optional[pulumi.Input[_builtins.str]] = None,
            label: Optional[pulumi.Input[_builtins.str]] = None,
            members: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            oldest_restore_time: Optional[pulumi.Input[_builtins.str]] = None,
            pending_updates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatabasePostgresqlV2PendingUpdateArgs', 'DatabasePostgresqlV2PendingUpdateArgsDict']]]]] = None,
            platform: Optional[pulumi.Input[_builtins.str]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            root_password: Optional[pulumi.Input[_builtins.str]] = None,
            root_username: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_connection: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            suspended: Optional[pulumi.Input[_builtins.bool]] = None,
            timeouts: Optional[pulumi.Input[Union['DatabasePostgresqlV2TimeoutsArgs', 'DatabasePostgresqlV2TimeoutsArgsDict']]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            updated: Optional[pulumi.Input[_builtins.str]] = None,
            updates: Optional[pulumi.Input[Union['DatabasePostgresqlV2UpdatesArgs', 'DatabasePostgresqlV2UpdatesArgsDict']]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'DatabasePostgresqlV2':
        """
        Get an existing DatabasePostgresqlV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allow_lists: A list of IP addresses that can access the Managed Database. Each item can be a single IP address or a range in CIDR format. Use `DatabaseAccessControls` to manage your allow list separately.
        :param pulumi.Input[_builtins.str] ca_cert: The base64-encoded SSL CA certificate for the Managed Database.
        :param pulumi.Input[_builtins.int] cluster_size: The number of Linode Instance nodes deployed to the Managed Database. (default `1`)
        :param pulumi.Input[_builtins.str] created: When this Managed Database was created.
        :param pulumi.Input[_builtins.bool] encrypted: Whether the Managed Databases is encrypted.
        :param pulumi.Input[_builtins.str] engine: The Managed Database engine. (e.g. `postgresql`)
        :param pulumi.Input[_builtins.float] engine_config_pg_autovacuum_analyze_scale_factor: Specifies a fraction of the table size to add to autovacuum_analyze_threshold when deciding whether to trigger an ANALYZE. The default is 0.2 (20% of table size)
        :param pulumi.Input[_builtins.int] engine_config_pg_autovacuum_analyze_threshold: Specifies the minimum number of inserted, updated or deleted tuples needed to trigger an ANALYZE in any one table. The default is 50 tuples.
        :param pulumi.Input[_builtins.int] engine_config_pg_autovacuum_max_workers: Specifies the maximum number of autovacuum processes (other than the autovacuum launcher) that may be running at any one time. The default is three. This parameter can only be set at server start.
        :param pulumi.Input[_builtins.int] engine_config_pg_autovacuum_naptime: Specifies the minimum delay between autovacuum runs on any given database. The delay is measured in seconds, and the default is one minute
        :param pulumi.Input[_builtins.int] engine_config_pg_autovacuum_vacuum_cost_delay: Specifies the cost delay value that will be used in automatic VACUUM operations. If -1 is specified, the regular vacuum_cost_delay value will be used. The default value is 20 milliseconds
        :param pulumi.Input[_builtins.int] engine_config_pg_autovacuum_vacuum_cost_limit: Specifies the cost limit value that will be used in automatic VACUUM operations. If -1 is specified (which is the default), the regular vacuum_cost_limit value will be used.
        :param pulumi.Input[_builtins.float] engine_config_pg_autovacuum_vacuum_scale_factor: Specifies a fraction of the table size to add to autovacuum_vacuum_threshold when deciding whether to trigger a VACUUM. The default is 0.2 (20% of table size)
        :param pulumi.Input[_builtins.int] engine_config_pg_autovacuum_vacuum_threshold: Specifies the minimum number of updated or deleted tuples needed to trigger a VACUUM in any one table. The default is 50 tuples.
        :param pulumi.Input[_builtins.int] engine_config_pg_bgwriter_delay: Specifies the delay between activity rounds for the background writer in milliseconds. Default is 200.
        :param pulumi.Input[_builtins.int] engine_config_pg_bgwriter_flush_after: Whenever more than bgwriter_flush_after bytes have been written by the background writer, attempt to force the OS to issue these writes to the underlying storage. Specified in kilobytes, default is 512. Setting of 0 disables forced writeback.
        :param pulumi.Input[_builtins.int] engine_config_pg_bgwriter_lru_maxpages: In each round, no more than this many buffers will be written by the background writer. Setting this to zero disables background writing. Default is 100.
        :param pulumi.Input[_builtins.float] engine_config_pg_bgwriter_lru_multiplier: The average recent need for new buffers is multiplied by bgwriter_lru_multiplier to arrive at an estimate of the number that will be needed during the next round, (up to bgwriter_lru_maxpages). 1.0 represents a “just in time” policy of writing exactly the number of buffers predicted to be needed. Larger values provide some cushion against spikes in demand, while smaller values intentionally leave writes to be done by server processes. The default is 2.0.
        :param pulumi.Input[_builtins.int] engine_config_pg_deadlock_timeout: This is the amount of time, in milliseconds, to wait on a lock before checking to see if there is a deadlock condition.
        :param pulumi.Input[_builtins.str] engine_config_pg_default_toast_compression: Specifies the default TOAST compression method for values of compressible columns (the default is lz4).
        :param pulumi.Input[_builtins.int] engine_config_pg_idle_in_transaction_session_timeout: Time out sessions with open transactions after this number of milliseconds.
        :param pulumi.Input[_builtins.bool] engine_config_pg_jit: Controls system-wide use of Just-in-Time Compilation (JIT).
        :param pulumi.Input[_builtins.int] engine_config_pg_max_files_per_process: PostgreSQL maximum number of files that can be open per process.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_locks_per_transaction: PostgreSQL maximum locks per transaction.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_logical_replication_workers: PostgreSQL maximum logical replication workers (taken from the pool of max_parallel_workers).
        :param pulumi.Input[_builtins.int] engine_config_pg_max_parallel_workers: Sets the maximum number of workers that the system can support for parallel queries.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_parallel_workers_per_gather: Sets the maximum number of workers that can be started by a single Gather or Gather Merge node.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_pred_locks_per_transaction: PostgreSQL maximum predicate locks per transaction.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_replication_slots: PostgreSQL maximum replication slots.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_slot_wal_keep_size: PostgreSQL maximum WAL size (MB) reserved for replication slots. Default is -1 (unlimited). wal_keep_size minimum WAL size setting takes precedence over this.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_stack_depth: Maximum depth of the stack in bytes.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_standby_archive_delay: Max standby archive delay in milliseconds.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_standby_streaming_delay: Max standby streaming delay in milliseconds.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_wal_senders: PostgreSQL maximum WAL senders.
        :param pulumi.Input[_builtins.int] engine_config_pg_max_worker_processes: Sets the maximum number of background processes that the system can support.
        :param pulumi.Input[_builtins.str] engine_config_pg_password_encryption: Chooses the algorithm for encrypting passwords. (default `md5`)
        :param pulumi.Input[_builtins.int] engine_config_pg_pg_partman_bgw_interval: Sets the time interval to run pg_partman's scheduled tasks.
        :param pulumi.Input[_builtins.str] engine_config_pg_pg_partman_bgw_role: Controls which role to use for pg_partman's scheduled background tasks.
        :param pulumi.Input[_builtins.bool] engine_config_pg_pg_stat_monitor_pgsm_enable_query_plan: Enables or disables query plan monitoring.
        :param pulumi.Input[_builtins.int] engine_config_pg_pg_stat_monitor_pgsm_max_buckets: Sets the maximum number of buckets.
        :param pulumi.Input[_builtins.str] engine_config_pg_pg_stat_statements_track: Controls which statements are counted. Specify top to track top-level statements (those issued directly by clients), all to also track nested statements (such as statements invoked within functions), or none to disable statement statistics collection. The default value is top.
        :param pulumi.Input[_builtins.bool] engine_config_pg_stat_monitor_enable: Enable the pg_stat_monitor extension. Enabling this extension will cause the cluster to be restarted. When this extension is enabled, pg_stat_statements results for utility commands are unreliable. (default `false`)
        :param pulumi.Input[_builtins.int] engine_config_pg_temp_file_limit: PostgreSQL temporary file limit in KiB, -1 for unlimited.
        :param pulumi.Input[_builtins.str] engine_config_pg_timezone: PostgreSQL service timezone.
        :param pulumi.Input[_builtins.int] engine_config_pg_track_activity_query_size: Specifies the number of bytes reserved to track the currently executing command for each active session.
        :param pulumi.Input[_builtins.str] engine_config_pg_track_commit_timestamp: Record commit time of transactions.
        :param pulumi.Input[_builtins.str] engine_config_pg_track_functions: Enables tracking of function call counts and time used.
        :param pulumi.Input[_builtins.str] engine_config_pg_track_io_timing: Enables timing of database I/O calls. This parameter is off by default, because it will repeatedly query the operating system for the current time, which may cause significant overhead on some platforms.
        :param pulumi.Input[_builtins.int] engine_config_pg_wal_sender_timeout: Terminate replication connections that are inactive for longer than this amount of time, in milliseconds. Setting this value to zero disables the timeout.
        :param pulumi.Input[_builtins.int] engine_config_pg_wal_writer_delay: WAL flush interval in milliseconds. Note that setting this value to lower than the default 200ms may negatively impact performance.
        :param pulumi.Input[_builtins.int] engine_config_pglookout_max_failover_replication_time_lag: Number of seconds of master unavailability before triggering database failover to standby. (default `60`)
        :param pulumi.Input[_builtins.float] engine_config_shared_buffers_percentage: Percentage of total RAM that the database server uses for shared memory buffers. Valid range is 20-60 (float), which corresponds to 20% - 60%. This setting adjusts the shared_buffers configuration value.
        :param pulumi.Input[_builtins.int] engine_config_work_mem: Sets the maximum amount of memory to be used by a query operation (such as a sort or hash table) before writing to temporary disk files, in MB. Default is 1MB + 0.075% of total RAM (up to 32MB).
        :param pulumi.Input[_builtins.str] engine_id: The Managed Database engine in engine/version format. (e.g. `postgresql/16`)
        :param pulumi.Input[_builtins.str] fork_restore_time: The database timestamp from which it was restored.
        :param pulumi.Input[_builtins.int] fork_source: The ID of the database that was forked from.
               
               * `updates` - (Optional) Configuration settings for automated patch update maintenance for the Managed Database.
        :param pulumi.Input[_builtins.str] host_primary: The primary host for the Managed Database.
        :param pulumi.Input[_builtins.str] host_secondary: The secondary/private host for the managed database.
        :param pulumi.Input[_builtins.str] label: A unique, user-defined string referring to the Managed Database.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] members: A mapping between IP addresses and strings designating them as primary or failover.
        :param pulumi.Input[_builtins.str] oldest_restore_time: The oldest time to which a database can be restored.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatabasePostgresqlV2PendingUpdateArgs', 'DatabasePostgresqlV2PendingUpdateArgsDict']]]] pending_updates: A set of pending updates.
        :param pulumi.Input[_builtins.str] platform: The back-end platform for relational databases used by the service.
        :param pulumi.Input[_builtins.int] port: The access port for this Managed Database.
        :param pulumi.Input[_builtins.str] region: The region to use for the Managed Database.
        :param pulumi.Input[_builtins.str] root_password: The randomly-generated root password for the Managed Database instance.
        :param pulumi.Input[_builtins.str] root_username: The root username for the Managed Database instance.
        :param pulumi.Input[_builtins.bool] ssl_connection: Whether to require SSL credentials to establish a connection to the Managed Database.
        :param pulumi.Input[_builtins.str] status: The operating status of the Managed Database.
        :param pulumi.Input[_builtins.bool] suspended: Whether this Managed Database should be suspended.
        :param pulumi.Input[_builtins.str] type: The Linode Instance type used for the nodes of the Managed Database.
               
               - - -
        :param pulumi.Input[_builtins.str] updated: When this Managed Database was last updated.
        :param pulumi.Input[Union['DatabasePostgresqlV2UpdatesArgs', 'DatabasePostgresqlV2UpdatesArgsDict']] updates: Configuration settings for automated patch update maintenance for the Managed Database.
        :param pulumi.Input[_builtins.str] version: The Managed Database engine version. (e.g. `13.2`)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabasePostgresqlV2State.__new__(_DatabasePostgresqlV2State)

        __props__.__dict__["allow_lists"] = allow_lists
        __props__.__dict__["ca_cert"] = ca_cert
        __props__.__dict__["cluster_size"] = cluster_size
        __props__.__dict__["created"] = created
        __props__.__dict__["encrypted"] = encrypted
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_config_pg_autovacuum_analyze_scale_factor"] = engine_config_pg_autovacuum_analyze_scale_factor
        __props__.__dict__["engine_config_pg_autovacuum_analyze_threshold"] = engine_config_pg_autovacuum_analyze_threshold
        __props__.__dict__["engine_config_pg_autovacuum_max_workers"] = engine_config_pg_autovacuum_max_workers
        __props__.__dict__["engine_config_pg_autovacuum_naptime"] = engine_config_pg_autovacuum_naptime
        __props__.__dict__["engine_config_pg_autovacuum_vacuum_cost_delay"] = engine_config_pg_autovacuum_vacuum_cost_delay
        __props__.__dict__["engine_config_pg_autovacuum_vacuum_cost_limit"] = engine_config_pg_autovacuum_vacuum_cost_limit
        __props__.__dict__["engine_config_pg_autovacuum_vacuum_scale_factor"] = engine_config_pg_autovacuum_vacuum_scale_factor
        __props__.__dict__["engine_config_pg_autovacuum_vacuum_threshold"] = engine_config_pg_autovacuum_vacuum_threshold
        __props__.__dict__["engine_config_pg_bgwriter_delay"] = engine_config_pg_bgwriter_delay
        __props__.__dict__["engine_config_pg_bgwriter_flush_after"] = engine_config_pg_bgwriter_flush_after
        __props__.__dict__["engine_config_pg_bgwriter_lru_maxpages"] = engine_config_pg_bgwriter_lru_maxpages
        __props__.__dict__["engine_config_pg_bgwriter_lru_multiplier"] = engine_config_pg_bgwriter_lru_multiplier
        __props__.__dict__["engine_config_pg_deadlock_timeout"] = engine_config_pg_deadlock_timeout
        __props__.__dict__["engine_config_pg_default_toast_compression"] = engine_config_pg_default_toast_compression
        __props__.__dict__["engine_config_pg_idle_in_transaction_session_timeout"] = engine_config_pg_idle_in_transaction_session_timeout
        __props__.__dict__["engine_config_pg_jit"] = engine_config_pg_jit
        __props__.__dict__["engine_config_pg_max_files_per_process"] = engine_config_pg_max_files_per_process
        __props__.__dict__["engine_config_pg_max_locks_per_transaction"] = engine_config_pg_max_locks_per_transaction
        __props__.__dict__["engine_config_pg_max_logical_replication_workers"] = engine_config_pg_max_logical_replication_workers
        __props__.__dict__["engine_config_pg_max_parallel_workers"] = engine_config_pg_max_parallel_workers
        __props__.__dict__["engine_config_pg_max_parallel_workers_per_gather"] = engine_config_pg_max_parallel_workers_per_gather
        __props__.__dict__["engine_config_pg_max_pred_locks_per_transaction"] = engine_config_pg_max_pred_locks_per_transaction
        __props__.__dict__["engine_config_pg_max_replication_slots"] = engine_config_pg_max_replication_slots
        __props__.__dict__["engine_config_pg_max_slot_wal_keep_size"] = engine_config_pg_max_slot_wal_keep_size
        __props__.__dict__["engine_config_pg_max_stack_depth"] = engine_config_pg_max_stack_depth
        __props__.__dict__["engine_config_pg_max_standby_archive_delay"] = engine_config_pg_max_standby_archive_delay
        __props__.__dict__["engine_config_pg_max_standby_streaming_delay"] = engine_config_pg_max_standby_streaming_delay
        __props__.__dict__["engine_config_pg_max_wal_senders"] = engine_config_pg_max_wal_senders
        __props__.__dict__["engine_config_pg_max_worker_processes"] = engine_config_pg_max_worker_processes
        __props__.__dict__["engine_config_pg_password_encryption"] = engine_config_pg_password_encryption
        __props__.__dict__["engine_config_pg_pg_partman_bgw_interval"] = engine_config_pg_pg_partman_bgw_interval
        __props__.__dict__["engine_config_pg_pg_partman_bgw_role"] = engine_config_pg_pg_partman_bgw_role
        __props__.__dict__["engine_config_pg_pg_stat_monitor_pgsm_enable_query_plan"] = engine_config_pg_pg_stat_monitor_pgsm_enable_query_plan
        __props__.__dict__["engine_config_pg_pg_stat_monitor_pgsm_max_buckets"] = engine_config_pg_pg_stat_monitor_pgsm_max_buckets
        __props__.__dict__["engine_config_pg_pg_stat_statements_track"] = engine_config_pg_pg_stat_statements_track
        __props__.__dict__["engine_config_pg_stat_monitor_enable"] = engine_config_pg_stat_monitor_enable
        __props__.__dict__["engine_config_pg_temp_file_limit"] = engine_config_pg_temp_file_limit
        __props__.__dict__["engine_config_pg_timezone"] = engine_config_pg_timezone
        __props__.__dict__["engine_config_pg_track_activity_query_size"] = engine_config_pg_track_activity_query_size
        __props__.__dict__["engine_config_pg_track_commit_timestamp"] = engine_config_pg_track_commit_timestamp
        __props__.__dict__["engine_config_pg_track_functions"] = engine_config_pg_track_functions
        __props__.__dict__["engine_config_pg_track_io_timing"] = engine_config_pg_track_io_timing
        __props__.__dict__["engine_config_pg_wal_sender_timeout"] = engine_config_pg_wal_sender_timeout
        __props__.__dict__["engine_config_pg_wal_writer_delay"] = engine_config_pg_wal_writer_delay
        __props__.__dict__["engine_config_pglookout_max_failover_replication_time_lag"] = engine_config_pglookout_max_failover_replication_time_lag
        __props__.__dict__["engine_config_shared_buffers_percentage"] = engine_config_shared_buffers_percentage
        __props__.__dict__["engine_config_work_mem"] = engine_config_work_mem
        __props__.__dict__["engine_id"] = engine_id
        __props__.__dict__["fork_restore_time"] = fork_restore_time
        __props__.__dict__["fork_source"] = fork_source
        __props__.__dict__["host_primary"] = host_primary
        __props__.__dict__["host_secondary"] = host_secondary
        __props__.__dict__["label"] = label
        __props__.__dict__["members"] = members
        __props__.__dict__["oldest_restore_time"] = oldest_restore_time
        __props__.__dict__["pending_updates"] = pending_updates
        __props__.__dict__["platform"] = platform
        __props__.__dict__["port"] = port
        __props__.__dict__["region"] = region
        __props__.__dict__["root_password"] = root_password
        __props__.__dict__["root_username"] = root_username
        __props__.__dict__["ssl_connection"] = ssl_connection
        __props__.__dict__["status"] = status
        __props__.__dict__["suspended"] = suspended
        __props__.__dict__["timeouts"] = timeouts
        __props__.__dict__["type"] = type
        __props__.__dict__["updated"] = updated
        __props__.__dict__["updates"] = updates
        __props__.__dict__["version"] = version
        return DatabasePostgresqlV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowLists")
    def allow_lists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of IP addresses that can access the Managed Database. Each item can be a single IP address or a range in CIDR format. Use `DatabaseAccessControls` to manage your allow list separately.
        """
        return pulumi.get(self, "allow_lists")

    @_builtins.property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> pulumi.Output[_builtins.str]:
        """
        The base64-encoded SSL CA certificate for the Managed Database.
        """
        return pulumi.get(self, "ca_cert")

    @_builtins.property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> pulumi.Output[_builtins.int]:
        """
        The number of Linode Instance nodes deployed to the Managed Database. (default `1`)
        """
        return pulumi.get(self, "cluster_size")

    @_builtins.property
    @pulumi.getter
    def created(self) -> pulumi.Output[_builtins.str]:
        """
        When this Managed Database was created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def encrypted(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the Managed Databases is encrypted.
        """
        return pulumi.get(self, "encrypted")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> pulumi.Output[_builtins.str]:
        """
        The Managed Database engine. (e.g. `postgresql`)
        """
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgAutovacuumAnalyzeScaleFactor")
    def engine_config_pg_autovacuum_analyze_scale_factor(self) -> pulumi.Output[_builtins.float]:
        """
        Specifies a fraction of the table size to add to autovacuum_analyze_threshold when deciding whether to trigger an ANALYZE. The default is 0.2 (20% of table size)
        """
        return pulumi.get(self, "engine_config_pg_autovacuum_analyze_scale_factor")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgAutovacuumAnalyzeThreshold")
    def engine_config_pg_autovacuum_analyze_threshold(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the minimum number of inserted, updated or deleted tuples needed to trigger an ANALYZE in any one table. The default is 50 tuples.
        """
        return pulumi.get(self, "engine_config_pg_autovacuum_analyze_threshold")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgAutovacuumMaxWorkers")
    def engine_config_pg_autovacuum_max_workers(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the maximum number of autovacuum processes (other than the autovacuum launcher) that may be running at any one time. The default is three. This parameter can only be set at server start.
        """
        return pulumi.get(self, "engine_config_pg_autovacuum_max_workers")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgAutovacuumNaptime")
    def engine_config_pg_autovacuum_naptime(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the minimum delay between autovacuum runs on any given database. The delay is measured in seconds, and the default is one minute
        """
        return pulumi.get(self, "engine_config_pg_autovacuum_naptime")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgAutovacuumVacuumCostDelay")
    def engine_config_pg_autovacuum_vacuum_cost_delay(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the cost delay value that will be used in automatic VACUUM operations. If -1 is specified, the regular vacuum_cost_delay value will be used. The default value is 20 milliseconds
        """
        return pulumi.get(self, "engine_config_pg_autovacuum_vacuum_cost_delay")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgAutovacuumVacuumCostLimit")
    def engine_config_pg_autovacuum_vacuum_cost_limit(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the cost limit value that will be used in automatic VACUUM operations. If -1 is specified (which is the default), the regular vacuum_cost_limit value will be used.
        """
        return pulumi.get(self, "engine_config_pg_autovacuum_vacuum_cost_limit")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgAutovacuumVacuumScaleFactor")
    def engine_config_pg_autovacuum_vacuum_scale_factor(self) -> pulumi.Output[_builtins.float]:
        """
        Specifies a fraction of the table size to add to autovacuum_vacuum_threshold when deciding whether to trigger a VACUUM. The default is 0.2 (20% of table size)
        """
        return pulumi.get(self, "engine_config_pg_autovacuum_vacuum_scale_factor")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgAutovacuumVacuumThreshold")
    def engine_config_pg_autovacuum_vacuum_threshold(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the minimum number of updated or deleted tuples needed to trigger a VACUUM in any one table. The default is 50 tuples.
        """
        return pulumi.get(self, "engine_config_pg_autovacuum_vacuum_threshold")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgBgwriterDelay")
    def engine_config_pg_bgwriter_delay(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the delay between activity rounds for the background writer in milliseconds. Default is 200.
        """
        return pulumi.get(self, "engine_config_pg_bgwriter_delay")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgBgwriterFlushAfter")
    def engine_config_pg_bgwriter_flush_after(self) -> pulumi.Output[_builtins.int]:
        """
        Whenever more than bgwriter_flush_after bytes have been written by the background writer, attempt to force the OS to issue these writes to the underlying storage. Specified in kilobytes, default is 512. Setting of 0 disables forced writeback.
        """
        return pulumi.get(self, "engine_config_pg_bgwriter_flush_after")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgBgwriterLruMaxpages")
    def engine_config_pg_bgwriter_lru_maxpages(self) -> pulumi.Output[_builtins.int]:
        """
        In each round, no more than this many buffers will be written by the background writer. Setting this to zero disables background writing. Default is 100.
        """
        return pulumi.get(self, "engine_config_pg_bgwriter_lru_maxpages")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgBgwriterLruMultiplier")
    def engine_config_pg_bgwriter_lru_multiplier(self) -> pulumi.Output[_builtins.float]:
        """
        The average recent need for new buffers is multiplied by bgwriter_lru_multiplier to arrive at an estimate of the number that will be needed during the next round, (up to bgwriter_lru_maxpages). 1.0 represents a “just in time” policy of writing exactly the number of buffers predicted to be needed. Larger values provide some cushion against spikes in demand, while smaller values intentionally leave writes to be done by server processes. The default is 2.0.
        """
        return pulumi.get(self, "engine_config_pg_bgwriter_lru_multiplier")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgDeadlockTimeout")
    def engine_config_pg_deadlock_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        This is the amount of time, in milliseconds, to wait on a lock before checking to see if there is a deadlock condition.
        """
        return pulumi.get(self, "engine_config_pg_deadlock_timeout")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgDefaultToastCompression")
    def engine_config_pg_default_toast_compression(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the default TOAST compression method for values of compressible columns (the default is lz4).
        """
        return pulumi.get(self, "engine_config_pg_default_toast_compression")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgIdleInTransactionSessionTimeout")
    def engine_config_pg_idle_in_transaction_session_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        Time out sessions with open transactions after this number of milliseconds.
        """
        return pulumi.get(self, "engine_config_pg_idle_in_transaction_session_timeout")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgJit")
    def engine_config_pg_jit(self) -> pulumi.Output[_builtins.bool]:
        """
        Controls system-wide use of Just-in-Time Compilation (JIT).
        """
        return pulumi.get(self, "engine_config_pg_jit")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxFilesPerProcess")
    def engine_config_pg_max_files_per_process(self) -> pulumi.Output[_builtins.int]:
        """
        PostgreSQL maximum number of files that can be open per process.
        """
        return pulumi.get(self, "engine_config_pg_max_files_per_process")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxLocksPerTransaction")
    def engine_config_pg_max_locks_per_transaction(self) -> pulumi.Output[_builtins.int]:
        """
        PostgreSQL maximum locks per transaction.
        """
        return pulumi.get(self, "engine_config_pg_max_locks_per_transaction")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxLogicalReplicationWorkers")
    def engine_config_pg_max_logical_replication_workers(self) -> pulumi.Output[_builtins.int]:
        """
        PostgreSQL maximum logical replication workers (taken from the pool of max_parallel_workers).
        """
        return pulumi.get(self, "engine_config_pg_max_logical_replication_workers")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxParallelWorkers")
    def engine_config_pg_max_parallel_workers(self) -> pulumi.Output[_builtins.int]:
        """
        Sets the maximum number of workers that the system can support for parallel queries.
        """
        return pulumi.get(self, "engine_config_pg_max_parallel_workers")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxParallelWorkersPerGather")
    def engine_config_pg_max_parallel_workers_per_gather(self) -> pulumi.Output[_builtins.int]:
        """
        Sets the maximum number of workers that can be started by a single Gather or Gather Merge node.
        """
        return pulumi.get(self, "engine_config_pg_max_parallel_workers_per_gather")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxPredLocksPerTransaction")
    def engine_config_pg_max_pred_locks_per_transaction(self) -> pulumi.Output[_builtins.int]:
        """
        PostgreSQL maximum predicate locks per transaction.
        """
        return pulumi.get(self, "engine_config_pg_max_pred_locks_per_transaction")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxReplicationSlots")
    def engine_config_pg_max_replication_slots(self) -> pulumi.Output[_builtins.int]:
        """
        PostgreSQL maximum replication slots.
        """
        return pulumi.get(self, "engine_config_pg_max_replication_slots")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxSlotWalKeepSize")
    def engine_config_pg_max_slot_wal_keep_size(self) -> pulumi.Output[_builtins.int]:
        """
        PostgreSQL maximum WAL size (MB) reserved for replication slots. Default is -1 (unlimited). wal_keep_size minimum WAL size setting takes precedence over this.
        """
        return pulumi.get(self, "engine_config_pg_max_slot_wal_keep_size")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxStackDepth")
    def engine_config_pg_max_stack_depth(self) -> pulumi.Output[_builtins.int]:
        """
        Maximum depth of the stack in bytes.
        """
        return pulumi.get(self, "engine_config_pg_max_stack_depth")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxStandbyArchiveDelay")
    def engine_config_pg_max_standby_archive_delay(self) -> pulumi.Output[_builtins.int]:
        """
        Max standby archive delay in milliseconds.
        """
        return pulumi.get(self, "engine_config_pg_max_standby_archive_delay")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxStandbyStreamingDelay")
    def engine_config_pg_max_standby_streaming_delay(self) -> pulumi.Output[_builtins.int]:
        """
        Max standby streaming delay in milliseconds.
        """
        return pulumi.get(self, "engine_config_pg_max_standby_streaming_delay")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxWalSenders")
    def engine_config_pg_max_wal_senders(self) -> pulumi.Output[_builtins.int]:
        """
        PostgreSQL maximum WAL senders.
        """
        return pulumi.get(self, "engine_config_pg_max_wal_senders")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgMaxWorkerProcesses")
    def engine_config_pg_max_worker_processes(self) -> pulumi.Output[_builtins.int]:
        """
        Sets the maximum number of background processes that the system can support.
        """
        return pulumi.get(self, "engine_config_pg_max_worker_processes")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgPasswordEncryption")
    def engine_config_pg_password_encryption(self) -> pulumi.Output[_builtins.str]:
        """
        Chooses the algorithm for encrypting passwords. (default `md5`)
        """
        return pulumi.get(self, "engine_config_pg_password_encryption")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgPgPartmanBgwInterval")
    def engine_config_pg_pg_partman_bgw_interval(self) -> pulumi.Output[_builtins.int]:
        """
        Sets the time interval to run pg_partman's scheduled tasks.
        """
        return pulumi.get(self, "engine_config_pg_pg_partman_bgw_interval")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgPgPartmanBgwRole")
    def engine_config_pg_pg_partman_bgw_role(self) -> pulumi.Output[_builtins.str]:
        """
        Controls which role to use for pg_partman's scheduled background tasks.
        """
        return pulumi.get(self, "engine_config_pg_pg_partman_bgw_role")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgPgStatMonitorPgsmEnableQueryPlan")
    def engine_config_pg_pg_stat_monitor_pgsm_enable_query_plan(self) -> pulumi.Output[_builtins.bool]:
        """
        Enables or disables query plan monitoring.
        """
        return pulumi.get(self, "engine_config_pg_pg_stat_monitor_pgsm_enable_query_plan")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgPgStatMonitorPgsmMaxBuckets")
    def engine_config_pg_pg_stat_monitor_pgsm_max_buckets(self) -> pulumi.Output[_builtins.int]:
        """
        Sets the maximum number of buckets.
        """
        return pulumi.get(self, "engine_config_pg_pg_stat_monitor_pgsm_max_buckets")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgPgStatStatementsTrack")
    def engine_config_pg_pg_stat_statements_track(self) -> pulumi.Output[_builtins.str]:
        """
        Controls which statements are counted. Specify top to track top-level statements (those issued directly by clients), all to also track nested statements (such as statements invoked within functions), or none to disable statement statistics collection. The default value is top.
        """
        return pulumi.get(self, "engine_config_pg_pg_stat_statements_track")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgStatMonitorEnable")
    def engine_config_pg_stat_monitor_enable(self) -> pulumi.Output[_builtins.bool]:
        """
        Enable the pg_stat_monitor extension. Enabling this extension will cause the cluster to be restarted. When this extension is enabled, pg_stat_statements results for utility commands are unreliable. (default `false`)
        """
        return pulumi.get(self, "engine_config_pg_stat_monitor_enable")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgTempFileLimit")
    def engine_config_pg_temp_file_limit(self) -> pulumi.Output[_builtins.int]:
        """
        PostgreSQL temporary file limit in KiB, -1 for unlimited.
        """
        return pulumi.get(self, "engine_config_pg_temp_file_limit")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgTimezone")
    def engine_config_pg_timezone(self) -> pulumi.Output[_builtins.str]:
        """
        PostgreSQL service timezone.
        """
        return pulumi.get(self, "engine_config_pg_timezone")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgTrackActivityQuerySize")
    def engine_config_pg_track_activity_query_size(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the number of bytes reserved to track the currently executing command for each active session.
        """
        return pulumi.get(self, "engine_config_pg_track_activity_query_size")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgTrackCommitTimestamp")
    def engine_config_pg_track_commit_timestamp(self) -> pulumi.Output[_builtins.str]:
        """
        Record commit time of transactions.
        """
        return pulumi.get(self, "engine_config_pg_track_commit_timestamp")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgTrackFunctions")
    def engine_config_pg_track_functions(self) -> pulumi.Output[_builtins.str]:
        """
        Enables tracking of function call counts and time used.
        """
        return pulumi.get(self, "engine_config_pg_track_functions")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgTrackIoTiming")
    def engine_config_pg_track_io_timing(self) -> pulumi.Output[_builtins.str]:
        """
        Enables timing of database I/O calls. This parameter is off by default, because it will repeatedly query the operating system for the current time, which may cause significant overhead on some platforms.
        """
        return pulumi.get(self, "engine_config_pg_track_io_timing")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgWalSenderTimeout")
    def engine_config_pg_wal_sender_timeout(self) -> pulumi.Output[_builtins.int]:
        """
        Terminate replication connections that are inactive for longer than this amount of time, in milliseconds. Setting this value to zero disables the timeout.
        """
        return pulumi.get(self, "engine_config_pg_wal_sender_timeout")

    @_builtins.property
    @pulumi.getter(name="engineConfigPgWalWriterDelay")
    def engine_config_pg_wal_writer_delay(self) -> pulumi.Output[_builtins.int]:
        """
        WAL flush interval in milliseconds. Note that setting this value to lower than the default 200ms may negatively impact performance.
        """
        return pulumi.get(self, "engine_config_pg_wal_writer_delay")

    @_builtins.property
    @pulumi.getter(name="engineConfigPglookoutMaxFailoverReplicationTimeLag")
    def engine_config_pglookout_max_failover_replication_time_lag(self) -> pulumi.Output[_builtins.int]:
        """
        Number of seconds of master unavailability before triggering database failover to standby. (default `60`)
        """
        return pulumi.get(self, "engine_config_pglookout_max_failover_replication_time_lag")

    @_builtins.property
    @pulumi.getter(name="engineConfigSharedBuffersPercentage")
    def engine_config_shared_buffers_percentage(self) -> pulumi.Output[_builtins.float]:
        """
        Percentage of total RAM that the database server uses for shared memory buffers. Valid range is 20-60 (float), which corresponds to 20% - 60%. This setting adjusts the shared_buffers configuration value.
        """
        return pulumi.get(self, "engine_config_shared_buffers_percentage")

    @_builtins.property
    @pulumi.getter(name="engineConfigWorkMem")
    def engine_config_work_mem(self) -> pulumi.Output[_builtins.int]:
        """
        Sets the maximum amount of memory to be used by a query operation (such as a sort or hash table) before writing to temporary disk files, in MB. Default is 1MB + 0.075% of total RAM (up to 32MB).
        """
        return pulumi.get(self, "engine_config_work_mem")

    @_builtins.property
    @pulumi.getter(name="engineId")
    def engine_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Managed Database engine in engine/version format. (e.g. `postgresql/16`)
        """
        return pulumi.get(self, "engine_id")

    @_builtins.property
    @pulumi.getter(name="forkRestoreTime")
    def fork_restore_time(self) -> pulumi.Output[_builtins.str]:
        """
        The database timestamp from which it was restored.
        """
        return pulumi.get(self, "fork_restore_time")

    @_builtins.property
    @pulumi.getter(name="forkSource")
    def fork_source(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The ID of the database that was forked from.

        * `updates` - (Optional) Configuration settings for automated patch update maintenance for the Managed Database.
        """
        return pulumi.get(self, "fork_source")

    @_builtins.property
    @pulumi.getter(name="hostPrimary")
    def host_primary(self) -> pulumi.Output[_builtins.str]:
        """
        The primary host for the Managed Database.
        """
        return pulumi.get(self, "host_primary")

    @_builtins.property
    @pulumi.getter(name="hostSecondary")
    def host_secondary(self) -> pulumi.Output[_builtins.str]:
        """
        The secondary/private host for the managed database.
        """
        return pulumi.get(self, "host_secondary")

    @_builtins.property
    @pulumi.getter
    def label(self) -> pulumi.Output[_builtins.str]:
        """
        A unique, user-defined string referring to the Managed Database.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def members(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A mapping between IP addresses and strings designating them as primary or failover.
        """
        return pulumi.get(self, "members")

    @_builtins.property
    @pulumi.getter(name="oldestRestoreTime")
    def oldest_restore_time(self) -> pulumi.Output[_builtins.str]:
        """
        The oldest time to which a database can be restored.
        """
        return pulumi.get(self, "oldest_restore_time")

    @_builtins.property
    @pulumi.getter(name="pendingUpdates")
    def pending_updates(self) -> pulumi.Output[Sequence['outputs.DatabasePostgresqlV2PendingUpdate']]:
        """
        A set of pending updates.
        """
        return pulumi.get(self, "pending_updates")

    @_builtins.property
    @pulumi.getter
    def platform(self) -> pulumi.Output[_builtins.str]:
        """
        The back-end platform for relational databases used by the service.
        """
        return pulumi.get(self, "platform")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.int]:
        """
        The access port for this Managed Database.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region to use for the Managed Database.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="rootPassword")
    def root_password(self) -> pulumi.Output[_builtins.str]:
        """
        The randomly-generated root password for the Managed Database instance.
        """
        return pulumi.get(self, "root_password")

    @_builtins.property
    @pulumi.getter(name="rootUsername")
    def root_username(self) -> pulumi.Output[_builtins.str]:
        """
        The root username for the Managed Database instance.
        """
        return pulumi.get(self, "root_username")

    @_builtins.property
    @pulumi.getter(name="sslConnection")
    def ssl_connection(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether to require SSL credentials to establish a connection to the Managed Database.
        """
        return pulumi.get(self, "ssl_connection")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The operating status of the Managed Database.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def suspended(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether this Managed Database should be suspended.
        """
        return pulumi.get(self, "suspended")

    @_builtins.property
    @pulumi.getter
    def timeouts(self) -> pulumi.Output[Optional['outputs.DatabasePostgresqlV2Timeouts']]:
        return pulumi.get(self, "timeouts")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The Linode Instance type used for the nodes of the Managed Database.

        - - -
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def updated(self) -> pulumi.Output[_builtins.str]:
        """
        When this Managed Database was last updated.
        """
        return pulumi.get(self, "updated")

    @_builtins.property
    @pulumi.getter
    def updates(self) -> pulumi.Output['outputs.DatabasePostgresqlV2Updates']:
        """
        Configuration settings for automated patch update maintenance for the Managed Database.
        """
        return pulumi.get(self, "updates")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        The Managed Database engine version. (e.g. `13.2`)
        """
        return pulumi.get(self, "version")

