# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetDomainZonefileResult',
    'AwaitableGetDomainZonefileResult',
    'get_domain_zonefile',
    'get_domain_zonefile_output',
]

@pulumi.output_type
class GetDomainZonefileResult:
    """
    A collection of values returned by getDomainZonefile.
    """
    def __init__(__self__, domain_id=None, id=None, zone_files=None):
        if domain_id and not isinstance(domain_id, int):
            raise TypeError("Expected argument 'domain_id' to be a int")
        pulumi.set(__self__, "domain_id", domain_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if zone_files and not isinstance(zone_files, list):
            raise TypeError("Expected argument 'zone_files' to be a list")
        pulumi.set(__self__, "zone_files", zone_files)

    @_builtins.property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> _builtins.int:
        """
        The associated domain's unique ID.
        """
        return pulumi.get(self, "domain_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="zoneFiles")
    def zone_files(self) -> Sequence[_builtins.str]:
        """
        Array of strings representing the Domain Zonefile.
        """
        return pulumi.get(self, "zone_files")


class AwaitableGetDomainZonefileResult(GetDomainZonefileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDomainZonefileResult(
            domain_id=self.domain_id,
            id=self.id,
            zone_files=self.zone_files)


def get_domain_zonefile(domain_id: Optional[_builtins.int] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDomainZonefileResult:
    """
    Provides information about a Linode Domain Zonefile.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-domain-zone).

    ## Example Usage

    The following example shows how one might use this data source to access information about a Linode Domain Zonefile.

    ```python
    import pulumi
    import pulumi_linode as linode

    my_zonefile = linode.get_domain_zonefile(domain_id=3150401)
    ```


    :param _builtins.int domain_id: The associated domain's unique ID.
    """
    __args__ = dict()
    __args__['domainId'] = domain_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getDomainZonefile:getDomainZonefile', __args__, opts=opts, typ=GetDomainZonefileResult).value

    return AwaitableGetDomainZonefileResult(
        domain_id=pulumi.get(__ret__, 'domain_id'),
        id=pulumi.get(__ret__, 'id'),
        zone_files=pulumi.get(__ret__, 'zone_files'))
def get_domain_zonefile_output(domain_id: Optional[pulumi.Input[_builtins.int]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDomainZonefileResult]:
    """
    Provides information about a Linode Domain Zonefile.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-domain-zone).

    ## Example Usage

    The following example shows how one might use this data source to access information about a Linode Domain Zonefile.

    ```python
    import pulumi
    import pulumi_linode as linode

    my_zonefile = linode.get_domain_zonefile(domain_id=3150401)
    ```


    :param _builtins.int domain_id: The associated domain's unique ID.
    """
    __args__ = dict()
    __args__['domainId'] = domain_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getDomainZonefile:getDomainZonefile', __args__, opts=opts, typ=GetDomainZonefileResult)
    return __ret__.apply(lambda __response__: GetDomainZonefileResult(
        domain_id=pulumi.get(__response__, 'domain_id'),
        id=pulumi.get(__response__, 'id'),
        zone_files=pulumi.get(__response__, 'zone_files')))
