# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetImagesResult',
    'AwaitableGetImagesResult',
    'get_images',
    'get_images_output',
]

@pulumi.output_type
class GetImagesResult:
    """
    A collection of values returned by getImages.
    """
    def __init__(__self__, filters=None, id=None, images=None, latest=None, order=None, order_by=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if images and not isinstance(images, list):
            raise TypeError("Expected argument 'images' to be a list")
        pulumi.set(__self__, "images", images)
        if latest and not isinstance(latest, bool):
            raise TypeError("Expected argument 'latest' to be a bool")
        pulumi.set(__self__, "latest", latest)
        if order and not isinstance(order, str):
            raise TypeError("Expected argument 'order' to be a str")
        pulumi.set(__self__, "order", order)
        if order_by and not isinstance(order_by, str):
            raise TypeError("Expected argument 'order_by' to be a str")
        pulumi.set(__self__, "order_by", order_by)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetImagesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The unique ID of this Image.  The ID of private images begin with `private/` followed by the numeric identifier of the private image, for example `private/12345`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def images(self) -> Optional[Sequence['outputs.GetImagesImageResult']]:
        return pulumi.get(self, "images")

    @_builtins.property
    @pulumi.getter
    def latest(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "latest")

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter(name="orderBy")
    def order_by(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "order_by")


class AwaitableGetImagesResult(GetImagesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetImagesResult(
            filters=self.filters,
            id=self.id,
            images=self.images,
            latest=self.latest,
            order=self.order,
            order_by=self.order_by)


def get_images(filters: Optional[Sequence[Union['GetImagesFilterArgs', 'GetImagesFilterArgsDict']]] = None,
               images: Optional[Sequence[Union['GetImagesImageArgs', 'GetImagesImageArgsDict']]] = None,
               latest: Optional[_builtins.bool] = None,
               order: Optional[_builtins.str] = None,
               order_by: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetImagesResult:
    """
    Provides information about Linode images that match a set of filters.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-images).

    ## Example Usage

    Get information about all Linode images with a certain label and visibility:

    ```python
    import pulumi
    import pulumi_linode as linode

    specific_images = linode.get_images(filters=[
        {
            "name": "label",
            "values": ["Debian 12"],
        },
        {
            "name": "is_public",
            "values": ["true"],
        },
    ])
    pulumi.export("imageId", specific_images.images[0].id)
    ```

    Get information about all Linode images associated with the current token:

    ```python
    import pulumi
    import pulumi_linode as linode

    all_images = linode.get_images()
    pulumi.export("imageIds", [__item.id for __item in all_images.images])
    ```

    ## Filterable Fields

    * `created_by`

    * `deprecated`

    * `description`

    * `id`

    * `is_public`

    * `label`

    * `size`

    * `status`

    * `vendor`

    * `tags`


    :param _builtins.bool latest: If true, only the latest image will be returned. Images without a valid `created` field are not included in the result.
           
           * `filter` - (Optional) A set of filters used to select Linode images that meet certain requirements.
    :param _builtins.str order: The order in which results should be returned. (`asc`, `desc`; default `asc`)
    :param _builtins.str order_by: The attribute to order the results by. See the Filterable Fields section for a list of valid fields.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['images'] = images
    __args__['latest'] = latest
    __args__['order'] = order
    __args__['orderBy'] = order_by
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getImages:getImages', __args__, opts=opts, typ=GetImagesResult).value

    return AwaitableGetImagesResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        images=pulumi.get(__ret__, 'images'),
        latest=pulumi.get(__ret__, 'latest'),
        order=pulumi.get(__ret__, 'order'),
        order_by=pulumi.get(__ret__, 'order_by'))
def get_images_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetImagesFilterArgs', 'GetImagesFilterArgsDict']]]]] = None,
                      images: Optional[pulumi.Input[Optional[Sequence[Union['GetImagesImageArgs', 'GetImagesImageArgsDict']]]]] = None,
                      latest: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                      order: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      order_by: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetImagesResult]:
    """
    Provides information about Linode images that match a set of filters.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-images).

    ## Example Usage

    Get information about all Linode images with a certain label and visibility:

    ```python
    import pulumi
    import pulumi_linode as linode

    specific_images = linode.get_images(filters=[
        {
            "name": "label",
            "values": ["Debian 12"],
        },
        {
            "name": "is_public",
            "values": ["true"],
        },
    ])
    pulumi.export("imageId", specific_images.images[0].id)
    ```

    Get information about all Linode images associated with the current token:

    ```python
    import pulumi
    import pulumi_linode as linode

    all_images = linode.get_images()
    pulumi.export("imageIds", [__item.id for __item in all_images.images])
    ```

    ## Filterable Fields

    * `created_by`

    * `deprecated`

    * `description`

    * `id`

    * `is_public`

    * `label`

    * `size`

    * `status`

    * `vendor`

    * `tags`


    :param _builtins.bool latest: If true, only the latest image will be returned. Images without a valid `created` field are not included in the result.
           
           * `filter` - (Optional) A set of filters used to select Linode images that meet certain requirements.
    :param _builtins.str order: The order in which results should be returned. (`asc`, `desc`; default `asc`)
    :param _builtins.str order_by: The attribute to order the results by. See the Filterable Fields section for a list of valid fields.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['images'] = images
    __args__['latest'] = latest
    __args__['order'] = order
    __args__['orderBy'] = order_by
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getImages:getImages', __args__, opts=opts, typ=GetImagesResult)
    return __ret__.apply(lambda __response__: GetImagesResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        images=pulumi.get(__response__, 'images'),
        latest=pulumi.get(__response__, 'latest'),
        order=pulumi.get(__response__, 'order'),
        order_by=pulumi.get(__response__, 'order_by')))
