# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetLkeClusterResult',
    'AwaitableGetLkeClusterResult',
    'get_lke_cluster',
    'get_lke_cluster_output',
]

@pulumi.output_type
class GetLkeClusterResult:
    """
    A collection of values returned by getLkeCluster.
    """
    def __init__(__self__, api_endpoints=None, apl_enabled=None, control_planes=None, created=None, dashboard_url=None, id=None, k8s_version=None, kubeconfig=None, label=None, pools=None, region=None, status=None, tags=None, tier=None, updated=None):
        if api_endpoints and not isinstance(api_endpoints, list):
            raise TypeError("Expected argument 'api_endpoints' to be a list")
        pulumi.set(__self__, "api_endpoints", api_endpoints)
        if apl_enabled and not isinstance(apl_enabled, bool):
            raise TypeError("Expected argument 'apl_enabled' to be a bool")
        pulumi.set(__self__, "apl_enabled", apl_enabled)
        if control_planes and not isinstance(control_planes, list):
            raise TypeError("Expected argument 'control_planes' to be a list")
        pulumi.set(__self__, "control_planes", control_planes)
        if created and not isinstance(created, str):
            raise TypeError("Expected argument 'created' to be a str")
        pulumi.set(__self__, "created", created)
        if dashboard_url and not isinstance(dashboard_url, str):
            raise TypeError("Expected argument 'dashboard_url' to be a str")
        pulumi.set(__self__, "dashboard_url", dashboard_url)
        if id and not isinstance(id, int):
            raise TypeError("Expected argument 'id' to be a int")
        pulumi.set(__self__, "id", id)
        if k8s_version and not isinstance(k8s_version, str):
            raise TypeError("Expected argument 'k8s_version' to be a str")
        pulumi.set(__self__, "k8s_version", k8s_version)
        if kubeconfig and not isinstance(kubeconfig, str):
            raise TypeError("Expected argument 'kubeconfig' to be a str")
        pulumi.set(__self__, "kubeconfig", kubeconfig)
        if label and not isinstance(label, str):
            raise TypeError("Expected argument 'label' to be a str")
        pulumi.set(__self__, "label", label)
        if pools and not isinstance(pools, list):
            raise TypeError("Expected argument 'pools' to be a list")
        pulumi.set(__self__, "pools", pools)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if tier and not isinstance(tier, str):
            raise TypeError("Expected argument 'tier' to be a str")
        pulumi.set(__self__, "tier", tier)
        if updated and not isinstance(updated, str):
            raise TypeError("Expected argument 'updated' to be a str")
        pulumi.set(__self__, "updated", updated)

    @_builtins.property
    @pulumi.getter(name="apiEndpoints")
    def api_endpoints(self) -> Sequence[_builtins.str]:
        """
        The endpoints for the Kubernetes API server.
        """
        return pulumi.get(self, "api_endpoints")

    @_builtins.property
    @pulumi.getter(name="aplEnabled")
    def apl_enabled(self) -> _builtins.bool:
        """
        Enables the App Platform Layer
        """
        return pulumi.get(self, "apl_enabled")

    @_builtins.property
    @pulumi.getter(name="controlPlanes")
    def control_planes(self) -> Optional[Sequence['outputs.GetLkeClusterControlPlaneResult']]:
        """
        The settings for the Kubernetes Control Plane.
        """
        return pulumi.get(self, "control_planes")

    @_builtins.property
    @pulumi.getter
    def created(self) -> _builtins.str:
        """
        When this Kubernetes cluster was created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter(name="dashboardUrl")
    def dashboard_url(self) -> _builtins.str:
        """
        The Kubernetes Dashboard access URL for this cluster. LKE Enterprise does not have a dashboard URL.
        """
        return pulumi.get(self, "dashboard_url")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.int:
        """
        The ID of the node.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="k8sVersion")
    def k8s_version(self) -> _builtins.str:
        """
        The k8s version of the nodes in this Node Pool. For LKE enterprise only and may not currently available to all users even under v4beta.
        """
        return pulumi.get(self, "k8s_version")

    @_builtins.property
    @pulumi.getter
    def kubeconfig(self) -> _builtins.str:
        """
        The base64 encoded kubeconfig for the Kubernetes cluster.
        """
        return pulumi.get(self, "kubeconfig")

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        The unique label for the cluster.
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def pools(self) -> Optional[Sequence['outputs.GetLkeClusterPoolResult']]:
        """
        Node pools associated with this cluster.
        """
        return pulumi.get(self, "pools")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        This Kubernetes cluster's location.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the node. (`ready`, `not_ready`)
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        An array of tags applied to this object. Tags are case-insensitive and are for organizational purposes only.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def tier(self) -> _builtins.str:
        """
        The desired Kubernetes tier. (**Note: v4beta only and may not currently be available to all users.**)
        """
        return pulumi.get(self, "tier")

    @_builtins.property
    @pulumi.getter
    def updated(self) -> _builtins.str:
        """
        When this Kubernetes cluster was updated.
        """
        return pulumi.get(self, "updated")


class AwaitableGetLkeClusterResult(GetLkeClusterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLkeClusterResult(
            api_endpoints=self.api_endpoints,
            apl_enabled=self.apl_enabled,
            control_planes=self.control_planes,
            created=self.created,
            dashboard_url=self.dashboard_url,
            id=self.id,
            k8s_version=self.k8s_version,
            kubeconfig=self.kubeconfig,
            label=self.label,
            pools=self.pools,
            region=self.region,
            status=self.status,
            tags=self.tags,
            tier=self.tier,
            updated=self.updated)


def get_lke_cluster(control_planes: Optional[Sequence[Union['GetLkeClusterControlPlaneArgs', 'GetLkeClusterControlPlaneArgsDict']]] = None,
                    id: Optional[_builtins.int] = None,
                    pools: Optional[Sequence[Union['GetLkeClusterPoolArgs', 'GetLkeClusterPoolArgsDict']]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLkeClusterResult:
    """
    Provides details about an LKE Cluster.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-lke-cluster).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_linode as linode

    my_cluster = linode.get_lke_cluster(id=123)
    ```


    :param Sequence[Union['GetLkeClusterControlPlaneArgs', 'GetLkeClusterControlPlaneArgsDict']] control_planes: The settings for the Kubernetes Control Plane.
    :param _builtins.int id: The LKE Cluster's ID.
    :param Sequence[Union['GetLkeClusterPoolArgs', 'GetLkeClusterPoolArgsDict']] pools: Node pools associated with this cluster.
    """
    __args__ = dict()
    __args__['controlPlanes'] = control_planes
    __args__['id'] = id
    __args__['pools'] = pools
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getLkeCluster:getLkeCluster', __args__, opts=opts, typ=GetLkeClusterResult).value

    return AwaitableGetLkeClusterResult(
        api_endpoints=pulumi.get(__ret__, 'api_endpoints'),
        apl_enabled=pulumi.get(__ret__, 'apl_enabled'),
        control_planes=pulumi.get(__ret__, 'control_planes'),
        created=pulumi.get(__ret__, 'created'),
        dashboard_url=pulumi.get(__ret__, 'dashboard_url'),
        id=pulumi.get(__ret__, 'id'),
        k8s_version=pulumi.get(__ret__, 'k8s_version'),
        kubeconfig=pulumi.get(__ret__, 'kubeconfig'),
        label=pulumi.get(__ret__, 'label'),
        pools=pulumi.get(__ret__, 'pools'),
        region=pulumi.get(__ret__, 'region'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        tier=pulumi.get(__ret__, 'tier'),
        updated=pulumi.get(__ret__, 'updated'))
def get_lke_cluster_output(control_planes: Optional[pulumi.Input[Optional[Sequence[Union['GetLkeClusterControlPlaneArgs', 'GetLkeClusterControlPlaneArgsDict']]]]] = None,
                           id: Optional[pulumi.Input[_builtins.int]] = None,
                           pools: Optional[pulumi.Input[Optional[Sequence[Union['GetLkeClusterPoolArgs', 'GetLkeClusterPoolArgsDict']]]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLkeClusterResult]:
    """
    Provides details about an LKE Cluster.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-lke-cluster).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_linode as linode

    my_cluster = linode.get_lke_cluster(id=123)
    ```


    :param Sequence[Union['GetLkeClusterControlPlaneArgs', 'GetLkeClusterControlPlaneArgsDict']] control_planes: The settings for the Kubernetes Control Plane.
    :param _builtins.int id: The LKE Cluster's ID.
    :param Sequence[Union['GetLkeClusterPoolArgs', 'GetLkeClusterPoolArgsDict']] pools: Node pools associated with this cluster.
    """
    __args__ = dict()
    __args__['controlPlanes'] = control_planes
    __args__['id'] = id
    __args__['pools'] = pools
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getLkeCluster:getLkeCluster', __args__, opts=opts, typ=GetLkeClusterResult)
    return __ret__.apply(lambda __response__: GetLkeClusterResult(
        api_endpoints=pulumi.get(__response__, 'api_endpoints'),
        apl_enabled=pulumi.get(__response__, 'apl_enabled'),
        control_planes=pulumi.get(__response__, 'control_planes'),
        created=pulumi.get(__response__, 'created'),
        dashboard_url=pulumi.get(__response__, 'dashboard_url'),
        id=pulumi.get(__response__, 'id'),
        k8s_version=pulumi.get(__response__, 'k8s_version'),
        kubeconfig=pulumi.get(__response__, 'kubeconfig'),
        label=pulumi.get(__response__, 'label'),
        pools=pulumi.get(__response__, 'pools'),
        region=pulumi.get(__response__, 'region'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        tier=pulumi.get(__response__, 'tier'),
        updated=pulumi.get(__response__, 'updated')))
