# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LkeNodePoolArgs', 'LkeNodePool']

@pulumi.input_type
class LkeNodePoolArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[_builtins.int],
                 type: pulumi.Input[_builtins.str],
                 autoscaler: Optional[pulumi.Input['LkeNodePoolAutoscalerArgs']] = None,
                 k8s_version: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['LkeNodePoolTaintArgs']]]] = None,
                 update_strategy: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a LkeNodePool resource.
        :param pulumi.Input[_builtins.int] cluster_id: ID of the LKE Cluster where to create the current Node Pool.
        :param pulumi.Input[_builtins.str] type: A Linode Type for all nodes in the Node Pool. See all node types [here](https://api.linode.com/v4/linode/types).
        :param pulumi.Input[_builtins.str] k8s_version: The k8s version of the nodes in this node pool. For LKE enterprise only and may not currently available to all users even under v4beta.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A map attribute containing key-value pairs to be added as labels to nodes in the node pool. Labels help classify your nodes and to easily select subsets of objects. To learn more, review [Add Labels and Taints to your LKE Node Pools](https://www.linode.com/docs/products/compute/kubernetes/guides/deploy-and-manage-cluster-with-the-linode-api/#add-labels-and-taints-to-your-lke-node-pools).
        :param pulumi.Input[_builtins.int] node_count: The number of nodes in the Node Pool. If undefined with an autoscaler the initial node count will equal the autoscaler minimum.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: An array of tags applied to the Node Pool. Tags can be used to flag node pools as externally managed, see Externally Managed Node Pools for more details.
        :param pulumi.Input[Sequence[pulumi.Input['LkeNodePoolTaintArgs']]] taints: Kubernetes taints to add to node pool nodes. Taints help control how pods are scheduled onto nodes, specifically
               allowing them to repel certain pods.
        :param pulumi.Input[_builtins.str] update_strategy: The strategy for updating the node pool k8s version. For LKE enterprise only and may not currently available to all users even under v4beta.
               
               * `autoscaler` - (Optional) If defined, an autoscaler will be enabled with the given configuration.
               
               * `taint` - (Optional) Kubernetes taints to add to node pool nodes. Taints help control how pods are scheduled onto nodes, specifically allowing them to repel certain pods. To learn more, review [Add Labels and Taints to your LKE Node Pools](https://www.linode.com/docs/products/compute/kubernetes/guides/deploy-and-manage-cluster-with-the-linode-api/#add-labels-and-taints-to-your-lke-node-pools).
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "type", type)
        if autoscaler is not None:
            pulumi.set(__self__, "autoscaler", autoscaler)
        if k8s_version is not None:
            pulumi.set(__self__, "k8s_version", k8s_version)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if update_strategy is not None:
            pulumi.set(__self__, "update_strategy", update_strategy)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[_builtins.int]:
        """
        ID of the LKE Cluster where to create the current Node Pool.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        A Linode Type for all nodes in the Node Pool. See all node types [here](https://api.linode.com/v4/linode/types).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def autoscaler(self) -> Optional[pulumi.Input['LkeNodePoolAutoscalerArgs']]:
        return pulumi.get(self, "autoscaler")

    @autoscaler.setter
    def autoscaler(self, value: Optional[pulumi.Input['LkeNodePoolAutoscalerArgs']]):
        pulumi.set(self, "autoscaler", value)

    @_builtins.property
    @pulumi.getter(name="k8sVersion")
    def k8s_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The k8s version of the nodes in this node pool. For LKE enterprise only and may not currently available to all users even under v4beta.
        """
        return pulumi.get(self, "k8s_version")

    @k8s_version.setter
    def k8s_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "k8s_version", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map attribute containing key-value pairs to be added as labels to nodes in the node pool. Labels help classify your nodes and to easily select subsets of objects. To learn more, review [Add Labels and Taints to your LKE Node Pools](https://www.linode.com/docs/products/compute/kubernetes/guides/deploy-and-manage-cluster-with-the-linode-api/#add-labels-and-taints-to-your-lke-node-pools).
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of nodes in the Node Pool. If undefined with an autoscaler the initial node count will equal the autoscaler minimum.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "node_count", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An array of tags applied to the Node Pool. Tags can be used to flag node pools as externally managed, see Externally Managed Node Pools for more details.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LkeNodePoolTaintArgs']]]]:
        """
        Kubernetes taints to add to node pool nodes. Taints help control how pods are scheduled onto nodes, specifically
        allowing them to repel certain pods.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LkeNodePoolTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @_builtins.property
    @pulumi.getter(name="updateStrategy")
    def update_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The strategy for updating the node pool k8s version. For LKE enterprise only and may not currently available to all users even under v4beta.

        * `autoscaler` - (Optional) If defined, an autoscaler will be enabled with the given configuration.

        * `taint` - (Optional) Kubernetes taints to add to node pool nodes. Taints help control how pods are scheduled onto nodes, specifically allowing them to repel certain pods. To learn more, review [Add Labels and Taints to your LKE Node Pools](https://www.linode.com/docs/products/compute/kubernetes/guides/deploy-and-manage-cluster-with-the-linode-api/#add-labels-and-taints-to-your-lke-node-pools).
        """
        return pulumi.get(self, "update_strategy")

    @update_strategy.setter
    def update_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_strategy", value)


@pulumi.input_type
class _LkeNodePoolState:
    def __init__(__self__, *,
                 autoscaler: Optional[pulumi.Input['LkeNodePoolAutoscalerArgs']] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_encryption: Optional[pulumi.Input[_builtins.str]] = None,
                 k8s_version: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['LkeNodePoolNodeArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['LkeNodePoolTaintArgs']]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 update_strategy: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering LkeNodePool resources.
        :param pulumi.Input[_builtins.int] cluster_id: ID of the LKE Cluster where to create the current Node Pool.
        :param pulumi.Input[_builtins.str] disk_encryption: The disk encryption policy for nodes in this pool.
        :param pulumi.Input[_builtins.str] k8s_version: The k8s version of the nodes in this node pool. For LKE enterprise only and may not currently available to all users even under v4beta.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A map attribute containing key-value pairs to be added as labels to nodes in the node pool. Labels help classify your nodes and to easily select subsets of objects. To learn more, review [Add Labels and Taints to your LKE Node Pools](https://www.linode.com/docs/products/compute/kubernetes/guides/deploy-and-manage-cluster-with-the-linode-api/#add-labels-and-taints-to-your-lke-node-pools).
        :param pulumi.Input[_builtins.int] node_count: The number of nodes in the Node Pool. If undefined with an autoscaler the initial node count will equal the autoscaler minimum.
        :param pulumi.Input[Sequence[pulumi.Input['LkeNodePoolNodeArgs']]] nodes: A list of nodes in the node pool.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: An array of tags applied to the Node Pool. Tags can be used to flag node pools as externally managed, see Externally Managed Node Pools for more details.
        :param pulumi.Input[Sequence[pulumi.Input['LkeNodePoolTaintArgs']]] taints: Kubernetes taints to add to node pool nodes. Taints help control how pods are scheduled onto nodes, specifically
               allowing them to repel certain pods.
        :param pulumi.Input[_builtins.str] type: A Linode Type for all nodes in the Node Pool. See all node types [here](https://api.linode.com/v4/linode/types).
        :param pulumi.Input[_builtins.str] update_strategy: The strategy for updating the node pool k8s version. For LKE enterprise only and may not currently available to all users even under v4beta.
               
               * `autoscaler` - (Optional) If defined, an autoscaler will be enabled with the given configuration.
               
               * `taint` - (Optional) Kubernetes taints to add to node pool nodes. Taints help control how pods are scheduled onto nodes, specifically allowing them to repel certain pods. To learn more, review [Add Labels and Taints to your LKE Node Pools](https://www.linode.com/docs/products/compute/kubernetes/guides/deploy-and-manage-cluster-with-the-linode-api/#add-labels-and-taints-to-your-lke-node-pools).
        """
        if autoscaler is not None:
            pulumi.set(__self__, "autoscaler", autoscaler)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if disk_encryption is not None:
            pulumi.set(__self__, "disk_encryption", disk_encryption)
        if k8s_version is not None:
            pulumi.set(__self__, "k8s_version", k8s_version)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if update_strategy is not None:
            pulumi.set(__self__, "update_strategy", update_strategy)

    @_builtins.property
    @pulumi.getter
    def autoscaler(self) -> Optional[pulumi.Input['LkeNodePoolAutoscalerArgs']]:
        return pulumi.get(self, "autoscaler")

    @autoscaler.setter
    def autoscaler(self, value: Optional[pulumi.Input['LkeNodePoolAutoscalerArgs']]):
        pulumi.set(self, "autoscaler", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        ID of the LKE Cluster where to create the current Node Pool.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="diskEncryption")
    def disk_encryption(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The disk encryption policy for nodes in this pool.
        """
        return pulumi.get(self, "disk_encryption")

    @disk_encryption.setter
    def disk_encryption(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_encryption", value)

    @_builtins.property
    @pulumi.getter(name="k8sVersion")
    def k8s_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The k8s version of the nodes in this node pool. For LKE enterprise only and may not currently available to all users even under v4beta.
        """
        return pulumi.get(self, "k8s_version")

    @k8s_version.setter
    def k8s_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "k8s_version", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map attribute containing key-value pairs to be added as labels to nodes in the node pool. Labels help classify your nodes and to easily select subsets of objects. To learn more, review [Add Labels and Taints to your LKE Node Pools](https://www.linode.com/docs/products/compute/kubernetes/guides/deploy-and-manage-cluster-with-the-linode-api/#add-labels-and-taints-to-your-lke-node-pools).
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of nodes in the Node Pool. If undefined with an autoscaler the initial node count will equal the autoscaler minimum.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "node_count", value)

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LkeNodePoolNodeArgs']]]]:
        """
        A list of nodes in the node pool.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LkeNodePoolNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An array of tags applied to the Node Pool. Tags can be used to flag node pools as externally managed, see Externally Managed Node Pools for more details.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LkeNodePoolTaintArgs']]]]:
        """
        Kubernetes taints to add to node pool nodes. Taints help control how pods are scheduled onto nodes, specifically
        allowing them to repel certain pods.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LkeNodePoolTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A Linode Type for all nodes in the Node Pool. See all node types [here](https://api.linode.com/v4/linode/types).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="updateStrategy")
    def update_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The strategy for updating the node pool k8s version. For LKE enterprise only and may not currently available to all users even under v4beta.

        * `autoscaler` - (Optional) If defined, an autoscaler will be enabled with the given configuration.

        * `taint` - (Optional) Kubernetes taints to add to node pool nodes. Taints help control how pods are scheduled onto nodes, specifically allowing them to repel certain pods. To learn more, review [Add Labels and Taints to your LKE Node Pools](https://www.linode.com/docs/products/compute/kubernetes/guides/deploy-and-manage-cluster-with-the-linode-api/#add-labels-and-taints-to-your-lke-node-pools).
        """
        return pulumi.get(self, "update_strategy")

    @update_strategy.setter
    def update_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_strategy", value)


@pulumi.type_token("linode:index/lkeNodePool:LkeNodePool")
class LkeNodePool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autoscaler: Optional[pulumi.Input[Union['LkeNodePoolAutoscalerArgs', 'LkeNodePoolAutoscalerArgsDict']]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.int]] = None,
                 k8s_version: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LkeNodePoolTaintArgs', 'LkeNodePoolTaintArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 update_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        LKE Node Pools can be imported using the `cluster_id,id`, e.g.

        ```sh
        $ pulumi import linode:index/lkeNodePool:LkeNodePool my_pool 150003,12345
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] cluster_id: ID of the LKE Cluster where to create the current Node Pool.
        :param pulumi.Input[_builtins.str] k8s_version: The k8s version of the nodes in this node pool. For LKE enterprise only and may not currently available to all users even under v4beta.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A map attribute containing key-value pairs to be added as labels to nodes in the node pool. Labels help classify your nodes and to easily select subsets of objects. To learn more, review [Add Labels and Taints to your LKE Node Pools](https://www.linode.com/docs/products/compute/kubernetes/guides/deploy-and-manage-cluster-with-the-linode-api/#add-labels-and-taints-to-your-lke-node-pools).
        :param pulumi.Input[_builtins.int] node_count: The number of nodes in the Node Pool. If undefined with an autoscaler the initial node count will equal the autoscaler minimum.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: An array of tags applied to the Node Pool. Tags can be used to flag node pools as externally managed, see Externally Managed Node Pools for more details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LkeNodePoolTaintArgs', 'LkeNodePoolTaintArgsDict']]]] taints: Kubernetes taints to add to node pool nodes. Taints help control how pods are scheduled onto nodes, specifically
               allowing them to repel certain pods.
        :param pulumi.Input[_builtins.str] type: A Linode Type for all nodes in the Node Pool. See all node types [here](https://api.linode.com/v4/linode/types).
        :param pulumi.Input[_builtins.str] update_strategy: The strategy for updating the node pool k8s version. For LKE enterprise only and may not currently available to all users even under v4beta.
               
               * `autoscaler` - (Optional) If defined, an autoscaler will be enabled with the given configuration.
               
               * `taint` - (Optional) Kubernetes taints to add to node pool nodes. Taints help control how pods are scheduled onto nodes, specifically allowing them to repel certain pods. To learn more, review [Add Labels and Taints to your LKE Node Pools](https://www.linode.com/docs/products/compute/kubernetes/guides/deploy-and-manage-cluster-with-the-linode-api/#add-labels-and-taints-to-your-lke-node-pools).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LkeNodePoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        LKE Node Pools can be imported using the `cluster_id,id`, e.g.

        ```sh
        $ pulumi import linode:index/lkeNodePool:LkeNodePool my_pool 150003,12345
        ```

        :param str resource_name: The name of the resource.
        :param LkeNodePoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LkeNodePoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autoscaler: Optional[pulumi.Input[Union['LkeNodePoolAutoscalerArgs', 'LkeNodePoolAutoscalerArgsDict']]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.int]] = None,
                 k8s_version: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 node_count: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LkeNodePoolTaintArgs', 'LkeNodePoolTaintArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 update_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LkeNodePoolArgs.__new__(LkeNodePoolArgs)

            __props__.__dict__["autoscaler"] = autoscaler
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["k8s_version"] = k8s_version
            __props__.__dict__["labels"] = labels
            __props__.__dict__["node_count"] = node_count
            __props__.__dict__["tags"] = tags
            __props__.__dict__["taints"] = taints
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["update_strategy"] = update_strategy
            __props__.__dict__["disk_encryption"] = None
            __props__.__dict__["nodes"] = None
        super(LkeNodePool, __self__).__init__(
            'linode:index/lkeNodePool:LkeNodePool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            autoscaler: Optional[pulumi.Input[Union['LkeNodePoolAutoscalerArgs', 'LkeNodePoolAutoscalerArgsDict']]] = None,
            cluster_id: Optional[pulumi.Input[_builtins.int]] = None,
            disk_encryption: Optional[pulumi.Input[_builtins.str]] = None,
            k8s_version: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            node_count: Optional[pulumi.Input[_builtins.int]] = None,
            nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LkeNodePoolNodeArgs', 'LkeNodePoolNodeArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            taints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LkeNodePoolTaintArgs', 'LkeNodePoolTaintArgsDict']]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            update_strategy: Optional[pulumi.Input[_builtins.str]] = None) -> 'LkeNodePool':
        """
        Get an existing LkeNodePool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] cluster_id: ID of the LKE Cluster where to create the current Node Pool.
        :param pulumi.Input[_builtins.str] disk_encryption: The disk encryption policy for nodes in this pool.
        :param pulumi.Input[_builtins.str] k8s_version: The k8s version of the nodes in this node pool. For LKE enterprise only and may not currently available to all users even under v4beta.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: A map attribute containing key-value pairs to be added as labels to nodes in the node pool. Labels help classify your nodes and to easily select subsets of objects. To learn more, review [Add Labels and Taints to your LKE Node Pools](https://www.linode.com/docs/products/compute/kubernetes/guides/deploy-and-manage-cluster-with-the-linode-api/#add-labels-and-taints-to-your-lke-node-pools).
        :param pulumi.Input[_builtins.int] node_count: The number of nodes in the Node Pool. If undefined with an autoscaler the initial node count will equal the autoscaler minimum.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LkeNodePoolNodeArgs', 'LkeNodePoolNodeArgsDict']]]] nodes: A list of nodes in the node pool.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: An array of tags applied to the Node Pool. Tags can be used to flag node pools as externally managed, see Externally Managed Node Pools for more details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LkeNodePoolTaintArgs', 'LkeNodePoolTaintArgsDict']]]] taints: Kubernetes taints to add to node pool nodes. Taints help control how pods are scheduled onto nodes, specifically
               allowing them to repel certain pods.
        :param pulumi.Input[_builtins.str] type: A Linode Type for all nodes in the Node Pool. See all node types [here](https://api.linode.com/v4/linode/types).
        :param pulumi.Input[_builtins.str] update_strategy: The strategy for updating the node pool k8s version. For LKE enterprise only and may not currently available to all users even under v4beta.
               
               * `autoscaler` - (Optional) If defined, an autoscaler will be enabled with the given configuration.
               
               * `taint` - (Optional) Kubernetes taints to add to node pool nodes. Taints help control how pods are scheduled onto nodes, specifically allowing them to repel certain pods. To learn more, review [Add Labels and Taints to your LKE Node Pools](https://www.linode.com/docs/products/compute/kubernetes/guides/deploy-and-manage-cluster-with-the-linode-api/#add-labels-and-taints-to-your-lke-node-pools).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LkeNodePoolState.__new__(_LkeNodePoolState)

        __props__.__dict__["autoscaler"] = autoscaler
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["disk_encryption"] = disk_encryption
        __props__.__dict__["k8s_version"] = k8s_version
        __props__.__dict__["labels"] = labels
        __props__.__dict__["node_count"] = node_count
        __props__.__dict__["nodes"] = nodes
        __props__.__dict__["tags"] = tags
        __props__.__dict__["taints"] = taints
        __props__.__dict__["type"] = type
        __props__.__dict__["update_strategy"] = update_strategy
        return LkeNodePool(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def autoscaler(self) -> pulumi.Output[Optional['outputs.LkeNodePoolAutoscaler']]:
        return pulumi.get(self, "autoscaler")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.int]:
        """
        ID of the LKE Cluster where to create the current Node Pool.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="diskEncryption")
    def disk_encryption(self) -> pulumi.Output[_builtins.str]:
        """
        The disk encryption policy for nodes in this pool.
        """
        return pulumi.get(self, "disk_encryption")

    @_builtins.property
    @pulumi.getter(name="k8sVersion")
    def k8s_version(self) -> pulumi.Output[_builtins.str]:
        """
        The k8s version of the nodes in this node pool. For LKE enterprise only and may not currently available to all users even under v4beta.
        """
        return pulumi.get(self, "k8s_version")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map attribute containing key-value pairs to be added as labels to nodes in the node pool. Labels help classify your nodes and to easily select subsets of objects. To learn more, review [Add Labels and Taints to your LKE Node Pools](https://www.linode.com/docs/products/compute/kubernetes/guides/deploy-and-manage-cluster-with-the-linode-api/#add-labels-and-taints-to-your-lke-node-pools).
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Output[_builtins.int]:
        """
        The number of nodes in the Node Pool. If undefined with an autoscaler the initial node count will equal the autoscaler minimum.
        """
        return pulumi.get(self, "node_count")

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> pulumi.Output[Sequence['outputs.LkeNodePoolNode']]:
        """
        A list of nodes in the node pool.
        """
        return pulumi.get(self, "nodes")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        An array of tags applied to the Node Pool. Tags can be used to flag node pools as externally managed, see Externally Managed Node Pools for more details.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def taints(self) -> pulumi.Output[Optional[Sequence['outputs.LkeNodePoolTaint']]]:
        """
        Kubernetes taints to add to node pool nodes. Taints help control how pods are scheduled onto nodes, specifically
        allowing them to repel certain pods.
        """
        return pulumi.get(self, "taints")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        A Linode Type for all nodes in the Node Pool. See all node types [here](https://api.linode.com/v4/linode/types).
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updateStrategy")
    def update_strategy(self) -> pulumi.Output[_builtins.str]:
        """
        The strategy for updating the node pool k8s version. For LKE enterprise only and may not currently available to all users even under v4beta.

        * `autoscaler` - (Optional) If defined, an autoscaler will be enabled with the given configuration.

        * `taint` - (Optional) Kubernetes taints to add to node pool nodes. Taints help control how pods are scheduled onto nodes, specifically allowing them to repel certain pods. To learn more, review [Add Labels and Taints to your LKE Node Pools](https://www.linode.com/docs/products/compute/kubernetes/guides/deploy-and-manage-cluster-with-the-linode-api/#add-labels-and-taints-to-your-lke-node-pools).
        """
        return pulumi.get(self, "update_strategy")

