# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetProjectsResult',
    'AwaitableGetProjectsResult',
    'get_projects',
    'get_projects_output',
]

@pulumi.output_type
class GetProjectsResult:
    """
    A collection of values returned by getProjects.
    """
    def __init__(__self__, created_at=None, description=None, id=None, name=None, organization_id=None, projects=None, updated_at=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if projects and not isinstance(projects, list):
            raise TypeError("Expected argument 'projects' to be a list")
        pulumi.set(__self__, "projects", projects)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        (Computed) The date and time when the project was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        (Computed) The description of the project.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        (Computed) The name of the project.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> _builtins.str:
        """
        (Computed) The unique identifier of the organization with which the project is associated.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter
    def projects(self) -> Sequence['outputs.GetProjectsProjectResult']:
        """
        (Computed) A list of projects. Each project has the following attributes:
        """
        return pulumi.get(self, "projects")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        (Computed) The date and time when the project was updated.
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetProjectsResult(GetProjectsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectsResult(
            created_at=self.created_at,
            description=self.description,
            id=self.id,
            name=self.name,
            organization_id=self.organization_id,
            projects=self.projects,
            updated_at=self.updated_at)


def get_projects(organization_id: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectsResult:
    """
    The `account_get_projects` data source is used to list all Scaleway projects in an Organization.

    Refer to the Organizations and Projects [documentation](https://www.scaleway.com/en/docs/organizations-and-projects/) and [API documentation](https://www.scaleway.com/en/developers/api/account/project-api/) for more information.

    ## Retrieve a Scaleway Projects

    The following commands allow you to:

    - retrieve all Projects in an Organization

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    # Get all Projects in an Organization
    all = scaleway.account.get_projects(organization_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx")
    ```

    ## Example Usage

    ### Deploy an SSH key in all your organization's projects

    ```python
    import pulumi
    import pulumi_scaleway as scaleway
    import pulumiverse_scaleway as scaleway

    all = scaleway.account.get_projects()
    main = []
    def create_main(range_body):
        for range in [{"value": i} for i in range(0, range_body)]:
            main.append(scaleway.account.SshKey(f"main-{range['value']}",
                name="main",
                public_key=public_key,
                project_id=all.projects[range["value"]].id))

    (len(all.projects)).apply(create_main)
    ```


    :param _builtins.str organization_id: The unique identifier of the Organization with which the Projects are associated.
           If no default `organization_id` is set, one must be set explicitly in this datasource
    """
    __args__ = dict()
    __args__['organizationId'] = organization_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:account/getProjects:getProjects', __args__, opts=opts, typ=GetProjectsResult).value

    return AwaitableGetProjectsResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        projects=pulumi.get(__ret__, 'projects'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_projects_output(organization_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProjectsResult]:
    """
    The `account_get_projects` data source is used to list all Scaleway projects in an Organization.

    Refer to the Organizations and Projects [documentation](https://www.scaleway.com/en/docs/organizations-and-projects/) and [API documentation](https://www.scaleway.com/en/developers/api/account/project-api/) for more information.

    ## Retrieve a Scaleway Projects

    The following commands allow you to:

    - retrieve all Projects in an Organization

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    # Get all Projects in an Organization
    all = scaleway.account.get_projects(organization_id="xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx")
    ```

    ## Example Usage

    ### Deploy an SSH key in all your organization's projects

    ```python
    import pulumi
    import pulumi_scaleway as scaleway
    import pulumiverse_scaleway as scaleway

    all = scaleway.account.get_projects()
    main = []
    def create_main(range_body):
        for range in [{"value": i} for i in range(0, range_body)]:
            main.append(scaleway.account.SshKey(f"main-{range['value']}",
                name="main",
                public_key=public_key,
                project_id=all.projects[range["value"]].id))

    (len(all.projects)).apply(create_main)
    ```


    :param _builtins.str organization_id: The unique identifier of the Organization with which the Projects are associated.
           If no default `organization_id` is set, one must be set explicitly in this datasource
    """
    __args__ = dict()
    __args__['organizationId'] = organization_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:account/getProjects:getProjects', __args__, opts=opts, typ=GetProjectsResult)
    return __ret__.apply(lambda __response__: GetProjectsResult(
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        projects=pulumi.get(__response__, 'projects'),
        updated_at=pulumi.get(__response__, 'updated_at')))
