# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ServerPrivateIp',
    'ServerPrivateNetwork',
]

@pulumi.output_type
class ServerPrivateIp(dict):
    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 id: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: The private IP address.
        :param _builtins.str id: The ID of the IP address resource.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        The private IP address.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the IP address resource.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class ServerPrivateNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "ipamIpIds":
            suggest = "ipam_ip_ids"
        elif key == "updatedAt":
            suggest = "updated_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerPrivateNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerPrivateNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerPrivateNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: _builtins.str,
                 created_at: Optional[_builtins.str] = None,
                 ipam_ip_ids: Optional[Sequence[_builtins.str]] = None,
                 status: Optional[_builtins.str] = None,
                 updated_at: Optional[_builtins.str] = None,
                 vlan: Optional[_builtins.int] = None):
        """
        :param _builtins.str id: The private network ID
        :param _builtins.str created_at: The date and time the private network was created.
        :param Sequence[_builtins.str] ipam_ip_ids: A list of IPAM IP IDs to attach to the server.
        :param _builtins.str status: The current status of the private network.
        :param _builtins.str updated_at: The date and time the private network was last updated.
        :param _builtins.int vlan: The VLAN ID associated with the private network.
        """
        pulumi.set(__self__, "id", id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if ipam_ip_ids is not None:
            pulumi.set(__self__, "ipam_ip_ids", ipam_ip_ids)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if vlan is not None:
            pulumi.set(__self__, "vlan", vlan)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The private network ID
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[_builtins.str]:
        """
        The date and time the private network was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="ipamIpIds")
    def ipam_ip_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of IPAM IP IDs to attach to the server.
        """
        return pulumi.get(self, "ipam_ip_ids")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The current status of the private network.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[_builtins.str]:
        """
        The date and time the private network was last updated.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def vlan(self) -> Optional[_builtins.int]:
        """
        The VLAN ID associated with the private network.
        """
        return pulumi.get(self, "vlan")


