# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceTemplateArgs', 'InstanceTemplate']

@pulumi.input_type
class InstanceTemplateArgs:
    def __init__(__self__, *,
                 commercial_type: pulumi.Input[_builtins.str],
                 cloud_init: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_network_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ips_v4_count: Optional[pulumi.Input[_builtins.int]] = None,
                 public_ips_v6_count: Optional[pulumi.Input[_builtins.int]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTemplateVolumeArgs']]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a InstanceTemplate resource.
        :param pulumi.Input[_builtins.str] commercial_type: The name of Instance commercial type.
        :param pulumi.Input[_builtins.str] cloud_init: The instance image ID. Can be an ID of a marketplace or personal image. This image must be compatible with `volume` and `commercial_type` template.
        :param pulumi.Input[_builtins.str] image_id: The instance image ID. Can be an ID of a marketplace or personal image. This image must be compatible with `volume` and `commercial_type` template.
        :param pulumi.Input[_builtins.str] name: The Instance group template.
        :param pulumi.Input[_builtins.str] placement_group_id: The instance placement group ID. This is optional, but it is highly recommended to set a preference for Instance location within Availability Zone.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_network_ids: The private Network IDs to attach to the new Instance.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project the Instance template is associated with.
        :param pulumi.Input[_builtins.int] public_ips_v4_count: The number of flexible IPv4 addresses to attach to the new Instance.
        :param pulumi.Input[_builtins.int] public_ips_v6_count: The number of flexible IPv6 addresses to attach to the new Instance.
        :param pulumi.Input[_builtins.str] security_group_id: The instance security group ID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags associated with the Instance template.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceTemplateVolumeArgs']]] volumes: The template of Instance volume.
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone in which the Instance template exists.
        """
        pulumi.set(__self__, "commercial_type", commercial_type)
        if cloud_init is not None:
            pulumi.set(__self__, "cloud_init", cloud_init)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if placement_group_id is not None:
            pulumi.set(__self__, "placement_group_id", placement_group_id)
        if private_network_ids is not None:
            pulumi.set(__self__, "private_network_ids", private_network_ids)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if public_ips_v4_count is not None:
            pulumi.set(__self__, "public_ips_v4_count", public_ips_v4_count)
        if public_ips_v6_count is not None:
            pulumi.set(__self__, "public_ips_v6_count", public_ips_v6_count)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="commercialType")
    def commercial_type(self) -> pulumi.Input[_builtins.str]:
        """
        The name of Instance commercial type.
        """
        return pulumi.get(self, "commercial_type")

    @commercial_type.setter
    def commercial_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "commercial_type", value)

    @_builtins.property
    @pulumi.getter(name="cloudInit")
    def cloud_init(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance image ID. Can be an ID of a marketplace or personal image. This image must be compatible with `volume` and `commercial_type` template.
        """
        return pulumi.get(self, "cloud_init")

    @cloud_init.setter
    def cloud_init(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_init", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance image ID. Can be an ID of a marketplace or personal image. This image must be compatible with `volume` and `commercial_type` template.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Instance group template.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="placementGroupId")
    def placement_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance placement group ID. This is optional, but it is highly recommended to set a preference for Instance location within Availability Zone.
        """
        return pulumi.get(self, "placement_group_id")

    @placement_group_id.setter
    def placement_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "placement_group_id", value)

    @_builtins.property
    @pulumi.getter(name="privateNetworkIds")
    def private_network_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The private Network IDs to attach to the new Instance.
        """
        return pulumi.get(self, "private_network_ids")

    @private_network_ids.setter
    def private_network_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "private_network_ids", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the Project the Instance template is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="publicIpsV4Count")
    def public_ips_v4_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of flexible IPv4 addresses to attach to the new Instance.
        """
        return pulumi.get(self, "public_ips_v4_count")

    @public_ips_v4_count.setter
    def public_ips_v4_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "public_ips_v4_count", value)

    @_builtins.property
    @pulumi.getter(name="publicIpsV6Count")
    def public_ips_v6_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of flexible IPv6 addresses to attach to the new Instance.
        """
        return pulumi.get(self, "public_ips_v6_count")

    @public_ips_v6_count.setter
    def public_ips_v6_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "public_ips_v6_count", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance security group ID.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The tags associated with the Instance template.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTemplateVolumeArgs']]]]:
        """
        The template of Instance volume.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTemplateVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `zone`) The zone in which the Instance template exists.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _InstanceTemplateState:
    def __init__(__self__, *,
                 cloud_init: Optional[pulumi.Input[_builtins.str]] = None,
                 commercial_type: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_network_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ips_v4_count: Optional[pulumi.Input[_builtins.int]] = None,
                 public_ips_v6_count: Optional[pulumi.Input[_builtins.int]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTemplateVolumeArgs']]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering InstanceTemplate resources.
        :param pulumi.Input[_builtins.str] cloud_init: The instance image ID. Can be an ID of a marketplace or personal image. This image must be compatible with `volume` and `commercial_type` template.
        :param pulumi.Input[_builtins.str] commercial_type: The name of Instance commercial type.
        :param pulumi.Input[_builtins.str] created_at: Date and time of Instance group's creation (RFC 3339 format).
        :param pulumi.Input[_builtins.str] image_id: The instance image ID. Can be an ID of a marketplace or personal image. This image must be compatible with `volume` and `commercial_type` template.
        :param pulumi.Input[_builtins.str] name: The Instance group template.
        :param pulumi.Input[_builtins.str] placement_group_id: The instance placement group ID. This is optional, but it is highly recommended to set a preference for Instance location within Availability Zone.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_network_ids: The private Network IDs to attach to the new Instance.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project the Instance template is associated with.
        :param pulumi.Input[_builtins.int] public_ips_v4_count: The number of flexible IPv4 addresses to attach to the new Instance.
        :param pulumi.Input[_builtins.int] public_ips_v6_count: The number of flexible IPv6 addresses to attach to the new Instance.
        :param pulumi.Input[_builtins.str] security_group_id: The instance security group ID.
        :param pulumi.Input[_builtins.str] status: The Instance template status
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags associated with the Instance template.
        :param pulumi.Input[_builtins.str] updated_at: Date and time of Instance group's last update (RFC 3339 format).
        :param pulumi.Input[Sequence[pulumi.Input['InstanceTemplateVolumeArgs']]] volumes: The template of Instance volume.
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone in which the Instance template exists.
        """
        if cloud_init is not None:
            pulumi.set(__self__, "cloud_init", cloud_init)
        if commercial_type is not None:
            pulumi.set(__self__, "commercial_type", commercial_type)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if placement_group_id is not None:
            pulumi.set(__self__, "placement_group_id", placement_group_id)
        if private_network_ids is not None:
            pulumi.set(__self__, "private_network_ids", private_network_ids)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if public_ips_v4_count is not None:
            pulumi.set(__self__, "public_ips_v4_count", public_ips_v4_count)
        if public_ips_v6_count is not None:
            pulumi.set(__self__, "public_ips_v6_count", public_ips_v6_count)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="cloudInit")
    def cloud_init(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance image ID. Can be an ID of a marketplace or personal image. This image must be compatible with `volume` and `commercial_type` template.
        """
        return pulumi.get(self, "cloud_init")

    @cloud_init.setter
    def cloud_init(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cloud_init", value)

    @_builtins.property
    @pulumi.getter(name="commercialType")
    def commercial_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of Instance commercial type.
        """
        return pulumi.get(self, "commercial_type")

    @commercial_type.setter
    def commercial_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "commercial_type", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time of Instance group's creation (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance image ID. Can be an ID of a marketplace or personal image. This image must be compatible with `volume` and `commercial_type` template.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Instance group template.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="placementGroupId")
    def placement_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance placement group ID. This is optional, but it is highly recommended to set a preference for Instance location within Availability Zone.
        """
        return pulumi.get(self, "placement_group_id")

    @placement_group_id.setter
    def placement_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "placement_group_id", value)

    @_builtins.property
    @pulumi.getter(name="privateNetworkIds")
    def private_network_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The private Network IDs to attach to the new Instance.
        """
        return pulumi.get(self, "private_network_ids")

    @private_network_ids.setter
    def private_network_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "private_network_ids", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the Project the Instance template is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="publicIpsV4Count")
    def public_ips_v4_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of flexible IPv4 addresses to attach to the new Instance.
        """
        return pulumi.get(self, "public_ips_v4_count")

    @public_ips_v4_count.setter
    def public_ips_v4_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "public_ips_v4_count", value)

    @_builtins.property
    @pulumi.getter(name="publicIpsV6Count")
    def public_ips_v6_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of flexible IPv6 addresses to attach to the new Instance.
        """
        return pulumi.get(self, "public_ips_v6_count")

    @public_ips_v6_count.setter
    def public_ips_v6_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "public_ips_v6_count", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance security group ID.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Instance template status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The tags associated with the Instance template.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time of Instance group's last update (RFC 3339 format).
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTemplateVolumeArgs']]]]:
        """
        The template of Instance volume.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTemplateVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `zone`) The zone in which the Instance template exists.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("scaleway:autoscaling/instanceTemplate:InstanceTemplate")
class InstanceTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_init: Optional[pulumi.Input[_builtins.str]] = None,
                 commercial_type: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_network_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ips_v4_count: Optional[pulumi.Input[_builtins.int]] = None,
                 public_ips_v6_count: Optional[pulumi.Input[_builtins.int]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceTemplateVolumeArgs', 'InstanceTemplateVolumeArgsDict']]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Books and manages Autoscaling Instance templates.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.autoscaling.InstanceTemplate("main",
            name="asg-template",
            commercial_type="PLAY2-MICRO",
            tags=[
                "terraform-test",
                "basic",
            ],
            volumes=[{
                "name": "as-volume",
                "volume_type": "sbs",
                "boot": True,
                "from_snapshot": {
                    "snapshot_id": main_scaleway_block_snapshot["id"],
                },
                "perf_iops": 5000,
            }],
            public_ips_v4_count=1,
            private_network_ids=[main_scaleway_vpc_private_network["id"]])
        ```

        ## Import

        Autoscaling Instance templates can be imported using `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:autoscaling/instanceTemplate:InstanceTemplate main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cloud_init: The instance image ID. Can be an ID of a marketplace or personal image. This image must be compatible with `volume` and `commercial_type` template.
        :param pulumi.Input[_builtins.str] commercial_type: The name of Instance commercial type.
        :param pulumi.Input[_builtins.str] image_id: The instance image ID. Can be an ID of a marketplace or personal image. This image must be compatible with `volume` and `commercial_type` template.
        :param pulumi.Input[_builtins.str] name: The Instance group template.
        :param pulumi.Input[_builtins.str] placement_group_id: The instance placement group ID. This is optional, but it is highly recommended to set a preference for Instance location within Availability Zone.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_network_ids: The private Network IDs to attach to the new Instance.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project the Instance template is associated with.
        :param pulumi.Input[_builtins.int] public_ips_v4_count: The number of flexible IPv4 addresses to attach to the new Instance.
        :param pulumi.Input[_builtins.int] public_ips_v6_count: The number of flexible IPv6 addresses to attach to the new Instance.
        :param pulumi.Input[_builtins.str] security_group_id: The instance security group ID.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags associated with the Instance template.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceTemplateVolumeArgs', 'InstanceTemplateVolumeArgsDict']]]] volumes: The template of Instance volume.
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone in which the Instance template exists.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Books and manages Autoscaling Instance templates.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.autoscaling.InstanceTemplate("main",
            name="asg-template",
            commercial_type="PLAY2-MICRO",
            tags=[
                "terraform-test",
                "basic",
            ],
            volumes=[{
                "name": "as-volume",
                "volume_type": "sbs",
                "boot": True,
                "from_snapshot": {
                    "snapshot_id": main_scaleway_block_snapshot["id"],
                },
                "perf_iops": 5000,
            }],
            public_ips_v4_count=1,
            private_network_ids=[main_scaleway_vpc_private_network["id"]])
        ```

        ## Import

        Autoscaling Instance templates can be imported using `{zone}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:autoscaling/instanceTemplate:InstanceTemplate main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param InstanceTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_init: Optional[pulumi.Input[_builtins.str]] = None,
                 commercial_type: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_network_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ips_v4_count: Optional[pulumi.Input[_builtins.int]] = None,
                 public_ips_v6_count: Optional[pulumi.Input[_builtins.int]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceTemplateVolumeArgs', 'InstanceTemplateVolumeArgsDict']]]]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceTemplateArgs.__new__(InstanceTemplateArgs)

            __props__.__dict__["cloud_init"] = cloud_init
            if commercial_type is None and not opts.urn:
                raise TypeError("Missing required property 'commercial_type'")
            __props__.__dict__["commercial_type"] = commercial_type
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["name"] = name
            __props__.__dict__["placement_group_id"] = placement_group_id
            __props__.__dict__["private_network_ids"] = private_network_ids
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["public_ips_v4_count"] = public_ips_v4_count
            __props__.__dict__["public_ips_v6_count"] = public_ips_v6_count
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["volumes"] = volumes
            __props__.__dict__["zone"] = zone
            __props__.__dict__["created_at"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
        super(InstanceTemplate, __self__).__init__(
            'scaleway:autoscaling/instanceTemplate:InstanceTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cloud_init: Optional[pulumi.Input[_builtins.str]] = None,
            commercial_type: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            image_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            private_network_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            public_ips_v4_count: Optional[pulumi.Input[_builtins.int]] = None,
            public_ips_v6_count: Optional[pulumi.Input[_builtins.int]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceTemplateVolumeArgs', 'InstanceTemplateVolumeArgsDict']]]]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'InstanceTemplate':
        """
        Get an existing InstanceTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cloud_init: The instance image ID. Can be an ID of a marketplace or personal image. This image must be compatible with `volume` and `commercial_type` template.
        :param pulumi.Input[_builtins.str] commercial_type: The name of Instance commercial type.
        :param pulumi.Input[_builtins.str] created_at: Date and time of Instance group's creation (RFC 3339 format).
        :param pulumi.Input[_builtins.str] image_id: The instance image ID. Can be an ID of a marketplace or personal image. This image must be compatible with `volume` and `commercial_type` template.
        :param pulumi.Input[_builtins.str] name: The Instance group template.
        :param pulumi.Input[_builtins.str] placement_group_id: The instance placement group ID. This is optional, but it is highly recommended to set a preference for Instance location within Availability Zone.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_network_ids: The private Network IDs to attach to the new Instance.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project the Instance template is associated with.
        :param pulumi.Input[_builtins.int] public_ips_v4_count: The number of flexible IPv4 addresses to attach to the new Instance.
        :param pulumi.Input[_builtins.int] public_ips_v6_count: The number of flexible IPv6 addresses to attach to the new Instance.
        :param pulumi.Input[_builtins.str] security_group_id: The instance security group ID.
        :param pulumi.Input[_builtins.str] status: The Instance template status
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags associated with the Instance template.
        :param pulumi.Input[_builtins.str] updated_at: Date and time of Instance group's last update (RFC 3339 format).
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceTemplateVolumeArgs', 'InstanceTemplateVolumeArgsDict']]]] volumes: The template of Instance volume.
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone in which the Instance template exists.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceTemplateState.__new__(_InstanceTemplateState)

        __props__.__dict__["cloud_init"] = cloud_init
        __props__.__dict__["commercial_type"] = commercial_type
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["name"] = name
        __props__.__dict__["placement_group_id"] = placement_group_id
        __props__.__dict__["private_network_ids"] = private_network_ids
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["public_ips_v4_count"] = public_ips_v4_count
        __props__.__dict__["public_ips_v6_count"] = public_ips_v6_count
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["volumes"] = volumes
        __props__.__dict__["zone"] = zone
        return InstanceTemplate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cloudInit")
    def cloud_init(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The instance image ID. Can be an ID of a marketplace or personal image. This image must be compatible with `volume` and `commercial_type` template.
        """
        return pulumi.get(self, "cloud_init")

    @_builtins.property
    @pulumi.getter(name="commercialType")
    def commercial_type(self) -> pulumi.Output[_builtins.str]:
        """
        The name of Instance commercial type.
        """
        return pulumi.get(self, "commercial_type")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Date and time of Instance group's creation (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The instance image ID. Can be an ID of a marketplace or personal image. This image must be compatible with `volume` and `commercial_type` template.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The Instance group template.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="placementGroupId")
    def placement_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The instance placement group ID. This is optional, but it is highly recommended to set a preference for Instance location within Availability Zone.
        """
        return pulumi.get(self, "placement_group_id")

    @_builtins.property
    @pulumi.getter(name="privateNetworkIds")
    def private_network_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The private Network IDs to attach to the new Instance.
        """
        return pulumi.get(self, "private_network_ids")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        `project_id`) The ID of the Project the Instance template is associated with.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="publicIpsV4Count")
    def public_ips_v4_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of flexible IPv4 addresses to attach to the new Instance.
        """
        return pulumi.get(self, "public_ips_v4_count")

    @_builtins.property
    @pulumi.getter(name="publicIpsV6Count")
    def public_ips_v6_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of flexible IPv6 addresses to attach to the new Instance.
        """
        return pulumi.get(self, "public_ips_v6_count")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The instance security group ID.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The Instance template status
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The tags associated with the Instance template.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        Date and time of Instance group's last update (RFC 3339 format).
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceTemplateVolume']]]:
        """
        The template of Instance volume.
        """
        return pulumi.get(self, "volumes")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `zone`) The zone in which the Instance template exists.
        """
        return pulumi.get(self, "zone")

