# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['CockpitGrafanaUserArgs', 'CockpitGrafanaUser']

@pulumi.input_type
class CockpitGrafanaUserArgs:
    def __init__(__self__, *,
                 login: pulumi.Input[_builtins.str],
                 role: pulumi.Input[_builtins.str],
                 project_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CockpitGrafanaUser resource.
        :param pulumi.Input[_builtins.str] login: The username of the Grafana user. The `admin` user is not yet available for creation. You need your Grafana username to log in to Grafana and access your dashboards.
        :param pulumi.Input[_builtins.str] role: The role assigned to the Grafana user. Must be `editor` or `viewer`.
        :param pulumi.Input[_builtins.str] project_id: ) The ID of the Project the Cockpit is associated with.
        """
        pulumi.set(__self__, "login", login)
        pulumi.set(__self__, "role", role)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @_builtins.property
    @pulumi.getter
    def login(self) -> pulumi.Input[_builtins.str]:
        """
        The username of the Grafana user. The `admin` user is not yet available for creation. You need your Grafana username to log in to Grafana and access your dashboards.
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "login", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Input[_builtins.str]:
        """
        The role assigned to the Grafana user. Must be `editor` or `viewer`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ) The ID of the Project the Cockpit is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)


@pulumi.input_type
class _CockpitGrafanaUserState:
    def __init__(__self__, *,
                 grafana_url: Optional[pulumi.Input[_builtins.str]] = None,
                 login: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CockpitGrafanaUser resources.
        :param pulumi.Input[_builtins.str] grafana_url: URL for Grafana.
        :param pulumi.Input[_builtins.str] login: The username of the Grafana user. The `admin` user is not yet available for creation. You need your Grafana username to log in to Grafana and access your dashboards.
        :param pulumi.Input[_builtins.str] password: The password of the Grafana user.
        :param pulumi.Input[_builtins.str] project_id: ) The ID of the Project the Cockpit is associated with.
        :param pulumi.Input[_builtins.str] role: The role assigned to the Grafana user. Must be `editor` or `viewer`.
        """
        if grafana_url is not None:
            pulumi.set(__self__, "grafana_url", grafana_url)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @_builtins.property
    @pulumi.getter(name="grafanaUrl")
    def grafana_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL for Grafana.
        """
        return pulumi.get(self, "grafana_url")

    @grafana_url.setter
    def grafana_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "grafana_url", value)

    @_builtins.property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username of the Grafana user. The `admin` user is not yet available for creation. You need your Grafana username to log in to Grafana and access your dashboards.
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "login", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password of the Grafana user.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ) The ID of the Project the Cockpit is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role assigned to the Grafana user. Must be `editor` or `viewer`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)


warnings.warn("""scaleway.index/cockpitgrafanauser.CockpitGrafanaUser has been deprecated in favor of scaleway.observability/grafanauser.GrafanaUser""", DeprecationWarning)


@pulumi.type_token("scaleway:index/cockpitGrafanaUser:CockpitGrafanaUser")
class CockpitGrafanaUser(pulumi.CustomResource):
    warnings.warn("""scaleway.index/cockpitgrafanauser.CockpitGrafanaUser has been deprecated in favor of scaleway.observability/grafanauser.GrafanaUser""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 login: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The `observability.GrafanaUser` resource allows you to create and manage [Grafana users](https://www.scaleway.com/en/docs/observability/cockpit/concepts/#grafana-users) in Scaleway Cockpit.

        Refer to Cockpit's [product documentation](https://www.scaleway.com/en/docs/observability/cockpit/concepts/) and [API documentation](https://www.scaleway.com/en/developers/api/cockpit/regional-api) for more information.

        ## Example Usage

        ### Create a Grafana user

        The following command allows you to create a Grafana user within a specific Scaleway Project.

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        project = scaleway.account.Project("project", name="test project grafana user")
        main = scaleway.observability.GrafanaUser("main",
            project_id=project.id,
            login="my-awesome-user",
            role="editor")
        ```

        ## Import

        This section explains how to import Grafana users using the ID of the Project associated with Cockpit, and the Grafana user ID in the `{project_id}/{grafana_user_id}` format.

        bash

        ```sh
        $ pulumi import scaleway:index/cockpitGrafanaUser:CockpitGrafanaUser main 11111111-1111-1111-1111-111111111111/2
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] login: The username of the Grafana user. The `admin` user is not yet available for creation. You need your Grafana username to log in to Grafana and access your dashboards.
        :param pulumi.Input[_builtins.str] project_id: ) The ID of the Project the Cockpit is associated with.
        :param pulumi.Input[_builtins.str] role: The role assigned to the Grafana user. Must be `editor` or `viewer`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CockpitGrafanaUserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `observability.GrafanaUser` resource allows you to create and manage [Grafana users](https://www.scaleway.com/en/docs/observability/cockpit/concepts/#grafana-users) in Scaleway Cockpit.

        Refer to Cockpit's [product documentation](https://www.scaleway.com/en/docs/observability/cockpit/concepts/) and [API documentation](https://www.scaleway.com/en/developers/api/cockpit/regional-api) for more information.

        ## Example Usage

        ### Create a Grafana user

        The following command allows you to create a Grafana user within a specific Scaleway Project.

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        project = scaleway.account.Project("project", name="test project grafana user")
        main = scaleway.observability.GrafanaUser("main",
            project_id=project.id,
            login="my-awesome-user",
            role="editor")
        ```

        ## Import

        This section explains how to import Grafana users using the ID of the Project associated with Cockpit, and the Grafana user ID in the `{project_id}/{grafana_user_id}` format.

        bash

        ```sh
        $ pulumi import scaleway:index/cockpitGrafanaUser:CockpitGrafanaUser main 11111111-1111-1111-1111-111111111111/2
        ```

        :param str resource_name: The name of the resource.
        :param CockpitGrafanaUserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CockpitGrafanaUserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 login: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""CockpitGrafanaUser is deprecated: scaleway.index/cockpitgrafanauser.CockpitGrafanaUser has been deprecated in favor of scaleway.observability/grafanauser.GrafanaUser""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CockpitGrafanaUserArgs.__new__(CockpitGrafanaUserArgs)

            if login is None and not opts.urn:
                raise TypeError("Missing required property 'login'")
            __props__.__dict__["login"] = login
            __props__.__dict__["project_id"] = project_id
            if role is None and not opts.urn:
                raise TypeError("Missing required property 'role'")
            __props__.__dict__["role"] = role
            __props__.__dict__["grafana_url"] = None
            __props__.__dict__["password"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(CockpitGrafanaUser, __self__).__init__(
            'scaleway:index/cockpitGrafanaUser:CockpitGrafanaUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            grafana_url: Optional[pulumi.Input[_builtins.str]] = None,
            login: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            role: Optional[pulumi.Input[_builtins.str]] = None) -> 'CockpitGrafanaUser':
        """
        Get an existing CockpitGrafanaUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] grafana_url: URL for Grafana.
        :param pulumi.Input[_builtins.str] login: The username of the Grafana user. The `admin` user is not yet available for creation. You need your Grafana username to log in to Grafana and access your dashboards.
        :param pulumi.Input[_builtins.str] password: The password of the Grafana user.
        :param pulumi.Input[_builtins.str] project_id: ) The ID of the Project the Cockpit is associated with.
        :param pulumi.Input[_builtins.str] role: The role assigned to the Grafana user. Must be `editor` or `viewer`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CockpitGrafanaUserState.__new__(_CockpitGrafanaUserState)

        __props__.__dict__["grafana_url"] = grafana_url
        __props__.__dict__["login"] = login
        __props__.__dict__["password"] = password
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["role"] = role
        return CockpitGrafanaUser(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="grafanaUrl")
    def grafana_url(self) -> pulumi.Output[_builtins.str]:
        """
        URL for Grafana.
        """
        return pulumi.get(self, "grafana_url")

    @_builtins.property
    @pulumi.getter
    def login(self) -> pulumi.Output[_builtins.str]:
        """
        The username of the Grafana user. The `admin` user is not yet available for creation. You need your Grafana username to log in to Grafana and access your dashboards.
        """
        return pulumi.get(self, "login")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[_builtins.str]:
        """
        The password of the Grafana user.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        ) The ID of the Project the Cockpit is associated with.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Output[_builtins.str]:
        """
        The role assigned to the Grafana user. Must be `editor` or `viewer`.
        """
        return pulumi.get(self, "role")

