# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ContainerNamespaceArgs', 'ContainerNamespace']

@pulumi.input_type
class ContainerNamespaceArgs:
    def __init__(__self__, *,
                 activate_vpc_integration: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destroy_registry: Optional[pulumi.Input[_builtins.bool]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ContainerNamespace resource.
        :param pulumi.Input[_builtins.bool] activate_vpc_integration: Activates VPC integration for the namespace. Containers of a namespace with VPC integration activated will be able to connect to a Private Network.
               
               > **Important:** VPC integration is now available on all namespaces, so this field is not configurable anymore and its value will always be "true".
        :param pulumi.Input[_builtins.str] description: The description of the namespace.
        :param pulumi.Input[_builtins.bool] destroy_registry: Destroy registry on deletion
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment_variables: The environment variables of the namespace.
        :param pulumi.Input[_builtins.str] name: The unique name of the Containers namespace.
               
               > **Important** Updates to the `name` argument will recreate the namespace.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The unique identifier of the project that contains the namespace.
        :param pulumi.Input[_builtins.str] region: `region`). The region in which the namespace is created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] secret_environment_variables: The secret environment variables of the namespace.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The list of tags associated with the namespace.
        """
        if activate_vpc_integration is not None:
            warnings.warn("""VPC integration is now available on all namespaces, so this field is not configurable anymore and its value will always be \"true\".""", DeprecationWarning)
            pulumi.log.warn("""activate_vpc_integration is deprecated: VPC integration is now available on all namespaces, so this field is not configurable anymore and its value will always be \"true\".""")
        if activate_vpc_integration is not None:
            pulumi.set(__self__, "activate_vpc_integration", activate_vpc_integration)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destroy_registry is not None:
            warnings.warn("""Registry namespace is automatically destroyed with namespace""", DeprecationWarning)
            pulumi.log.warn("""destroy_registry is deprecated: Registry namespace is automatically destroyed with namespace""")
        if destroy_registry is not None:
            pulumi.set(__self__, "destroy_registry", destroy_registry)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_environment_variables is not None:
            pulumi.set(__self__, "secret_environment_variables", secret_environment_variables)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="activateVpcIntegration")
    @_utilities.deprecated("""VPC integration is now available on all namespaces, so this field is not configurable anymore and its value will always be \"true\".""")
    def activate_vpc_integration(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Activates VPC integration for the namespace. Containers of a namespace with VPC integration activated will be able to connect to a Private Network.

        > **Important:** VPC integration is now available on all namespaces, so this field is not configurable anymore and its value will always be "true".
        """
        return pulumi.get(self, "activate_vpc_integration")

    @activate_vpc_integration.setter
    def activate_vpc_integration(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "activate_vpc_integration", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the namespace.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destroyRegistry")
    @_utilities.deprecated("""Registry namespace is automatically destroyed with namespace""")
    def destroy_registry(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Destroy registry on deletion
        """
        return pulumi.get(self, "destroy_registry")

    @destroy_registry.setter
    def destroy_registry(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "destroy_registry", value)

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The environment variables of the namespace.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "environment_variables", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique name of the Containers namespace.

        > **Important** Updates to the `name` argument will recreate the namespace.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The unique identifier of the project that contains the namespace.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`). The region in which the namespace is created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="secretEnvironmentVariables")
    def secret_environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The secret environment variables of the namespace.
        """
        return pulumi.get(self, "secret_environment_variables")

    @secret_environment_variables.setter
    def secret_environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "secret_environment_variables", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of tags associated with the namespace.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ContainerNamespaceState:
    def __init__(__self__, *,
                 activate_vpc_integration: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destroy_registry: Optional[pulumi.Input[_builtins.bool]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 registry_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 registry_namespace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ContainerNamespace resources.
        :param pulumi.Input[_builtins.bool] activate_vpc_integration: Activates VPC integration for the namespace. Containers of a namespace with VPC integration activated will be able to connect to a Private Network.
               
               > **Important:** VPC integration is now available on all namespaces, so this field is not configurable anymore and its value will always be "true".
        :param pulumi.Input[_builtins.str] description: The description of the namespace.
        :param pulumi.Input[_builtins.bool] destroy_registry: Destroy registry on deletion
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment_variables: The environment variables of the namespace.
        :param pulumi.Input[_builtins.str] name: The unique name of the Containers namespace.
               
               > **Important** Updates to the `name` argument will recreate the namespace.
        :param pulumi.Input[_builtins.str] organization_id: The Organization ID with which the namespace is associated.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The unique identifier of the project that contains the namespace.
        :param pulumi.Input[_builtins.str] region: `region`). The region in which the namespace is created.
        :param pulumi.Input[_builtins.str] registry_endpoint: The registry endpoint of the namespace.
        :param pulumi.Input[_builtins.str] registry_namespace_id: The registry namespace ID of the namespace.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] secret_environment_variables: The secret environment variables of the namespace.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The list of tags associated with the namespace.
        """
        if activate_vpc_integration is not None:
            warnings.warn("""VPC integration is now available on all namespaces, so this field is not configurable anymore and its value will always be \"true\".""", DeprecationWarning)
            pulumi.log.warn("""activate_vpc_integration is deprecated: VPC integration is now available on all namespaces, so this field is not configurable anymore and its value will always be \"true\".""")
        if activate_vpc_integration is not None:
            pulumi.set(__self__, "activate_vpc_integration", activate_vpc_integration)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destroy_registry is not None:
            warnings.warn("""Registry namespace is automatically destroyed with namespace""", DeprecationWarning)
            pulumi.log.warn("""destroy_registry is deprecated: Registry namespace is automatically destroyed with namespace""")
        if destroy_registry is not None:
            pulumi.set(__self__, "destroy_registry", destroy_registry)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if registry_endpoint is not None:
            pulumi.set(__self__, "registry_endpoint", registry_endpoint)
        if registry_namespace_id is not None:
            pulumi.set(__self__, "registry_namespace_id", registry_namespace_id)
        if secret_environment_variables is not None:
            pulumi.set(__self__, "secret_environment_variables", secret_environment_variables)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="activateVpcIntegration")
    @_utilities.deprecated("""VPC integration is now available on all namespaces, so this field is not configurable anymore and its value will always be \"true\".""")
    def activate_vpc_integration(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Activates VPC integration for the namespace. Containers of a namespace with VPC integration activated will be able to connect to a Private Network.

        > **Important:** VPC integration is now available on all namespaces, so this field is not configurable anymore and its value will always be "true".
        """
        return pulumi.get(self, "activate_vpc_integration")

    @activate_vpc_integration.setter
    def activate_vpc_integration(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "activate_vpc_integration", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the namespace.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destroyRegistry")
    @_utilities.deprecated("""Registry namespace is automatically destroyed with namespace""")
    def destroy_registry(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Destroy registry on deletion
        """
        return pulumi.get(self, "destroy_registry")

    @destroy_registry.setter
    def destroy_registry(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "destroy_registry", value)

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The environment variables of the namespace.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "environment_variables", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique name of the Containers namespace.

        > **Important** Updates to the `name` argument will recreate the namespace.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Organization ID with which the namespace is associated.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The unique identifier of the project that contains the namespace.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`). The region in which the namespace is created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="registryEndpoint")
    def registry_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The registry endpoint of the namespace.
        """
        return pulumi.get(self, "registry_endpoint")

    @registry_endpoint.setter
    def registry_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "registry_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="registryNamespaceId")
    def registry_namespace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The registry namespace ID of the namespace.
        """
        return pulumi.get(self, "registry_namespace_id")

    @registry_namespace_id.setter
    def registry_namespace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "registry_namespace_id", value)

    @_builtins.property
    @pulumi.getter(name="secretEnvironmentVariables")
    def secret_environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The secret environment variables of the namespace.
        """
        return pulumi.get(self, "secret_environment_variables")

    @secret_environment_variables.setter
    def secret_environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "secret_environment_variables", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of tags associated with the namespace.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


warnings.warn("""scaleway.index/containernamespace.ContainerNamespace has been deprecated in favor of scaleway.containers/namespace.Namespace""", DeprecationWarning)


@pulumi.type_token("scaleway:index/containerNamespace:ContainerNamespace")
class ContainerNamespace(pulumi.CustomResource):
    warnings.warn("""scaleway.index/containernamespace.ContainerNamespace has been deprecated in favor of scaleway.containers/namespace.Namespace""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activate_vpc_integration: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destroy_registry: Optional[pulumi.Input[_builtins.bool]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        The `containers.Namespace` resource allows you to
        for Scaleway [Serverless Containers](https://www.scaleway.com/en/docs/serverless/containers/).

        Refer to the Containers namespace [documentation](https://www.scaleway.com/en/docs/serverless/containers/how-to/create-manage-delete-containers-namespace/) and [API documentation](https://www.scaleway.com/en/developers/api/serverless-containers/#path-namespaces-list-all-your-namespaces) for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.containers.Namespace("main",
            name="main-container-namespace",
            description="Main container namespace",
            tags=[
                "tag1",
                "tag2",
            ])
        ```

        ## Import

        Containers namespaces can be imported using `{region}/{id}`, as shown below:

        bash

        ```sh
        $ pulumi import scaleway:index/containerNamespace:ContainerNamespace main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] activate_vpc_integration: Activates VPC integration for the namespace. Containers of a namespace with VPC integration activated will be able to connect to a Private Network.
               
               > **Important:** VPC integration is now available on all namespaces, so this field is not configurable anymore and its value will always be "true".
        :param pulumi.Input[_builtins.str] description: The description of the namespace.
        :param pulumi.Input[_builtins.bool] destroy_registry: Destroy registry on deletion
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment_variables: The environment variables of the namespace.
        :param pulumi.Input[_builtins.str] name: The unique name of the Containers namespace.
               
               > **Important** Updates to the `name` argument will recreate the namespace.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The unique identifier of the project that contains the namespace.
        :param pulumi.Input[_builtins.str] region: `region`). The region in which the namespace is created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] secret_environment_variables: The secret environment variables of the namespace.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The list of tags associated with the namespace.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ContainerNamespaceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `containers.Namespace` resource allows you to
        for Scaleway [Serverless Containers](https://www.scaleway.com/en/docs/serverless/containers/).

        Refer to the Containers namespace [documentation](https://www.scaleway.com/en/docs/serverless/containers/how-to/create-manage-delete-containers-namespace/) and [API documentation](https://www.scaleway.com/en/developers/api/serverless-containers/#path-namespaces-list-all-your-namespaces) for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.containers.Namespace("main",
            name="main-container-namespace",
            description="Main container namespace",
            tags=[
                "tag1",
                "tag2",
            ])
        ```

        ## Import

        Containers namespaces can be imported using `{region}/{id}`, as shown below:

        bash

        ```sh
        $ pulumi import scaleway:index/containerNamespace:ContainerNamespace main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param ContainerNamespaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ContainerNamespaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activate_vpc_integration: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destroy_registry: Optional[pulumi.Input[_builtins.bool]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        pulumi.log.warn("""ContainerNamespace is deprecated: scaleway.index/containernamespace.ContainerNamespace has been deprecated in favor of scaleway.containers/namespace.Namespace""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ContainerNamespaceArgs.__new__(ContainerNamespaceArgs)

            __props__.__dict__["activate_vpc_integration"] = activate_vpc_integration
            __props__.__dict__["description"] = description
            __props__.__dict__["destroy_registry"] = destroy_registry
            __props__.__dict__["environment_variables"] = environment_variables
            __props__.__dict__["name"] = name
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            __props__.__dict__["secret_environment_variables"] = None if secret_environment_variables is None else pulumi.Output.secret(secret_environment_variables)
            __props__.__dict__["tags"] = tags
            __props__.__dict__["organization_id"] = None
            __props__.__dict__["registry_endpoint"] = None
            __props__.__dict__["registry_namespace_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secretEnvironmentVariables"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ContainerNamespace, __self__).__init__(
            'scaleway:index/containerNamespace:ContainerNamespace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activate_vpc_integration: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            destroy_registry: Optional[pulumi.Input[_builtins.bool]] = None,
            environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            registry_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            registry_namespace_id: Optional[pulumi.Input[_builtins.str]] = None,
            secret_environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'ContainerNamespace':
        """
        Get an existing ContainerNamespace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] activate_vpc_integration: Activates VPC integration for the namespace. Containers of a namespace with VPC integration activated will be able to connect to a Private Network.
               
               > **Important:** VPC integration is now available on all namespaces, so this field is not configurable anymore and its value will always be "true".
        :param pulumi.Input[_builtins.str] description: The description of the namespace.
        :param pulumi.Input[_builtins.bool] destroy_registry: Destroy registry on deletion
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment_variables: The environment variables of the namespace.
        :param pulumi.Input[_builtins.str] name: The unique name of the Containers namespace.
               
               > **Important** Updates to the `name` argument will recreate the namespace.
        :param pulumi.Input[_builtins.str] organization_id: The Organization ID with which the namespace is associated.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The unique identifier of the project that contains the namespace.
        :param pulumi.Input[_builtins.str] region: `region`). The region in which the namespace is created.
        :param pulumi.Input[_builtins.str] registry_endpoint: The registry endpoint of the namespace.
        :param pulumi.Input[_builtins.str] registry_namespace_id: The registry namespace ID of the namespace.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] secret_environment_variables: The secret environment variables of the namespace.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The list of tags associated with the namespace.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ContainerNamespaceState.__new__(_ContainerNamespaceState)

        __props__.__dict__["activate_vpc_integration"] = activate_vpc_integration
        __props__.__dict__["description"] = description
        __props__.__dict__["destroy_registry"] = destroy_registry
        __props__.__dict__["environment_variables"] = environment_variables
        __props__.__dict__["name"] = name
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["registry_endpoint"] = registry_endpoint
        __props__.__dict__["registry_namespace_id"] = registry_namespace_id
        __props__.__dict__["secret_environment_variables"] = secret_environment_variables
        __props__.__dict__["tags"] = tags
        return ContainerNamespace(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="activateVpcIntegration")
    @_utilities.deprecated("""VPC integration is now available on all namespaces, so this field is not configurable anymore and its value will always be \"true\".""")
    def activate_vpc_integration(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Activates VPC integration for the namespace. Containers of a namespace with VPC integration activated will be able to connect to a Private Network.

        > **Important:** VPC integration is now available on all namespaces, so this field is not configurable anymore and its value will always be "true".
        """
        return pulumi.get(self, "activate_vpc_integration")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the namespace.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destroyRegistry")
    @_utilities.deprecated("""Registry namespace is automatically destroyed with namespace""")
    def destroy_registry(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Destroy registry on deletion
        """
        return pulumi.get(self, "destroy_registry")

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The environment variables of the namespace.
        """
        return pulumi.get(self, "environment_variables")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The unique name of the Containers namespace.

        > **Important** Updates to the `name` argument will recreate the namespace.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Organization ID with which the namespace is associated.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        `project_id`) The unique identifier of the project that contains the namespace.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `region`). The region in which the namespace is created.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="registryEndpoint")
    def registry_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The registry endpoint of the namespace.
        """
        return pulumi.get(self, "registry_endpoint")

    @_builtins.property
    @pulumi.getter(name="registryNamespaceId")
    def registry_namespace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The registry namespace ID of the namespace.
        """
        return pulumi.get(self, "registry_namespace_id")

    @_builtins.property
    @pulumi.getter(name="secretEnvironmentVariables")
    def secret_environment_variables(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The secret environment variables of the namespace.
        """
        return pulumi.get(self, "secret_environment_variables")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The list of tags associated with the namespace.
        """
        return pulumi.get(self, "tags")

