# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetContainerResult',
    'AwaitableGetContainerResult',
    'get_container',
    'get_container_output',
]

@pulumi.output_type
class GetContainerResult:
    """
    A collection of values returned by getContainer.
    """
    def __init__(__self__, args=None, commands=None, container_id=None, cpu_limit=None, cron_status=None, deploy=None, description=None, domain_name=None, environment_variables=None, error_message=None, health_checks=None, http_option=None, id=None, local_storage_limit=None, max_concurrency=None, max_scale=None, memory_limit=None, min_scale=None, name=None, namespace_id=None, port=None, privacy=None, private_network_id=None, project_id=None, protocol=None, region=None, registry_image=None, registry_sha256=None, sandbox=None, scaling_options=None, secret_environment_variables=None, status=None, tags=None, timeout=None):
        if args and not isinstance(args, list):
            raise TypeError("Expected argument 'args' to be a list")
        pulumi.set(__self__, "args", args)
        if commands and not isinstance(commands, list):
            raise TypeError("Expected argument 'commands' to be a list")
        pulumi.set(__self__, "commands", commands)
        if container_id and not isinstance(container_id, str):
            raise TypeError("Expected argument 'container_id' to be a str")
        pulumi.set(__self__, "container_id", container_id)
        if cpu_limit and not isinstance(cpu_limit, int):
            raise TypeError("Expected argument 'cpu_limit' to be a int")
        pulumi.set(__self__, "cpu_limit", cpu_limit)
        if cron_status and not isinstance(cron_status, str):
            raise TypeError("Expected argument 'cron_status' to be a str")
        pulumi.set(__self__, "cron_status", cron_status)
        if deploy and not isinstance(deploy, bool):
            raise TypeError("Expected argument 'deploy' to be a bool")
        pulumi.set(__self__, "deploy", deploy)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if domain_name and not isinstance(domain_name, str):
            raise TypeError("Expected argument 'domain_name' to be a str")
        pulumi.set(__self__, "domain_name", domain_name)
        if environment_variables and not isinstance(environment_variables, dict):
            raise TypeError("Expected argument 'environment_variables' to be a dict")
        pulumi.set(__self__, "environment_variables", environment_variables)
        if error_message and not isinstance(error_message, str):
            raise TypeError("Expected argument 'error_message' to be a str")
        pulumi.set(__self__, "error_message", error_message)
        if health_checks and not isinstance(health_checks, list):
            raise TypeError("Expected argument 'health_checks' to be a list")
        pulumi.set(__self__, "health_checks", health_checks)
        if http_option and not isinstance(http_option, str):
            raise TypeError("Expected argument 'http_option' to be a str")
        pulumi.set(__self__, "http_option", http_option)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if local_storage_limit and not isinstance(local_storage_limit, int):
            raise TypeError("Expected argument 'local_storage_limit' to be a int")
        pulumi.set(__self__, "local_storage_limit", local_storage_limit)
        if max_concurrency and not isinstance(max_concurrency, int):
            raise TypeError("Expected argument 'max_concurrency' to be a int")
        pulumi.set(__self__, "max_concurrency", max_concurrency)
        if max_scale and not isinstance(max_scale, int):
            raise TypeError("Expected argument 'max_scale' to be a int")
        pulumi.set(__self__, "max_scale", max_scale)
        if memory_limit and not isinstance(memory_limit, int):
            raise TypeError("Expected argument 'memory_limit' to be a int")
        pulumi.set(__self__, "memory_limit", memory_limit)
        if min_scale and not isinstance(min_scale, int):
            raise TypeError("Expected argument 'min_scale' to be a int")
        pulumi.set(__self__, "min_scale", min_scale)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespace_id and not isinstance(namespace_id, str):
            raise TypeError("Expected argument 'namespace_id' to be a str")
        pulumi.set(__self__, "namespace_id", namespace_id)
        if port and not isinstance(port, int):
            raise TypeError("Expected argument 'port' to be a int")
        pulumi.set(__self__, "port", port)
        if privacy and not isinstance(privacy, str):
            raise TypeError("Expected argument 'privacy' to be a str")
        pulumi.set(__self__, "privacy", privacy)
        if private_network_id and not isinstance(private_network_id, str):
            raise TypeError("Expected argument 'private_network_id' to be a str")
        pulumi.set(__self__, "private_network_id", private_network_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if protocol and not isinstance(protocol, str):
            raise TypeError("Expected argument 'protocol' to be a str")
        pulumi.set(__self__, "protocol", protocol)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if registry_image and not isinstance(registry_image, str):
            raise TypeError("Expected argument 'registry_image' to be a str")
        pulumi.set(__self__, "registry_image", registry_image)
        if registry_sha256 and not isinstance(registry_sha256, str):
            raise TypeError("Expected argument 'registry_sha256' to be a str")
        pulumi.set(__self__, "registry_sha256", registry_sha256)
        if sandbox and not isinstance(sandbox, str):
            raise TypeError("Expected argument 'sandbox' to be a str")
        pulumi.set(__self__, "sandbox", sandbox)
        if scaling_options and not isinstance(scaling_options, list):
            raise TypeError("Expected argument 'scaling_options' to be a list")
        pulumi.set(__self__, "scaling_options", scaling_options)
        if secret_environment_variables and not isinstance(secret_environment_variables, dict):
            raise TypeError("Expected argument 'secret_environment_variables' to be a dict")
        pulumi.set(__self__, "secret_environment_variables", secret_environment_variables)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if timeout and not isinstance(timeout, int):
            raise TypeError("Expected argument 'timeout' to be a int")
        pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def args(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "args")

    @_builtins.property
    @pulumi.getter
    def commands(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "commands")

    @_builtins.property
    @pulumi.getter(name="containerId")
    def container_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "container_id")

    @_builtins.property
    @pulumi.getter(name="cpuLimit")
    def cpu_limit(self) -> _builtins.int:
        """
        The amount of vCPU computing resources to allocate to each container.
        """
        return pulumi.get(self, "cpu_limit")

    @_builtins.property
    @pulumi.getter(name="cronStatus")
    def cron_status(self) -> _builtins.str:
        """
        The cron status of the container.
        """
        return pulumi.get(self, "cron_status")

    @_builtins.property
    @pulumi.getter
    def deploy(self) -> _builtins.bool:
        """
        Boolean indicating whether the container is on a production environment.
        """
        return pulumi.get(self, "deploy")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the container.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> _builtins.str:
        """
        The container domain name.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Mapping[str, _builtins.str]:
        """
        The [environment](https://www.scaleway.com/en/docs/serverless-containers/concepts/#environment-variables) variables of the container.
        """
        return pulumi.get(self, "environment_variables")

    @_builtins.property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> _builtins.str:
        """
        The error message of the container.
        """
        return pulumi.get(self, "error_message")

    @_builtins.property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> Sequence['outputs.GetContainerHealthCheckResult']:
        """
        Health check configuration block of the container.
        """
        return pulumi.get(self, "health_checks")

    @_builtins.property
    @pulumi.getter(name="httpOption")
    def http_option(self) -> _builtins.str:
        return pulumi.get(self, "http_option")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="localStorageLimit")
    def local_storage_limit(self) -> _builtins.int:
        return pulumi.get(self, "local_storage_limit")

    @_builtins.property
    @pulumi.getter(name="maxConcurrency")
    def max_concurrency(self) -> _builtins.int:
        """
        The maximum number of simultaneous requests your container can handle at the same time.
        """
        return pulumi.get(self, "max_concurrency")

    @_builtins.property
    @pulumi.getter(name="maxScale")
    def max_scale(self) -> _builtins.int:
        """
        The maximum number of instances the container can scale to.
        """
        return pulumi.get(self, "max_scale")

    @_builtins.property
    @pulumi.getter(name="memoryLimit")
    def memory_limit(self) -> _builtins.int:
        """
        The memory resources in MB to allocate to each container.
        """
        return pulumi.get(self, "memory_limit")

    @_builtins.property
    @pulumi.getter(name="minScale")
    def min_scale(self) -> _builtins.int:
        """
        The minimum number of container instances running continuously.
        """
        return pulumi.get(self, "min_scale")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> _builtins.str:
        return pulumi.get(self, "namespace_id")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port to expose the container.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def privacy(self) -> _builtins.str:
        """
        The privacy type define the way to authenticate to your container. Refer to the [dedicated documentation](https://www.scaleway.com/en/developers/api/serverless-containers/#path-containers-update-an-existing-container) for more information.
        """
        return pulumi.get(self, "privacy")

    @_builtins.property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> _builtins.str:
        return pulumi.get(self, "private_network_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The communication [protocol](https://www.scaleway.com/en/developers/api/serverless-containers/#path-containers-update-an-existing-container) `http1` or `h2c`. Defaults to `http1`.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        (Defaults to provider `region`) The region in which the container was created.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="registryImage")
    def registry_image(self) -> _builtins.str:
        """
        The registry image address (e.g. `rg.fr-par.scw.cloud/$NAMESPACE/$IMAGE`).
        """
        return pulumi.get(self, "registry_image")

    @_builtins.property
    @pulumi.getter(name="registrySha256")
    def registry_sha256(self) -> _builtins.str:
        """
        The sha256 of your source registry image, changing it will re-apply the deployment. Can be any string.
        """
        return pulumi.get(self, "registry_sha256")

    @_builtins.property
    @pulumi.getter
    def sandbox(self) -> _builtins.str:
        """
        (Optional) Execution environment of the container.
        """
        return pulumi.get(self, "sandbox")

    @_builtins.property
    @pulumi.getter(name="scalingOptions")
    def scaling_options(self) -> Sequence['outputs.GetContainerScalingOptionResult']:
        """
        Configuration block used to decide when to scale up or down. Possible values:
        """
        return pulumi.get(self, "scaling_options")

    @_builtins.property
    @pulumi.getter(name="secretEnvironmentVariables")
    def secret_environment_variables(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "secret_environment_variables")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The container status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> _builtins.int:
        """
        The maximum amount of time your container can spend processing a request before being stopped.
        """
        return pulumi.get(self, "timeout")


class AwaitableGetContainerResult(GetContainerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetContainerResult(
            args=self.args,
            commands=self.commands,
            container_id=self.container_id,
            cpu_limit=self.cpu_limit,
            cron_status=self.cron_status,
            deploy=self.deploy,
            description=self.description,
            domain_name=self.domain_name,
            environment_variables=self.environment_variables,
            error_message=self.error_message,
            health_checks=self.health_checks,
            http_option=self.http_option,
            id=self.id,
            local_storage_limit=self.local_storage_limit,
            max_concurrency=self.max_concurrency,
            max_scale=self.max_scale,
            memory_limit=self.memory_limit,
            min_scale=self.min_scale,
            name=self.name,
            namespace_id=self.namespace_id,
            port=self.port,
            privacy=self.privacy,
            private_network_id=self.private_network_id,
            project_id=self.project_id,
            protocol=self.protocol,
            region=self.region,
            registry_image=self.registry_image,
            registry_sha256=self.registry_sha256,
            sandbox=self.sandbox,
            scaling_options=self.scaling_options,
            secret_environment_variables=self.secret_environment_variables,
            status=self.status,
            tags=self.tags,
            timeout=self.timeout)


def get_container(container_id: Optional[_builtins.str] = None,
                  name: Optional[_builtins.str] = None,
                  namespace_id: Optional[_builtins.str] = None,
                  project_id: Optional[_builtins.str] = None,
                  region: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetContainerResult:
    """
    The `containers.Container` data source is used to retrieve information about a Serverless Container.

    Refer to the Serverless Containers [product documentation](https://www.scaleway.com/en/docs/serverless/containers/) and [API documentation](https://www.scaleway.com/en/developers/api/serverless-containers/) for more information.

    For more information on the limitations of Serverless Containers, refer to the [dedicated documentation](https://www.scaleway.com/en/docs/serverless-containers/reference-content/containers-limitations/).

    ## Retrieve a Serverless Container

    The following commands allow you to:

    - retrieve a container by its name
    - retrieve a container by its ID

    ```python
    import pulumi
    import pulumi_scaleway as scaleway
    import pulumiverse_scaleway as scaleway

    main = scaleway.containers.Namespace("main")
    main_container = scaleway.containers.Container("main",
        name="test-container-data",
        namespace_id=main.id)
    # Get info by container name
    by_name = scaleway.containers.get_container_output(namespace_id=main.id,
        name=main_container.name)
    # Get info by container ID
    by_id = scaleway.containers.get_container_output(namespace_id=main.id,
        container_id=main_container.id)
    ```

    ## Arguments reference

    This section lists the arguments that you can provide to the `containers.Container` data source to filter and retrieve the desired namespace. Each argument has a specific purpose:

    - `name` - (Required) The unique name of the container.

    - `namespace_id` - (Required) The container namespace ID of the container.

    - `project_id` - (Optional) The unique identifier of the project with which the container is associated.

    > **Important** Updating the `name` argument will recreate the container.


    :param _builtins.str region: (Defaults to provider `region`) The region in which the container was created.
    """
    __args__ = dict()
    __args__['containerId'] = container_id
    __args__['name'] = name
    __args__['namespaceId'] = namespace_id
    __args__['projectId'] = project_id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:containers/getContainer:getContainer', __args__, opts=opts, typ=GetContainerResult).value

    return AwaitableGetContainerResult(
        args=pulumi.get(__ret__, 'args'),
        commands=pulumi.get(__ret__, 'commands'),
        container_id=pulumi.get(__ret__, 'container_id'),
        cpu_limit=pulumi.get(__ret__, 'cpu_limit'),
        cron_status=pulumi.get(__ret__, 'cron_status'),
        deploy=pulumi.get(__ret__, 'deploy'),
        description=pulumi.get(__ret__, 'description'),
        domain_name=pulumi.get(__ret__, 'domain_name'),
        environment_variables=pulumi.get(__ret__, 'environment_variables'),
        error_message=pulumi.get(__ret__, 'error_message'),
        health_checks=pulumi.get(__ret__, 'health_checks'),
        http_option=pulumi.get(__ret__, 'http_option'),
        id=pulumi.get(__ret__, 'id'),
        local_storage_limit=pulumi.get(__ret__, 'local_storage_limit'),
        max_concurrency=pulumi.get(__ret__, 'max_concurrency'),
        max_scale=pulumi.get(__ret__, 'max_scale'),
        memory_limit=pulumi.get(__ret__, 'memory_limit'),
        min_scale=pulumi.get(__ret__, 'min_scale'),
        name=pulumi.get(__ret__, 'name'),
        namespace_id=pulumi.get(__ret__, 'namespace_id'),
        port=pulumi.get(__ret__, 'port'),
        privacy=pulumi.get(__ret__, 'privacy'),
        private_network_id=pulumi.get(__ret__, 'private_network_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        protocol=pulumi.get(__ret__, 'protocol'),
        region=pulumi.get(__ret__, 'region'),
        registry_image=pulumi.get(__ret__, 'registry_image'),
        registry_sha256=pulumi.get(__ret__, 'registry_sha256'),
        sandbox=pulumi.get(__ret__, 'sandbox'),
        scaling_options=pulumi.get(__ret__, 'scaling_options'),
        secret_environment_variables=pulumi.get(__ret__, 'secret_environment_variables'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        timeout=pulumi.get(__ret__, 'timeout'))
def get_container_output(container_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         namespace_id: Optional[pulumi.Input[_builtins.str]] = None,
                         project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetContainerResult]:
    """
    The `containers.Container` data source is used to retrieve information about a Serverless Container.

    Refer to the Serverless Containers [product documentation](https://www.scaleway.com/en/docs/serverless/containers/) and [API documentation](https://www.scaleway.com/en/developers/api/serverless-containers/) for more information.

    For more information on the limitations of Serverless Containers, refer to the [dedicated documentation](https://www.scaleway.com/en/docs/serverless-containers/reference-content/containers-limitations/).

    ## Retrieve a Serverless Container

    The following commands allow you to:

    - retrieve a container by its name
    - retrieve a container by its ID

    ```python
    import pulumi
    import pulumi_scaleway as scaleway
    import pulumiverse_scaleway as scaleway

    main = scaleway.containers.Namespace("main")
    main_container = scaleway.containers.Container("main",
        name="test-container-data",
        namespace_id=main.id)
    # Get info by container name
    by_name = scaleway.containers.get_container_output(namespace_id=main.id,
        name=main_container.name)
    # Get info by container ID
    by_id = scaleway.containers.get_container_output(namespace_id=main.id,
        container_id=main_container.id)
    ```

    ## Arguments reference

    This section lists the arguments that you can provide to the `containers.Container` data source to filter and retrieve the desired namespace. Each argument has a specific purpose:

    - `name` - (Required) The unique name of the container.

    - `namespace_id` - (Required) The container namespace ID of the container.

    - `project_id` - (Optional) The unique identifier of the project with which the container is associated.

    > **Important** Updating the `name` argument will recreate the container.


    :param _builtins.str region: (Defaults to provider `region`) The region in which the container was created.
    """
    __args__ = dict()
    __args__['containerId'] = container_id
    __args__['name'] = name
    __args__['namespaceId'] = namespace_id
    __args__['projectId'] = project_id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:containers/getContainer:getContainer', __args__, opts=opts, typ=GetContainerResult)
    return __ret__.apply(lambda __response__: GetContainerResult(
        args=pulumi.get(__response__, 'args'),
        commands=pulumi.get(__response__, 'commands'),
        container_id=pulumi.get(__response__, 'container_id'),
        cpu_limit=pulumi.get(__response__, 'cpu_limit'),
        cron_status=pulumi.get(__response__, 'cron_status'),
        deploy=pulumi.get(__response__, 'deploy'),
        description=pulumi.get(__response__, 'description'),
        domain_name=pulumi.get(__response__, 'domain_name'),
        environment_variables=pulumi.get(__response__, 'environment_variables'),
        error_message=pulumi.get(__response__, 'error_message'),
        health_checks=pulumi.get(__response__, 'health_checks'),
        http_option=pulumi.get(__response__, 'http_option'),
        id=pulumi.get(__response__, 'id'),
        local_storage_limit=pulumi.get(__response__, 'local_storage_limit'),
        max_concurrency=pulumi.get(__response__, 'max_concurrency'),
        max_scale=pulumi.get(__response__, 'max_scale'),
        memory_limit=pulumi.get(__response__, 'memory_limit'),
        min_scale=pulumi.get(__response__, 'min_scale'),
        name=pulumi.get(__response__, 'name'),
        namespace_id=pulumi.get(__response__, 'namespace_id'),
        port=pulumi.get(__response__, 'port'),
        privacy=pulumi.get(__response__, 'privacy'),
        private_network_id=pulumi.get(__response__, 'private_network_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        protocol=pulumi.get(__response__, 'protocol'),
        region=pulumi.get(__response__, 'region'),
        registry_image=pulumi.get(__response__, 'registry_image'),
        registry_sha256=pulumi.get(__response__, 'registry_sha256'),
        sandbox=pulumi.get(__response__, 'sandbox'),
        scaling_options=pulumi.get(__response__, 'scaling_options'),
        secret_environment_variables=pulumi.get(__response__, 'secret_environment_variables'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        timeout=pulumi.get(__response__, 'timeout')))
