# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ContainerHealthCheck',
    'ContainerHealthCheckHttp',
    'ContainerScalingOption',
    'TriggerNats',
    'TriggerSqs',
    'GetContainerHealthCheckResult',
    'GetContainerHealthCheckHttpResult',
    'GetContainerScalingOptionResult',
]

@pulumi.output_type
class ContainerHealthCheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureThreshold":
            suggest = "failure_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerHealthCheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerHealthCheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerHealthCheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_threshold: _builtins.int,
                 https: Sequence['outputs.ContainerHealthCheckHttp'],
                 interval: _builtins.str):
        """
        :param _builtins.int failure_threshold: Number of consecutive health check failures before considering the container unhealthy.
        :param Sequence['ContainerHealthCheckHttpArgs'] https: HTTP health check configuration.
        :param _builtins.str interval: Period between health checks (in seconds).
        """
        pulumi.set(__self__, "failure_threshold", failure_threshold)
        pulumi.set(__self__, "https", https)
        pulumi.set(__self__, "interval", interval)

    @_builtins.property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> _builtins.int:
        """
        Number of consecutive health check failures before considering the container unhealthy.
        """
        return pulumi.get(self, "failure_threshold")

    @_builtins.property
    @pulumi.getter
    def https(self) -> Sequence['outputs.ContainerHealthCheckHttp']:
        """
        HTTP health check configuration.
        """
        return pulumi.get(self, "https")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> _builtins.str:
        """
        Period between health checks (in seconds).
        """
        return pulumi.get(self, "interval")


@pulumi.output_type
class ContainerHealthCheckHttp(dict):
    def __init__(__self__, *,
                 path: _builtins.str):
        """
        :param _builtins.str path: Path to use for the HTTP health check.
        """
        pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Path to use for the HTTP health check.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class ContainerScalingOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "concurrentRequestsThreshold":
            suggest = "concurrent_requests_threshold"
        elif key == "cpuUsageThreshold":
            suggest = "cpu_usage_threshold"
        elif key == "memoryUsageThreshold":
            suggest = "memory_usage_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerScalingOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerScalingOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerScalingOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 concurrent_requests_threshold: Optional[_builtins.int] = None,
                 cpu_usage_threshold: Optional[_builtins.int] = None,
                 memory_usage_threshold: Optional[_builtins.int] = None):
        """
        :param _builtins.int concurrent_requests_threshold: Scale depending on the number of concurrent requests being processed per container instance.
        :param _builtins.int cpu_usage_threshold: Scale depending on the CPU usage of a container instance.
        :param _builtins.int memory_usage_threshold: Scale depending on the memory usage of a container instance.
        """
        if concurrent_requests_threshold is not None:
            pulumi.set(__self__, "concurrent_requests_threshold", concurrent_requests_threshold)
        if cpu_usage_threshold is not None:
            pulumi.set(__self__, "cpu_usage_threshold", cpu_usage_threshold)
        if memory_usage_threshold is not None:
            pulumi.set(__self__, "memory_usage_threshold", memory_usage_threshold)

    @_builtins.property
    @pulumi.getter(name="concurrentRequestsThreshold")
    def concurrent_requests_threshold(self) -> Optional[_builtins.int]:
        """
        Scale depending on the number of concurrent requests being processed per container instance.
        """
        return pulumi.get(self, "concurrent_requests_threshold")

    @_builtins.property
    @pulumi.getter(name="cpuUsageThreshold")
    def cpu_usage_threshold(self) -> Optional[_builtins.int]:
        """
        Scale depending on the CPU usage of a container instance.
        """
        return pulumi.get(self, "cpu_usage_threshold")

    @_builtins.property
    @pulumi.getter(name="memoryUsageThreshold")
    def memory_usage_threshold(self) -> Optional[_builtins.int]:
        """
        Scale depending on the memory usage of a container instance.
        """
        return pulumi.get(self, "memory_usage_threshold")


@pulumi.output_type
class TriggerNats(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountId":
            suggest = "account_id"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerNats. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerNats.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerNats.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subject: _builtins.str,
                 account_id: Optional[_builtins.str] = None,
                 project_id: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None):
        """
        :param _builtins.str subject: The subject to listen to.
        :param _builtins.str account_id: unique identifier of the Messaging and Queuing NATS account.
        :param _builtins.str project_id: THe ID of the project that contains the Messaging and Queuing NATS account (defaults to provider `project_id`)
        :param _builtins.str region: Region where the Messaging and Queuing NATS account is enabled (defaults to provider `region`)
        """
        pulumi.set(__self__, "subject", subject)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def subject(self) -> _builtins.str:
        """
        The subject to listen to.
        """
        return pulumi.get(self, "subject")

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[_builtins.str]:
        """
        unique identifier of the Messaging and Queuing NATS account.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        THe ID of the project that contains the Messaging and Queuing NATS account (defaults to provider `project_id`)
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        Region where the Messaging and Queuing NATS account is enabled (defaults to provider `region`)
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class TriggerSqs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "namespaceId":
            suggest = "namespace_id"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerSqs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerSqs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerSqs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 queue: _builtins.str,
                 namespace_id: Optional[_builtins.str] = None,
                 project_id: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None):
        """
        :param _builtins.str queue: The name of the SQS queue.
        :param _builtins.str namespace_id: ID of the Messaging and Queuing namespace. This argument is deprecated.
        :param _builtins.str project_id: The ID of the project in which SQS is enabled, (defaults to provider `project_id`)
        :param _builtins.str region: Region where SQS is enabled (defaults to provider `region`)
        """
        pulumi.set(__self__, "queue", queue)
        if namespace_id is not None:
            pulumi.set(__self__, "namespace_id", namespace_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def queue(self) -> _builtins.str:
        """
        The name of the SQS queue.
        """
        return pulumi.get(self, "queue")

    @_builtins.property
    @pulumi.getter(name="namespaceId")
    @_utilities.deprecated("""The 'namespace_id' field is deprecated and will be removed in the next major version. It is no longer necessary to specify it""")
    def namespace_id(self) -> Optional[_builtins.str]:
        """
        ID of the Messaging and Queuing namespace. This argument is deprecated.
        """
        return pulumi.get(self, "namespace_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        The ID of the project in which SQS is enabled, (defaults to provider `project_id`)
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        Region where SQS is enabled (defaults to provider `region`)
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class GetContainerHealthCheckResult(dict):
    def __init__(__self__, *,
                 failure_threshold: _builtins.int,
                 https: Sequence['outputs.GetContainerHealthCheckHttpResult'],
                 interval: _builtins.str):
        """
        :param _builtins.int failure_threshold: Number of consecutive health check failures before considering the container unhealthy.
        :param Sequence['GetContainerHealthCheckHttpArgs'] https: HTTP health check configuration.
        :param _builtins.str interval: Period between health checks (in seconds).
        """
        pulumi.set(__self__, "failure_threshold", failure_threshold)
        pulumi.set(__self__, "https", https)
        pulumi.set(__self__, "interval", interval)

    @_builtins.property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> _builtins.int:
        """
        Number of consecutive health check failures before considering the container unhealthy.
        """
        return pulumi.get(self, "failure_threshold")

    @_builtins.property
    @pulumi.getter
    def https(self) -> Sequence['outputs.GetContainerHealthCheckHttpResult']:
        """
        HTTP health check configuration.
        """
        return pulumi.get(self, "https")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> _builtins.str:
        """
        Period between health checks (in seconds).
        """
        return pulumi.get(self, "interval")


@pulumi.output_type
class GetContainerHealthCheckHttpResult(dict):
    def __init__(__self__, *,
                 path: _builtins.str):
        """
        :param _builtins.str path: Path to use for the HTTP health check.
        """
        pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Path to use for the HTTP health check.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class GetContainerScalingOptionResult(dict):
    def __init__(__self__, *,
                 concurrent_requests_threshold: _builtins.int,
                 cpu_usage_threshold: _builtins.int,
                 memory_usage_threshold: _builtins.int):
        """
        :param _builtins.int concurrent_requests_threshold: Scale depending on the number of concurrent requests being processed per container instance.
        :param _builtins.int cpu_usage_threshold: Scale depending on the CPU usage of a container instance.
        :param _builtins.int memory_usage_threshold: Scale depending on the memory usage of a container instance.
        """
        pulumi.set(__self__, "concurrent_requests_threshold", concurrent_requests_threshold)
        pulumi.set(__self__, "cpu_usage_threshold", cpu_usage_threshold)
        pulumi.set(__self__, "memory_usage_threshold", memory_usage_threshold)

    @_builtins.property
    @pulumi.getter(name="concurrentRequestsThreshold")
    def concurrent_requests_threshold(self) -> _builtins.int:
        """
        Scale depending on the number of concurrent requests being processed per container instance.
        """
        return pulumi.get(self, "concurrent_requests_threshold")

    @_builtins.property
    @pulumi.getter(name="cpuUsageThreshold")
    def cpu_usage_threshold(self) -> _builtins.int:
        """
        Scale depending on the CPU usage of a container instance.
        """
        return pulumi.get(self, "cpu_usage_threshold")

    @_builtins.property
    @pulumi.getter(name="memoryUsageThreshold")
    def memory_usage_threshold(self) -> _builtins.int:
        """
        Scale depending on the memory usage of a container instance.
        """
        return pulumi.get(self, "memory_usage_threshold")


