# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DatabaseArgs', 'Database']

@pulumi.input_type
class DatabaseArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Database resource.
        :param pulumi.Input[_builtins.str] instance_id: UUID of the Database Instance.
               
               > **Important:** Updates to `instance_id` will recreate the database.
        :param pulumi.Input[_builtins.str] name: Name of the database (e.g. `my-new-database`).
        :param pulumi.Input[_builtins.str] region: `region`) The region in which the resource exists.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        UUID of the Database Instance.

        > **Important:** Updates to `instance_id` will recreate the database.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the database (e.g. `my-new-database`).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`) The region in which the resource exists.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _DatabaseState:
    def __init__(__self__, *,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Database resources.
        :param pulumi.Input[_builtins.str] instance_id: UUID of the Database Instance.
               
               > **Important:** Updates to `instance_id` will recreate the database.
        :param pulumi.Input[_builtins.bool] managed: Whether the database is managed or not.
        :param pulumi.Input[_builtins.str] name: Name of the database (e.g. `my-new-database`).
        :param pulumi.Input[_builtins.str] owner: The name of the owner of the database.
        :param pulumi.Input[_builtins.str] region: `region`) The region in which the resource exists.
        :param pulumi.Input[_builtins.str] size: Size of the database (in bytes).
        """
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if managed is not None:
            pulumi.set(__self__, "managed", managed)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        UUID of the Database Instance.

        > **Important:** Updates to `instance_id` will recreate the database.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def managed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the database is managed or not.
        """
        return pulumi.get(self, "managed")

    @managed.setter
    def managed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "managed", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the database (e.g. `my-new-database`).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the owner of the database.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`) The region in which the resource exists.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Size of the database (in bytes).
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "size", value)


@pulumi.type_token("scaleway:databases/database:Database")
class Database(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages databases.
        For more information, refer to the [API documentation](https://www.scaleway.com/en/developers/api/managed-database-postgre-mysql/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.databases.Instance("main",
            name="test-rdb",
            node_type="DB-DEV-S",
            engine="PostgreSQL-15",
            is_ha_cluster=True,
            disable_backup=True,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret")
        main_database = scaleway.databases.Database("main",
            instance_id=main.id,
            name="my-new-database")
        ```

        ## Import

        RDB Database can be imported using the `{region}/{id}/{DBNAME}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:databases/database:Database rdb01_mydb fr-par/11111111-1111-1111-1111-111111111111/mydb
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] instance_id: UUID of the Database Instance.
               
               > **Important:** Updates to `instance_id` will recreate the database.
        :param pulumi.Input[_builtins.str] name: Name of the database (e.g. `my-new-database`).
        :param pulumi.Input[_builtins.str] region: `region`) The region in which the resource exists.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages databases.
        For more information, refer to the [API documentation](https://www.scaleway.com/en/developers/api/managed-database-postgre-mysql/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.databases.Instance("main",
            name="test-rdb",
            node_type="DB-DEV-S",
            engine="PostgreSQL-15",
            is_ha_cluster=True,
            disable_backup=True,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret")
        main_database = scaleway.databases.Database("main",
            instance_id=main.id,
            name="my-new-database")
        ```

        ## Import

        RDB Database can be imported using the `{region}/{id}/{DBNAME}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:databases/database:Database rdb01_mydb fr-par/11111111-1111-1111-1111-111111111111/mydb
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseArgs.__new__(DatabaseArgs)

            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["managed"] = None
            __props__.__dict__["owner"] = None
            __props__.__dict__["size"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/database:Database")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Database, __self__).__init__(
            'scaleway:databases/database:Database',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            managed: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            owner: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            size: Optional[pulumi.Input[_builtins.str]] = None) -> 'Database':
        """
        Get an existing Database resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] instance_id: UUID of the Database Instance.
               
               > **Important:** Updates to `instance_id` will recreate the database.
        :param pulumi.Input[_builtins.bool] managed: Whether the database is managed or not.
        :param pulumi.Input[_builtins.str] name: Name of the database (e.g. `my-new-database`).
        :param pulumi.Input[_builtins.str] owner: The name of the owner of the database.
        :param pulumi.Input[_builtins.str] region: `region`) The region in which the resource exists.
        :param pulumi.Input[_builtins.str] size: Size of the database (in bytes).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseState.__new__(_DatabaseState)

        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["managed"] = managed
        __props__.__dict__["name"] = name
        __props__.__dict__["owner"] = owner
        __props__.__dict__["region"] = region
        __props__.__dict__["size"] = size
        return Database(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        UUID of the Database Instance.

        > **Important:** Updates to `instance_id` will recreate the database.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def managed(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the database is managed or not.
        """
        return pulumi.get(self, "managed")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the database (e.g. `my-new-database`).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the owner of the database.
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `region`) The region in which the resource exists.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.str]:
        """
        Size of the database (in bytes).
        """
        return pulumi.get(self, "size")

