# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SnapshotArgs', 'Snapshot']

@pulumi.input_type
class SnapshotArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 expires_at: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Snapshot resource.
        :param pulumi.Input[_builtins.str] instance_id: The UUID of the database instance for which the snapshot is created.
        :param pulumi.Input[_builtins.str] expires_at: Expiration date of the snapshot in ISO 8601 format (e.g., `2025-01-31T00:00:00Z`). If not set, the snapshot will not expire automatically.
        :param pulumi.Input[_builtins.str] name: The name of the snapshot.
        :param pulumi.Input[_builtins.str] region: The region where the snapshot is stored. Defaults to the region set in the provider configuration.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The UUID of the database instance for which the snapshot is created.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Expiration date of the snapshot in ISO 8601 format (e.g., `2025-01-31T00:00:00Z`). If not set, the snapshot will not expire automatically.
        """
        return pulumi.get(self, "expires_at")

    @expires_at.setter
    def expires_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expires_at", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the snapshot.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the snapshot is stored. Defaults to the region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _SnapshotState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 expires_at: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Snapshot resources.
        :param pulumi.Input[_builtins.str] created_at: The timestamp when the snapshot was created, in ISO 8601 format.
        :param pulumi.Input[_builtins.str] expires_at: Expiration date of the snapshot in ISO 8601 format (e.g., `2025-01-31T00:00:00Z`). If not set, the snapshot will not expire automatically.
        :param pulumi.Input[_builtins.str] instance_id: The UUID of the database instance for which the snapshot is created.
        :param pulumi.Input[_builtins.str] name: The name of the snapshot.
        :param pulumi.Input[_builtins.str] node_type: The type of the database instance for which the snapshot was created.
        :param pulumi.Input[_builtins.str] region: The region where the snapshot is stored. Defaults to the region set in the provider configuration.
        :param pulumi.Input[_builtins.int] size: The size of the snapshot in bytes.
        :param pulumi.Input[_builtins.str] status: The current status of the snapshot (e.g., `ready`, `creating`, `error`).
        :param pulumi.Input[_builtins.str] updated_at: The timestamp when the snapshot was last updated, in ISO 8601 format.
        :param pulumi.Input[_builtins.str] volume_type: The type of volume used by the snapshot.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp when the snapshot was created, in ISO 8601 format.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Expiration date of the snapshot in ISO 8601 format (e.g., `2025-01-31T00:00:00Z`). If not set, the snapshot will not expire automatically.
        """
        return pulumi.get(self, "expires_at")

    @expires_at.setter
    def expires_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expires_at", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UUID of the database instance for which the snapshot is created.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the snapshot.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the database instance for which the snapshot was created.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_type", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the snapshot is stored. Defaults to the region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the snapshot in bytes.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current status of the snapshot (e.g., `ready`, `creating`, `error`).
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timestamp when the snapshot was last updated, in ISO 8601 format.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of volume used by the snapshot.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_type", value)


@pulumi.type_token("scaleway:databases/snapshot:Snapshot")
class Snapshot(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 expires_at: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway RDB (Relational Database) Snapshots.
        Snapshots are point-in-time backups of a database instance that can be used for recovery or duplication.
        For more information, refer to [the API documentation](https://www.scaleway.com/en/developers/api/managed-database-postgre-mysql/).

        ## Example Usage

        ### Example Basic Snapshot

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.databases.Instance("main",
            name="test-rdb-instance",
            node_type="db-dev-s",
            engine="PostgreSQL-15",
            is_ha_cluster=False,
            disable_backup=True,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            tags=[
                "terraform-test",
                "scaleway_rdb_instance",
                "minimal",
            ],
            volume_type="sbs_5k",
            volume_size_in_gb=10)
        test = scaleway.databases.Snapshot("test",
            name="initial-snapshot",
            instance_id=main.id,
            opts = pulumi.ResourceOptions(depends_on=[main]))
        ```

        ### Example with Expiration

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        snapshot_with_expiration = scaleway.databases.Snapshot("snapshot_with_expiration",
            name="snapshot-with-expiration",
            instance_id=main["id"],
            expires_at="2025-01-31T00:00:00Z")
        ```

        ### Example with Multiple Snapshots

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        snapshot_a = scaleway.databases.Snapshot("snapshot_a",
            name="snapshot_a",
            instance_id=main["id"],
            opts = pulumi.ResourceOptions(depends_on=[main]))
        snapshot_b = scaleway.databases.Snapshot("snapshot_b",
            name="snapshot_b",
            instance_id=main["id"],
            expires_at="2025-02-07T00:00:00Z",
            opts = pulumi.ResourceOptions(depends_on=[main]))
        ```

        ## Limitations

        - Snapshots are tied to the database instance and region where they are created.
        - Expired snapshots are automatically deleted and cannot be restored.

        ## Notes

        - Ensure the `instance_id` corresponds to an existing database instance.
        - Use the `depends_on` argument when creating snapshots right after creating an instance to ensure proper dependency management.

        ## Import

        RDB Snapshots can be imported using the `{region}/{snapshot_id}` format.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] expires_at: Expiration date of the snapshot in ISO 8601 format (e.g., `2025-01-31T00:00:00Z`). If not set, the snapshot will not expire automatically.
        :param pulumi.Input[_builtins.str] instance_id: The UUID of the database instance for which the snapshot is created.
        :param pulumi.Input[_builtins.str] name: The name of the snapshot.
        :param pulumi.Input[_builtins.str] region: The region where the snapshot is stored. Defaults to the region set in the provider configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SnapshotArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway RDB (Relational Database) Snapshots.
        Snapshots are point-in-time backups of a database instance that can be used for recovery or duplication.
        For more information, refer to [the API documentation](https://www.scaleway.com/en/developers/api/managed-database-postgre-mysql/).

        ## Example Usage

        ### Example Basic Snapshot

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.databases.Instance("main",
            name="test-rdb-instance",
            node_type="db-dev-s",
            engine="PostgreSQL-15",
            is_ha_cluster=False,
            disable_backup=True,
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            tags=[
                "terraform-test",
                "scaleway_rdb_instance",
                "minimal",
            ],
            volume_type="sbs_5k",
            volume_size_in_gb=10)
        test = scaleway.databases.Snapshot("test",
            name="initial-snapshot",
            instance_id=main.id,
            opts = pulumi.ResourceOptions(depends_on=[main]))
        ```

        ### Example with Expiration

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        snapshot_with_expiration = scaleway.databases.Snapshot("snapshot_with_expiration",
            name="snapshot-with-expiration",
            instance_id=main["id"],
            expires_at="2025-01-31T00:00:00Z")
        ```

        ### Example with Multiple Snapshots

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        snapshot_a = scaleway.databases.Snapshot("snapshot_a",
            name="snapshot_a",
            instance_id=main["id"],
            opts = pulumi.ResourceOptions(depends_on=[main]))
        snapshot_b = scaleway.databases.Snapshot("snapshot_b",
            name="snapshot_b",
            instance_id=main["id"],
            expires_at="2025-02-07T00:00:00Z",
            opts = pulumi.ResourceOptions(depends_on=[main]))
        ```

        ## Limitations

        - Snapshots are tied to the database instance and region where they are created.
        - Expired snapshots are automatically deleted and cannot be restored.

        ## Notes

        - Ensure the `instance_id` corresponds to an existing database instance.
        - Use the `depends_on` argument when creating snapshots right after creating an instance to ensure proper dependency management.

        ## Import

        RDB Snapshots can be imported using the `{region}/{snapshot_id}` format.

        :param str resource_name: The name of the resource.
        :param SnapshotArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SnapshotArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 expires_at: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SnapshotArgs.__new__(SnapshotArgs)

            __props__.__dict__["expires_at"] = expires_at
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["created_at"] = None
            __props__.__dict__["node_type"] = None
            __props__.__dict__["size"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["volume_type"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/rdbSnapshot:RdbSnapshot")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Snapshot, __self__).__init__(
            'scaleway:databases/snapshot:Snapshot',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            expires_at: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            node_type: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            size: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            volume_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Snapshot':
        """
        Get an existing Snapshot resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: The timestamp when the snapshot was created, in ISO 8601 format.
        :param pulumi.Input[_builtins.str] expires_at: Expiration date of the snapshot in ISO 8601 format (e.g., `2025-01-31T00:00:00Z`). If not set, the snapshot will not expire automatically.
        :param pulumi.Input[_builtins.str] instance_id: The UUID of the database instance for which the snapshot is created.
        :param pulumi.Input[_builtins.str] name: The name of the snapshot.
        :param pulumi.Input[_builtins.str] node_type: The type of the database instance for which the snapshot was created.
        :param pulumi.Input[_builtins.str] region: The region where the snapshot is stored. Defaults to the region set in the provider configuration.
        :param pulumi.Input[_builtins.int] size: The size of the snapshot in bytes.
        :param pulumi.Input[_builtins.str] status: The current status of the snapshot (e.g., `ready`, `creating`, `error`).
        :param pulumi.Input[_builtins.str] updated_at: The timestamp when the snapshot was last updated, in ISO 8601 format.
        :param pulumi.Input[_builtins.str] volume_type: The type of volume used by the snapshot.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SnapshotState.__new__(_SnapshotState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["expires_at"] = expires_at
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        __props__.__dict__["node_type"] = node_type
        __props__.__dict__["region"] = region
        __props__.__dict__["size"] = size
        __props__.__dict__["status"] = status
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["volume_type"] = volume_type
        return Snapshot(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp when the snapshot was created, in ISO 8601 format.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> pulumi.Output[_builtins.str]:
        """
        Expiration date of the snapshot in ISO 8601 format (e.g., `2025-01-31T00:00:00Z`). If not set, the snapshot will not expire automatically.
        """
        return pulumi.get(self, "expires_at")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The UUID of the database instance for which the snapshot is created.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the snapshot.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the database instance for which the snapshot was created.
        """
        return pulumi.get(self, "node_type")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The region where the snapshot is stored. Defaults to the region set in the provider configuration.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.int]:
        """
        The size of the snapshot in bytes.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The current status of the snapshot (e.g., `ready`, `creating`, `error`).
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The timestamp when the snapshot was last updated, in ISO 8601 format.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of volume used by the snapshot.
        """
        return pulumi.get(self, "volume_type")

