# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 deployment_id: pulumi.Input[_builtins.str],
                 password: pulumi.Input[_builtins.str],
                 is_admin: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[_builtins.str] deployment_id: ID of the Data Warehouse deployment to which this user belongs.
        :param pulumi.Input[_builtins.str] password: Password for the ClickHouse user.
        :param pulumi.Input[_builtins.bool] is_admin: Whether the user has administrator privileges. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: Name of the ClickHouse user.
        :param pulumi.Input[_builtins.str] region: `region`) The region in which the user should be created.
        """
        pulumi.set(__self__, "deployment_id", deployment_id)
        pulumi.set(__self__, "password", password)
        if is_admin is not None:
            pulumi.set(__self__, "is_admin", is_admin)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the Data Warehouse deployment to which this user belongs.
        """
        return pulumi.get(self, "deployment_id")

    @deployment_id.setter
    def deployment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "deployment_id", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Input[_builtins.str]:
        """
        Password for the ClickHouse user.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the user has administrator privileges. Defaults to `false`.
        """
        return pulumi.get(self, "is_admin")

    @is_admin.setter
    def is_admin(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_admin", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the ClickHouse user.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`) The region in which the user should be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 deployment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_admin: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[_builtins.str] deployment_id: ID of the Data Warehouse deployment to which this user belongs.
        :param pulumi.Input[_builtins.bool] is_admin: Whether the user has administrator privileges. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: Name of the ClickHouse user.
        :param pulumi.Input[_builtins.str] password: Password for the ClickHouse user.
        :param pulumi.Input[_builtins.str] region: `region`) The region in which the user should be created.
        """
        if deployment_id is not None:
            pulumi.set(__self__, "deployment_id", deployment_id)
        if is_admin is not None:
            pulumi.set(__self__, "is_admin", is_admin)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the Data Warehouse deployment to which this user belongs.
        """
        return pulumi.get(self, "deployment_id")

    @deployment_id.setter
    def deployment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deployment_id", value)

    @_builtins.property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the user has administrator privileges. Defaults to `false`.
        """
        return pulumi.get(self, "is_admin")

    @is_admin.setter
    def is_admin(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_admin", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the ClickHouse user.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Password for the ClickHouse user.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`) The region in which the user should be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("scaleway:datawarehouse/user:User")
class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deployment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_admin: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Data Warehouse users within a deployment.
        For more information refer to the [product documentation](https://www.scaleway.com/en/docs/data-warehouse/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.datawarehouse.Deployment("main",
            name="my-datawarehouse",
            version="v25",
            replica_count=1,
            cpu_min=2,
            cpu_max=4,
            ram_per_cpu=4,
            password="thiZ_is_v&ry_s3cret")
        main_user = scaleway.datawarehouse.User("main",
            deployment_id=main.id,
            name="my_user",
            password="user_password_123")
        ```

        ### Admin User

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.datawarehouse.Deployment("main",
            name="my-datawarehouse",
            version="v25",
            replica_count=1,
            cpu_min=2,
            cpu_max=4,
            ram_per_cpu=4,
            password="thiZ_is_v&ry_s3cret")
        admin = scaleway.datawarehouse.User("admin",
            deployment_id=main.id,
            name="admin_user",
            password="admin_password_456",
            is_admin=True)
        ```

        ## Import

        Data Warehouse users can be imported using the `{region}/{deployment_id}/{name}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:datawarehouse/user:User main fr-par/11111111-1111-1111-1111-111111111111/my_user
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] deployment_id: ID of the Data Warehouse deployment to which this user belongs.
        :param pulumi.Input[_builtins.bool] is_admin: Whether the user has administrator privileges. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: Name of the ClickHouse user.
        :param pulumi.Input[_builtins.str] password: Password for the ClickHouse user.
        :param pulumi.Input[_builtins.str] region: `region`) The region in which the user should be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Data Warehouse users within a deployment.
        For more information refer to the [product documentation](https://www.scaleway.com/en/docs/data-warehouse/).

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.datawarehouse.Deployment("main",
            name="my-datawarehouse",
            version="v25",
            replica_count=1,
            cpu_min=2,
            cpu_max=4,
            ram_per_cpu=4,
            password="thiZ_is_v&ry_s3cret")
        main_user = scaleway.datawarehouse.User("main",
            deployment_id=main.id,
            name="my_user",
            password="user_password_123")
        ```

        ### Admin User

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.datawarehouse.Deployment("main",
            name="my-datawarehouse",
            version="v25",
            replica_count=1,
            cpu_min=2,
            cpu_max=4,
            ram_per_cpu=4,
            password="thiZ_is_v&ry_s3cret")
        admin = scaleway.datawarehouse.User("admin",
            deployment_id=main.id,
            name="admin_user",
            password="admin_password_456",
            is_admin=True)
        ```

        ## Import

        Data Warehouse users can be imported using the `{region}/{deployment_id}/{name}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:datawarehouse/user:User main fr-par/11111111-1111-1111-1111-111111111111/my_user
        ```

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deployment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_admin: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            if deployment_id is None and not opts.urn:
                raise TypeError("Missing required property 'deployment_id'")
            __props__.__dict__["deployment_id"] = deployment_id
            __props__.__dict__["is_admin"] = is_admin
            __props__.__dict__["name"] = name
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["region"] = region
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(User, __self__).__init__(
            'scaleway:datawarehouse/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            deployment_id: Optional[pulumi.Input[_builtins.str]] = None,
            is_admin: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] deployment_id: ID of the Data Warehouse deployment to which this user belongs.
        :param pulumi.Input[_builtins.bool] is_admin: Whether the user has administrator privileges. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: Name of the ClickHouse user.
        :param pulumi.Input[_builtins.str] password: Password for the ClickHouse user.
        :param pulumi.Input[_builtins.str] region: `region`) The region in which the user should be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["deployment_id"] = deployment_id
        __props__.__dict__["is_admin"] = is_admin
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["region"] = region
        return User(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the Data Warehouse deployment to which this user belongs.
        """
        return pulumi.get(self, "deployment_id")

    @_builtins.property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the user has administrator privileges. Defaults to `false`.
        """
        return pulumi.get(self, "is_admin")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the ClickHouse user.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[_builtins.str]:
        """
        Password for the ClickHouse user.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `region`) The region in which the user should be created.
        """
        return pulumi.get(self, "region")

