# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainRecordArgs', 'DomainRecord']

@pulumi.input_type
class DomainRecordArgs:
    def __init__(__self__, *,
                 data: pulumi.Input[_builtins.str],
                 dns_zone: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 geo_ip: Optional[pulumi.Input['DomainRecordGeoIpArgs']] = None,
                 http_service: Optional[pulumi.Input['DomainRecordHttpServiceArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 views: Optional[pulumi.Input[Sequence[pulumi.Input['DomainRecordViewArgs']]]] = None,
                 weighteds: Optional[pulumi.Input[Sequence[pulumi.Input['DomainRecordWeightedArgs']]]] = None):
        """
        The set of arguments for constructing a DomainRecord resource.
        :param pulumi.Input[_builtins.str] data: The content of the record (an IPv4 for an `A` record, a string for a `TXT` record, etc.).
        :param pulumi.Input[_builtins.str] dns_zone: The DNS zone of the domain. If the domain has no DNS zone, one will be automatically created.
        :param pulumi.Input[_builtins.str] type: The type of the record (`A`, `AAAA`, `MX`, `CNAME`, `DNAME`, `ALIAS`, `NS`, `PTR`, `SRV`, `TXT`, `TLSA`, or `CAA`).
        :param pulumi.Input['DomainRecordGeoIpArgs'] geo_ip: Return record based on client localisation
        :param pulumi.Input['DomainRecordHttpServiceArgs'] http_service: Return record based on client localisation
        :param pulumi.Input[_builtins.str] name: The name of the record (can be an empty string for a root record).
        :param pulumi.Input[_builtins.int] priority: The priority of the record (mostly used with an `MX` record).
        :param pulumi.Input[_builtins.str] project_id: The project_id you want to attach the resource to
        :param pulumi.Input[_builtins.int] ttl: Time To Live of the record in seconds.
        :param pulumi.Input[Sequence[pulumi.Input['DomainRecordViewArgs']]] views: Return record based on client subnet
        :param pulumi.Input[Sequence[pulumi.Input['DomainRecordWeightedArgs']]] weighteds: Return record based on weight
        """
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "dns_zone", dns_zone)
        pulumi.set(__self__, "type", type)
        if geo_ip is not None:
            pulumi.set(__self__, "geo_ip", geo_ip)
        if http_service is not None:
            pulumi.set(__self__, "http_service", http_service)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if views is not None:
            pulumi.set(__self__, "views", views)
        if weighteds is not None:
            pulumi.set(__self__, "weighteds", weighteds)

    @_builtins.property
    @pulumi.getter
    def data(self) -> pulumi.Input[_builtins.str]:
        """
        The content of the record (an IPv4 for an `A` record, a string for a `TXT` record, etc.).
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data", value)

    @_builtins.property
    @pulumi.getter(name="dnsZone")
    def dns_zone(self) -> pulumi.Input[_builtins.str]:
        """
        The DNS zone of the domain. If the domain has no DNS zone, one will be automatically created.
        """
        return pulumi.get(self, "dns_zone")

    @dns_zone.setter
    def dns_zone(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dns_zone", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the record (`A`, `AAAA`, `MX`, `CNAME`, `DNAME`, `ALIAS`, `NS`, `PTR`, `SRV`, `TXT`, `TLSA`, or `CAA`).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="geoIp")
    def geo_ip(self) -> Optional[pulumi.Input['DomainRecordGeoIpArgs']]:
        """
        Return record based on client localisation
        """
        return pulumi.get(self, "geo_ip")

    @geo_ip.setter
    def geo_ip(self, value: Optional[pulumi.Input['DomainRecordGeoIpArgs']]):
        pulumi.set(self, "geo_ip", value)

    @_builtins.property
    @pulumi.getter(name="httpService")
    def http_service(self) -> Optional[pulumi.Input['DomainRecordHttpServiceArgs']]:
        """
        Return record based on client localisation
        """
        return pulumi.get(self, "http_service")

    @http_service.setter
    def http_service(self, value: Optional[pulumi.Input['DomainRecordHttpServiceArgs']]):
        pulumi.set(self, "http_service", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the record (can be an empty string for a root record).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The priority of the record (mostly used with an `MX` record).
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project_id you want to attach the resource to
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time To Live of the record in seconds.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl", value)

    @_builtins.property
    @pulumi.getter
    def views(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainRecordViewArgs']]]]:
        """
        Return record based on client subnet
        """
        return pulumi.get(self, "views")

    @views.setter
    def views(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainRecordViewArgs']]]]):
        pulumi.set(self, "views", value)

    @_builtins.property
    @pulumi.getter
    def weighteds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainRecordWeightedArgs']]]]:
        """
        Return record based on weight
        """
        return pulumi.get(self, "weighteds")

    @weighteds.setter
    def weighteds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainRecordWeightedArgs']]]]):
        pulumi.set(self, "weighteds", value)


@pulumi.input_type
class _DomainRecordState:
    def __init__(__self__, *,
                 data: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 fqdn: Optional[pulumi.Input[_builtins.str]] = None,
                 geo_ip: Optional[pulumi.Input['DomainRecordGeoIpArgs']] = None,
                 http_service: Optional[pulumi.Input['DomainRecordHttpServiceArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 root_zone: Optional[pulumi.Input[_builtins.bool]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 views: Optional[pulumi.Input[Sequence[pulumi.Input['DomainRecordViewArgs']]]] = None,
                 weighteds: Optional[pulumi.Input[Sequence[pulumi.Input['DomainRecordWeightedArgs']]]] = None):
        """
        Input properties used for looking up and filtering DomainRecord resources.
        :param pulumi.Input[_builtins.str] data: The content of the record (an IPv4 for an `A` record, a string for a `TXT` record, etc.).
        :param pulumi.Input[_builtins.str] dns_zone: The DNS zone of the domain. If the domain has no DNS zone, one will be automatically created.
        :param pulumi.Input[_builtins.str] fqdn: The FQDN of the record.
        :param pulumi.Input['DomainRecordGeoIpArgs'] geo_ip: Return record based on client localisation
        :param pulumi.Input['DomainRecordHttpServiceArgs'] http_service: Return record based on client localisation
        :param pulumi.Input[_builtins.str] name: The name of the record (can be an empty string for a root record).
        :param pulumi.Input[_builtins.int] priority: The priority of the record (mostly used with an `MX` record).
        :param pulumi.Input[_builtins.str] project_id: The project_id you want to attach the resource to
        :param pulumi.Input[_builtins.bool] root_zone: Does the DNS zone is the root zone or not
        :param pulumi.Input[_builtins.int] ttl: Time To Live of the record in seconds.
        :param pulumi.Input[_builtins.str] type: The type of the record (`A`, `AAAA`, `MX`, `CNAME`, `DNAME`, `ALIAS`, `NS`, `PTR`, `SRV`, `TXT`, `TLSA`, or `CAA`).
        :param pulumi.Input[Sequence[pulumi.Input['DomainRecordViewArgs']]] views: Return record based on client subnet
        :param pulumi.Input[Sequence[pulumi.Input['DomainRecordWeightedArgs']]] weighteds: Return record based on weight
        """
        if data is not None:
            pulumi.set(__self__, "data", data)
        if dns_zone is not None:
            pulumi.set(__self__, "dns_zone", dns_zone)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if geo_ip is not None:
            pulumi.set(__self__, "geo_ip", geo_ip)
        if http_service is not None:
            pulumi.set(__self__, "http_service", http_service)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if root_zone is not None:
            pulumi.set(__self__, "root_zone", root_zone)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if views is not None:
            pulumi.set(__self__, "views", views)
        if weighteds is not None:
            pulumi.set(__self__, "weighteds", weighteds)

    @_builtins.property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content of the record (an IPv4 for an `A` record, a string for a `TXT` record, etc.).
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data", value)

    @_builtins.property
    @pulumi.getter(name="dnsZone")
    def dns_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The DNS zone of the domain. If the domain has no DNS zone, one will be automatically created.
        """
        return pulumi.get(self, "dns_zone")

    @dns_zone.setter
    def dns_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_zone", value)

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The FQDN of the record.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fqdn", value)

    @_builtins.property
    @pulumi.getter(name="geoIp")
    def geo_ip(self) -> Optional[pulumi.Input['DomainRecordGeoIpArgs']]:
        """
        Return record based on client localisation
        """
        return pulumi.get(self, "geo_ip")

    @geo_ip.setter
    def geo_ip(self, value: Optional[pulumi.Input['DomainRecordGeoIpArgs']]):
        pulumi.set(self, "geo_ip", value)

    @_builtins.property
    @pulumi.getter(name="httpService")
    def http_service(self) -> Optional[pulumi.Input['DomainRecordHttpServiceArgs']]:
        """
        Return record based on client localisation
        """
        return pulumi.get(self, "http_service")

    @http_service.setter
    def http_service(self, value: Optional[pulumi.Input['DomainRecordHttpServiceArgs']]):
        pulumi.set(self, "http_service", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the record (can be an empty string for a root record).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The priority of the record (mostly used with an `MX` record).
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The project_id you want to attach the resource to
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="rootZone")
    def root_zone(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Does the DNS zone is the root zone or not
        """
        return pulumi.get(self, "root_zone")

    @root_zone.setter
    def root_zone(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "root_zone", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time To Live of the record in seconds.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the record (`A`, `AAAA`, `MX`, `CNAME`, `DNAME`, `ALIAS`, `NS`, `PTR`, `SRV`, `TXT`, `TLSA`, or `CAA`).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def views(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainRecordViewArgs']]]]:
        """
        Return record based on client subnet
        """
        return pulumi.get(self, "views")

    @views.setter
    def views(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainRecordViewArgs']]]]):
        pulumi.set(self, "views", value)

    @_builtins.property
    @pulumi.getter
    def weighteds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainRecordWeightedArgs']]]]:
        """
        Return record based on weight
        """
        return pulumi.get(self, "weighteds")

    @weighteds.setter
    def weighteds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainRecordWeightedArgs']]]]):
        pulumi.set(self, "weighteds", value)


warnings.warn("""scaleway.index/domainrecord.DomainRecord has been deprecated in favor of scaleway.domain/record.Record""", DeprecationWarning)


@pulumi.type_token("scaleway:index/domainRecord:DomainRecord")
class DomainRecord(pulumi.CustomResource):
    warnings.warn("""scaleway.index/domainrecord.DomainRecord has been deprecated in favor of scaleway.domain/record.Record""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 geo_ip: Optional[pulumi.Input[Union['DomainRecordGeoIpArgs', 'DomainRecordGeoIpArgsDict']]] = None,
                 http_service: Optional[pulumi.Input[Union['DomainRecordHttpServiceArgs', 'DomainRecordHttpServiceArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 views: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainRecordViewArgs', 'DomainRecordViewArgsDict']]]]] = None,
                 weighteds: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainRecordWeightedArgs', 'DomainRecordWeightedArgsDict']]]]] = None,
                 __props__=None):
        """
        The `domain.Record` resource allows you to create and manage DNS records for Scaleway domains.

        Refer to the Domains and DNS [product documentation](https://www.scaleway.com/en/docs/network/domains-and-dns/) and [API documentation](https://www.scaleway.com/en/developers/api/domains-and-dns/) for more information.

        ## Example Usage

        ### Create basic DNS records

        The following commands allow you to:

        - create an A record for the `www.domain.tld` domain, pointing to `1.2.3.4` and another one pointing to `1.2.3.5`

        - create an MX record with the `mx.online.net.` mail server and a priority of 10, and another one with the `mx-cache.online.net.` mail server and a priority of 20

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        www = scaleway.domain.Record("www",
            dns_zone="domain.tld",
            name="www",
            type="A",
            data="1.2.3.4",
            ttl=3600)
        www2 = scaleway.domain.Record("www2",
            dns_zone="domain.tld",
            name="www",
            type="A",
            data="1.2.3.5",
            ttl=3600)
        mx = scaleway.domain.Record("mx",
            dns_zone="domain.tld",
            name="",
            type="MX",
            data="mx.online.net.",
            ttl=3600,
            priority=10)
        mx2 = scaleway.domain.Record("mx2",
            dns_zone="domain.tld",
            name="",
            type="MX",
            data="mx-cache.online.net.",
            ttl=3600,
            priority=20)
        ```

        ### Create dynamic records

        The following commands allow you to:

        - create a Geo IP record for `images.domain.tld` that points to different IPs based on the user's location: `1.2.3.5` for users in France (EU), and `4.3.2.1` for users in North America (NA)

        - create an HTTP service record for `app.domain.tld` that checks the health of specified IPs and responds based on their status.

        - create view-based records for `db.domain.tld` that resolve differently based on the client's subnet.

        - create a weighted record for `web.domain.tld` that directs traffic to different IPs based on their weights.

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        geo_ip = scaleway.domain.Record("geo_ip",
            dns_zone="domain.tld",
            name="images",
            type="A",
            data="1.2.3.4",
            ttl=3600,
            geo_ip={
                "matches": [
                    {
                        "continents": ["EU"],
                        "countries": ["FR"],
                        "data": "1.2.3.5",
                    },
                    {
                        "continents": ["NA"],
                        "data": "4.3.2.1",
                    },
                ],
            })
        http_service = scaleway.domain.Record("http_service",
            dns_zone="domain.tld",
            name="app",
            type="A",
            data="1.2.3.4",
            ttl=3600,
            http_service={
                "ips": [
                    "1.2.3.5",
                    "1.2.3.6",
                ],
                "must_contain": "up",
                "url": "http://mywebsite.com/health",
                "user_agent": "scw_service_up",
                "strategy": "hashed",
            })
        view = scaleway.domain.Record("view",
            dns_zone="domain.tld",
            name="db",
            type="A",
            data="1.2.3.4",
            ttl=3600,
            views=[
                {
                    "subnet": "100.0.0.0/16",
                    "data": "1.2.3.5",
                },
                {
                    "subnet": "100.1.0.0/16",
                    "data": "1.2.3.6",
                },
            ])
        weighted = scaleway.domain.Record("weighted",
            dns_zone="domain.tld",
            name="web",
            type="A",
            data="1.2.3.4",
            ttl=3600,
            weighteds=[
                {
                    "ip": "1.2.3.5",
                    "weight": 1,
                },
                {
                    "ip": "1.2.3.6",
                    "weight": 2,
                },
            ])
        ```

        ### Create an Instance and add records with the new Instance IP

        The following commands allow you to:

        - create a Scaleway Instance
        - assign The Instance's IP address to various DNS records for a specified DNS zone

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        config = pulumi.Config()
        # Your project ID.
        project_id = config.require("projectId")
        # The DNS Zone used for testing records.
        dns_zone = config.require("dnsZone")
        public_ip = scaleway.instance.Ip("public_ip", project_id=project_id)
        web = scaleway.instance.Server("web",
            project_id=project_id,
            type="DEV1-S",
            image="ubuntu_jammy",
            tags=[
                "front",
                "web",
            ],
            ip_id=public_ip.id,
            root_volume={
                "size_in_gb": 20,
            })
        web_a = scaleway.domain.Record("web_A",
            dns_zone=dns_zone,
            name="web",
            type="A",
            data=web.public_ip,
            ttl=3600)
        web_cname = scaleway.domain.Record("web_cname",
            dns_zone=dns_zone,
            name="www",
            type="CNAME",
            data=f"web.{dns_zone}.",
            ttl=3600)
        web_alias = scaleway.domain.Record("web_alias",
            dns_zone=dns_zone,
            name="",
            type="ALIAS",
            data=f"web.{dns_zone}.",
            ttl=3600)
        ```

        ## Multiple records

        Some record types can have multiple data with the same name (e.g., `A`, `AAAA`, `MX`, `NS`, etc.). You can duplicate a `domain.Record`  resource with the same `name`, and the records will be added.

        Note however, that some records (e.g., CNAME, multiple dynamic records of different types) must be unique.

        ## Import

        This section explains how to import a record using the `{dns_zone}/{id}` format.

        bash

        ```sh
        $ pulumi import scaleway:index/domainRecord:DomainRecord www subdomain.domain.tld/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] data: The content of the record (an IPv4 for an `A` record, a string for a `TXT` record, etc.).
        :param pulumi.Input[_builtins.str] dns_zone: The DNS zone of the domain. If the domain has no DNS zone, one will be automatically created.
        :param pulumi.Input[Union['DomainRecordGeoIpArgs', 'DomainRecordGeoIpArgsDict']] geo_ip: Return record based on client localisation
        :param pulumi.Input[Union['DomainRecordHttpServiceArgs', 'DomainRecordHttpServiceArgsDict']] http_service: Return record based on client localisation
        :param pulumi.Input[_builtins.str] name: The name of the record (can be an empty string for a root record).
        :param pulumi.Input[_builtins.int] priority: The priority of the record (mostly used with an `MX` record).
        :param pulumi.Input[_builtins.str] project_id: The project_id you want to attach the resource to
        :param pulumi.Input[_builtins.int] ttl: Time To Live of the record in seconds.
        :param pulumi.Input[_builtins.str] type: The type of the record (`A`, `AAAA`, `MX`, `CNAME`, `DNAME`, `ALIAS`, `NS`, `PTR`, `SRV`, `TXT`, `TLSA`, or `CAA`).
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainRecordViewArgs', 'DomainRecordViewArgsDict']]]] views: Return record based on client subnet
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainRecordWeightedArgs', 'DomainRecordWeightedArgsDict']]]] weighteds: Return record based on weight
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainRecordArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `domain.Record` resource allows you to create and manage DNS records for Scaleway domains.

        Refer to the Domains and DNS [product documentation](https://www.scaleway.com/en/docs/network/domains-and-dns/) and [API documentation](https://www.scaleway.com/en/developers/api/domains-and-dns/) for more information.

        ## Example Usage

        ### Create basic DNS records

        The following commands allow you to:

        - create an A record for the `www.domain.tld` domain, pointing to `1.2.3.4` and another one pointing to `1.2.3.5`

        - create an MX record with the `mx.online.net.` mail server and a priority of 10, and another one with the `mx-cache.online.net.` mail server and a priority of 20

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        www = scaleway.domain.Record("www",
            dns_zone="domain.tld",
            name="www",
            type="A",
            data="1.2.3.4",
            ttl=3600)
        www2 = scaleway.domain.Record("www2",
            dns_zone="domain.tld",
            name="www",
            type="A",
            data="1.2.3.5",
            ttl=3600)
        mx = scaleway.domain.Record("mx",
            dns_zone="domain.tld",
            name="",
            type="MX",
            data="mx.online.net.",
            ttl=3600,
            priority=10)
        mx2 = scaleway.domain.Record("mx2",
            dns_zone="domain.tld",
            name="",
            type="MX",
            data="mx-cache.online.net.",
            ttl=3600,
            priority=20)
        ```

        ### Create dynamic records

        The following commands allow you to:

        - create a Geo IP record for `images.domain.tld` that points to different IPs based on the user's location: `1.2.3.5` for users in France (EU), and `4.3.2.1` for users in North America (NA)

        - create an HTTP service record for `app.domain.tld` that checks the health of specified IPs and responds based on their status.

        - create view-based records for `db.domain.tld` that resolve differently based on the client's subnet.

        - create a weighted record for `web.domain.tld` that directs traffic to different IPs based on their weights.

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        geo_ip = scaleway.domain.Record("geo_ip",
            dns_zone="domain.tld",
            name="images",
            type="A",
            data="1.2.3.4",
            ttl=3600,
            geo_ip={
                "matches": [
                    {
                        "continents": ["EU"],
                        "countries": ["FR"],
                        "data": "1.2.3.5",
                    },
                    {
                        "continents": ["NA"],
                        "data": "4.3.2.1",
                    },
                ],
            })
        http_service = scaleway.domain.Record("http_service",
            dns_zone="domain.tld",
            name="app",
            type="A",
            data="1.2.3.4",
            ttl=3600,
            http_service={
                "ips": [
                    "1.2.3.5",
                    "1.2.3.6",
                ],
                "must_contain": "up",
                "url": "http://mywebsite.com/health",
                "user_agent": "scw_service_up",
                "strategy": "hashed",
            })
        view = scaleway.domain.Record("view",
            dns_zone="domain.tld",
            name="db",
            type="A",
            data="1.2.3.4",
            ttl=3600,
            views=[
                {
                    "subnet": "100.0.0.0/16",
                    "data": "1.2.3.5",
                },
                {
                    "subnet": "100.1.0.0/16",
                    "data": "1.2.3.6",
                },
            ])
        weighted = scaleway.domain.Record("weighted",
            dns_zone="domain.tld",
            name="web",
            type="A",
            data="1.2.3.4",
            ttl=3600,
            weighteds=[
                {
                    "ip": "1.2.3.5",
                    "weight": 1,
                },
                {
                    "ip": "1.2.3.6",
                    "weight": 2,
                },
            ])
        ```

        ### Create an Instance and add records with the new Instance IP

        The following commands allow you to:

        - create a Scaleway Instance
        - assign The Instance's IP address to various DNS records for a specified DNS zone

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        config = pulumi.Config()
        # Your project ID.
        project_id = config.require("projectId")
        # The DNS Zone used for testing records.
        dns_zone = config.require("dnsZone")
        public_ip = scaleway.instance.Ip("public_ip", project_id=project_id)
        web = scaleway.instance.Server("web",
            project_id=project_id,
            type="DEV1-S",
            image="ubuntu_jammy",
            tags=[
                "front",
                "web",
            ],
            ip_id=public_ip.id,
            root_volume={
                "size_in_gb": 20,
            })
        web_a = scaleway.domain.Record("web_A",
            dns_zone=dns_zone,
            name="web",
            type="A",
            data=web.public_ip,
            ttl=3600)
        web_cname = scaleway.domain.Record("web_cname",
            dns_zone=dns_zone,
            name="www",
            type="CNAME",
            data=f"web.{dns_zone}.",
            ttl=3600)
        web_alias = scaleway.domain.Record("web_alias",
            dns_zone=dns_zone,
            name="",
            type="ALIAS",
            data=f"web.{dns_zone}.",
            ttl=3600)
        ```

        ## Multiple records

        Some record types can have multiple data with the same name (e.g., `A`, `AAAA`, `MX`, `NS`, etc.). You can duplicate a `domain.Record`  resource with the same `name`, and the records will be added.

        Note however, that some records (e.g., CNAME, multiple dynamic records of different types) must be unique.

        ## Import

        This section explains how to import a record using the `{dns_zone}/{id}` format.

        bash

        ```sh
        $ pulumi import scaleway:index/domainRecord:DomainRecord www subdomain.domain.tld/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param DomainRecordArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainRecordArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 geo_ip: Optional[pulumi.Input[Union['DomainRecordGeoIpArgs', 'DomainRecordGeoIpArgsDict']]] = None,
                 http_service: Optional[pulumi.Input[Union['DomainRecordHttpServiceArgs', 'DomainRecordHttpServiceArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 priority: Optional[pulumi.Input[_builtins.int]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 views: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainRecordViewArgs', 'DomainRecordViewArgsDict']]]]] = None,
                 weighteds: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainRecordWeightedArgs', 'DomainRecordWeightedArgsDict']]]]] = None,
                 __props__=None):
        pulumi.log.warn("""DomainRecord is deprecated: scaleway.index/domainrecord.DomainRecord has been deprecated in favor of scaleway.domain/record.Record""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainRecordArgs.__new__(DomainRecordArgs)

            if data is None and not opts.urn:
                raise TypeError("Missing required property 'data'")
            __props__.__dict__["data"] = data
            if dns_zone is None and not opts.urn:
                raise TypeError("Missing required property 'dns_zone'")
            __props__.__dict__["dns_zone"] = dns_zone
            __props__.__dict__["geo_ip"] = geo_ip
            __props__.__dict__["http_service"] = http_service
            __props__.__dict__["name"] = name
            __props__.__dict__["priority"] = priority
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["ttl"] = ttl
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["views"] = views
            __props__.__dict__["weighteds"] = weighteds
            __props__.__dict__["fqdn"] = None
            __props__.__dict__["root_zone"] = None
        super(DomainRecord, __self__).__init__(
            'scaleway:index/domainRecord:DomainRecord',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            data: Optional[pulumi.Input[_builtins.str]] = None,
            dns_zone: Optional[pulumi.Input[_builtins.str]] = None,
            fqdn: Optional[pulumi.Input[_builtins.str]] = None,
            geo_ip: Optional[pulumi.Input[Union['DomainRecordGeoIpArgs', 'DomainRecordGeoIpArgsDict']]] = None,
            http_service: Optional[pulumi.Input[Union['DomainRecordHttpServiceArgs', 'DomainRecordHttpServiceArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            priority: Optional[pulumi.Input[_builtins.int]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            root_zone: Optional[pulumi.Input[_builtins.bool]] = None,
            ttl: Optional[pulumi.Input[_builtins.int]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            views: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainRecordViewArgs', 'DomainRecordViewArgsDict']]]]] = None,
            weighteds: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainRecordWeightedArgs', 'DomainRecordWeightedArgsDict']]]]] = None) -> 'DomainRecord':
        """
        Get an existing DomainRecord resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] data: The content of the record (an IPv4 for an `A` record, a string for a `TXT` record, etc.).
        :param pulumi.Input[_builtins.str] dns_zone: The DNS zone of the domain. If the domain has no DNS zone, one will be automatically created.
        :param pulumi.Input[_builtins.str] fqdn: The FQDN of the record.
        :param pulumi.Input[Union['DomainRecordGeoIpArgs', 'DomainRecordGeoIpArgsDict']] geo_ip: Return record based on client localisation
        :param pulumi.Input[Union['DomainRecordHttpServiceArgs', 'DomainRecordHttpServiceArgsDict']] http_service: Return record based on client localisation
        :param pulumi.Input[_builtins.str] name: The name of the record (can be an empty string for a root record).
        :param pulumi.Input[_builtins.int] priority: The priority of the record (mostly used with an `MX` record).
        :param pulumi.Input[_builtins.str] project_id: The project_id you want to attach the resource to
        :param pulumi.Input[_builtins.bool] root_zone: Does the DNS zone is the root zone or not
        :param pulumi.Input[_builtins.int] ttl: Time To Live of the record in seconds.
        :param pulumi.Input[_builtins.str] type: The type of the record (`A`, `AAAA`, `MX`, `CNAME`, `DNAME`, `ALIAS`, `NS`, `PTR`, `SRV`, `TXT`, `TLSA`, or `CAA`).
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainRecordViewArgs', 'DomainRecordViewArgsDict']]]] views: Return record based on client subnet
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainRecordWeightedArgs', 'DomainRecordWeightedArgsDict']]]] weighteds: Return record based on weight
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainRecordState.__new__(_DomainRecordState)

        __props__.__dict__["data"] = data
        __props__.__dict__["dns_zone"] = dns_zone
        __props__.__dict__["fqdn"] = fqdn
        __props__.__dict__["geo_ip"] = geo_ip
        __props__.__dict__["http_service"] = http_service
        __props__.__dict__["name"] = name
        __props__.__dict__["priority"] = priority
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["root_zone"] = root_zone
        __props__.__dict__["ttl"] = ttl
        __props__.__dict__["type"] = type
        __props__.__dict__["views"] = views
        __props__.__dict__["weighteds"] = weighteds
        return DomainRecord(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def data(self) -> pulumi.Output[_builtins.str]:
        """
        The content of the record (an IPv4 for an `A` record, a string for a `TXT` record, etc.).
        """
        return pulumi.get(self, "data")

    @_builtins.property
    @pulumi.getter(name="dnsZone")
    def dns_zone(self) -> pulumi.Output[_builtins.str]:
        """
        The DNS zone of the domain. If the domain has no DNS zone, one will be automatically created.
        """
        return pulumi.get(self, "dns_zone")

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> pulumi.Output[_builtins.str]:
        """
        The FQDN of the record.
        """
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter(name="geoIp")
    def geo_ip(self) -> pulumi.Output[Optional['outputs.DomainRecordGeoIp']]:
        """
        Return record based on client localisation
        """
        return pulumi.get(self, "geo_ip")

    @_builtins.property
    @pulumi.getter(name="httpService")
    def http_service(self) -> pulumi.Output[Optional['outputs.DomainRecordHttpService']]:
        """
        Return record based on client localisation
        """
        return pulumi.get(self, "http_service")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the record (can be an empty string for a root record).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[_builtins.int]:
        """
        The priority of the record (mostly used with an `MX` record).
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The project_id you want to attach the resource to
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="rootZone")
    def root_zone(self) -> pulumi.Output[_builtins.bool]:
        """
        Does the DNS zone is the root zone or not
        """
        return pulumi.get(self, "root_zone")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Time To Live of the record in seconds.
        """
        return pulumi.get(self, "ttl")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the record (`A`, `AAAA`, `MX`, `CNAME`, `DNAME`, `ALIAS`, `NS`, `PTR`, `SRV`, `TXT`, `TLSA`, or `CAA`).
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def views(self) -> pulumi.Output[Optional[Sequence['outputs.DomainRecordView']]]:
        """
        Return record based on client subnet
        """
        return pulumi.get(self, "views")

    @_builtins.property
    @pulumi.getter
    def weighteds(self) -> pulumi.Output[Optional[Sequence['outputs.DomainRecordWeighted']]]:
        """
        Return record based on weight
        """
        return pulumi.get(self, "weighteds")

