# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DomainZoneArgs', 'DomainZone']

@pulumi.input_type
class DomainZoneArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[_builtins.str],
                 subdomain: pulumi.Input[_builtins.str],
                 project_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DomainZone resource.
        :param pulumi.Input[_builtins.str] domain: The main domain where the DNS zone will be created.
        :param pulumi.Input[_builtins.str] subdomain: The name of the subdomain (zone name) to create within the domain.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project associated with the domain.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "subdomain", subdomain)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Input[_builtins.str]:
        """
        The main domain where the DNS zone will be created.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter
    def subdomain(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the subdomain (zone name) to create within the domain.
        """
        return pulumi.get(self, "subdomain")

    @subdomain.setter
    def subdomain(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subdomain", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the Project associated with the domain.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)


@pulumi.input_type
class _DomainZoneState:
    def __init__(__self__, *,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 message: Optional[pulumi.Input[_builtins.str]] = None,
                 ns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ns_defaults: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ns_masters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subdomain: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DomainZone resources.
        :param pulumi.Input[_builtins.str] domain: The main domain where the DNS zone will be created.
        :param pulumi.Input[_builtins.str] message: Message.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ns: The list of same servers for the zone.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ns_defaults: The default list of same servers for the zone.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ns_masters: The master list of same servers for the zone.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project associated with the domain.
        :param pulumi.Input[_builtins.str] status: The status of the domain zone.
        :param pulumi.Input[_builtins.str] subdomain: The name of the subdomain (zone name) to create within the domain.
        :param pulumi.Input[_builtins.str] updated_at: The date and time at which the DNS zone was last updated.
        """
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if ns is not None:
            pulumi.set(__self__, "ns", ns)
        if ns_defaults is not None:
            pulumi.set(__self__, "ns_defaults", ns_defaults)
        if ns_masters is not None:
            pulumi.set(__self__, "ns_masters", ns_masters)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subdomain is not None:
            pulumi.set(__self__, "subdomain", subdomain)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The main domain where the DNS zone will be created.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Message.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message", value)

    @_builtins.property
    @pulumi.getter
    def ns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of same servers for the zone.
        """
        return pulumi.get(self, "ns")

    @ns.setter
    def ns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ns", value)

    @_builtins.property
    @pulumi.getter(name="nsDefaults")
    def ns_defaults(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The default list of same servers for the zone.
        """
        return pulumi.get(self, "ns_defaults")

    @ns_defaults.setter
    def ns_defaults(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ns_defaults", value)

    @_builtins.property
    @pulumi.getter(name="nsMasters")
    def ns_masters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The master list of same servers for the zone.
        """
        return pulumi.get(self, "ns_masters")

    @ns_masters.setter
    def ns_masters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ns_masters", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the Project associated with the domain.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the domain zone.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def subdomain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the subdomain (zone name) to create within the domain.
        """
        return pulumi.get(self, "subdomain")

    @subdomain.setter
    def subdomain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subdomain", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time at which the DNS zone was last updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


warnings.warn("""scaleway.index/domainzone.DomainZone has been deprecated in favor of scaleway.domain/zone.Zone""", DeprecationWarning)


@pulumi.type_token("scaleway:index/domainZone:DomainZone")
class DomainZone(pulumi.CustomResource):
    warnings.warn("""scaleway.index/domainzone.DomainZone has been deprecated in favor of scaleway.domain/zone.Zone""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subdomain: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        This section explains how to import a zone using the `{subdomain}.{domain}` format.

        bash

        ```sh
        $ pulumi import scaleway:index/domainZone:DomainZone test test.scaleway-terraform.com
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain: The main domain where the DNS zone will be created.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project associated with the domain.
        :param pulumi.Input[_builtins.str] subdomain: The name of the subdomain (zone name) to create within the domain.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainZoneArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        This section explains how to import a zone using the `{subdomain}.{domain}` format.

        bash

        ```sh
        $ pulumi import scaleway:index/domainZone:DomainZone test test.scaleway-terraform.com
        ```

        :param str resource_name: The name of the resource.
        :param DomainZoneArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainZoneArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subdomain: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""DomainZone is deprecated: scaleway.index/domainzone.DomainZone has been deprecated in favor of scaleway.domain/zone.Zone""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainZoneArgs.__new__(DomainZoneArgs)

            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            __props__.__dict__["project_id"] = project_id
            if subdomain is None and not opts.urn:
                raise TypeError("Missing required property 'subdomain'")
            __props__.__dict__["subdomain"] = subdomain
            __props__.__dict__["message"] = None
            __props__.__dict__["ns"] = None
            __props__.__dict__["ns_defaults"] = None
            __props__.__dict__["ns_masters"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
        super(DomainZone, __self__).__init__(
            'scaleway:index/domainZone:DomainZone',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            domain: Optional[pulumi.Input[_builtins.str]] = None,
            message: Optional[pulumi.Input[_builtins.str]] = None,
            ns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ns_defaults: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ns_masters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            subdomain: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'DomainZone':
        """
        Get an existing DomainZone resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain: The main domain where the DNS zone will be created.
        :param pulumi.Input[_builtins.str] message: Message.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ns: The list of same servers for the zone.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ns_defaults: The default list of same servers for the zone.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ns_masters: The master list of same servers for the zone.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the Project associated with the domain.
        :param pulumi.Input[_builtins.str] status: The status of the domain zone.
        :param pulumi.Input[_builtins.str] subdomain: The name of the subdomain (zone name) to create within the domain.
        :param pulumi.Input[_builtins.str] updated_at: The date and time at which the DNS zone was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainZoneState.__new__(_DomainZoneState)

        __props__.__dict__["domain"] = domain
        __props__.__dict__["message"] = message
        __props__.__dict__["ns"] = ns
        __props__.__dict__["ns_defaults"] = ns_defaults
        __props__.__dict__["ns_masters"] = ns_masters
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["status"] = status
        __props__.__dict__["subdomain"] = subdomain
        __props__.__dict__["updated_at"] = updated_at
        return DomainZone(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Output[_builtins.str]:
        """
        The main domain where the DNS zone will be created.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def message(self) -> pulumi.Output[_builtins.str]:
        """
        Message.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def ns(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of same servers for the zone.
        """
        return pulumi.get(self, "ns")

    @_builtins.property
    @pulumi.getter(name="nsDefaults")
    def ns_defaults(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The default list of same servers for the zone.
        """
        return pulumi.get(self, "ns_defaults")

    @_builtins.property
    @pulumi.getter(name="nsMasters")
    def ns_masters(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The master list of same servers for the zone.
        """
        return pulumi.get(self, "ns_masters")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        `project_id`) The ID of the Project associated with the domain.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the domain zone.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def subdomain(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the subdomain (zone name) to create within the domain.
        """
        return pulumi.get(self, "subdomain")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time at which the DNS zone was last updated.
        """
        return pulumi.get(self, "updated_at")

