# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['EdgeServicesDnsStageArgs', 'EdgeServicesDnsStage']

@pulumi.input_type
class EdgeServicesDnsStageArgs:
    def __init__(__self__, *,
                 pipeline_id: pulumi.Input[_builtins.str],
                 backend_stage_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_stage_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_stage_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EdgeServicesDnsStage resource.
        :param pulumi.Input[_builtins.str] pipeline_id: The ID of the pipeline.
        :param pulumi.Input[_builtins.str] backend_stage_id: The backend stage ID the DNS stage will be linked to. Only one of `backend_stage_id`, `cache_stage_id` and `tls_stage_id` should be specified.
        :param pulumi.Input[_builtins.str] cache_stage_id: The cache stage ID the DNS stage will be linked to. Only one of `backend_stage_id`, `cache_stage_id` and `tls_stage_id` should be specified.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fqdns: Fully Qualified Domain Name (in the format subdomain.example.com) to attach to the stage.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the DNS stage is associated with.
        :param pulumi.Input[_builtins.str] tls_stage_id: The TLS stage ID the DNS stage will be linked to. Only one of `backend_stage_id`, `cache_stage_id` and `tls_stage_id` should be specified.
        """
        pulumi.set(__self__, "pipeline_id", pipeline_id)
        if backend_stage_id is not None:
            pulumi.set(__self__, "backend_stage_id", backend_stage_id)
        if cache_stage_id is not None:
            pulumi.set(__self__, "cache_stage_id", cache_stage_id)
        if fqdns is not None:
            pulumi.set(__self__, "fqdns", fqdns)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tls_stage_id is not None:
            pulumi.set(__self__, "tls_stage_id", tls_stage_id)

    @_builtins.property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the pipeline.
        """
        return pulumi.get(self, "pipeline_id")

    @pipeline_id.setter
    def pipeline_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "pipeline_id", value)

    @_builtins.property
    @pulumi.getter(name="backendStageId")
    def backend_stage_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backend stage ID the DNS stage will be linked to. Only one of `backend_stage_id`, `cache_stage_id` and `tls_stage_id` should be specified.
        """
        return pulumi.get(self, "backend_stage_id")

    @backend_stage_id.setter
    def backend_stage_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend_stage_id", value)

    @_builtins.property
    @pulumi.getter(name="cacheStageId")
    def cache_stage_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cache stage ID the DNS stage will be linked to. Only one of `backend_stage_id`, `cache_stage_id` and `tls_stage_id` should be specified.
        """
        return pulumi.get(self, "cache_stage_id")

    @cache_stage_id.setter
    def cache_stage_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_stage_id", value)

    @_builtins.property
    @pulumi.getter
    def fqdns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Fully Qualified Domain Name (in the format subdomain.example.com) to attach to the stage.
        """
        return pulumi.get(self, "fqdns")

    @fqdns.setter
    def fqdns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "fqdns", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the project the DNS stage is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="tlsStageId")
    def tls_stage_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The TLS stage ID the DNS stage will be linked to. Only one of `backend_stage_id`, `cache_stage_id` and `tls_stage_id` should be specified.
        """
        return pulumi.get(self, "tls_stage_id")

    @tls_stage_id.setter
    def tls_stage_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls_stage_id", value)


@pulumi.input_type
class _EdgeServicesDnsStageState:
    def __init__(__self__, *,
                 backend_stage_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_stage_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 pipeline_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_stage_id: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EdgeServicesDnsStage resources.
        :param pulumi.Input[_builtins.str] backend_stage_id: The backend stage ID the DNS stage will be linked to. Only one of `backend_stage_id`, `cache_stage_id` and `tls_stage_id` should be specified.
        :param pulumi.Input[_builtins.str] cache_stage_id: The cache stage ID the DNS stage will be linked to. Only one of `backend_stage_id`, `cache_stage_id` and `tls_stage_id` should be specified.
        :param pulumi.Input[_builtins.str] created_at: The date and time of the creation of the DNS stage.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fqdns: Fully Qualified Domain Name (in the format subdomain.example.com) to attach to the stage.
        :param pulumi.Input[_builtins.str] pipeline_id: The ID of the pipeline.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the DNS stage is associated with.
        :param pulumi.Input[_builtins.str] tls_stage_id: The TLS stage ID the DNS stage will be linked to. Only one of `backend_stage_id`, `cache_stage_id` and `tls_stage_id` should be specified.
        :param pulumi.Input[_builtins.str] type: The type of the stage.
        :param pulumi.Input[_builtins.str] updated_at: The date and time of the last update of the DNS stage.
        """
        if backend_stage_id is not None:
            pulumi.set(__self__, "backend_stage_id", backend_stage_id)
        if cache_stage_id is not None:
            pulumi.set(__self__, "cache_stage_id", cache_stage_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if fqdns is not None:
            pulumi.set(__self__, "fqdns", fqdns)
        if pipeline_id is not None:
            pulumi.set(__self__, "pipeline_id", pipeline_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tls_stage_id is not None:
            pulumi.set(__self__, "tls_stage_id", tls_stage_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="backendStageId")
    def backend_stage_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backend stage ID the DNS stage will be linked to. Only one of `backend_stage_id`, `cache_stage_id` and `tls_stage_id` should be specified.
        """
        return pulumi.get(self, "backend_stage_id")

    @backend_stage_id.setter
    def backend_stage_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend_stage_id", value)

    @_builtins.property
    @pulumi.getter(name="cacheStageId")
    def cache_stage_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cache stage ID the DNS stage will be linked to. Only one of `backend_stage_id`, `cache_stage_id` and `tls_stage_id` should be specified.
        """
        return pulumi.get(self, "cache_stage_id")

    @cache_stage_id.setter
    def cache_stage_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cache_stage_id", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the creation of the DNS stage.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def fqdns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Fully Qualified Domain Name (in the format subdomain.example.com) to attach to the stage.
        """
        return pulumi.get(self, "fqdns")

    @fqdns.setter
    def fqdns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "fqdns", value)

    @_builtins.property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the pipeline.
        """
        return pulumi.get(self, "pipeline_id")

    @pipeline_id.setter
    def pipeline_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pipeline_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the project the DNS stage is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="tlsStageId")
    def tls_stage_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The TLS stage ID the DNS stage will be linked to. Only one of `backend_stage_id`, `cache_stage_id` and `tls_stage_id` should be specified.
        """
        return pulumi.get(self, "tls_stage_id")

    @tls_stage_id.setter
    def tls_stage_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tls_stage_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the stage.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the last update of the DNS stage.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("scaleway:index/edgeServicesDnsStage:EdgeServicesDnsStage")
class EdgeServicesDnsStage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend_stage_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_stage_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 pipeline_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_stage_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Edge Services DNS Stages.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.EdgeServicesDnsStage("main",
            pipeline_id=main_scaleway_edge_services_pipeline["id"],
            fqdns=["subdomain.example.com"])
        ```

        ## Import

        DNS stages can be imported using the `{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/edgeServicesDnsStage:EdgeServicesDnsStage basic 11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backend_stage_id: The backend stage ID the DNS stage will be linked to. Only one of `backend_stage_id`, `cache_stage_id` and `tls_stage_id` should be specified.
        :param pulumi.Input[_builtins.str] cache_stage_id: The cache stage ID the DNS stage will be linked to. Only one of `backend_stage_id`, `cache_stage_id` and `tls_stage_id` should be specified.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fqdns: Fully Qualified Domain Name (in the format subdomain.example.com) to attach to the stage.
        :param pulumi.Input[_builtins.str] pipeline_id: The ID of the pipeline.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the DNS stage is associated with.
        :param pulumi.Input[_builtins.str] tls_stage_id: The TLS stage ID the DNS stage will be linked to. Only one of `backend_stage_id`, `cache_stage_id` and `tls_stage_id` should be specified.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EdgeServicesDnsStageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Edge Services DNS Stages.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.EdgeServicesDnsStage("main",
            pipeline_id=main_scaleway_edge_services_pipeline["id"],
            fqdns=["subdomain.example.com"])
        ```

        ## Import

        DNS stages can be imported using the `{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/edgeServicesDnsStage:EdgeServicesDnsStage basic 11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param EdgeServicesDnsStageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EdgeServicesDnsStageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend_stage_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cache_stage_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 pipeline_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tls_stage_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EdgeServicesDnsStageArgs.__new__(EdgeServicesDnsStageArgs)

            __props__.__dict__["backend_stage_id"] = backend_stage_id
            __props__.__dict__["cache_stage_id"] = cache_stage_id
            __props__.__dict__["fqdns"] = fqdns
            if pipeline_id is None and not opts.urn:
                raise TypeError("Missing required property 'pipeline_id'")
            __props__.__dict__["pipeline_id"] = pipeline_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["tls_stage_id"] = tls_stage_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["updated_at"] = None
        super(EdgeServicesDnsStage, __self__).__init__(
            'scaleway:index/edgeServicesDnsStage:EdgeServicesDnsStage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend_stage_id: Optional[pulumi.Input[_builtins.str]] = None,
            cache_stage_id: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            pipeline_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            tls_stage_id: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'EdgeServicesDnsStage':
        """
        Get an existing EdgeServicesDnsStage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backend_stage_id: The backend stage ID the DNS stage will be linked to. Only one of `backend_stage_id`, `cache_stage_id` and `tls_stage_id` should be specified.
        :param pulumi.Input[_builtins.str] cache_stage_id: The cache stage ID the DNS stage will be linked to. Only one of `backend_stage_id`, `cache_stage_id` and `tls_stage_id` should be specified.
        :param pulumi.Input[_builtins.str] created_at: The date and time of the creation of the DNS stage.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fqdns: Fully Qualified Domain Name (in the format subdomain.example.com) to attach to the stage.
        :param pulumi.Input[_builtins.str] pipeline_id: The ID of the pipeline.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the DNS stage is associated with.
        :param pulumi.Input[_builtins.str] tls_stage_id: The TLS stage ID the DNS stage will be linked to. Only one of `backend_stage_id`, `cache_stage_id` and `tls_stage_id` should be specified.
        :param pulumi.Input[_builtins.str] type: The type of the stage.
        :param pulumi.Input[_builtins.str] updated_at: The date and time of the last update of the DNS stage.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EdgeServicesDnsStageState.__new__(_EdgeServicesDnsStageState)

        __props__.__dict__["backend_stage_id"] = backend_stage_id
        __props__.__dict__["cache_stage_id"] = cache_stage_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["fqdns"] = fqdns
        __props__.__dict__["pipeline_id"] = pipeline_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["tls_stage_id"] = tls_stage_id
        __props__.__dict__["type"] = type
        __props__.__dict__["updated_at"] = updated_at
        return EdgeServicesDnsStage(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backendStageId")
    def backend_stage_id(self) -> pulumi.Output[_builtins.str]:
        """
        The backend stage ID the DNS stage will be linked to. Only one of `backend_stage_id`, `cache_stage_id` and `tls_stage_id` should be specified.
        """
        return pulumi.get(self, "backend_stage_id")

    @_builtins.property
    @pulumi.getter(name="cacheStageId")
    def cache_stage_id(self) -> pulumi.Output[_builtins.str]:
        """
        The cache stage ID the DNS stage will be linked to. Only one of `backend_stage_id`, `cache_stage_id` and `tls_stage_id` should be specified.
        """
        return pulumi.get(self, "cache_stage_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of the creation of the DNS stage.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def fqdns(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Fully Qualified Domain Name (in the format subdomain.example.com) to attach to the stage.
        """
        return pulumi.get(self, "fqdns")

    @_builtins.property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the pipeline.
        """
        return pulumi.get(self, "pipeline_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        `project_id`) The ID of the project the DNS stage is associated with.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="tlsStageId")
    def tls_stage_id(self) -> pulumi.Output[_builtins.str]:
        """
        The TLS stage ID the DNS stage will be linked to. Only one of `backend_stage_id`, `cache_stage_id` and `tls_stage_id` should be specified.
        """
        return pulumi.get(self, "tls_stage_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the stage.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of the last update of the DNS stage.
        """
        return pulumi.get(self, "updated_at")

