# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['EdgeServicesWafStageArgs', 'EdgeServicesWafStage']

@pulumi.input_type
class EdgeServicesWafStageArgs:
    def __init__(__self__, *,
                 paranoia_level: pulumi.Input[_builtins.int],
                 pipeline_id: pulumi.Input[_builtins.str],
                 backend_stage_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EdgeServicesWafStage resource.
        :param pulumi.Input[_builtins.int] paranoia_level: The sensitivity level (`1`,`2`,`3`,`4`) to use when classifying requests as malicious. With a high level, requests are more likely to be classed as malicious, and false positives are expected. With a lower level, requests are more likely to be classed as benign.
        :param pulumi.Input[_builtins.str] pipeline_id: The ID of the pipeline.
        :param pulumi.Input[_builtins.str] backend_stage_id: The ID of the backend stage to forward requests to after the WAF stage.
        :param pulumi.Input[_builtins.str] mode: The mode defining WAF behavior (`disable`/`log_only`/`enable`).
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the WAF stage is associated with.
        """
        pulumi.set(__self__, "paranoia_level", paranoia_level)
        pulumi.set(__self__, "pipeline_id", pipeline_id)
        if backend_stage_id is not None:
            pulumi.set(__self__, "backend_stage_id", backend_stage_id)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @_builtins.property
    @pulumi.getter(name="paranoiaLevel")
    def paranoia_level(self) -> pulumi.Input[_builtins.int]:
        """
        The sensitivity level (`1`,`2`,`3`,`4`) to use when classifying requests as malicious. With a high level, requests are more likely to be classed as malicious, and false positives are expected. With a lower level, requests are more likely to be classed as benign.
        """
        return pulumi.get(self, "paranoia_level")

    @paranoia_level.setter
    def paranoia_level(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "paranoia_level", value)

    @_builtins.property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the pipeline.
        """
        return pulumi.get(self, "pipeline_id")

    @pipeline_id.setter
    def pipeline_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "pipeline_id", value)

    @_builtins.property
    @pulumi.getter(name="backendStageId")
    def backend_stage_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the backend stage to forward requests to after the WAF stage.
        """
        return pulumi.get(self, "backend_stage_id")

    @backend_stage_id.setter
    def backend_stage_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend_stage_id", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mode defining WAF behavior (`disable`/`log_only`/`enable`).
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the project the WAF stage is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)


@pulumi.input_type
class _EdgeServicesWafStageState:
    def __init__(__self__, *,
                 backend_stage_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 paranoia_level: Optional[pulumi.Input[_builtins.int]] = None,
                 pipeline_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EdgeServicesWafStage resources.
        :param pulumi.Input[_builtins.str] backend_stage_id: The ID of the backend stage to forward requests to after the WAF stage.
        :param pulumi.Input[_builtins.str] created_at: The date and time of the creation of the WAF stage.
        :param pulumi.Input[_builtins.str] mode: The mode defining WAF behavior (`disable`/`log_only`/`enable`).
        :param pulumi.Input[_builtins.int] paranoia_level: The sensitivity level (`1`,`2`,`3`,`4`) to use when classifying requests as malicious. With a high level, requests are more likely to be classed as malicious, and false positives are expected. With a lower level, requests are more likely to be classed as benign.
        :param pulumi.Input[_builtins.str] pipeline_id: The ID of the pipeline.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the WAF stage is associated with.
        :param pulumi.Input[_builtins.str] updated_at: The date and time of the last update of the WAF stage.
        """
        if backend_stage_id is not None:
            pulumi.set(__self__, "backend_stage_id", backend_stage_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if paranoia_level is not None:
            pulumi.set(__self__, "paranoia_level", paranoia_level)
        if pipeline_id is not None:
            pulumi.set(__self__, "pipeline_id", pipeline_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="backendStageId")
    def backend_stage_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the backend stage to forward requests to after the WAF stage.
        """
        return pulumi.get(self, "backend_stage_id")

    @backend_stage_id.setter
    def backend_stage_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend_stage_id", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the creation of the WAF stage.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mode defining WAF behavior (`disable`/`log_only`/`enable`).
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter(name="paranoiaLevel")
    def paranoia_level(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The sensitivity level (`1`,`2`,`3`,`4`) to use when classifying requests as malicious. With a high level, requests are more likely to be classed as malicious, and false positives are expected. With a lower level, requests are more likely to be classed as benign.
        """
        return pulumi.get(self, "paranoia_level")

    @paranoia_level.setter
    def paranoia_level(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "paranoia_level", value)

    @_builtins.property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the pipeline.
        """
        return pulumi.get(self, "pipeline_id")

    @pipeline_id.setter
    def pipeline_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pipeline_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the project the WAF stage is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the last update of the WAF stage.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("scaleway:index/edgeServicesWafStage:EdgeServicesWafStage")
class EdgeServicesWafStage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend_stage_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 paranoia_level: Optional[pulumi.Input[_builtins.int]] = None,
                 pipeline_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Edge Services WAF Stages.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.EdgeServicesWafStage("main",
            pipeline_id=main_scaleway_edge_services_pipeline["id"],
            mode="enable",
            paranoia_level=3)
        ```

        ## Import

        WAF stages can be imported using the `{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/edgeServicesWafStage:EdgeServicesWafStage basic 11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backend_stage_id: The ID of the backend stage to forward requests to after the WAF stage.
        :param pulumi.Input[_builtins.str] mode: The mode defining WAF behavior (`disable`/`log_only`/`enable`).
        :param pulumi.Input[_builtins.int] paranoia_level: The sensitivity level (`1`,`2`,`3`,`4`) to use when classifying requests as malicious. With a high level, requests are more likely to be classed as malicious, and false positives are expected. With a lower level, requests are more likely to be classed as benign.
        :param pulumi.Input[_builtins.str] pipeline_id: The ID of the pipeline.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the WAF stage is associated with.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EdgeServicesWafStageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Edge Services WAF Stages.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.EdgeServicesWafStage("main",
            pipeline_id=main_scaleway_edge_services_pipeline["id"],
            mode="enable",
            paranoia_level=3)
        ```

        ## Import

        WAF stages can be imported using the `{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/edgeServicesWafStage:EdgeServicesWafStage basic 11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param EdgeServicesWafStageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EdgeServicesWafStageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend_stage_id: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 paranoia_level: Optional[pulumi.Input[_builtins.int]] = None,
                 pipeline_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EdgeServicesWafStageArgs.__new__(EdgeServicesWafStageArgs)

            __props__.__dict__["backend_stage_id"] = backend_stage_id
            __props__.__dict__["mode"] = mode
            if paranoia_level is None and not opts.urn:
                raise TypeError("Missing required property 'paranoia_level'")
            __props__.__dict__["paranoia_level"] = paranoia_level
            if pipeline_id is None and not opts.urn:
                raise TypeError("Missing required property 'pipeline_id'")
            __props__.__dict__["pipeline_id"] = pipeline_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["updated_at"] = None
        super(EdgeServicesWafStage, __self__).__init__(
            'scaleway:index/edgeServicesWafStage:EdgeServicesWafStage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend_stage_id: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            mode: Optional[pulumi.Input[_builtins.str]] = None,
            paranoia_level: Optional[pulumi.Input[_builtins.int]] = None,
            pipeline_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'EdgeServicesWafStage':
        """
        Get an existing EdgeServicesWafStage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backend_stage_id: The ID of the backend stage to forward requests to after the WAF stage.
        :param pulumi.Input[_builtins.str] created_at: The date and time of the creation of the WAF stage.
        :param pulumi.Input[_builtins.str] mode: The mode defining WAF behavior (`disable`/`log_only`/`enable`).
        :param pulumi.Input[_builtins.int] paranoia_level: The sensitivity level (`1`,`2`,`3`,`4`) to use when classifying requests as malicious. With a high level, requests are more likely to be classed as malicious, and false positives are expected. With a lower level, requests are more likely to be classed as benign.
        :param pulumi.Input[_builtins.str] pipeline_id: The ID of the pipeline.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the WAF stage is associated with.
        :param pulumi.Input[_builtins.str] updated_at: The date and time of the last update of the WAF stage.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EdgeServicesWafStageState.__new__(_EdgeServicesWafStageState)

        __props__.__dict__["backend_stage_id"] = backend_stage_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["mode"] = mode
        __props__.__dict__["paranoia_level"] = paranoia_level
        __props__.__dict__["pipeline_id"] = pipeline_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["updated_at"] = updated_at
        return EdgeServicesWafStage(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backendStageId")
    def backend_stage_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the backend stage to forward requests to after the WAF stage.
        """
        return pulumi.get(self, "backend_stage_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of the creation of the WAF stage.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Output[_builtins.str]:
        """
        The mode defining WAF behavior (`disable`/`log_only`/`enable`).
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="paranoiaLevel")
    def paranoia_level(self) -> pulumi.Output[_builtins.int]:
        """
        The sensitivity level (`1`,`2`,`3`,`4`) to use when classifying requests as malicious. With a high level, requests are more likely to be classed as malicious, and false positives are expected. With a lower level, requests are more likely to be classed as benign.
        """
        return pulumi.get(self, "paranoia_level")

    @_builtins.property
    @pulumi.getter(name="pipelineId")
    def pipeline_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the pipeline.
        """
        return pulumi.get(self, "pipeline_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        `project_id`) The ID of the project the WAF stage is associated with.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of the last update of the WAF stage.
        """
        return pulumi.get(self, "updated_at")

