# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['FileFilesystemArgs', 'FileFilesystem']

@pulumi.input_type
class FileFilesystemArgs:
    def __init__(__self__, *,
                 size_in_gb: pulumi.Input[_builtins.int],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a FileFilesystem resource.
        :param pulumi.Input[_builtins.int] size_in_gb: The size of the filesystem in bytes, with a granularity of 100 GB (10¹¹ bytes).
               - Minimum: 100 GB (100000000000 bytes)
               - Maximum: 10 TB (10000000000000 bytes)
        :param pulumi.Input[_builtins.str] name: The name of the filesystem. If not provided, a random name will be generated.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the server is
               associated with.
        :param pulumi.Input[_builtins.str] region: `region`) The region where the filesystem will be created (e.g., fr-par, nl-ams).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags associated with the filesystem.
        """
        pulumi.set(__self__, "size_in_gb", size_in_gb)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="sizeInGb")
    def size_in_gb(self) -> pulumi.Input[_builtins.int]:
        """
        The size of the filesystem in bytes, with a granularity of 100 GB (10¹¹ bytes).
        - Minimum: 100 GB (100000000000 bytes)
        - Maximum: 10 TB (10000000000000 bytes)
        """
        return pulumi.get(self, "size_in_gb")

    @size_in_gb.setter
    def size_in_gb(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "size_in_gb", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the filesystem. If not provided, a random name will be generated.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the project the server is
        associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`) The region where the filesystem will be created (e.g., fr-par, nl-ams).
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of tags associated with the filesystem.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _FileFilesystemState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_attachments: Optional[pulumi.Input[_builtins.int]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 size_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FileFilesystem resources.
        :param pulumi.Input[_builtins.str] created_at: The date and time when the File Storage filesystem was created.
        :param pulumi.Input[_builtins.str] name: The name of the filesystem. If not provided, a random name will be generated.
        :param pulumi.Input[_builtins.int] number_of_attachments: The number of active attachments (mounts) on the filesystem.
        :param pulumi.Input[_builtins.str] organization_id: `organization_id`) The ID of the organization the user is associated with.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the server is
               associated with.
        :param pulumi.Input[_builtins.str] region: `region`) The region where the filesystem will be created (e.g., fr-par, nl-ams).
        :param pulumi.Input[_builtins.int] size_in_gb: The size of the filesystem in bytes, with a granularity of 100 GB (10¹¹ bytes).
               - Minimum: 100 GB (100000000000 bytes)
               - Maximum: 10 TB (10000000000000 bytes)
        :param pulumi.Input[_builtins.str] status: The current status of the filesystem. Possible values include creating, available, etc.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags associated with the filesystem.
        :param pulumi.Input[_builtins.str] updated_at: The date and time of the last update to the File Storage filesystem.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number_of_attachments is not None:
            pulumi.set(__self__, "number_of_attachments", number_of_attachments)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if size_in_gb is not None:
            pulumi.set(__self__, "size_in_gb", size_in_gb)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time when the File Storage filesystem was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the filesystem. If not provided, a random name will be generated.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="numberOfAttachments")
    def number_of_attachments(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of active attachments (mounts) on the filesystem.
        """
        return pulumi.get(self, "number_of_attachments")

    @number_of_attachments.setter
    def number_of_attachments(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "number_of_attachments", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `organization_id`) The ID of the organization the user is associated with.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the project the server is
        associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`) The region where the filesystem will be created (e.g., fr-par, nl-ams).
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sizeInGb")
    def size_in_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the filesystem in bytes, with a granularity of 100 GB (10¹¹ bytes).
        - Minimum: 100 GB (100000000000 bytes)
        - Maximum: 10 TB (10000000000000 bytes)
        """
        return pulumi.get(self, "size_in_gb")

    @size_in_gb.setter
    def size_in_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size_in_gb", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current status of the filesystem. Possible values include creating, available, etc.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of tags associated with the filesystem.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the last update to the File Storage filesystem.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("scaleway:index/fileFilesystem:FileFilesystem")
class FileFilesystem(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 size_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        > **This product is currently in private beta. To request access, please contact your Technical Account Manager.**

        Creates and manages a Scaleway File Storage filesystem in a specific region. A filesystem is a scalable storage resource that can be mounted on Compute instances and is typically used for share persistent storage between multiple instances (RWX).

        This resource allows you to define and manage the size, tags, and region of a filesystem, and track its creation and update timestamps, current status, and number of active attachments.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        file = scaleway.FileFilesystem("file",
            name="my-nfs-filesystem",
            size_in_gb=100)
        ```

        ## Import

        File Storage filesystems can be imported using the `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/fileFilesystem:FileFilesystem main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name of the filesystem. If not provided, a random name will be generated.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the server is
               associated with.
        :param pulumi.Input[_builtins.str] region: `region`) The region where the filesystem will be created (e.g., fr-par, nl-ams).
        :param pulumi.Input[_builtins.int] size_in_gb: The size of the filesystem in bytes, with a granularity of 100 GB (10¹¹ bytes).
               - Minimum: 100 GB (100000000000 bytes)
               - Maximum: 10 TB (10000000000000 bytes)
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags associated with the filesystem.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FileFilesystemArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **This product is currently in private beta. To request access, please contact your Technical Account Manager.**

        Creates and manages a Scaleway File Storage filesystem in a specific region. A filesystem is a scalable storage resource that can be mounted on Compute instances and is typically used for share persistent storage between multiple instances (RWX).

        This resource allows you to define and manage the size, tags, and region of a filesystem, and track its creation and update timestamps, current status, and number of active attachments.

        ## Example Usage

        ### Basic

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        file = scaleway.FileFilesystem("file",
            name="my-nfs-filesystem",
            size_in_gb=100)
        ```

        ## Import

        File Storage filesystems can be imported using the `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:index/fileFilesystem:FileFilesystem main fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param FileFilesystemArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FileFilesystemArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 size_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FileFilesystemArgs.__new__(FileFilesystemArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            if size_in_gb is None and not opts.urn:
                raise TypeError("Missing required property 'size_in_gb'")
            __props__.__dict__["size_in_gb"] = size_in_gb
            __props__.__dict__["tags"] = tags
            __props__.__dict__["created_at"] = None
            __props__.__dict__["number_of_attachments"] = None
            __props__.__dict__["organization_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
        super(FileFilesystem, __self__).__init__(
            'scaleway:index/fileFilesystem:FileFilesystem',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            number_of_attachments: Optional[pulumi.Input[_builtins.int]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            size_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'FileFilesystem':
        """
        Get an existing FileFilesystem resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: The date and time when the File Storage filesystem was created.
        :param pulumi.Input[_builtins.str] name: The name of the filesystem. If not provided, a random name will be generated.
        :param pulumi.Input[_builtins.int] number_of_attachments: The number of active attachments (mounts) on the filesystem.
        :param pulumi.Input[_builtins.str] organization_id: `organization_id`) The ID of the organization the user is associated with.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the server is
               associated with.
        :param pulumi.Input[_builtins.str] region: `region`) The region where the filesystem will be created (e.g., fr-par, nl-ams).
        :param pulumi.Input[_builtins.int] size_in_gb: The size of the filesystem in bytes, with a granularity of 100 GB (10¹¹ bytes).
               - Minimum: 100 GB (100000000000 bytes)
               - Maximum: 10 TB (10000000000000 bytes)
        :param pulumi.Input[_builtins.str] status: The current status of the filesystem. Possible values include creating, available, etc.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags associated with the filesystem.
        :param pulumi.Input[_builtins.str] updated_at: The date and time of the last update to the File Storage filesystem.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FileFilesystemState.__new__(_FileFilesystemState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["name"] = name
        __props__.__dict__["number_of_attachments"] = number_of_attachments
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["size_in_gb"] = size_in_gb
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["updated_at"] = updated_at
        return FileFilesystem(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time when the File Storage filesystem was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the filesystem. If not provided, a random name will be generated.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="numberOfAttachments")
    def number_of_attachments(self) -> pulumi.Output[_builtins.int]:
        """
        The number of active attachments (mounts) on the filesystem.
        """
        return pulumi.get(self, "number_of_attachments")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        `organization_id`) The ID of the organization the user is associated with.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        `project_id`) The ID of the project the server is
        associated with.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `region`) The region where the filesystem will be created (e.g., fr-par, nl-ams).
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="sizeInGb")
    def size_in_gb(self) -> pulumi.Output[_builtins.int]:
        """
        The size of the filesystem in bytes, with a granularity of 100 GB (10¹¹ bytes).
        - Minimum: 100 GB (100000000000 bytes)
        - Maximum: 10 TB (10000000000000 bytes)
        """
        return pulumi.get(self, "size_in_gb")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The current status of the filesystem. Possible values include creating, available, etc.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of tags associated with the filesystem.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of the last update to the File Storage filesystem.
        """
        return pulumi.get(self, "updated_at")

