# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetLbFrontendResult',
    'AwaitableGetLbFrontendResult',
    'get_lb_frontend',
    'get_lb_frontend_output',
]

warnings.warn("""scaleway.index/getlbfrontend.getLbFrontend has been deprecated in favor of scaleway.loadbalancers/getfrontend.getFrontend""", DeprecationWarning)

@pulumi.output_type
class GetLbFrontendResult:
    """
    A collection of values returned by getLbFrontend.
    """
    def __init__(__self__, acls=None, backend_id=None, certificate_id=None, certificate_ids=None, connection_rate_limit=None, created_at=None, enable_access_logs=None, enable_http3=None, external_acls=None, frontend_id=None, id=None, inbound_port=None, lb_id=None, name=None, timeout_client=None, updated_at=None):
        if acls and not isinstance(acls, list):
            raise TypeError("Expected argument 'acls' to be a list")
        pulumi.set(__self__, "acls", acls)
        if backend_id and not isinstance(backend_id, str):
            raise TypeError("Expected argument 'backend_id' to be a str")
        pulumi.set(__self__, "backend_id", backend_id)
        if certificate_id and not isinstance(certificate_id, str):
            raise TypeError("Expected argument 'certificate_id' to be a str")
        pulumi.set(__self__, "certificate_id", certificate_id)
        if certificate_ids and not isinstance(certificate_ids, list):
            raise TypeError("Expected argument 'certificate_ids' to be a list")
        pulumi.set(__self__, "certificate_ids", certificate_ids)
        if connection_rate_limit and not isinstance(connection_rate_limit, int):
            raise TypeError("Expected argument 'connection_rate_limit' to be a int")
        pulumi.set(__self__, "connection_rate_limit", connection_rate_limit)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if enable_access_logs and not isinstance(enable_access_logs, bool):
            raise TypeError("Expected argument 'enable_access_logs' to be a bool")
        pulumi.set(__self__, "enable_access_logs", enable_access_logs)
        if enable_http3 and not isinstance(enable_http3, bool):
            raise TypeError("Expected argument 'enable_http3' to be a bool")
        pulumi.set(__self__, "enable_http3", enable_http3)
        if external_acls and not isinstance(external_acls, bool):
            raise TypeError("Expected argument 'external_acls' to be a bool")
        pulumi.set(__self__, "external_acls", external_acls)
        if frontend_id and not isinstance(frontend_id, str):
            raise TypeError("Expected argument 'frontend_id' to be a str")
        pulumi.set(__self__, "frontend_id", frontend_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if inbound_port and not isinstance(inbound_port, int):
            raise TypeError("Expected argument 'inbound_port' to be a int")
        pulumi.set(__self__, "inbound_port", inbound_port)
        if lb_id and not isinstance(lb_id, str):
            raise TypeError("Expected argument 'lb_id' to be a str")
        pulumi.set(__self__, "lb_id", lb_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if timeout_client and not isinstance(timeout_client, str):
            raise TypeError("Expected argument 'timeout_client' to be a str")
        pulumi.set(__self__, "timeout_client", timeout_client)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter
    def acls(self) -> Sequence['outputs.GetLbFrontendAclResult']:
        return pulumi.get(self, "acls")

    @_builtins.property
    @pulumi.getter(name="backendId")
    def backend_id(self) -> _builtins.str:
        return pulumi.get(self, "backend_id")

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> _builtins.str:
        return pulumi.get(self, "certificate_id")

    @_builtins.property
    @pulumi.getter(name="certificateIds")
    def certificate_ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "certificate_ids")

    @_builtins.property
    @pulumi.getter(name="connectionRateLimit")
    def connection_rate_limit(self) -> _builtins.int:
        return pulumi.get(self, "connection_rate_limit")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="enableAccessLogs")
    def enable_access_logs(self) -> _builtins.bool:
        return pulumi.get(self, "enable_access_logs")

    @_builtins.property
    @pulumi.getter(name="enableHttp3")
    def enable_http3(self) -> _builtins.bool:
        return pulumi.get(self, "enable_http3")

    @_builtins.property
    @pulumi.getter(name="externalAcls")
    def external_acls(self) -> _builtins.bool:
        return pulumi.get(self, "external_acls")

    @_builtins.property
    @pulumi.getter(name="frontendId")
    def frontend_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "frontend_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="inboundPort")
    def inbound_port(self) -> _builtins.int:
        return pulumi.get(self, "inbound_port")

    @_builtins.property
    @pulumi.getter(name="lbId")
    def lb_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "lb_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="timeoutClient")
    def timeout_client(self) -> _builtins.str:
        return pulumi.get(self, "timeout_client")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        return pulumi.get(self, "updated_at")


class AwaitableGetLbFrontendResult(GetLbFrontendResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLbFrontendResult(
            acls=self.acls,
            backend_id=self.backend_id,
            certificate_id=self.certificate_id,
            certificate_ids=self.certificate_ids,
            connection_rate_limit=self.connection_rate_limit,
            created_at=self.created_at,
            enable_access_logs=self.enable_access_logs,
            enable_http3=self.enable_http3,
            external_acls=self.external_acls,
            frontend_id=self.frontend_id,
            id=self.id,
            inbound_port=self.inbound_port,
            lb_id=self.lb_id,
            name=self.name,
            timeout_client=self.timeout_client,
            updated_at=self.updated_at)


def get_lb_frontend(frontend_id: Optional[_builtins.str] = None,
                    lb_id: Optional[_builtins.str] = None,
                    name: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLbFrontendResult:
    """
    Get information about Scaleway Load Balancer frontends.

    For more information, see the [main documentation](https://www.scaleway.com/en/docs/load-balancer/reference-content/configuring-frontends/) or [API documentation](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-frontends).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway
    import pulumiverse_scaleway as scaleway

    ip01 = scaleway.loadbalancers.Ip("ip01")
    lb01 = scaleway.loadbalancers.LoadBalancer("lb01",
        ip_id=ip01.id,
        name="test-lb",
        type="lb-s")
    bkd01 = scaleway.loadbalancers.Backend("bkd01",
        lb_id=lb01.id,
        forward_protocol="tcp",
        forward_port=80,
        proxy_protocol="none")
    frt01 = scaleway.loadbalancers.Frontend("frt01",
        lb_id=lb01.id,
        backend_id=bkd01.id,
        inbound_port=80)
    by_id = scaleway.loadbalancers.get_frontend_output(frontend_id=frt01.id)
    by_name = scaleway.loadbalancers.get_frontend_output(name=frt01.name,
        lb_id=lb01.id)
    ```


    :param _builtins.str frontend_id: The frontend ID.
           - Only one of `name` and `frontend_id` should be specified.
    :param _builtins.str lb_id: The Load Balancer ID this frontend is attached to.
    :param _builtins.str name: The name of the frontend.
           - When using the `name` you should specify the `lb-id`
    """
    pulumi.log.warn("""get_lb_frontend is deprecated: scaleway.index/getlbfrontend.getLbFrontend has been deprecated in favor of scaleway.loadbalancers/getfrontend.getFrontend""")
    __args__ = dict()
    __args__['frontendId'] = frontend_id
    __args__['lbId'] = lb_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:index/getLbFrontend:getLbFrontend', __args__, opts=opts, typ=GetLbFrontendResult).value

    return AwaitableGetLbFrontendResult(
        acls=pulumi.get(__ret__, 'acls'),
        backend_id=pulumi.get(__ret__, 'backend_id'),
        certificate_id=pulumi.get(__ret__, 'certificate_id'),
        certificate_ids=pulumi.get(__ret__, 'certificate_ids'),
        connection_rate_limit=pulumi.get(__ret__, 'connection_rate_limit'),
        created_at=pulumi.get(__ret__, 'created_at'),
        enable_access_logs=pulumi.get(__ret__, 'enable_access_logs'),
        enable_http3=pulumi.get(__ret__, 'enable_http3'),
        external_acls=pulumi.get(__ret__, 'external_acls'),
        frontend_id=pulumi.get(__ret__, 'frontend_id'),
        id=pulumi.get(__ret__, 'id'),
        inbound_port=pulumi.get(__ret__, 'inbound_port'),
        lb_id=pulumi.get(__ret__, 'lb_id'),
        name=pulumi.get(__ret__, 'name'),
        timeout_client=pulumi.get(__ret__, 'timeout_client'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_lb_frontend_output(frontend_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           lb_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLbFrontendResult]:
    """
    Get information about Scaleway Load Balancer frontends.

    For more information, see the [main documentation](https://www.scaleway.com/en/docs/load-balancer/reference-content/configuring-frontends/) or [API documentation](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-frontends).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway
    import pulumiverse_scaleway as scaleway

    ip01 = scaleway.loadbalancers.Ip("ip01")
    lb01 = scaleway.loadbalancers.LoadBalancer("lb01",
        ip_id=ip01.id,
        name="test-lb",
        type="lb-s")
    bkd01 = scaleway.loadbalancers.Backend("bkd01",
        lb_id=lb01.id,
        forward_protocol="tcp",
        forward_port=80,
        proxy_protocol="none")
    frt01 = scaleway.loadbalancers.Frontend("frt01",
        lb_id=lb01.id,
        backend_id=bkd01.id,
        inbound_port=80)
    by_id = scaleway.loadbalancers.get_frontend_output(frontend_id=frt01.id)
    by_name = scaleway.loadbalancers.get_frontend_output(name=frt01.name,
        lb_id=lb01.id)
    ```


    :param _builtins.str frontend_id: The frontend ID.
           - Only one of `name` and `frontend_id` should be specified.
    :param _builtins.str lb_id: The Load Balancer ID this frontend is attached to.
    :param _builtins.str name: The name of the frontend.
           - When using the `name` you should specify the `lb-id`
    """
    pulumi.log.warn("""get_lb_frontend is deprecated: scaleway.index/getlbfrontend.getLbFrontend has been deprecated in favor of scaleway.loadbalancers/getfrontend.getFrontend""")
    __args__ = dict()
    __args__['frontendId'] = frontend_id
    __args__['lbId'] = lb_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:index/getLbFrontend:getLbFrontend', __args__, opts=opts, typ=GetLbFrontendResult)
    return __ret__.apply(lambda __response__: GetLbFrontendResult(
        acls=pulumi.get(__response__, 'acls'),
        backend_id=pulumi.get(__response__, 'backend_id'),
        certificate_id=pulumi.get(__response__, 'certificate_id'),
        certificate_ids=pulumi.get(__response__, 'certificate_ids'),
        connection_rate_limit=pulumi.get(__response__, 'connection_rate_limit'),
        created_at=pulumi.get(__response__, 'created_at'),
        enable_access_logs=pulumi.get(__response__, 'enable_access_logs'),
        enable_http3=pulumi.get(__response__, 'enable_http3'),
        external_acls=pulumi.get(__response__, 'external_acls'),
        frontend_id=pulumi.get(__response__, 'frontend_id'),
        id=pulumi.get(__response__, 'id'),
        inbound_port=pulumi.get(__response__, 'inbound_port'),
        lb_id=pulumi.get(__response__, 'lb_id'),
        name=pulumi.get(__response__, 'name'),
        timeout_client=pulumi.get(__response__, 'timeout_client'),
        updated_at=pulumi.get(__response__, 'updated_at')))
