# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetHostingResult',
    'AwaitableGetHostingResult',
    'get_hosting',
    'get_hosting_output',
]

@pulumi.output_type
class GetHostingResult:
    """
    A collection of values returned by getHosting.
    """
    def __init__(__self__, cpanel_urls=None, created_at=None, dns_status=None, domain=None, email=None, id=None, name_servers=None, offer_id=None, offer_name=None, option_ids=None, options=None, organization_id=None, platform_hostname=None, platform_number=None, project_id=None, records=None, region=None, status=None, tags=None, updated_at=None, username=None, webhosting_id=None):
        if cpanel_urls and not isinstance(cpanel_urls, list):
            raise TypeError("Expected argument 'cpanel_urls' to be a list")
        pulumi.set(__self__, "cpanel_urls", cpanel_urls)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if dns_status and not isinstance(dns_status, str):
            raise TypeError("Expected argument 'dns_status' to be a str")
        pulumi.set(__self__, "dns_status", dns_status)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name_servers and not isinstance(name_servers, list):
            raise TypeError("Expected argument 'name_servers' to be a list")
        pulumi.set(__self__, "name_servers", name_servers)
        if offer_id and not isinstance(offer_id, str):
            raise TypeError("Expected argument 'offer_id' to be a str")
        pulumi.set(__self__, "offer_id", offer_id)
        if offer_name and not isinstance(offer_name, str):
            raise TypeError("Expected argument 'offer_name' to be a str")
        pulumi.set(__self__, "offer_name", offer_name)
        if option_ids and not isinstance(option_ids, list):
            raise TypeError("Expected argument 'option_ids' to be a list")
        pulumi.set(__self__, "option_ids", option_ids)
        if options and not isinstance(options, list):
            raise TypeError("Expected argument 'options' to be a list")
        pulumi.set(__self__, "options", options)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if platform_hostname and not isinstance(platform_hostname, str):
            raise TypeError("Expected argument 'platform_hostname' to be a str")
        pulumi.set(__self__, "platform_hostname", platform_hostname)
        if platform_number and not isinstance(platform_number, int):
            raise TypeError("Expected argument 'platform_number' to be a int")
        pulumi.set(__self__, "platform_number", platform_number)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if records and not isinstance(records, list):
            raise TypeError("Expected argument 'records' to be a list")
        pulumi.set(__self__, "records", records)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)
        if webhosting_id and not isinstance(webhosting_id, str):
            raise TypeError("Expected argument 'webhosting_id' to be a str")
        pulumi.set(__self__, "webhosting_id", webhosting_id)

    @_builtins.property
    @pulumi.getter(name="cpanelUrls")
    def cpanel_urls(self) -> Sequence['outputs.GetHostingCpanelUrlResult']:
        return pulumi.get(self, "cpanel_urls")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="dnsStatus")
    def dns_status(self) -> _builtins.str:
        return pulumi.get(self, "dns_status")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="nameServers")
    def name_servers(self) -> Sequence['outputs.GetHostingNameServerResult']:
        return pulumi.get(self, "name_servers")

    @_builtins.property
    @pulumi.getter(name="offerId")
    def offer_id(self) -> _builtins.str:
        return pulumi.get(self, "offer_id")

    @_builtins.property
    @pulumi.getter(name="offerName")
    def offer_name(self) -> _builtins.str:
        return pulumi.get(self, "offer_name")

    @_builtins.property
    @pulumi.getter(name="optionIds")
    def option_ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "option_ids")

    @_builtins.property
    @pulumi.getter
    def options(self) -> Sequence['outputs.GetHostingOptionResult']:
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> _builtins.str:
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="platformHostname")
    def platform_hostname(self) -> _builtins.str:
        return pulumi.get(self, "platform_hostname")

    @_builtins.property
    @pulumi.getter(name="platformNumber")
    def platform_number(self) -> _builtins.int:
        return pulumi.get(self, "platform_number")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def records(self) -> Sequence['outputs.GetHostingRecordResult']:
        return pulumi.get(self, "records")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="webhostingId")
    def webhosting_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "webhosting_id")


class AwaitableGetHostingResult(GetHostingResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHostingResult(
            cpanel_urls=self.cpanel_urls,
            created_at=self.created_at,
            dns_status=self.dns_status,
            domain=self.domain,
            email=self.email,
            id=self.id,
            name_servers=self.name_servers,
            offer_id=self.offer_id,
            offer_name=self.offer_name,
            option_ids=self.option_ids,
            options=self.options,
            organization_id=self.organization_id,
            platform_hostname=self.platform_hostname,
            platform_number=self.platform_number,
            project_id=self.project_id,
            records=self.records,
            region=self.region,
            status=self.status,
            tags=self.tags,
            updated_at=self.updated_at,
            username=self.username,
            webhosting_id=self.webhosting_id)


def get_hosting(domain: Optional[_builtins.str] = None,
                organization_id: Optional[_builtins.str] = None,
                project_id: Optional[_builtins.str] = None,
                webhosting_id: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHostingResult:
    """
    Gets information about a webhosting.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    # Get info by offer domain
    by_domain = scaleway.hosting.get_hosting(domain="foobar.com")
    # Get info by id
    by_id = scaleway.hosting.get_hosting(webhosting_id="11111111-1111-1111-1111-111111111111")
    ```


    :param _builtins.str domain: The hosting domain name. Only one of `domain` and `webhosting_id` should be specified.
    :param _builtins.str organization_id: The ID of the organization the hosting is associated with.
    :param _builtins.str project_id: `project_id`) The ID of the project the hosting is associated with.
    :param _builtins.str webhosting_id: The hosting id. Only one of `domain` and `webhosting_id` should be specified.
    """
    __args__ = dict()
    __args__['domain'] = domain
    __args__['organizationId'] = organization_id
    __args__['projectId'] = project_id
    __args__['webhostingId'] = webhosting_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:hosting/getHosting:getHosting', __args__, opts=opts, typ=GetHostingResult).value

    return AwaitableGetHostingResult(
        cpanel_urls=pulumi.get(__ret__, 'cpanel_urls'),
        created_at=pulumi.get(__ret__, 'created_at'),
        dns_status=pulumi.get(__ret__, 'dns_status'),
        domain=pulumi.get(__ret__, 'domain'),
        email=pulumi.get(__ret__, 'email'),
        id=pulumi.get(__ret__, 'id'),
        name_servers=pulumi.get(__ret__, 'name_servers'),
        offer_id=pulumi.get(__ret__, 'offer_id'),
        offer_name=pulumi.get(__ret__, 'offer_name'),
        option_ids=pulumi.get(__ret__, 'option_ids'),
        options=pulumi.get(__ret__, 'options'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        platform_hostname=pulumi.get(__ret__, 'platform_hostname'),
        platform_number=pulumi.get(__ret__, 'platform_number'),
        project_id=pulumi.get(__ret__, 'project_id'),
        records=pulumi.get(__ret__, 'records'),
        region=pulumi.get(__ret__, 'region'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        username=pulumi.get(__ret__, 'username'),
        webhosting_id=pulumi.get(__ret__, 'webhosting_id'))
def get_hosting_output(domain: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       organization_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       webhosting_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetHostingResult]:
    """
    Gets information about a webhosting.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    # Get info by offer domain
    by_domain = scaleway.hosting.get_hosting(domain="foobar.com")
    # Get info by id
    by_id = scaleway.hosting.get_hosting(webhosting_id="11111111-1111-1111-1111-111111111111")
    ```


    :param _builtins.str domain: The hosting domain name. Only one of `domain` and `webhosting_id` should be specified.
    :param _builtins.str organization_id: The ID of the organization the hosting is associated with.
    :param _builtins.str project_id: `project_id`) The ID of the project the hosting is associated with.
    :param _builtins.str webhosting_id: The hosting id. Only one of `domain` and `webhosting_id` should be specified.
    """
    __args__ = dict()
    __args__['domain'] = domain
    __args__['organizationId'] = organization_id
    __args__['projectId'] = project_id
    __args__['webhostingId'] = webhosting_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:hosting/getHosting:getHosting', __args__, opts=opts, typ=GetHostingResult)
    return __ret__.apply(lambda __response__: GetHostingResult(
        cpanel_urls=pulumi.get(__response__, 'cpanel_urls'),
        created_at=pulumi.get(__response__, 'created_at'),
        dns_status=pulumi.get(__response__, 'dns_status'),
        domain=pulumi.get(__response__, 'domain'),
        email=pulumi.get(__response__, 'email'),
        id=pulumi.get(__response__, 'id'),
        name_servers=pulumi.get(__response__, 'name_servers'),
        offer_id=pulumi.get(__response__, 'offer_id'),
        offer_name=pulumi.get(__response__, 'offer_name'),
        option_ids=pulumi.get(__response__, 'option_ids'),
        options=pulumi.get(__response__, 'options'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        platform_hostname=pulumi.get(__response__, 'platform_hostname'),
        platform_number=pulumi.get(__response__, 'platform_number'),
        project_id=pulumi.get(__response__, 'project_id'),
        records=pulumi.get(__response__, 'records'),
        region=pulumi.get(__response__, 'region'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        username=pulumi.get(__response__, 'username'),
        webhosting_id=pulumi.get(__response__, 'webhosting_id')))
