# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetOfferResult',
    'AwaitableGetOfferResult',
    'get_offer',
    'get_offer_output',
]

@pulumi.output_type
class GetOfferResult:
    """
    A collection of values returned by getOffer.
    """
    def __init__(__self__, billing_operation_path=None, control_panel=None, id=None, name=None, offer_id=None, offers=None, price=None, products=None, region=None):
        if billing_operation_path and not isinstance(billing_operation_path, str):
            raise TypeError("Expected argument 'billing_operation_path' to be a str")
        pulumi.set(__self__, "billing_operation_path", billing_operation_path)
        if control_panel and not isinstance(control_panel, str):
            raise TypeError("Expected argument 'control_panel' to be a str")
        pulumi.set(__self__, "control_panel", control_panel)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if offer_id and not isinstance(offer_id, str):
            raise TypeError("Expected argument 'offer_id' to be a str")
        pulumi.set(__self__, "offer_id", offer_id)
        if offers and not isinstance(offers, list):
            raise TypeError("Expected argument 'offers' to be a list")
        pulumi.set(__self__, "offers", offers)
        if price and not isinstance(price, str):
            raise TypeError("Expected argument 'price' to be a str")
        pulumi.set(__self__, "price", price)
        if products and not isinstance(products, list):
            raise TypeError("Expected argument 'products' to be a list")
        pulumi.set(__self__, "products", products)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="billingOperationPath")
    def billing_operation_path(self) -> _builtins.str:
        """
        The billing operation identifier for the option.
        """
        return pulumi.get(self, "billing_operation_path")

    @_builtins.property
    @pulumi.getter(name="controlPanel")
    def control_panel(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "control_panel")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the option.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="offerId")
    def offer_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "offer_id")

    @_builtins.property
    @pulumi.getter
    def offers(self) -> Sequence['outputs.GetOfferOfferResult']:
        """
        The detailed offer of the hosting.
        """
        return pulumi.get(self, "offers")

    @_builtins.property
    @pulumi.getter
    def price(self) -> _builtins.str:
        """
        The offer price.
        """
        return pulumi.get(self, "price")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""The product field is deprecated. Please use the offer field instead.""")
    def products(self) -> Sequence['outputs.GetOfferProductResult']:
        """
        (deprecated) The offer product.
        """
        return pulumi.get(self, "products")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "region")


class AwaitableGetOfferResult(GetOfferResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOfferResult(
            billing_operation_path=self.billing_operation_path,
            control_panel=self.control_panel,
            id=self.id,
            name=self.name,
            offer_id=self.offer_id,
            offers=self.offers,
            price=self.price,
            products=self.products,
            region=self.region)


def get_offer(control_panel: Optional[_builtins.str] = None,
              name: Optional[_builtins.str] = None,
              offer_id: Optional[_builtins.str] = None,
              region: Optional[_builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOfferResult:
    """
    Gets information about a webhosting offer.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    # Get info by offer name
    by_name = scaleway.hosting.get_offer(name="performance",
        control_panel="Cpanel")
    # Get info by offer id
    by_id = scaleway.hosting.get_offer(offer_id="de2426b4-a9e9-11ec-b909-0242ac120002")
    ```


    :param _builtins.str control_panel: Name of the control panel (Cpanel or Plesk). This argument is only used when `offer_id` is not specified.
    :param _builtins.str name: The offer name. Only one of `name` and `offer_id` should be specified.
    :param _builtins.str offer_id: The offer id. Only one of `name` and `offer_id` should be specified.
    :param _builtins.str region: `region`) The region in which offer exists.
    """
    __args__ = dict()
    __args__['controlPanel'] = control_panel
    __args__['name'] = name
    __args__['offerId'] = offer_id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:hosting/getOffer:getOffer', __args__, opts=opts, typ=GetOfferResult).value

    return AwaitableGetOfferResult(
        billing_operation_path=pulumi.get(__ret__, 'billing_operation_path'),
        control_panel=pulumi.get(__ret__, 'control_panel'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        offer_id=pulumi.get(__ret__, 'offer_id'),
        offers=pulumi.get(__ret__, 'offers'),
        price=pulumi.get(__ret__, 'price'),
        products=pulumi.get(__ret__, 'products'),
        region=pulumi.get(__ret__, 'region'))
def get_offer_output(control_panel: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     offer_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOfferResult]:
    """
    Gets information about a webhosting offer.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    # Get info by offer name
    by_name = scaleway.hosting.get_offer(name="performance",
        control_panel="Cpanel")
    # Get info by offer id
    by_id = scaleway.hosting.get_offer(offer_id="de2426b4-a9e9-11ec-b909-0242ac120002")
    ```


    :param _builtins.str control_panel: Name of the control panel (Cpanel or Plesk). This argument is only used when `offer_id` is not specified.
    :param _builtins.str name: The offer name. Only one of `name` and `offer_id` should be specified.
    :param _builtins.str offer_id: The offer id. Only one of `name` and `offer_id` should be specified.
    :param _builtins.str region: `region`) The region in which offer exists.
    """
    __args__ = dict()
    __args__['controlPanel'] = control_panel
    __args__['name'] = name
    __args__['offerId'] = offer_id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:hosting/getOffer:getOffer', __args__, opts=opts, typ=GetOfferResult)
    return __ret__.apply(lambda __response__: GetOfferResult(
        billing_operation_path=pulumi.get(__response__, 'billing_operation_path'),
        control_panel=pulumi.get(__response__, 'control_panel'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        offer_id=pulumi.get(__response__, 'offer_id'),
        offers=pulumi.get(__response__, 'offers'),
        price=pulumi.get(__response__, 'price'),
        products=pulumi.get(__response__, 'products'),
        region=pulumi.get(__response__, 'region')))
