# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HostingArgs', 'Hosting']

@pulumi.input_type
class HostingArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[_builtins.str],
                 email: pulumi.Input[_builtins.str],
                 offer_id: pulumi.Input[_builtins.str],
                 option_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Hosting resource.
        :param pulumi.Input[_builtins.str] domain: The domain name of the hosting.
        :param pulumi.Input[_builtins.str] email: The contact email of the client for the hosting.
        :param pulumi.Input[_builtins.str] offer_id: The ID of the selected offer for the hosting.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] option_ids: The IDs of the selected options for the hosting.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the VPC is associated with.
        :param pulumi.Input[_builtins.str] region: `region`) The region of the Hosting.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags associated with the hosting.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "offer_id", offer_id)
        if option_ids is not None:
            pulumi.set(__self__, "option_ids", option_ids)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Input[_builtins.str]:
        """
        The domain name of the hosting.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Input[_builtins.str]:
        """
        The contact email of the client for the hosting.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="offerId")
    def offer_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the selected offer for the hosting.
        """
        return pulumi.get(self, "offer_id")

    @offer_id.setter
    def offer_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "offer_id", value)

    @_builtins.property
    @pulumi.getter(name="optionIds")
    def option_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IDs of the selected options for the hosting.
        """
        return pulumi.get(self, "option_ids")

    @option_ids.setter
    def option_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "option_ids", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the project the VPC is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`) The region of the Hosting.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The tags associated with the hosting.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _HostingState:
    def __init__(__self__, *,
                 cpanel_urls: Optional[pulumi.Input[Sequence[pulumi.Input['HostingCpanelUrlArgs']]]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_status: Optional[pulumi.Input[_builtins.str]] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 name_servers: Optional[pulumi.Input[Sequence[pulumi.Input['HostingNameServerArgs']]]] = None,
                 offer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 offer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 option_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input['HostingOptionArgs']]]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 platform_hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 platform_number: Optional[pulumi.Input[_builtins.int]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 records: Optional[pulumi.Input[Sequence[pulumi.Input['HostingRecordArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Hosting resources.
        :param pulumi.Input[Sequence[pulumi.Input['HostingCpanelUrlArgs']]] cpanel_urls: The URL to connect to cPanel Dashboard and to Webmail interface.
        :param pulumi.Input[_builtins.str] created_at: Date and time of hosting's creation (RFC 3339 format).
        :param pulumi.Input[_builtins.str] dns_status: The DNS status of the hosting.
        :param pulumi.Input[_builtins.str] domain: The domain name of the hosting.
        :param pulumi.Input[_builtins.str] email: The contact email of the client for the hosting.
        :param pulumi.Input[Sequence[pulumi.Input['HostingNameServerArgs']]] name_servers: List of nameservers associated with the webhosting.
        :param pulumi.Input[_builtins.str] offer_id: The ID of the selected offer for the hosting.
        :param pulumi.Input[_builtins.str] offer_name: The name of the active offer.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] option_ids: The IDs of the selected options for the hosting.
        :param pulumi.Input[Sequence[pulumi.Input['HostingOptionArgs']]] options: The active options of the hosting.
        :param pulumi.Input[_builtins.str] organization_id: (Deprecated) The organization ID the hosting is associated with.
        :param pulumi.Input[_builtins.str] platform_hostname: The hostname of the host platform.
        :param pulumi.Input[_builtins.int] platform_number: The number of the host platform.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the VPC is associated with.
        :param pulumi.Input[Sequence[pulumi.Input['HostingRecordArgs']]] records: List of DNS records associated with the webhosting.
        :param pulumi.Input[_builtins.str] region: `region`) The region of the Hosting.
        :param pulumi.Input[_builtins.str] status: The hosting status.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags associated with the hosting.
        :param pulumi.Input[_builtins.str] updated_at: Date and time of hosting's last update (RFC 3339 format).
        :param pulumi.Input[_builtins.str] username: The main hosting cPanel username.
        """
        if cpanel_urls is not None:
            pulumi.set(__self__, "cpanel_urls", cpanel_urls)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if dns_status is not None:
            pulumi.set(__self__, "dns_status", dns_status)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if name_servers is not None:
            pulumi.set(__self__, "name_servers", name_servers)
        if offer_id is not None:
            pulumi.set(__self__, "offer_id", offer_id)
        if offer_name is not None:
            pulumi.set(__self__, "offer_name", offer_name)
        if option_ids is not None:
            pulumi.set(__self__, "option_ids", option_ids)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if organization_id is not None:
            warnings.warn("""The organization_id field is deprecated and will be removed in the next major version.""", DeprecationWarning)
            pulumi.log.warn("""organization_id is deprecated: The organization_id field is deprecated and will be removed in the next major version.""")
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if platform_hostname is not None:
            pulumi.set(__self__, "platform_hostname", platform_hostname)
        if platform_number is not None:
            pulumi.set(__self__, "platform_number", platform_number)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if records is not None:
            pulumi.set(__self__, "records", records)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="cpanelUrls")
    def cpanel_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HostingCpanelUrlArgs']]]]:
        """
        The URL to connect to cPanel Dashboard and to Webmail interface.
        """
        return pulumi.get(self, "cpanel_urls")

    @cpanel_urls.setter
    def cpanel_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HostingCpanelUrlArgs']]]]):
        pulumi.set(self, "cpanel_urls", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time of hosting's creation (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="dnsStatus")
    def dns_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The DNS status of the hosting.
        """
        return pulumi.get(self, "dns_status")

    @dns_status.setter
    def dns_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_status", value)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name of the hosting.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The contact email of the client for the hosting.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="nameServers")
    def name_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HostingNameServerArgs']]]]:
        """
        List of nameservers associated with the webhosting.
        """
        return pulumi.get(self, "name_servers")

    @name_servers.setter
    def name_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HostingNameServerArgs']]]]):
        pulumi.set(self, "name_servers", value)

    @_builtins.property
    @pulumi.getter(name="offerId")
    def offer_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the selected offer for the hosting.
        """
        return pulumi.get(self, "offer_id")

    @offer_id.setter
    def offer_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "offer_id", value)

    @_builtins.property
    @pulumi.getter(name="offerName")
    def offer_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the active offer.
        """
        return pulumi.get(self, "offer_name")

    @offer_name.setter
    def offer_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "offer_name", value)

    @_builtins.property
    @pulumi.getter(name="optionIds")
    def option_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IDs of the selected options for the hosting.
        """
        return pulumi.get(self, "option_ids")

    @option_ids.setter
    def option_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "option_ids", value)

    @_builtins.property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HostingOptionArgs']]]]:
        """
        The active options of the hosting.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HostingOptionArgs']]]]):
        pulumi.set(self, "options", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    @_utilities.deprecated("""The organization_id field is deprecated and will be removed in the next major version.""")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Deprecated) The organization ID the hosting is associated with.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="platformHostname")
    def platform_hostname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The hostname of the host platform.
        """
        return pulumi.get(self, "platform_hostname")

    @platform_hostname.setter
    def platform_hostname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "platform_hostname", value)

    @_builtins.property
    @pulumi.getter(name="platformNumber")
    def platform_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of the host platform.
        """
        return pulumi.get(self, "platform_number")

    @platform_number.setter
    def platform_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "platform_number", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `project_id`) The ID of the project the VPC is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def records(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HostingRecordArgs']]]]:
        """
        List of DNS records associated with the webhosting.
        """
        return pulumi.get(self, "records")

    @records.setter
    def records(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HostingRecordArgs']]]]):
        pulumi.set(self, "records", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `region`) The region of the Hosting.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The hosting status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The tags associated with the hosting.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date and time of hosting's last update (RFC 3339 format).
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The main hosting cPanel username.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("scaleway:hosting/hosting:Hosting")
class Hosting(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 offer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 option_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Web Hostings.
        For more information, see the [API documentation](https://www.scaleway.com/en/developers/api/webhosting/hosting-api/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scaleway as scaleway
        import pulumiverse_scaleway as scaleway

        by_name = scaleway.hosting.get_offer(name="lite",
            control_panel="Cpanel")
        main = scaleway.hosting.Hosting("main",
            offer_id=by_name.offer_id,
            email="your@email.com",
            domain="yourdomain.com",
            tags=[
                "webhosting",
                "provider",
                "terraform",
            ])
        ```

        ## Import

        Hostings can be imported using the `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:hosting/hosting:Hosting hosting01 fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain: The domain name of the hosting.
        :param pulumi.Input[_builtins.str] email: The contact email of the client for the hosting.
        :param pulumi.Input[_builtins.str] offer_id: The ID of the selected offer for the hosting.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] option_ids: The IDs of the selected options for the hosting.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the VPC is associated with.
        :param pulumi.Input[_builtins.str] region: `region`) The region of the Hosting.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags associated with the hosting.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HostingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Web Hostings.
        For more information, see the [API documentation](https://www.scaleway.com/en/developers/api/webhosting/hosting-api/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_scaleway as scaleway
        import pulumiverse_scaleway as scaleway

        by_name = scaleway.hosting.get_offer(name="lite",
            control_panel="Cpanel")
        main = scaleway.hosting.Hosting("main",
            offer_id=by_name.offer_id,
            email="your@email.com",
            domain="yourdomain.com",
            tags=[
                "webhosting",
                "provider",
                "terraform",
            ])
        ```

        ## Import

        Hostings can be imported using the `{region}/{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:hosting/hosting:Hosting hosting01 fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param HostingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HostingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 offer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 option_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HostingArgs.__new__(HostingArgs)

            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            if offer_id is None and not opts.urn:
                raise TypeError("Missing required property 'offer_id'")
            __props__.__dict__["offer_id"] = offer_id
            __props__.__dict__["option_ids"] = option_ids
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            __props__.__dict__["cpanel_urls"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["dns_status"] = None
            __props__.__dict__["name_servers"] = None
            __props__.__dict__["offer_name"] = None
            __props__.__dict__["options"] = None
            __props__.__dict__["organization_id"] = None
            __props__.__dict__["platform_hostname"] = None
            __props__.__dict__["platform_number"] = None
            __props__.__dict__["records"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["username"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/webhosting:Webhosting")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Hosting, __self__).__init__(
            'scaleway:hosting/hosting:Hosting',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cpanel_urls: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HostingCpanelUrlArgs', 'HostingCpanelUrlArgsDict']]]]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            dns_status: Optional[pulumi.Input[_builtins.str]] = None,
            domain: Optional[pulumi.Input[_builtins.str]] = None,
            email: Optional[pulumi.Input[_builtins.str]] = None,
            name_servers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HostingNameServerArgs', 'HostingNameServerArgsDict']]]]] = None,
            offer_id: Optional[pulumi.Input[_builtins.str]] = None,
            offer_name: Optional[pulumi.Input[_builtins.str]] = None,
            option_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HostingOptionArgs', 'HostingOptionArgsDict']]]]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None,
            platform_hostname: Optional[pulumi.Input[_builtins.str]] = None,
            platform_number: Optional[pulumi.Input[_builtins.int]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            records: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HostingRecordArgs', 'HostingRecordArgsDict']]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None) -> 'Hosting':
        """
        Get an existing Hosting resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['HostingCpanelUrlArgs', 'HostingCpanelUrlArgsDict']]]] cpanel_urls: The URL to connect to cPanel Dashboard and to Webmail interface.
        :param pulumi.Input[_builtins.str] created_at: Date and time of hosting's creation (RFC 3339 format).
        :param pulumi.Input[_builtins.str] dns_status: The DNS status of the hosting.
        :param pulumi.Input[_builtins.str] domain: The domain name of the hosting.
        :param pulumi.Input[_builtins.str] email: The contact email of the client for the hosting.
        :param pulumi.Input[Sequence[pulumi.Input[Union['HostingNameServerArgs', 'HostingNameServerArgsDict']]]] name_servers: List of nameservers associated with the webhosting.
        :param pulumi.Input[_builtins.str] offer_id: The ID of the selected offer for the hosting.
        :param pulumi.Input[_builtins.str] offer_name: The name of the active offer.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] option_ids: The IDs of the selected options for the hosting.
        :param pulumi.Input[Sequence[pulumi.Input[Union['HostingOptionArgs', 'HostingOptionArgsDict']]]] options: The active options of the hosting.
        :param pulumi.Input[_builtins.str] organization_id: (Deprecated) The organization ID the hosting is associated with.
        :param pulumi.Input[_builtins.str] platform_hostname: The hostname of the host platform.
        :param pulumi.Input[_builtins.int] platform_number: The number of the host platform.
        :param pulumi.Input[_builtins.str] project_id: `project_id`) The ID of the project the VPC is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[Union['HostingRecordArgs', 'HostingRecordArgsDict']]]] records: List of DNS records associated with the webhosting.
        :param pulumi.Input[_builtins.str] region: `region`) The region of the Hosting.
        :param pulumi.Input[_builtins.str] status: The hosting status.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The tags associated with the hosting.
        :param pulumi.Input[_builtins.str] updated_at: Date and time of hosting's last update (RFC 3339 format).
        :param pulumi.Input[_builtins.str] username: The main hosting cPanel username.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HostingState.__new__(_HostingState)

        __props__.__dict__["cpanel_urls"] = cpanel_urls
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["dns_status"] = dns_status
        __props__.__dict__["domain"] = domain
        __props__.__dict__["email"] = email
        __props__.__dict__["name_servers"] = name_servers
        __props__.__dict__["offer_id"] = offer_id
        __props__.__dict__["offer_name"] = offer_name
        __props__.__dict__["option_ids"] = option_ids
        __props__.__dict__["options"] = options
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["platform_hostname"] = platform_hostname
        __props__.__dict__["platform_number"] = platform_number
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["records"] = records
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["username"] = username
        return Hosting(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cpanelUrls")
    def cpanel_urls(self) -> pulumi.Output[Sequence['outputs.HostingCpanelUrl']]:
        """
        The URL to connect to cPanel Dashboard and to Webmail interface.
        """
        return pulumi.get(self, "cpanel_urls")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Date and time of hosting's creation (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="dnsStatus")
    def dns_status(self) -> pulumi.Output[_builtins.str]:
        """
        The DNS status of the hosting.
        """
        return pulumi.get(self, "dns_status")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> pulumi.Output[_builtins.str]:
        """
        The domain name of the hosting.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Output[_builtins.str]:
        """
        The contact email of the client for the hosting.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="nameServers")
    def name_servers(self) -> pulumi.Output[Sequence['outputs.HostingNameServer']]:
        """
        List of nameservers associated with the webhosting.
        """
        return pulumi.get(self, "name_servers")

    @_builtins.property
    @pulumi.getter(name="offerId")
    def offer_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the selected offer for the hosting.
        """
        return pulumi.get(self, "offer_id")

    @_builtins.property
    @pulumi.getter(name="offerName")
    def offer_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the active offer.
        """
        return pulumi.get(self, "offer_name")

    @_builtins.property
    @pulumi.getter(name="optionIds")
    def option_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The IDs of the selected options for the hosting.
        """
        return pulumi.get(self, "option_ids")

    @_builtins.property
    @pulumi.getter
    def options(self) -> pulumi.Output[Sequence['outputs.HostingOption']]:
        """
        The active options of the hosting.
        """
        return pulumi.get(self, "options")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    @_utilities.deprecated("""The organization_id field is deprecated and will be removed in the next major version.""")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Deprecated) The organization ID the hosting is associated with.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="platformHostname")
    def platform_hostname(self) -> pulumi.Output[_builtins.str]:
        """
        The hostname of the host platform.
        """
        return pulumi.get(self, "platform_hostname")

    @_builtins.property
    @pulumi.getter(name="platformNumber")
    def platform_number(self) -> pulumi.Output[_builtins.int]:
        """
        The number of the host platform.
        """
        return pulumi.get(self, "platform_number")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        `project_id`) The ID of the project the VPC is associated with.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def records(self) -> pulumi.Output[Sequence['outputs.HostingRecord']]:
        """
        List of DNS records associated with the webhosting.
        """
        return pulumi.get(self, "records")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `region`) The region of the Hosting.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The hosting status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The tags associated with the hosting.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        Date and time of hosting's last update (RFC 3339 format).
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[_builtins.str]:
        """
        The main hosting cPanel username.
        """
        return pulumi.get(self, "username")

