# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'PolicyRuleArgs',
    'PolicyRuleArgsDict',
]

MYPY = False

if not MYPY:
    class PolicyRuleArgsDict(TypedDict):
        permission_set_names: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Names of permission sets bind to the rule.
        """
        condition: NotRequired[pulumi.Input[_builtins.str]]
        """
        The condition of the rule.

        **_TIP:_** You can use the Scaleway CLI to list the permissions details. e.g:

        ```shell
        scw iam permission-set list
        ```
        """
        organization_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        ID of organization scoped to the rule, this can be used to create a rule for all projects in an organization.
        """
        project_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        List of project IDs scoped to the rule.

        > **Important** One `organization_id` or `project_ids` must be set per rule.
        """
elif False:
    PolicyRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PolicyRuleArgs:
    def __init__(__self__, *,
                 permission_set_names: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 condition: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] permission_set_names: Names of permission sets bind to the rule.
        :param pulumi.Input[_builtins.str] condition: The condition of the rule.
               
               **_TIP:_** You can use the Scaleway CLI to list the permissions details. e.g:
               
               ```shell
               scw iam permission-set list
               ```
        :param pulumi.Input[_builtins.str] organization_id: ID of organization scoped to the rule, this can be used to create a rule for all projects in an organization.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] project_ids: List of project IDs scoped to the rule.
               
               > **Important** One `organization_id` or `project_ids` must be set per rule.
        """
        pulumi.set(__self__, "permission_set_names", permission_set_names)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if project_ids is not None:
            pulumi.set(__self__, "project_ids", project_ids)

    @_builtins.property
    @pulumi.getter(name="permissionSetNames")
    def permission_set_names(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Names of permission sets bind to the rule.
        """
        return pulumi.get(self, "permission_set_names")

    @permission_set_names.setter
    def permission_set_names(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "permission_set_names", value)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The condition of the rule.

        **_TIP:_** You can use the Scaleway CLI to list the permissions details. e.g:

        ```shell
        scw iam permission-set list
        ```
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of organization scoped to the rule, this can be used to create a rule for all projects in an organization.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="projectIds")
    def project_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of project IDs scoped to the rule.

        > **Important** One `organization_id` or `project_ids` must be set per rule.
        """
        return pulumi.get(self, "project_ids")

    @project_ids.setter
    def project_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "project_ids", value)


