# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ApiKeyArgs', 'ApiKey']

@pulumi.input_type
class ApiKeyArgs:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 expires_at: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ApiKey resource.
        :param pulumi.Input[_builtins.str] application_id: ID of the application attached to the API key.
        :param pulumi.Input[_builtins.str] default_project_id: The default Project ID to use with Object Storage.
        :param pulumi.Input[_builtins.str] description: The description of the API key.
        :param pulumi.Input[_builtins.str] expires_at: The date and time of the expiration of the IAM API key. Please note that in case of any changes,
               the resource will be recreated.
        :param pulumi.Input[_builtins.str] user_id: ID of the user attached to the API key.
               > **Note** You must specify at least one: `application_id` and/or `user_id`.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if default_project_id is not None:
            pulumi.set(__self__, "default_project_id", default_project_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the application attached to the API key.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultProjectId")
    def default_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default Project ID to use with Object Storage.
        """
        return pulumi.get(self, "default_project_id")

    @default_project_id.setter
    def default_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_project_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the API key.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the expiration of the IAM API key. Please note that in case of any changes,
        the resource will be recreated.
        """
        return pulumi.get(self, "expires_at")

    @expires_at.setter
    def expires_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expires_at", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the user attached to the API key.
        > **Note** You must specify at least one: `application_id` and/or `user_id`.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class _ApiKeyState:
    def __init__(__self__, *,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 default_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 editable: Optional[pulumi.Input[_builtins.bool]] = None,
                 expires_at: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ApiKey resources.
        :param pulumi.Input[_builtins.str] access_key: The access key of the IAM API key.
        :param pulumi.Input[_builtins.str] application_id: ID of the application attached to the API key.
        :param pulumi.Input[_builtins.str] created_at: The date and time of the creation of the IAM API key.
        :param pulumi.Input[_builtins.str] creation_ip: The IP Address of the device which created the API key.
        :param pulumi.Input[_builtins.str] default_project_id: The default Project ID to use with Object Storage.
        :param pulumi.Input[_builtins.str] description: The description of the API key.
        :param pulumi.Input[_builtins.bool] editable: Whether the IAM API key is editable.
        :param pulumi.Input[_builtins.str] expires_at: The date and time of the expiration of the IAM API key. Please note that in case of any changes,
               the resource will be recreated.
        :param pulumi.Input[_builtins.str] secret_key: The secret Key of the IAM API key.
        :param pulumi.Input[_builtins.str] updated_at: The date and time of the last update of the IAM API key.
        :param pulumi.Input[_builtins.str] user_id: ID of the user attached to the API key.
               > **Note** You must specify at least one: `application_id` and/or `user_id`.
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if creation_ip is not None:
            pulumi.set(__self__, "creation_ip", creation_ip)
        if default_project_id is not None:
            pulumi.set(__self__, "default_project_id", default_project_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if editable is not None:
            pulumi.set(__self__, "editable", editable)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access key of the IAM API key.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key", value)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the application attached to the API key.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_id", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the creation of the IAM API key.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="creationIp")
    def creation_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP Address of the device which created the API key.
        """
        return pulumi.get(self, "creation_ip")

    @creation_ip.setter
    def creation_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_ip", value)

    @_builtins.property
    @pulumi.getter(name="defaultProjectId")
    def default_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default Project ID to use with Object Storage.
        """
        return pulumi.get(self, "default_project_id")

    @default_project_id.setter
    def default_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_project_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the API key.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def editable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the IAM API key is editable.
        """
        return pulumi.get(self, "editable")

    @editable.setter
    def editable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "editable", value)

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the expiration of the IAM API key. Please note that in case of any changes,
        the resource will be recreated.
        """
        return pulumi.get(self, "expires_at")

    @expires_at.setter
    def expires_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expires_at", value)

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secret Key of the IAM API key.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_key", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of the last update of the IAM API key.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the user attached to the API key.
        > **Note** You must specify at least one: `application_id` and/or `user_id`.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)


@pulumi.type_token("scaleway:iam/apiKey:ApiKey")
class ApiKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 expires_at: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway API Keys. For more information, refer to the [IAM API documentation](https://www.scaleway.com/en/developers/api/iam/#api-keys-3665ae).

        ## Example Usage

        ### With application

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        ci_cd = scaleway.iam.Application("ci_cd", name="My application")
        main = scaleway.iam.ApiKey("main",
            application_id=main_scaleway_iam_application["id"],
            description="a description")
        ```

        ### With user

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.iam.User("main", email="test@test.com")
        main_api_key = scaleway.iam.ApiKey("main",
            user_id=main.id,
            description="a description")
        ```

        ### With expiration

        ```python
        import pulumi
        import pulumi_time as time
        import pulumiverse_scaleway as scaleway

        rotate_after_a_year = time.index.Rotating("rotate_after_a_year", rotation_years=1)
        main = scaleway.iam.ApiKey("main",
            application_id=main_scaleway_iam_application["id"],
            expires_at=rotate_after_a_year["rotationRfc3339"])
        ```

        ## Import

        Api keys can be imported using the `{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:iam/apiKey:ApiKey main 11111111111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_id: ID of the application attached to the API key.
        :param pulumi.Input[_builtins.str] default_project_id: The default Project ID to use with Object Storage.
        :param pulumi.Input[_builtins.str] description: The description of the API key.
        :param pulumi.Input[_builtins.str] expires_at: The date and time of the expiration of the IAM API key. Please note that in case of any changes,
               the resource will be recreated.
        :param pulumi.Input[_builtins.str] user_id: ID of the user attached to the API key.
               > **Note** You must specify at least one: `application_id` and/or `user_id`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ApiKeyArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway API Keys. For more information, refer to the [IAM API documentation](https://www.scaleway.com/en/developers/api/iam/#api-keys-3665ae).

        ## Example Usage

        ### With application

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        ci_cd = scaleway.iam.Application("ci_cd", name="My application")
        main = scaleway.iam.ApiKey("main",
            application_id=main_scaleway_iam_application["id"],
            description="a description")
        ```

        ### With user

        ```python
        import pulumi
        import pulumiverse_scaleway as scaleway

        main = scaleway.iam.User("main", email="test@test.com")
        main_api_key = scaleway.iam.ApiKey("main",
            user_id=main.id,
            description="a description")
        ```

        ### With expiration

        ```python
        import pulumi
        import pulumi_time as time
        import pulumiverse_scaleway as scaleway

        rotate_after_a_year = time.index.Rotating("rotate_after_a_year", rotation_years=1)
        main = scaleway.iam.ApiKey("main",
            application_id=main_scaleway_iam_application["id"],
            expires_at=rotate_after_a_year["rotationRfc3339"])
        ```

        ## Import

        Api keys can be imported using the `{id}`, e.g.

        bash

        ```sh
        $ pulumi import scaleway:iam/apiKey:ApiKey main 11111111111111111111
        ```

        :param str resource_name: The name of the resource.
        :param ApiKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApiKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 expires_at: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApiKeyArgs.__new__(ApiKeyArgs)

            __props__.__dict__["application_id"] = application_id
            __props__.__dict__["default_project_id"] = default_project_id
            __props__.__dict__["description"] = description
            __props__.__dict__["expires_at"] = expires_at
            __props__.__dict__["user_id"] = user_id
            __props__.__dict__["access_key"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["creation_ip"] = None
            __props__.__dict__["editable"] = None
            __props__.__dict__["secret_key"] = None
            __props__.__dict__["updated_at"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="scaleway:index/iamApiKey:IamApiKey")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secretKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ApiKey, __self__).__init__(
            'scaleway:iam/apiKey:ApiKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_key: Optional[pulumi.Input[_builtins.str]] = None,
            application_id: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            creation_ip: Optional[pulumi.Input[_builtins.str]] = None,
            default_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            editable: Optional[pulumi.Input[_builtins.bool]] = None,
            expires_at: Optional[pulumi.Input[_builtins.str]] = None,
            secret_key: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            user_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ApiKey':
        """
        Get an existing ApiKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key: The access key of the IAM API key.
        :param pulumi.Input[_builtins.str] application_id: ID of the application attached to the API key.
        :param pulumi.Input[_builtins.str] created_at: The date and time of the creation of the IAM API key.
        :param pulumi.Input[_builtins.str] creation_ip: The IP Address of the device which created the API key.
        :param pulumi.Input[_builtins.str] default_project_id: The default Project ID to use with Object Storage.
        :param pulumi.Input[_builtins.str] description: The description of the API key.
        :param pulumi.Input[_builtins.bool] editable: Whether the IAM API key is editable.
        :param pulumi.Input[_builtins.str] expires_at: The date and time of the expiration of the IAM API key. Please note that in case of any changes,
               the resource will be recreated.
        :param pulumi.Input[_builtins.str] secret_key: The secret Key of the IAM API key.
        :param pulumi.Input[_builtins.str] updated_at: The date and time of the last update of the IAM API key.
        :param pulumi.Input[_builtins.str] user_id: ID of the user attached to the API key.
               > **Note** You must specify at least one: `application_id` and/or `user_id`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApiKeyState.__new__(_ApiKeyState)

        __props__.__dict__["access_key"] = access_key
        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["creation_ip"] = creation_ip
        __props__.__dict__["default_project_id"] = default_project_id
        __props__.__dict__["description"] = description
        __props__.__dict__["editable"] = editable
        __props__.__dict__["expires_at"] = expires_at
        __props__.__dict__["secret_key"] = secret_key
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["user_id"] = user_id
        return ApiKey(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Output[_builtins.str]:
        """
        The access key of the IAM API key.
        """
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of the application attached to the API key.
        """
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of the creation of the IAM API key.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="creationIp")
    def creation_ip(self) -> pulumi.Output[_builtins.str]:
        """
        The IP Address of the device which created the API key.
        """
        return pulumi.get(self, "creation_ip")

    @_builtins.property
    @pulumi.getter(name="defaultProjectId")
    def default_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The default Project ID to use with Object Storage.
        """
        return pulumi.get(self, "default_project_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the API key.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def editable(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the IAM API key is editable.
        """
        return pulumi.get(self, "editable")

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The date and time of the expiration of the IAM API key. Please note that in case of any changes,
        the resource will be recreated.
        """
        return pulumi.get(self, "expires_at")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Output[_builtins.str]:
        """
        The secret Key of the IAM API key.
        """
        return pulumi.get(self, "secret_key")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of the last update of the IAM API key.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of the user attached to the API key.
        > **Note** You must specify at least one: `application_id` and/or `user_id`.
        """
        return pulumi.get(self, "user_id")

