# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetPolicyResult',
    'AwaitableGetPolicyResult',
    'get_policy',
    'get_policy_output',
]

@pulumi.output_type
class GetPolicyResult:
    """
    A collection of values returned by getPolicy.
    """
    def __init__(__self__, application_id=None, created_at=None, description=None, editable=None, group_id=None, id=None, name=None, no_principal=None, organization_id=None, policy_id=None, rules=None, tags=None, updated_at=None, user_id=None):
        if application_id and not isinstance(application_id, str):
            raise TypeError("Expected argument 'application_id' to be a str")
        pulumi.set(__self__, "application_id", application_id)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if editable and not isinstance(editable, bool):
            raise TypeError("Expected argument 'editable' to be a bool")
        pulumi.set(__self__, "editable", editable)
        if group_id and not isinstance(group_id, str):
            raise TypeError("Expected argument 'group_id' to be a str")
        pulumi.set(__self__, "group_id", group_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if no_principal and not isinstance(no_principal, bool):
            raise TypeError("Expected argument 'no_principal' to be a bool")
        pulumi.set(__self__, "no_principal", no_principal)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if policy_id and not isinstance(policy_id, str):
            raise TypeError("Expected argument 'policy_id' to be a str")
        pulumi.set(__self__, "policy_id", policy_id)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)
        if user_id and not isinstance(user_id, str):
            raise TypeError("Expected argument 'user_id' to be a str")
        pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> _builtins.str:
        """
        ID of the application the policy is linked to
        """
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        The date and time of the creation of the policy.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the IAM policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def editable(self) -> _builtins.bool:
        """
        Whether the policy is editable.
        """
        return pulumi.get(self, "editable")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> _builtins.str:
        """
        ID of the group the policy is linked to
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="noPrincipal")
    def no_principal(self) -> _builtins.bool:
        """
        If the policy doesn't apply to a principal.
        """
        return pulumi.get(self, "no_principal")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> _builtins.str:
        """
        ID of organization scoped to the rule.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "policy_id")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetPolicyRuleResult']:
        """
        List of rules in the policy.
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        The tags associated with the IAM policy.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        The date and time of the last update of the policy.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> _builtins.str:
        """
        ID of the user the policy is linked to
        """
        return pulumi.get(self, "user_id")


class AwaitableGetPolicyResult(GetPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPolicyResult(
            application_id=self.application_id,
            created_at=self.created_at,
            description=self.description,
            editable=self.editable,
            group_id=self.group_id,
            id=self.id,
            name=self.name,
            no_principal=self.no_principal,
            organization_id=self.organization_id,
            policy_id=self.policy_id,
            rules=self.rules,
            tags=self.tags,
            updated_at=self.updated_at,
            user_id=self.user_id)


def get_policy(name: Optional[_builtins.str] = None,
               policy_id: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPolicyResult:
    """
    Use this data source to get information on an existing IAM policy based on its ID.
    For more information refer to the [IAM API documentation](https://developers.scaleway.com/en/products/iam/api/).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    # Get policy by id
    find_by_id = scaleway.iam.get_policy(policy_id="11111111-1111-1111-1111-111111111111")
    # Get policy by name
    find_by_name = scaleway.iam.get_policy(name="my_policy")
    ```


    :param _builtins.str name: The name of the IAM policy.
    :param _builtins.str policy_id: The ID of the IAM policy.
           
           > **Note** You must specify at least one: `name` and/or `policy_id`.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['policyId'] = policy_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:iam/getPolicy:getPolicy', __args__, opts=opts, typ=GetPolicyResult).value

    return AwaitableGetPolicyResult(
        application_id=pulumi.get(__ret__, 'application_id'),
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        editable=pulumi.get(__ret__, 'editable'),
        group_id=pulumi.get(__ret__, 'group_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        no_principal=pulumi.get(__ret__, 'no_principal'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        policy_id=pulumi.get(__ret__, 'policy_id'),
        rules=pulumi.get(__ret__, 'rules'),
        tags=pulumi.get(__ret__, 'tags'),
        updated_at=pulumi.get(__ret__, 'updated_at'),
        user_id=pulumi.get(__ret__, 'user_id'))
def get_policy_output(name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      policy_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPolicyResult]:
    """
    Use this data source to get information on an existing IAM policy based on its ID.
    For more information refer to the [IAM API documentation](https://developers.scaleway.com/en/products/iam/api/).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    # Get policy by id
    find_by_id = scaleway.iam.get_policy(policy_id="11111111-1111-1111-1111-111111111111")
    # Get policy by name
    find_by_name = scaleway.iam.get_policy(name="my_policy")
    ```


    :param _builtins.str name: The name of the IAM policy.
    :param _builtins.str policy_id: The ID of the IAM policy.
           
           > **Note** You must specify at least one: `name` and/or `policy_id`.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['policyId'] = policy_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:iam/getPolicy:getPolicy', __args__, opts=opts, typ=GetPolicyResult)
    return __ret__.apply(lambda __response__: GetPolicyResult(
        application_id=pulumi.get(__response__, 'application_id'),
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        editable=pulumi.get(__response__, 'editable'),
        group_id=pulumi.get(__response__, 'group_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        no_principal=pulumi.get(__response__, 'no_principal'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        policy_id=pulumi.get(__response__, 'policy_id'),
        rules=pulumi.get(__response__, 'rules'),
        tags=pulumi.get(__response__, 'tags'),
        updated_at=pulumi.get(__response__, 'updated_at'),
        user_id=pulumi.get(__response__, 'user_id')))
