# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ImageAdditionalVolumeArgs',
    'ImageAdditionalVolumeArgsDict',
    'ImageRootVolumeArgs',
    'ImageRootVolumeArgsDict',
    'PrivateNicPrivateIpArgs',
    'PrivateNicPrivateIpArgsDict',
    'SecurityGroupInboundRuleArgs',
    'SecurityGroupInboundRuleArgsDict',
    'SecurityGroupOutboundRuleArgs',
    'SecurityGroupOutboundRuleArgsDict',
    'SecurityGroupRulesInboundRuleArgs',
    'SecurityGroupRulesInboundRuleArgsDict',
    'SecurityGroupRulesOutboundRuleArgs',
    'SecurityGroupRulesOutboundRuleArgsDict',
    'ServerFilesystemArgs',
    'ServerFilesystemArgsDict',
    'ServerPrivateIpArgs',
    'ServerPrivateIpArgsDict',
    'ServerPrivateNetworkArgs',
    'ServerPrivateNetworkArgsDict',
    'ServerPublicIpArgs',
    'ServerPublicIpArgsDict',
    'ServerRootVolumeArgs',
    'ServerRootVolumeArgsDict',
    'SnapshotImportArgs',
    'SnapshotImportArgsDict',
]

MYPY = False

if not MYPY:
    class ImageAdditionalVolumeArgsDict(TypedDict):
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        ID of the server containing the volume.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the image. If not provided it will be randomly generated.
        """
        server: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        """
        Description of the server containing the volume (in case the image is a backup from a server).
        """
        size: NotRequired[pulumi.Input[_builtins.int]]
        """
        The size of the volume.
        """
        tags: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of tags to apply to the image.
        """
        volume_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The type of volume, possible values are `l_ssd` and `sbs_snapshot`.
        """
elif False:
    ImageAdditionalVolumeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ImageAdditionalVolumeArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 server: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 volume_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] id: ID of the server containing the volume.
        :param pulumi.Input[_builtins.str] name: The name of the image. If not provided it will be randomly generated.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] server: Description of the server containing the volume (in case the image is a backup from a server).
        :param pulumi.Input[_builtins.int] size: The size of the volume.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: A list of tags to apply to the image.
        :param pulumi.Input[_builtins.str] volume_type: The type of volume, possible values are `l_ssd` and `sbs_snapshot`.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the server containing the volume.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the image. If not provided it will be randomly generated.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def server(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Description of the server containing the volume (in case the image is a backup from a server).
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "server", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the volume.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of tags to apply to the image.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of volume, possible values are `l_ssd` and `sbs_snapshot`.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_type", value)


if not MYPY:
    class ImageRootVolumeArgsDict(TypedDict):
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        ID of the server containing the volume.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the image. If not provided it will be randomly generated.
        """
        size: NotRequired[pulumi.Input[_builtins.int]]
        """
        The size of the volume.
        """
        volume_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The type of volume, possible values are `l_ssd` and `sbs_snapshot`.
        """
elif False:
    ImageRootVolumeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ImageRootVolumeArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 volume_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] id: ID of the server containing the volume.
        :param pulumi.Input[_builtins.str] name: The name of the image. If not provided it will be randomly generated.
        :param pulumi.Input[_builtins.int] size: The size of the volume.
        :param pulumi.Input[_builtins.str] volume_type: The type of volume, possible values are `l_ssd` and `sbs_snapshot`.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the server containing the volume.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the image. If not provided it will be randomly generated.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the volume.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of volume, possible values are `l_ssd` and `sbs_snapshot`.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_type", value)


if not MYPY:
    class PrivateNicPrivateIpArgsDict(TypedDict):
        address: NotRequired[pulumi.Input[_builtins.str]]
        """
        The private IP address.
        """
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the IP address resource.
        """
elif False:
    PrivateNicPrivateIpArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PrivateNicPrivateIpArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] address: The private IP address.
        :param pulumi.Input[_builtins.str] id: The ID of the IP address resource.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private IP address.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the IP address resource.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)


if not MYPY:
    class SecurityGroupInboundRuleArgsDict(TypedDict):
        action: pulumi.Input[_builtins.str]
        """
        The action to take when rule match. Possible values are: `accept` or `drop`.
        """
        ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        ip_range: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        port: NotRequired[pulumi.Input[_builtins.int]]
        """
        The port this rule applies to. If no `port` nor `port_range` are specified, the rule will apply to all port. Only one of `port` and `port_range` should be specified.
        """
        port_range: NotRequired[pulumi.Input[_builtins.str]]
        """
        Computed port range for this rule (e.g: 1-1024, 22-22)
        """
        protocol: NotRequired[pulumi.Input[_builtins.str]]
        """
        The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
elif False:
    SecurityGroupInboundRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGroupInboundRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[_builtins.str],
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_range: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] action: The action to take when rule match. Possible values are: `accept` or `drop`.
        :param pulumi.Input[_builtins.str] ip: The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param pulumi.Input[_builtins.str] ip_range: The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param pulumi.Input[_builtins.int] port: The port this rule applies to. If no `port` nor `port_range` are specified, the rule will apply to all port. Only one of `port` and `port_range` should be specified.
        :param pulumi.Input[_builtins.str] port_range: Computed port range for this rule (e.g: 1-1024, 22-22)
        :param pulumi.Input[_builtins.str] protocol: The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        pulumi.set(__self__, "action", action)
        if ip is not None:
            warnings.warn("""Ip address is deprecated. Please use ip_range instead""", DeprecationWarning)
            pulumi.log.warn("""ip is deprecated: Ip address is deprecated. Please use ip_range instead""")
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input[_builtins.str]:
        """
        The action to take when rule match. Possible values are: `accept` or `drop`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Ip address is deprecated. Please use ip_range instead""")
    def ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip", value)

    @_builtins.property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip_range")

    @ip_range.setter
    def ip_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_range", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port this rule applies to. If no `port` nor `port_range` are specified, the rule will apply to all port. Only one of `port` and `port_range` should be specified.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Computed port range for this rule (e.g: 1-1024, 22-22)
        """
        return pulumi.get(self, "port_range")

    @port_range.setter
    def port_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port_range", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)


if not MYPY:
    class SecurityGroupOutboundRuleArgsDict(TypedDict):
        action: pulumi.Input[_builtins.str]
        """
        Action when rule match request (drop or accept)
        """
        ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        Ip address for this rule (e.g: 1.1.1.1). Only one of ip or ip_range should be provided
        """
        ip_range: NotRequired[pulumi.Input[_builtins.str]]
        """
        Ip range for this rule (e.g: 192.168.1.0/24). Only one of ip or ip_range should be provided
        """
        port: NotRequired[pulumi.Input[_builtins.int]]
        """
        Network port for this rule
        """
        port_range: NotRequired[pulumi.Input[_builtins.str]]
        """
        Computed port range for this rule (e.g: 1-1024, 22-22)
        """
        protocol: NotRequired[pulumi.Input[_builtins.str]]
        """
        Protocol for this rule (TCP, UDP, ICMP or ANY)
        """
elif False:
    SecurityGroupOutboundRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGroupOutboundRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[_builtins.str],
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_range: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] action: Action when rule match request (drop or accept)
        :param pulumi.Input[_builtins.str] ip: Ip address for this rule (e.g: 1.1.1.1). Only one of ip or ip_range should be provided
        :param pulumi.Input[_builtins.str] ip_range: Ip range for this rule (e.g: 192.168.1.0/24). Only one of ip or ip_range should be provided
        :param pulumi.Input[_builtins.int] port: Network port for this rule
        :param pulumi.Input[_builtins.str] port_range: Computed port range for this rule (e.g: 1-1024, 22-22)
        :param pulumi.Input[_builtins.str] protocol: Protocol for this rule (TCP, UDP, ICMP or ANY)
        """
        pulumi.set(__self__, "action", action)
        if ip is not None:
            warnings.warn("""Ip address is deprecated. Please use ip_range instead""", DeprecationWarning)
            pulumi.log.warn("""ip is deprecated: Ip address is deprecated. Please use ip_range instead""")
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input[_builtins.str]:
        """
        Action when rule match request (drop or accept)
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Ip address is deprecated. Please use ip_range instead""")
    def ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Ip address for this rule (e.g: 1.1.1.1). Only one of ip or ip_range should be provided
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip", value)

    @_builtins.property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Ip range for this rule (e.g: 192.168.1.0/24). Only one of ip or ip_range should be provided
        """
        return pulumi.get(self, "ip_range")

    @ip_range.setter
    def ip_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_range", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Network port for this rule
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Computed port range for this rule (e.g: 1-1024, 22-22)
        """
        return pulumi.get(self, "port_range")

    @port_range.setter
    def port_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port_range", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Protocol for this rule (TCP, UDP, ICMP or ANY)
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)


if not MYPY:
    class SecurityGroupRulesInboundRuleArgsDict(TypedDict):
        action: pulumi.Input[_builtins.str]
        """
        The action to take when rule match. Possible values are: `accept` or `drop`.
        """
        ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        ip_range: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        port: NotRequired[pulumi.Input[_builtins.int]]
        """
        The port this rule apply to. If no port is specified, rule will apply to all port.
        """
        port_range: NotRequired[pulumi.Input[_builtins.str]]
        """
        Computed port range for this rule (e.g: 1-1024, 22-22)
        """
        protocol: NotRequired[pulumi.Input[_builtins.str]]
        """
        The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
elif False:
    SecurityGroupRulesInboundRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGroupRulesInboundRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[_builtins.str],
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_range: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] action: The action to take when rule match. Possible values are: `accept` or `drop`.
        :param pulumi.Input[_builtins.str] ip: The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param pulumi.Input[_builtins.str] ip_range: The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        :param pulumi.Input[_builtins.int] port: The port this rule apply to. If no port is specified, rule will apply to all port.
        :param pulumi.Input[_builtins.str] port_range: Computed port range for this rule (e.g: 1-1024, 22-22)
        :param pulumi.Input[_builtins.str] protocol: The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        pulumi.set(__self__, "action", action)
        if ip is not None:
            warnings.warn("""Ip address is deprecated. Please use ip_range instead""", DeprecationWarning)
            pulumi.log.warn("""ip is deprecated: Ip address is deprecated. Please use ip_range instead""")
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input[_builtins.str]:
        """
        The action to take when rule match. Possible values are: `accept` or `drop`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Ip address is deprecated. Please use ip_range instead""")
    def ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ip this rule apply to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip", value)

    @_builtins.property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ip range (e.g `192.168.1.0/24`) this rule applies to. If no `ip` nor `ip_range` are specified, rule will apply to all ip. Only one of `ip` and `ip_range` should be specified.
        """
        return pulumi.get(self, "ip_range")

    @ip_range.setter
    def ip_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_range", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port this rule apply to. If no port is specified, rule will apply to all port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Computed port range for this rule (e.g: 1-1024, 22-22)
        """
        return pulumi.get(self, "port_range")

    @port_range.setter
    def port_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port_range", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The protocol this rule apply to. Possible values are: `TCP`, `UDP`, `ICMP` or `ANY`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)


if not MYPY:
    class SecurityGroupRulesOutboundRuleArgsDict(TypedDict):
        action: pulumi.Input[_builtins.str]
        """
        Action when rule match request (drop or accept)
        """
        ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        Ip address for this rule (e.g: 1.1.1.1). Only one of ip or ip_range should be provided
        """
        ip_range: NotRequired[pulumi.Input[_builtins.str]]
        """
        Ip range for this rule (e.g: 192.168.1.0/24). Only one of ip or ip_range should be provided
        """
        port: NotRequired[pulumi.Input[_builtins.int]]
        """
        Network port for this rule
        """
        port_range: NotRequired[pulumi.Input[_builtins.str]]
        """
        Computed port range for this rule (e.g: 1-1024, 22-22)
        """
        protocol: NotRequired[pulumi.Input[_builtins.str]]
        """
        Protocol for this rule (TCP, UDP, ICMP or ANY)
        """
elif False:
    SecurityGroupRulesOutboundRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityGroupRulesOutboundRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[_builtins.str],
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_range: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 port_range: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] action: Action when rule match request (drop or accept)
        :param pulumi.Input[_builtins.str] ip: Ip address for this rule (e.g: 1.1.1.1). Only one of ip or ip_range should be provided
        :param pulumi.Input[_builtins.str] ip_range: Ip range for this rule (e.g: 192.168.1.0/24). Only one of ip or ip_range should be provided
        :param pulumi.Input[_builtins.int] port: Network port for this rule
        :param pulumi.Input[_builtins.str] port_range: Computed port range for this rule (e.g: 1-1024, 22-22)
        :param pulumi.Input[_builtins.str] protocol: Protocol for this rule (TCP, UDP, ICMP or ANY)
        """
        pulumi.set(__self__, "action", action)
        if ip is not None:
            warnings.warn("""Ip address is deprecated. Please use ip_range instead""", DeprecationWarning)
            pulumi.log.warn("""ip is deprecated: Ip address is deprecated. Please use ip_range instead""")
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input[_builtins.str]:
        """
        Action when rule match request (drop or accept)
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Ip address is deprecated. Please use ip_range instead""")
    def ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Ip address for this rule (e.g: 1.1.1.1). Only one of ip or ip_range should be provided
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip", value)

    @_builtins.property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Ip range for this rule (e.g: 192.168.1.0/24). Only one of ip or ip_range should be provided
        """
        return pulumi.get(self, "ip_range")

    @ip_range.setter
    def ip_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_range", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Network port for this rule
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Computed port range for this rule (e.g: 1-1024, 22-22)
        """
        return pulumi.get(self, "port_range")

    @port_range.setter
    def port_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port_range", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Protocol for this rule (TCP, UDP, ICMP or ANY)
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)


if not MYPY:
    class ServerFilesystemArgsDict(TypedDict):
        filesystem_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The unique ID of the filesystem attached to the server.
        """
        status: NotRequired[pulumi.Input[_builtins.str]]
        """
        The state of the filesystem
        """
elif False:
    ServerFilesystemArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerFilesystemArgs:
    def __init__(__self__, *,
                 filesystem_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] filesystem_id: The unique ID of the filesystem attached to the server.
        :param pulumi.Input[_builtins.str] status: The state of the filesystem
        """
        if filesystem_id is not None:
            pulumi.set(__self__, "filesystem_id", filesystem_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="filesystemId")
    def filesystem_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique ID of the filesystem attached to the server.
        """
        return pulumi.get(self, "filesystem_id")

    @filesystem_id.setter
    def filesystem_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "filesystem_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The state of the filesystem
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)


if not MYPY:
    class ServerPrivateIpArgsDict(TypedDict):
        address: NotRequired[pulumi.Input[_builtins.str]]
        """
        The private IP address.
        """
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the IP address resource.
        """
elif False:
    ServerPrivateIpArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerPrivateIpArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] address: The private IP address.
        :param pulumi.Input[_builtins.str] id: The ID of the IP address resource.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if id is not None:
            pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private IP address.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the IP address resource.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)


if not MYPY:
    class ServerPrivateNetworkArgsDict(TypedDict):
        pn_id: pulumi.Input[_builtins.str]
        """
        The Private Network ID
        """
        mac_address: NotRequired[pulumi.Input[_builtins.str]]
        """
        MAC address of the NIC
        """
        pnic_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the NIC
        """
        status: NotRequired[pulumi.Input[_builtins.str]]
        """
        The private NIC state
        """
        zone: NotRequired[pulumi.Input[_builtins.str]]
        """
        `zone`) The zone in which the server should be created.
        """
elif False:
    ServerPrivateNetworkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerPrivateNetworkArgs:
    def __init__(__self__, *,
                 pn_id: pulumi.Input[_builtins.str],
                 mac_address: Optional[pulumi.Input[_builtins.str]] = None,
                 pnic_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] pn_id: The Private Network ID
        :param pulumi.Input[_builtins.str] mac_address: MAC address of the NIC
        :param pulumi.Input[_builtins.str] pnic_id: The ID of the NIC
        :param pulumi.Input[_builtins.str] status: The private NIC state
        :param pulumi.Input[_builtins.str] zone: `zone`) The zone in which the server should be created.
        """
        pulumi.set(__self__, "pn_id", pn_id)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if pnic_id is not None:
            pulumi.set(__self__, "pnic_id", pnic_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="pnId")
    def pn_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Private Network ID
        """
        return pulumi.get(self, "pn_id")

    @pn_id.setter
    def pn_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "pn_id", value)

    @_builtins.property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        MAC address of the NIC
        """
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mac_address", value)

    @_builtins.property
    @pulumi.getter(name="pnicId")
    def pnic_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the NIC
        """
        return pulumi.get(self, "pnic_id")

    @pnic_id.setter
    def pnic_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pnic_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private NIC state
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `zone`) The zone in which the server should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


if not MYPY:
    class ServerPublicIpArgsDict(TypedDict):
        address: NotRequired[pulumi.Input[_builtins.str]]
        """
        The address of the IP.
        """
        dynamic: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether the IP is dynamic.
        """
        family: NotRequired[pulumi.Input[_builtins.str]]
        """
        The IP address' family.
        """
        gateway: NotRequired[pulumi.Input[_builtins.str]]
        """
        The IP of the Gateway associated with the IP.
        """
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the IP.
        """
        netmask: NotRequired[pulumi.Input[_builtins.str]]
        """
        The CIDR netmask of the IP.
        """
        provisioning_mode: NotRequired[pulumi.Input[_builtins.str]]
        """
        The provisioning mode of the IP
        """
elif False:
    ServerPublicIpArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerPublicIpArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[_builtins.str]] = None,
                 dynamic: Optional[pulumi.Input[_builtins.bool]] = None,
                 family: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 id: Optional[pulumi.Input[_builtins.str]] = None,
                 netmask: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioning_mode: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] address: The address of the IP.
        :param pulumi.Input[_builtins.bool] dynamic: Whether the IP is dynamic.
        :param pulumi.Input[_builtins.str] family: The IP address' family.
        :param pulumi.Input[_builtins.str] gateway: The IP of the Gateway associated with the IP.
        :param pulumi.Input[_builtins.str] id: The ID of the IP.
        :param pulumi.Input[_builtins.str] netmask: The CIDR netmask of the IP.
        :param pulumi.Input[_builtins.str] provisioning_mode: The provisioning mode of the IP
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if dynamic is not None:
            pulumi.set(__self__, "dynamic", dynamic)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if gateway is not None:
            pulumi.set(__self__, "gateway", gateway)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if netmask is not None:
            pulumi.set(__self__, "netmask", netmask)
        if provisioning_mode is not None:
            pulumi.set(__self__, "provisioning_mode", provisioning_mode)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The address of the IP.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address", value)

    @_builtins.property
    @pulumi.getter
    def dynamic(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the IP is dynamic.
        """
        return pulumi.get(self, "dynamic")

    @dynamic.setter
    def dynamic(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dynamic", value)

    @_builtins.property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address' family.
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "family", value)

    @_builtins.property
    @pulumi.getter
    def gateway(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP of the Gateway associated with the IP.
        """
        return pulumi.get(self, "gateway")

    @gateway.setter
    def gateway(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the IP.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def netmask(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CIDR netmask of the IP.
        """
        return pulumi.get(self, "netmask")

    @netmask.setter
    def netmask(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "netmask", value)

    @_builtins.property
    @pulumi.getter(name="provisioningMode")
    def provisioning_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The provisioning mode of the IP
        """
        return pulumi.get(self, "provisioning_mode")

    @provisioning_mode.setter
    def provisioning_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provisioning_mode", value)


if not MYPY:
    class ServerRootVolumeArgsDict(TypedDict):
        boot: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Set the volume where the boot the server
        """
        delete_on_termination: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Forces deletion of the root volume on instance termination.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the server.
        """
        sbs_iops: NotRequired[pulumi.Input[_builtins.int]]
        """
        Choose IOPS of your sbs volume, has to be used with `sbs_volume` for root volume type.

        > **Important:** Updates to `root_volume.size_in_gb` will be ignored after the creation of the server.
        """
        size_in_gb: NotRequired[pulumi.Input[_builtins.int]]
        """
        Size of the root volume in gigabytes.
        To find the right size use [this endpoint](https://www.scaleway.com/en/developers/api/instance/#path-instances-list-all-instances) and
        check the `volumes_constraint.{min|max}_size` (in bytes) for your `commercial_type`.
        Depending on `volume_type`, updates to this field may recreate a new resource.
        """
        volume_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The volume ID of the root volume of the server, allows you to create server with an existing volume. If empty, will be computed to a created volume ID.
        """
        volume_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Volume type of root volume, can be `l_ssd` or `sbs_volume`, default value depends on server type
        """
elif False:
    ServerRootVolumeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerRootVolumeArgs:
    def __init__(__self__, *,
                 boot: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_on_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sbs_iops: Optional[pulumi.Input[_builtins.int]] = None,
                 size_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 volume_id: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.bool] boot: Set the volume where the boot the server
        :param pulumi.Input[_builtins.bool] delete_on_termination: Forces deletion of the root volume on instance termination.
        :param pulumi.Input[_builtins.str] name: The name of the server.
        :param pulumi.Input[_builtins.int] sbs_iops: Choose IOPS of your sbs volume, has to be used with `sbs_volume` for root volume type.
               
               > **Important:** Updates to `root_volume.size_in_gb` will be ignored after the creation of the server.
        :param pulumi.Input[_builtins.int] size_in_gb: Size of the root volume in gigabytes.
               To find the right size use [this endpoint](https://www.scaleway.com/en/developers/api/instance/#path-instances-list-all-instances) and
               check the `volumes_constraint.{min|max}_size` (in bytes) for your `commercial_type`.
               Depending on `volume_type`, updates to this field may recreate a new resource.
        :param pulumi.Input[_builtins.str] volume_id: The volume ID of the root volume of the server, allows you to create server with an existing volume. If empty, will be computed to a created volume ID.
        :param pulumi.Input[_builtins.str] volume_type: Volume type of root volume, can be `l_ssd` or `sbs_volume`, default value depends on server type
        """
        if boot is not None:
            pulumi.set(__self__, "boot", boot)
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sbs_iops is not None:
            pulumi.set(__self__, "sbs_iops", sbs_iops)
        if size_in_gb is not None:
            pulumi.set(__self__, "size_in_gb", size_in_gb)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @_builtins.property
    @pulumi.getter
    def boot(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set the volume where the boot the server
        """
        return pulumi.get(self, "boot")

    @boot.setter
    def boot(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "boot", value)

    @_builtins.property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Forces deletion of the root volume on instance termination.
        """
        return pulumi.get(self, "delete_on_termination")

    @delete_on_termination.setter
    def delete_on_termination(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_on_termination", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="sbsIops")
    def sbs_iops(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Choose IOPS of your sbs volume, has to be used with `sbs_volume` for root volume type.

        > **Important:** Updates to `root_volume.size_in_gb` will be ignored after the creation of the server.
        """
        return pulumi.get(self, "sbs_iops")

    @sbs_iops.setter
    def sbs_iops(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "sbs_iops", value)

    @_builtins.property
    @pulumi.getter(name="sizeInGb")
    def size_in_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Size of the root volume in gigabytes.
        To find the right size use [this endpoint](https://www.scaleway.com/en/developers/api/instance/#path-instances-list-all-instances) and
        check the `volumes_constraint.{min|max}_size` (in bytes) for your `commercial_type`.
        Depending on `volume_type`, updates to this field may recreate a new resource.
        """
        return pulumi.get(self, "size_in_gb")

    @size_in_gb.setter
    def size_in_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size_in_gb", value)

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The volume ID of the root volume of the server, allows you to create server with an existing volume. If empty, will be computed to a created volume ID.
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_id", value)

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Volume type of root volume, can be `l_ssd` or `sbs_volume`, default value depends on server type
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_type", value)


if not MYPY:
    class SnapshotImportArgsDict(TypedDict):
        bucket: pulumi.Input[_builtins.str]
        """
        Bucket name containing [qcow2](https://en.wikipedia.org/wiki/Qcow) to import
        """
        key: pulumi.Input[_builtins.str]
        """
        Key of the object to import
        """
elif False:
    SnapshotImportArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SnapshotImportArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[_builtins.str],
                 key: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] bucket: Bucket name containing [qcow2](https://en.wikipedia.org/wiki/Qcow) to import
        :param pulumi.Input[_builtins.str] key: Key of the object to import
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[_builtins.str]:
        """
        Bucket name containing [qcow2](https://en.wikipedia.org/wiki/Qcow) to import
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bucket", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        """
        Key of the object to import
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)


