# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetServerResult',
    'AwaitableGetServerResult',
    'get_server',
    'get_server_output',
]

@pulumi.output_type
class GetServerResult:
    """
    A collection of values returned by getServer.
    """
    def __init__(__self__, additional_volume_ids=None, admin_password_encryption_ssh_key_id=None, boot_type=None, bootscript_id=None, cloud_init=None, enable_dynamic_ip=None, filesystems=None, id=None, image=None, ip_id=None, ip_ids=None, name=None, organization_id=None, placement_group_id=None, placement_group_policy_respected=None, private_ips=None, private_networks=None, project_id=None, protected=None, public_ips=None, replace_on_type_change=None, root_volumes=None, security_group_id=None, server_id=None, state=None, tags=None, type=None, user_data=None, zone=None):
        if additional_volume_ids and not isinstance(additional_volume_ids, list):
            raise TypeError("Expected argument 'additional_volume_ids' to be a list")
        pulumi.set(__self__, "additional_volume_ids", additional_volume_ids)
        if admin_password_encryption_ssh_key_id and not isinstance(admin_password_encryption_ssh_key_id, str):
            raise TypeError("Expected argument 'admin_password_encryption_ssh_key_id' to be a str")
        pulumi.set(__self__, "admin_password_encryption_ssh_key_id", admin_password_encryption_ssh_key_id)
        if boot_type and not isinstance(boot_type, str):
            raise TypeError("Expected argument 'boot_type' to be a str")
        pulumi.set(__self__, "boot_type", boot_type)
        if bootscript_id and not isinstance(bootscript_id, str):
            raise TypeError("Expected argument 'bootscript_id' to be a str")
        pulumi.set(__self__, "bootscript_id", bootscript_id)
        if cloud_init and not isinstance(cloud_init, str):
            raise TypeError("Expected argument 'cloud_init' to be a str")
        pulumi.set(__self__, "cloud_init", cloud_init)
        if enable_dynamic_ip and not isinstance(enable_dynamic_ip, bool):
            raise TypeError("Expected argument 'enable_dynamic_ip' to be a bool")
        pulumi.set(__self__, "enable_dynamic_ip", enable_dynamic_ip)
        if filesystems and not isinstance(filesystems, list):
            raise TypeError("Expected argument 'filesystems' to be a list")
        pulumi.set(__self__, "filesystems", filesystems)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image and not isinstance(image, str):
            raise TypeError("Expected argument 'image' to be a str")
        pulumi.set(__self__, "image", image)
        if ip_id and not isinstance(ip_id, str):
            raise TypeError("Expected argument 'ip_id' to be a str")
        pulumi.set(__self__, "ip_id", ip_id)
        if ip_ids and not isinstance(ip_ids, list):
            raise TypeError("Expected argument 'ip_ids' to be a list")
        pulumi.set(__self__, "ip_ids", ip_ids)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if placement_group_id and not isinstance(placement_group_id, str):
            raise TypeError("Expected argument 'placement_group_id' to be a str")
        pulumi.set(__self__, "placement_group_id", placement_group_id)
        if placement_group_policy_respected and not isinstance(placement_group_policy_respected, bool):
            raise TypeError("Expected argument 'placement_group_policy_respected' to be a bool")
        pulumi.set(__self__, "placement_group_policy_respected", placement_group_policy_respected)
        if private_ips and not isinstance(private_ips, list):
            raise TypeError("Expected argument 'private_ips' to be a list")
        pulumi.set(__self__, "private_ips", private_ips)
        if private_networks and not isinstance(private_networks, list):
            raise TypeError("Expected argument 'private_networks' to be a list")
        pulumi.set(__self__, "private_networks", private_networks)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if protected and not isinstance(protected, bool):
            raise TypeError("Expected argument 'protected' to be a bool")
        pulumi.set(__self__, "protected", protected)
        if public_ips and not isinstance(public_ips, list):
            raise TypeError("Expected argument 'public_ips' to be a list")
        pulumi.set(__self__, "public_ips", public_ips)
        if replace_on_type_change and not isinstance(replace_on_type_change, bool):
            raise TypeError("Expected argument 'replace_on_type_change' to be a bool")
        pulumi.set(__self__, "replace_on_type_change", replace_on_type_change)
        if root_volumes and not isinstance(root_volumes, list):
            raise TypeError("Expected argument 'root_volumes' to be a list")
        pulumi.set(__self__, "root_volumes", root_volumes)
        if security_group_id and not isinstance(security_group_id, str):
            raise TypeError("Expected argument 'security_group_id' to be a str")
        pulumi.set(__self__, "security_group_id", security_group_id)
        if server_id and not isinstance(server_id, str):
            raise TypeError("Expected argument 'server_id' to be a str")
        pulumi.set(__self__, "server_id", server_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if user_data and not isinstance(user_data, dict):
            raise TypeError("Expected argument 'user_data' to be a dict")
        pulumi.set(__self__, "user_data", user_data)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="additionalVolumeIds")
    def additional_volume_ids(self) -> Sequence[_builtins.str]:
        """
        The [additional volumes](https://developers.scaleway.com/en/products/instance/api/#volumes-7e8a39)
        attached to the server.
        """
        return pulumi.get(self, "additional_volume_ids")

    @_builtins.property
    @pulumi.getter(name="adminPasswordEncryptionSshKeyId")
    def admin_password_encryption_ssh_key_id(self) -> _builtins.str:
        return pulumi.get(self, "admin_password_encryption_ssh_key_id")

    @_builtins.property
    @pulumi.getter(name="bootType")
    def boot_type(self) -> _builtins.str:
        return pulumi.get(self, "boot_type")

    @_builtins.property
    @pulumi.getter(name="bootscriptId")
    def bootscript_id(self) -> _builtins.str:
        return pulumi.get(self, "bootscript_id")

    @_builtins.property
    @pulumi.getter(name="cloudInit")
    def cloud_init(self) -> _builtins.str:
        """
        The cloud init script associated with this server.
        """
        return pulumi.get(self, "cloud_init")

    @_builtins.property
    @pulumi.getter(name="enableDynamicIp")
    def enable_dynamic_ip(self) -> _builtins.bool:
        """
        True if dynamic IP in enable on the server.
        """
        return pulumi.get(self, "enable_dynamic_ip")

    @_builtins.property
    @pulumi.getter
    def filesystems(self) -> Sequence['outputs.GetServerFilesystemResult']:
        return pulumi.get(self, "filesystems")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def image(self) -> _builtins.str:
        """
        The UUID and the label of the base image used by the server.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter(name="ipId")
    def ip_id(self) -> _builtins.str:
        return pulumi.get(self, "ip_id")

    @_builtins.property
    @pulumi.getter(name="ipIds")
    def ip_ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "ip_ids")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> _builtins.str:
        """
        The ID of the organization the server is associated with.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="placementGroupId")
    def placement_group_id(self) -> _builtins.str:
        """
        The [placement group](https://developers.scaleway.com/en/products/instance/api/#placement-groups-d8f653) the server is attached to.
        """
        return pulumi.get(self, "placement_group_id")

    @_builtins.property
    @pulumi.getter(name="placementGroupPolicyRespected")
    def placement_group_policy_respected(self) -> _builtins.bool:
        """
        True when the placement group policy is respected.
        """
        return pulumi.get(self, "placement_group_policy_respected")

    @_builtins.property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Sequence['outputs.GetServerPrivateIpResult']:
        """
        The list of private IPs of the server.
        """
        return pulumi.get(self, "private_ips")

    @_builtins.property
    @pulumi.getter(name="privateNetworks")
    def private_networks(self) -> Sequence['outputs.GetServerPrivateNetworkResult']:
        return pulumi.get(self, "private_networks")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def protected(self) -> _builtins.bool:
        return pulumi.get(self, "protected")

    @_builtins.property
    @pulumi.getter(name="publicIps")
    def public_ips(self) -> Sequence['outputs.GetServerPublicIpResult']:
        """
        The list of public IPs of the server
        """
        return pulumi.get(self, "public_ips")

    @_builtins.property
    @pulumi.getter(name="replaceOnTypeChange")
    def replace_on_type_change(self) -> _builtins.bool:
        return pulumi.get(self, "replace_on_type_change")

    @_builtins.property
    @pulumi.getter(name="rootVolumes")
    def root_volumes(self) -> Sequence['outputs.GetServerRootVolumeResult']:
        return pulumi.get(self, "root_volumes")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> _builtins.str:
        """
        The [security group](https://developers.scaleway.com/en/products/instance/api/#security-groups-8d7f89) the server is attached to.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "server_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The state of the server. Possible values are: `started`, `stopped` or `standby`.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        The tags associated with the server.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The commercial type of the server.
        You find all the available types on the [pricing page](https://www.scaleway.com/en/pricing/).
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Mapping[str, _builtins.str]:
        """
        The user data associated with the server.
        """
        return pulumi.get(self, "user_data")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "zone")


class AwaitableGetServerResult(GetServerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerResult(
            additional_volume_ids=self.additional_volume_ids,
            admin_password_encryption_ssh_key_id=self.admin_password_encryption_ssh_key_id,
            boot_type=self.boot_type,
            bootscript_id=self.bootscript_id,
            cloud_init=self.cloud_init,
            enable_dynamic_ip=self.enable_dynamic_ip,
            filesystems=self.filesystems,
            id=self.id,
            image=self.image,
            ip_id=self.ip_id,
            ip_ids=self.ip_ids,
            name=self.name,
            organization_id=self.organization_id,
            placement_group_id=self.placement_group_id,
            placement_group_policy_respected=self.placement_group_policy_respected,
            private_ips=self.private_ips,
            private_networks=self.private_networks,
            project_id=self.project_id,
            protected=self.protected,
            public_ips=self.public_ips,
            replace_on_type_change=self.replace_on_type_change,
            root_volumes=self.root_volumes,
            security_group_id=self.security_group_id,
            server_id=self.server_id,
            state=self.state,
            tags=self.tags,
            type=self.type,
            user_data=self.user_data,
            zone=self.zone)


def get_server(name: Optional[_builtins.str] = None,
               project_id: Optional[_builtins.str] = None,
               server_id: Optional[_builtins.str] = None,
               zone: Optional[_builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerResult:
    """
    Gets information about an instance server.


    :param _builtins.str name: The server name. Only one of `name` and `server_id` should be specified.
    :param _builtins.str project_id: The ID of the project the instance server is associated with.
    :param _builtins.str server_id: The server id. Only one of `name` and `server_id` should be specified.
    :param _builtins.str zone: `zone`) The zone in which the server exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['serverId'] = server_id
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:instance/getServer:getServer', __args__, opts=opts, typ=GetServerResult).value

    return AwaitableGetServerResult(
        additional_volume_ids=pulumi.get(__ret__, 'additional_volume_ids'),
        admin_password_encryption_ssh_key_id=pulumi.get(__ret__, 'admin_password_encryption_ssh_key_id'),
        boot_type=pulumi.get(__ret__, 'boot_type'),
        bootscript_id=pulumi.get(__ret__, 'bootscript_id'),
        cloud_init=pulumi.get(__ret__, 'cloud_init'),
        enable_dynamic_ip=pulumi.get(__ret__, 'enable_dynamic_ip'),
        filesystems=pulumi.get(__ret__, 'filesystems'),
        id=pulumi.get(__ret__, 'id'),
        image=pulumi.get(__ret__, 'image'),
        ip_id=pulumi.get(__ret__, 'ip_id'),
        ip_ids=pulumi.get(__ret__, 'ip_ids'),
        name=pulumi.get(__ret__, 'name'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        placement_group_id=pulumi.get(__ret__, 'placement_group_id'),
        placement_group_policy_respected=pulumi.get(__ret__, 'placement_group_policy_respected'),
        private_ips=pulumi.get(__ret__, 'private_ips'),
        private_networks=pulumi.get(__ret__, 'private_networks'),
        project_id=pulumi.get(__ret__, 'project_id'),
        protected=pulumi.get(__ret__, 'protected'),
        public_ips=pulumi.get(__ret__, 'public_ips'),
        replace_on_type_change=pulumi.get(__ret__, 'replace_on_type_change'),
        root_volumes=pulumi.get(__ret__, 'root_volumes'),
        security_group_id=pulumi.get(__ret__, 'security_group_id'),
        server_id=pulumi.get(__ret__, 'server_id'),
        state=pulumi.get(__ret__, 'state'),
        tags=pulumi.get(__ret__, 'tags'),
        type=pulumi.get(__ret__, 'type'),
        user_data=pulumi.get(__ret__, 'user_data'),
        zone=pulumi.get(__ret__, 'zone'))
def get_server_output(name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      server_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      zone: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServerResult]:
    """
    Gets information about an instance server.


    :param _builtins.str name: The server name. Only one of `name` and `server_id` should be specified.
    :param _builtins.str project_id: The ID of the project the instance server is associated with.
    :param _builtins.str server_id: The server id. Only one of `name` and `server_id` should be specified.
    :param _builtins.str zone: `zone`) The zone in which the server exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['projectId'] = project_id
    __args__['serverId'] = server_id
    __args__['zone'] = zone
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('scaleway:instance/getServer:getServer', __args__, opts=opts, typ=GetServerResult)
    return __ret__.apply(lambda __response__: GetServerResult(
        additional_volume_ids=pulumi.get(__response__, 'additional_volume_ids'),
        admin_password_encryption_ssh_key_id=pulumi.get(__response__, 'admin_password_encryption_ssh_key_id'),
        boot_type=pulumi.get(__response__, 'boot_type'),
        bootscript_id=pulumi.get(__response__, 'bootscript_id'),
        cloud_init=pulumi.get(__response__, 'cloud_init'),
        enable_dynamic_ip=pulumi.get(__response__, 'enable_dynamic_ip'),
        filesystems=pulumi.get(__response__, 'filesystems'),
        id=pulumi.get(__response__, 'id'),
        image=pulumi.get(__response__, 'image'),
        ip_id=pulumi.get(__response__, 'ip_id'),
        ip_ids=pulumi.get(__response__, 'ip_ids'),
        name=pulumi.get(__response__, 'name'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        placement_group_id=pulumi.get(__response__, 'placement_group_id'),
        placement_group_policy_respected=pulumi.get(__response__, 'placement_group_policy_respected'),
        private_ips=pulumi.get(__response__, 'private_ips'),
        private_networks=pulumi.get(__response__, 'private_networks'),
        project_id=pulumi.get(__response__, 'project_id'),
        protected=pulumi.get(__response__, 'protected'),
        public_ips=pulumi.get(__response__, 'public_ips'),
        replace_on_type_change=pulumi.get(__response__, 'replace_on_type_change'),
        root_volumes=pulumi.get(__response__, 'root_volumes'),
        security_group_id=pulumi.get(__response__, 'security_group_id'),
        server_id=pulumi.get(__response__, 'server_id'),
        state=pulumi.get(__response__, 'state'),
        tags=pulumi.get(__response__, 'tags'),
        type=pulumi.get(__response__, 'type'),
        user_data=pulumi.get(__response__, 'user_data'),
        zone=pulumi.get(__response__, 'zone')))
